/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2024-03-29 16:44:17 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT '10',
  `args` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `attempts` int(11) NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=1454 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=4703 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=4131 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_eg_grids` (
  `id` mediumint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `handle` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `postparams` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `params` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `layers` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `settings` text COLLATE utf8mb4_unicode_520_ci,
  `last_modified` datetime DEFAULT NULL,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `handle` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_eg_item_elements` (
  `id` mediumint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `handle` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `settings` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `handle` (`handle`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_eg_item_skins` (
  `id` mediumint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `handle` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `params` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `layers` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `settings` text COLLATE utf8mb4_unicode_520_ci,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `name` (`name`),
  UNIQUE KEY `handle` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_eg_navigation_skins` (
  `id` mediumint(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `handle` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `css` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `navversion` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `handle` (`handle`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gla_attribute_mapping_rules` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `attribute` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `category_condition_type` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `categories` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gla_budget_recommendations` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `currency` varchar(3) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `daily_budget_low` int(11) NOT NULL,
  `daily_budget_high` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `country_currency` (`country`,`currency`)
) ENGINE=InnoDB AUTO_INCREMENT=4231 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gla_merchant_issues` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) NOT NULL,
  `issue` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `code` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `severity` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'warning',
  `product` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `action_url` varchar(1024) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `applicable_countries` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'mc',
  `type` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'product',
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gla_shipping_rates` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `currency` varchar(3) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `rate` double NOT NULL DEFAULT '0',
  `options` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `country` (`country`),
  KEY `currency` (`currency`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_gla_shipping_times` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `time` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `country` (`country`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_layerslider` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `group_id` int(10) DEFAULT NULL,
  `author` int(10) NOT NULL DEFAULT '0',
  `name` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `slug` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `data` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_c` int(10) NOT NULL,
  `date_m` int(10) NOT NULL,
  `schedule_start` int(10) NOT NULL DEFAULT '0',
  `schedule_end` int(10) NOT NULL DEFAULT '0',
  `flag_dirty` tinyint(1) NOT NULL DEFAULT '0',
  `flag_hidden` tinyint(1) NOT NULL DEFAULT '0',
  `flag_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `flag_popup` tinyint(1) NOT NULL DEFAULT '0',
  `flag_group` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_layerslider_drafts` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `slider_id` int(10) NOT NULL,
  `author` int(10) NOT NULL DEFAULT '0',
  `data` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_c` int(10) NOT NULL,
  `date_m` int(10) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `slider_id` (`slider_id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_layerslider_revisions` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `slider_id` int(10) NOT NULL,
  `author` int(10) NOT NULL DEFAULT '0',
  `data` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_c` int(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_automation_run_logs` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `automation_run_id` int(11) unsigned NOT NULL,
  `step_id` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `step_type` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `step_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `started_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `run_number` int(11) NOT NULL,
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `error` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `automation_run_id_step_id` (`automation_run_id`,`step_id`),
  KEY `status` (`status`),
  KEY `step_id` (`step_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_automation_run_subjects` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `automation_run_id` int(11) unsigned NOT NULL,
  `key` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `args` longtext COLLATE utf8mb4_unicode_520_ci,
  `hash` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `automation_run_id` (`automation_run_id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_automation_runs` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `automation_id` int(11) unsigned NOT NULL,
  `version_id` int(11) unsigned NOT NULL,
  `trigger_key` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `next_step_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `automation_id` (`automation_id`,`status`),
  KEY `created_at` (`created_at`),
  KEY `version_id` (`version_id`),
  KEY `status` (`status`),
  KEY `next_step_id` (`next_step_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_automation_triggers` (
  `automation_id` int(11) unsigned NOT NULL,
  `trigger_key` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`automation_id`,`trigger_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_automation_versions` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `automation_id` int(11) unsigned NOT NULL,
  `steps` longtext COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `automation_id` (`automation_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_automations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `author` bigint(20) NOT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `meta` longtext COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `activated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_custom_fields` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(90) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `params` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_dynamic_segment_filters` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `segment_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `filter_data` longblob,
  `filter_type` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `action` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `segment_id` (`segment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_feature_flags` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_forms` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'enabled',
  `body` longtext COLLATE utf8mb4_unicode_520_ci,
  `settings` longtext COLLATE utf8mb4_unicode_520_ci,
  `styles` longtext COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `level` int(11) DEFAULT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `raw_message` longtext COLLATE utf8mb4_unicode_520_ci,
  `context` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_migrations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `started_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `completed_at` timestamp NULL DEFAULT NULL,
  `retries` int(11) unsigned NOT NULL DEFAULT '0',
  `error` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_newsletter_links` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `url` varchar(2083) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `newsletter_id` (`newsletter_id`),
  KEY `queue_id` (`queue_id`),
  KEY `url` (`url`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_newsletter_option` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `option_field_id` int(11) unsigned NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `newsletter_id_option_field_id` (`newsletter_id`,`option_field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_newsletter_option_fields` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `newsletter_type` varchar(90) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name_newsletter_type` (`newsletter_type`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_newsletter_posts` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `post_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `newsletter_id` (`newsletter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_newsletter_segment` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `segment_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `newsletter_segment` (`newsletter_id`,`segment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_newsletter_templates` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) DEFAULT '0',
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `categories` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '[]',
  `description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `body` longtext COLLATE utf8mb4_unicode_520_ci,
  `thumbnail` longtext COLLATE utf8mb4_unicode_520_ci,
  `thumbnail_data` longtext COLLATE utf8mb4_unicode_520_ci,
  `readonly` tinyint(1) DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=148 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_newsletters` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `hash` varchar(150) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `parent_id` int(11) unsigned DEFAULT NULL,
  `subject` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `type` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'standard',
  `sender_address` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `sender_name` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'draft',
  `reply_to_address` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `reply_to_name` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `preheader` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `body` longtext COLLATE utf8mb4_unicode_520_ci,
  `sent_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `unsubscribe_token` char(15) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ga_campaign` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `wp_post_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unsubscribe_token` (`unsubscribe_token`),
  KEY `type_status` (`type`,`status`),
  KEY `wp_post_id` (`wp_post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_scheduled_task_subscribers` (
  `task_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `processed` int(1) NOT NULL,
  `failed` smallint(1) NOT NULL DEFAULT '0',
  `error` text COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`task_id`,`subscriber_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_scheduled_tasks` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(90) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `status` varchar(12) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `priority` mediumint(9) NOT NULL DEFAULT '0',
  `scheduled_at` timestamp NULL DEFAULT NULL,
  `processed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `in_progress` int(1) DEFAULT NULL,
  `reschedule_count` int(11) NOT NULL DEFAULT '0',
  `meta` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=66 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_segments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(90) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'default',
  `description` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `average_engagement_score` float unsigned DEFAULT NULL,
  `average_engagement_score_updated_at` timestamp NULL DEFAULT NULL,
  `display_in_manage_subscription_page` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `average_engagement_score_updated_at` (`average_engagement_score_updated_at`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_sending_queues` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `task_id` int(11) unsigned NOT NULL,
  `newsletter_id` int(11) unsigned DEFAULT NULL,
  `newsletter_rendered_body` longtext COLLATE utf8mb4_unicode_520_ci,
  `newsletter_rendered_subject` varchar(250) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `subscribers` longtext COLLATE utf8mb4_unicode_520_ci,
  `count_total` int(11) unsigned NOT NULL DEFAULT '0',
  `count_processed` int(11) unsigned NOT NULL DEFAULT '0',
  `count_to_process` int(11) unsigned NOT NULL DEFAULT '0',
  `meta` longtext COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_id` (`task_id`),
  KEY `newsletter_id` (`newsletter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_settings` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=503 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_statistics_bounces` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_statistics_clicks` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `link_id` int(11) unsigned NOT NULL,
  `user_agent_id` int(11) unsigned DEFAULT NULL,
  `user_agent_type` tinyint(1) NOT NULL DEFAULT '0',
  `count` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `newsletter_id_subscriber_id_user_agent_type` (`newsletter_id`,`subscriber_id`,`user_agent_type`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_statistics_forms` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `form_subscriber` (`form_id`,`subscriber_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_statistics_newsletters` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `sent_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `newsletter_id` (`newsletter_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_statistics_opens` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `user_agent_id` int(11) unsigned DEFAULT NULL,
  `user_agent_type` tinyint(1) NOT NULL DEFAULT '0',
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `newsletter_id_subscriber_id_user_agent_type` (`newsletter_id`,`subscriber_id`,`user_agent_type`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`),
  KEY `created_at` (`created_at`),
  KEY `subscriber_id_created_at` (`subscriber_id`,`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_statistics_unsubscribes` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned DEFAULT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `source` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT 'unknown',
  `meta` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `method` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'unknown',
  PRIMARY KEY (`id`),
  KEY `newsletter_id_subscriber_id` (`newsletter_id`,`subscriber_id`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_statistics_woocommerce_purchases` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned DEFAULT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `click_id` int(11) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `order_currency` char(3) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_price_total` float NOT NULL COMMENT 'With shipping and taxes in order_currency',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `status` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'unknown',
  PRIMARY KEY (`id`),
  UNIQUE KEY `click_id_order_id` (`click_id`,`order_id`),
  KEY `newsletter_id` (`newsletter_id`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`),
  KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_stats_notifications` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `task_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `newsletter_id_task_id` (`newsletter_id`,`task_id`),
  KEY `task_id` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_subscriber_custom_field` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `subscriber_id` int(11) unsigned NOT NULL,
  `custom_field_id` int(11) unsigned NOT NULL,
  `value` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `subscriber_id_custom_field_id` (`subscriber_id`,`custom_field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_subscriber_ips` (
  `ip` varchar(45) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`created_at`,`ip`),
  KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_subscriber_segment` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `subscriber_id` int(11) unsigned NOT NULL,
  `segment_id` int(11) unsigned NOT NULL,
  `status` varchar(12) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `subscriber_segment` (`subscriber_id`,`segment_id`),
  KEY `segment_id` (`segment_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_subscriber_tag` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `subscriber_id` int(11) unsigned NOT NULL,
  `tag_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `subscriber_tag` (`subscriber_id`,`tag_id`),
  KEY `tag_id` (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_subscribers` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `wp_user_id` bigint(20) DEFAULT NULL,
  `is_woocommerce_user` int(1) NOT NULL DEFAULT '0',
  `first_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `last_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `email` varchar(150) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(12) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'unconfirmed',
  `subscribed_ip` varchar(45) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `confirmed_ip` varchar(45) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `confirmed_at` timestamp NULL DEFAULT NULL,
  `last_subscribed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `unconfirmed_data` longtext COLLATE utf8mb4_unicode_520_ci,
  `source` enum('form','imported','administrator','api','wordpress_user','woocommerce_user','woocommerce_checkout','unknown') COLLATE utf8mb4_unicode_520_ci DEFAULT 'unknown',
  `count_confirmations` int(11) unsigned NOT NULL DEFAULT '0',
  `unsubscribe_token` char(15) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `link_token` char(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `engagement_score` float unsigned DEFAULT NULL,
  `engagement_score_updated_at` timestamp NULL DEFAULT NULL,
  `last_engagement_at` timestamp NULL DEFAULT NULL,
  `woocommerce_synced_at` timestamp NULL DEFAULT NULL,
  `email_count` int(11) unsigned NOT NULL DEFAULT '0',
  `last_sending_at` timestamp NULL DEFAULT NULL,
  `last_open_at` timestamp NULL DEFAULT NULL,
  `last_click_at` timestamp NULL DEFAULT NULL,
  `last_purchase_at` timestamp NULL DEFAULT NULL,
  `last_page_view_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  UNIQUE KEY `unsubscribe_token` (`unsubscribe_token`),
  KEY `wp_user_id` (`wp_user_id`),
  KEY `updated_at` (`updated_at`),
  KEY `status_deleted_at` (`status`,`deleted_at`),
  KEY `last_subscribed_at` (`last_subscribed_at`),
  KEY `engagement_score_updated_at` (`engagement_score_updated_at`),
  KEY `link_token` (`link_token`),
  KEY `first_name` (`first_name`(10)),
  KEY `last_name` (`last_name`(10)),
  KEY `last_sending_at` (`last_sending_at`),
  KEY `last_open_at` (`last_open_at`),
  KEY `last_click_at` (`last_click_at`),
  KEY `last_purchase_at` (`last_purchase_at`),
  KEY `last_page_view_at` (`last_page_view_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_tags` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_user_agents` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `hash` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailpoet_user_flags` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `name` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id_name` (`user_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=6933 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3247 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=368 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext,
  `hover` longtext,
  `advanced` longtext,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_css_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext,
  `hover` longtext,
  `advanced` longtext,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_layer_animations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_navigations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_sliders_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext,
  `params` longtext NOT NULL,
  `settings` text,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_revslider_static_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=80 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=227 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=80 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=72 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `label` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `query` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `actioned_text` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonce_action` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `nonce_name` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6026 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `locale` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `title` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `content_data` longtext COLLATE utf8mb4_unicode_520_ci,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT '0',
  `layout` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `image` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT '0',
  `is_read` tinyint(1) NOT NULL DEFAULT '0',
  `icon` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=80 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `postcode` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `city` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `state` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `first_name` text COLLATE utf8mb4_unicode_520_ci,
  `last_name` text COLLATE utf8mb4_unicode_520_ci,
  `company` text COLLATE utf8mb4_unicode_520_ci,
  `address_1` text COLLATE utf8mb4_unicode_520_ci,
  `address_2` text COLLATE utf8mb4_unicode_520_ci,
  `city` text COLLATE utf8mb4_unicode_520_ci,
  `state` text COLLATE utf8mb4_unicode_520_ci,
  `postcode` text COLLATE utf8mb4_unicode_520_ci,
  `country` text COLLATE utf8mb4_unicode_520_ci,
  `email` varchar(320) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `phone` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `woocommerce_version` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT '0',
  `product_gross_revenue` double NOT NULL DEFAULT '0',
  `coupon_amount` double NOT NULL DEFAULT '0',
  `tax_amount` double NOT NULL DEFAULT '0',
  `shipping_amount` double NOT NULL DEFAULT '0',
  `shipping_tax_amount` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT '0',
  `total_sales` double NOT NULL DEFAULT '0',
  `tax_total` double NOT NULL DEFAULT '0',
  `shipping_total` double NOT NULL DEFAULT '0',
  `net_total` double NOT NULL DEFAULT '0',
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT '0',
  `order_tax` double NOT NULL DEFAULT '0',
  `total_tax` double NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `currency` varchar(10) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `payment_method_title` text COLLATE utf8mb4_unicode_520_ci,
  `transaction_id` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `ip_address` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_520_ci,
  `customer_note` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  `virtual` tinyint(1) DEFAULT '0',
  `downloadable` tinyint(1) DEFAULT '0',
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT '0',
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT '0',
  `average_rating` decimal(3,2) DEFAULT '0.00',
  `total_sales` bigint(20) DEFAULT '0',
  `tax_status` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT 'taxable',
  `tax_class` varchar(100) COLLATE utf8mb4_unicode_520_ci DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT '0',
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `secret` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `topic` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT '0',
  `pending_delivery` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `permissions` varchar(10) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_key` char(64) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `consumer_secret` char(43) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `nonces` longtext COLLATE utf8mb4_unicode_520_ci,
  `truncated_key` char(7) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_label` varchar(200) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `attribute_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_orderby` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `order_key` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_email` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `message` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `context` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `order_item_type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `type` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate` varchar(8) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT '0',
  `tax_rate_shipping` int(1) NOT NULL DEFAULT '1',
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("149", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "failed", "2023-11-15 13:17:15", "2023-11-15 13:17:15", "10", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2023-11-15 13:17:31", "2023-11-15 13:17:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1069", "pinterest_for_woocommerce_daily_heartbeat", "failed", "2023-12-07 11:52:36", "2023-12-07 11:52:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1701949956;s:18:\"\0*\0first_timestamp\";i:1700042549;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1701949956;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2023-12-12 09:58:37", "2023-12-12 09:58:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1070", "pinterest_for_woocommerce_hourly_heartbeat", "failed", "2023-12-06 12:52:36", "2023-12-06 12:52:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1701867156;s:18:\"\0*\0first_timestamp\";i:1700042549;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1701867156;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "4", "1", "2023-12-06 12:52:37", "2023-12-06 12:52:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1095", "pinterest_for_woocommerce_hourly_heartbeat", "failed", "2023-12-06 13:52:37", "2023-12-06 13:52:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1701870757;s:18:\"\0*\0first_timestamp\";i:1700042549;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1701870757;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "4", "1", "2023-12-06 13:53:31", "2023-12-06 13:53:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1104", "pinterest_for_woocommerce_hourly_heartbeat", "failed", "2023-12-06 14:53:31", "2023-12-06 14:53:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1701874411;s:18:\"\0*\0first_timestamp\";i:1700042549;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1701874411;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "4", "1", "2023-12-06 14:53:40", "2023-12-06 14:53:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1105", "pinterest_for_woocommerce_hourly_heartbeat", "failed", "2023-12-06 15:53:40", "2023-12-06 15:53:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1701878020;s:18:\"\0*\0first_timestamp\";i:1700042549;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1701878020;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "4", "1", "2023-12-12 09:58:37", "2023-12-12 09:58:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1106", "pinterest_for_woocommerce_hourly_heartbeat", "failed", "2023-12-12 10:58:37", "2023-12-12 10:58:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1702378717;s:18:\"\0*\0first_timestamp\";i:1700042549;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1702378717;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "4", "1", "2023-12-12 11:00:04", "2023-12-12 11:00:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1108", "pinterest_for_woocommerce_daily_heartbeat", "failed", "2023-12-13 09:58:37", "2023-12-13 09:58:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1702461517;s:18:\"\0*\0first_timestamp\";i:1700042549;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1702461517;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2023-12-13 10:49:34", "2023-12-13 10:49:34", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1109", "pinterest_for_woocommerce_hourly_heartbeat", "failed", "2023-12-12 12:00:04", "2023-12-12 12:00:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1702382404;s:18:\"\0*\0first_timestamp\";i:1700042549;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1702382404;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "4", "1", "2023-12-12 12:00:05", "2023-12-12 12:00:05", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1110", "pinterest_for_woocommerce_hourly_heartbeat", "failed", "2023-12-12 13:00:05", "2023-12-12 13:00:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1702386005;s:18:\"\0*\0first_timestamp\";i:1700042549;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1702386005;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "4", "1", "2023-12-13 10:49:34", "2023-12-13 10:49:34", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1119", "pinterest_for_woocommerce_hourly_heartbeat", "failed", "2023-12-13 11:49:34", "2023-12-13 11:49:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1702468174;s:18:\"\0*\0first_timestamp\";i:1700042549;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1702468174;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "4", "1", "2024-01-02 15:44:46", "2024-01-02 15:44:46", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1121", "pinterest_for_woocommerce_daily_heartbeat", "failed", "2023-12-14 10:49:34", "2023-12-14 10:49:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1702550974;s:18:\"\0*\0first_timestamp\";i:1700042549;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1702550974;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2024-01-02 15:44:46", "2024-01-02 15:44:46", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1122", "pinterest_for_woocommerce_hourly_heartbeat", "failed", "2024-01-02 16:44:46", "2024-01-02 16:44:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1704213886;s:18:\"\0*\0first_timestamp\";i:1700042549;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1704213886;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "4", "1", "2024-01-02 16:45:57", "2024-01-02 16:45:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1124", "pinterest_for_woocommerce_daily_heartbeat", "failed", "2024-01-03 15:44:46", "2024-01-03 15:44:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1704296686;s:18:\"\0*\0first_timestamp\";i:1700042549;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1704296686;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2024-02-05 12:17:39", "2024-02-05 12:17:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1125", "pinterest_for_woocommerce_hourly_heartbeat", "failed", "2024-01-02 17:45:57", "2024-01-02 17:45:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1704217557;s:18:\"\0*\0first_timestamp\";i:1700042549;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1704217557;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "4", "1", "2024-01-02 17:45:57", "2024-01-02 17:45:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1126", "pinterest_for_woocommerce_hourly_heartbeat", "failed", "2024-01-02 18:45:57", "2024-01-02 18:45:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1704221157;s:18:\"\0*\0first_timestamp\";i:1700042549;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1704221157;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "4", "1", "2024-01-02 18:45:57", "2024-01-02 18:45:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1127", "pinterest_for_woocommerce_hourly_heartbeat", "failed", "2024-01-02 19:45:57", "2024-01-02 19:45:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1704224757;s:18:\"\0*\0first_timestamp\";i:1700042549;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1704224757;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "4", "1", "2024-02-05 12:17:39", "2024-02-05 12:17:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1129", "pinterest_for_woocommerce_daily_heartbeat", "failed", "2024-02-06 12:17:39", "2024-02-06 12:17:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1707221859;s:18:\"\0*\0first_timestamp\";i:1700042549;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1707221859;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "4", "1", "2024-02-07 13:47:18", "2024-02-07 13:47:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1235", "woocommerce_cleanup_draft_orders", "complete", "2024-02-28 13:28:24", "2024-02-28 13:28:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1709126904;s:18:\"\0*\0first_timestamp\";i:1700042492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1709126904;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-02-29 15:06:41", "2024-02-29 15:06:41", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1236", "woocommerce_cleanup_draft_orders", "complete", "2024-03-01 15:06:41", "2024-03-01 15:06:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1709305601;s:18:\"\0*\0first_timestamp\";i:1700042492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1709305601;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-03-26 14:42:23", "2024-03-26 14:42:23", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1237", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-02-29 15:08:44", "2024-02-29 15:08:44", "10", "[245,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1709219324;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1709219324;}", "5", "1", "2024-02-29 15:09:09", "2024-02-29 15:09:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1238", "woocommerce_cleanup_draft_orders", "complete", "2024-03-27 14:42:23", "2024-03-27 14:42:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711550543;s:18:\"\0*\0first_timestamp\";i:1700042492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711550543;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-03-27 14:58:39", "2024-03-27 14:58:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1239", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2024-03-26 14:43:05", "2024-03-26 14:43:05", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711464185;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711464185;}", "7", "1", "2024-03-26 15:16:06", "2024-03-26 15:16:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1240", "action_scheduler/migration_hook", "complete", "2024-03-26 15:26:46", "2024-03-26 15:26:46", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711466806;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711466806;}", "1", "1", "2024-03-26 15:26:46", "2024-03-26 15:26:46", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1241", "action_scheduler/migration_hook", "complete", "2024-03-26 15:28:09", "2024-03-26 15:28:09", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711466889;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711466889;}", "1", "1", "2024-03-26 15:28:13", "2024-03-26 15:28:13", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1242", "woocommerce_run_update_callback", "complete", "2024-03-26 15:34:24", "2024-03-26 15:34:24", "10", "{\"update_callback\":\"wc_update_860_remove_recommended_marketing_plugins_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711467264;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711467264;}", "5", "1", "2024-03-26 15:34:39", "2024-03-26 15:34:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1243", "woocommerce_run_update_callback", "complete", "2024-03-26 15:34:25", "2024-03-26 15:34:25", "10", "{\"update_callback\":\"wc_update_870_prevent_listing_of_transient_files_directory\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711467265;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711467265;}", "5", "1", "2024-03-26 15:34:39", "2024-03-26 15:34:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1244", "woocommerce_update_db_to_current_version", "complete", "2024-03-26 15:34:26", "2024-03-26 15:34:26", "10", "{\"version\":\"8.7.0\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711467266;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711467266;}", "5", "1", "2024-03-26 15:34:39", "2024-03-26 15:34:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1245", "mailpoet/cron/daemon-trigger", "complete", "2024-03-26 15:34:52", "2024-03-26 15:34:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711467292;s:18:\"\0*\0first_timestamp\";i:1711467292;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711467292;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-26 15:36:27", "2024-03-26 15:36:27", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1246", "mailpoet/cron/daemon-run", "complete", "2024-03-26 15:36:22", "2024-03-26 15:36:22", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711467382;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711467382;}", "6", "1", "2024-03-26 15:36:27", "2024-03-26 15:36:27", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1247", "mailpoet/cron/daemon-trigger", "complete", "2024-03-26 15:38:27", "2024-03-26 15:38:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711467507;s:18:\"\0*\0first_timestamp\";i:1711467292;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711467507;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-26 15:40:14", "2024-03-26 15:40:14", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1248", "mailpoet/cron/daemon-run", "complete", "2024-03-26 15:40:09", "2024-03-26 15:40:09", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711467609;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711467609;}", "6", "1", "2024-03-26 15:40:14", "2024-03-26 15:40:14", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1249", "mailpoet/cron/daemon-trigger", "complete", "2024-03-26 15:42:14", "2024-03-26 15:42:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711467734;s:18:\"\0*\0first_timestamp\";i:1711467292;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711467734;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-26 15:42:53", "2024-03-26 15:42:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1250", "mailpoet/cron/daemon-run", "complete", "2024-03-26 15:42:50", "2024-03-26 15:42:50", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711467770;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711467770;}", "6", "1", "2024-03-26 15:42:53", "2024-03-26 15:42:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1251", "mailpoet/cron/daemon-trigger", "complete", "2024-03-26 15:44:53", "2024-03-26 15:44:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711467893;s:18:\"\0*\0first_timestamp\";i:1711467292;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711467893;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-26 15:46:16", "2024-03-26 15:46:16", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1252", "mailpoet/cron/daemon-run", "complete", "2024-03-26 15:46:11", "2024-03-26 15:46:11", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711467971;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711467971;}", "6", "1", "2024-03-26 15:46:17", "2024-03-26 15:46:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1253", "mailpoet/cron/daemon-trigger", "complete", "2024-03-26 15:48:17", "2024-03-26 15:48:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711468097;s:18:\"\0*\0first_timestamp\";i:1711467292;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711468097;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-27 14:58:39", "2024-03-27 14:58:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1254", "mailpoet/cron/daemon-run", "complete", "2024-03-27 14:58:38", "2024-03-27 14:58:38", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711551518;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711551518;}", "6", "1", "2024-03-27 14:58:39", "2024-03-27 14:58:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1255", "mailpoet/cron/daemon-trigger", "complete", "2024-03-27 15:00:39", "2024-03-27 15:00:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711551639;s:18:\"\0*\0first_timestamp\";i:1711467292;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711551639;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-27 15:01:49", "2024-03-27 15:01:49", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1256", "woocommerce_cleanup_draft_orders", "complete", "2024-03-28 14:58:39", "2024-03-28 14:58:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711637919;s:18:\"\0*\0first_timestamp\";i:1700042492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711637919;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2024-03-29 12:40:06", "2024-03-29 12:40:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1257", "mailpoet/cron/daemon-run", "complete", "2024-03-27 15:01:44", "2024-03-27 15:01:44", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711551704;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711551704;}", "6", "1", "2024-03-27 15:01:49", "2024-03-27 15:01:49", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1258", "mailpoet/cron/daemon-trigger", "complete", "2024-03-27 15:03:49", "2024-03-27 15:03:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711551829;s:18:\"\0*\0first_timestamp\";i:1711467292;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711551829;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-27 15:05:51", "2024-03-27 15:05:51", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1259", "mailpoet/cron/daemon-run", "complete", "2024-03-27 15:05:46", "2024-03-27 15:05:46", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711551946;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711551946;}", "6", "1", "2024-03-27 15:05:51", "2024-03-27 15:05:51", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1260", "mailpoet/cron/daemon-trigger", "complete", "2024-03-27 15:07:51", "2024-03-27 15:07:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711552071;s:18:\"\0*\0first_timestamp\";i:1711467292;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711552071;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-27 15:08:47", "2024-03-27 15:08:47", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1261", "mailpoet/cron/daemon-run", "complete", "2024-03-27 15:08:42", "2024-03-27 15:08:42", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711552122;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711552122;}", "6", "1", "2024-03-27 15:08:47", "2024-03-27 15:08:47", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1262", "mailpoet/cron/daemon-trigger", "complete", "2024-03-27 15:10:47", "2024-03-27 15:10:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711552247;s:18:\"\0*\0first_timestamp\";i:1711467292;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711552247;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-27 15:12:49", "2024-03-27 15:12:49", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1263", "mailpoet/cron/daemon-run", "complete", "2024-03-27 15:12:44", "2024-03-27 15:12:44", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711552364;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711552364;}", "6", "1", "2024-03-27 15:12:49", "2024-03-27 15:12:49", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1264", "mailpoet/cron/daemon-trigger", "complete", "2024-03-27 15:14:49", "2024-03-27 15:14:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711552489;s:18:\"\0*\0first_timestamp\";i:1711467292;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711552489;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-27 15:16:51", "2024-03-27 15:16:51", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1265", "mailpoet/cron/daemon-run", "complete", "2024-03-27 15:16:46", "2024-03-27 15:16:46", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711552606;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711552606;}", "6", "1", "2024-03-27 15:16:51", "2024-03-27 15:16:51", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1266", "mailpoet/cron/daemon-trigger", "complete", "2024-03-27 15:18:51", "2024-03-27 15:18:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711552731;s:18:\"\0*\0first_timestamp\";i:1711467292;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711552731;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-27 15:19:21", "2024-03-27 15:19:21", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1267", "mailpoet/cron/daemon-run", "complete", "2024-03-27 15:19:16", "2024-03-27 15:19:16", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711552756;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711552756;}", "6", "1", "2024-03-27 15:19:21", "2024-03-27 15:19:21", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1268", "mailpoet/cron/daemon-trigger", "complete", "2024-03-27 15:21:21", "2024-03-27 15:21:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711552881;s:18:\"\0*\0first_timestamp\";i:1711467292;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711552881;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-27 15:23:23", "2024-03-27 15:23:23", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1269", "mailpoet/cron/daemon-run", "complete", "2024-03-27 15:23:18", "2024-03-27 15:23:18", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711552998;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711552998;}", "6", "1", "2024-03-27 15:23:23", "2024-03-27 15:23:23", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1270", "mailpoet/cron/daemon-trigger", "complete", "2024-03-27 15:25:23", "2024-03-27 15:25:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711553123;s:18:\"\0*\0first_timestamp\";i:1711467292;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711553123;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-27 15:27:25", "2024-03-27 15:27:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1271", "mailpoet/cron/daemon-run", "complete", "2024-03-27 15:27:20", "2024-03-27 15:27:20", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711553240;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711553240;}", "6", "1", "2024-03-27 15:27:25", "2024-03-27 15:27:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1272", "mailpoet/cron/daemon-trigger", "complete", "2024-03-27 15:29:25", "2024-03-27 15:29:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711553365;s:18:\"\0*\0first_timestamp\";i:1711467292;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711553365;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-27 15:31:27", "2024-03-27 15:31:27", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1273", "mailpoet/cron/daemon-run", "complete", "2024-03-27 15:31:22", "2024-03-27 15:31:22", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711553482;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711553482;}", "6", "1", "2024-03-27 15:31:27", "2024-03-27 15:31:27", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1274", "mailpoet/cron/daemon-trigger", "complete", "2024-03-27 15:33:27", "2024-03-27 15:33:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711553607;s:18:\"\0*\0first_timestamp\";i:1711467292;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711553607;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-27 15:35:29", "2024-03-27 15:35:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1275", "mailpoet/cron/daemon-run", "complete", "2024-03-27 15:35:24", "2024-03-27 15:35:24", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711553724;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711553724;}", "6", "1", "2024-03-27 15:35:29", "2024-03-27 15:35:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1276", "mailpoet/cron/daemon-trigger", "complete", "2024-03-27 15:37:29", "2024-03-27 15:37:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711553849;s:18:\"\0*\0first_timestamp\";i:1711467292;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711553849;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-27 15:39:31", "2024-03-27 15:39:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1277", "mailpoet/cron/daemon-run", "complete", "2024-03-27 15:39:26", "2024-03-27 15:39:26", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711553966;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711553966;}", "6", "1", "2024-03-27 15:39:31", "2024-03-27 15:39:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1279", "action_scheduler/migration_hook", "complete", "2024-03-28 08:34:40", "2024-03-28 08:34:40", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711614880;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711614880;}", "1", "1", "2024-03-28 08:35:01", "2024-03-28 08:35:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1280", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 12:38:58", "2024-03-29 12:38:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711715938;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711715938;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 12:40:11", "2024-03-29 12:40:11", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1281", "woocommerce_cleanup_draft_orders", "pending", "2024-03-30 12:40:06", "2024-03-30 12:40:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711802406;s:18:\"\0*\0first_timestamp\";i:1700042492;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711802406;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1282", "mailpoet/cron/daemon-run", "complete", "2024-03-29 12:40:06", "2024-03-29 12:40:06", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711716006;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711716006;}", "6", "1", "2024-03-29 12:40:11", "2024-03-29 12:40:11", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1283", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 12:42:11", "2024-03-29 12:42:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711716131;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711716131;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 12:42:39", "2024-03-29 12:42:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1284", "mailpoet/cron/daemon-run", "complete", "2024-03-29 12:42:34", "2024-03-29 12:42:34", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711716154;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711716154;}", "6", "1", "2024-03-29 12:42:39", "2024-03-29 12:42:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1285", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 12:44:39", "2024-03-29 12:44:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711716279;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711716279;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 12:44:44", "2024-03-29 12:44:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1286", "mailpoet/cron/daemon-run", "complete", "2024-03-29 12:44:43", "2024-03-29 12:44:43", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711716283;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711716283;}", "6", "1", "2024-03-29 12:44:44", "2024-03-29 12:44:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1287", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 12:46:44", "2024-03-29 12:46:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711716404;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711716404;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 12:48:40", "2024-03-29 12:48:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1288", "mailpoet/cron/daemon-run", "complete", "2024-03-29 12:48:35", "2024-03-29 12:48:35", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711716515;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711716515;}", "6", "1", "2024-03-29 12:48:41", "2024-03-29 12:48:41", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1289", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 12:50:40", "2024-03-29 12:50:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711716640;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711716640;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 12:52:42", "2024-03-29 12:52:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1290", "mailpoet/cron/daemon-run", "complete", "2024-03-29 12:52:37", "2024-03-29 12:52:37", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711716757;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711716757;}", "6", "1", "2024-03-29 12:52:42", "2024-03-29 12:52:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1291", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 12:54:42", "2024-03-29 12:54:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711716882;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711716882;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 12:55:34", "2024-03-29 12:55:34", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1292", "mailpoet/cron/daemon-run", "complete", "2024-03-29 12:55:29", "2024-03-29 12:55:29", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711716929;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711716929;}", "6", "1", "2024-03-29 12:55:35", "2024-03-29 12:55:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1293", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 12:57:34", "2024-03-29 12:57:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711717054;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711717054;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 12:59:36", "2024-03-29 12:59:36", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1294", "mailpoet/cron/daemon-run", "complete", "2024-03-29 12:59:31", "2024-03-29 12:59:31", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711717171;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711717171;}", "6", "1", "2024-03-29 12:59:37", "2024-03-29 12:59:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1295", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 13:01:36", "2024-03-29 13:01:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711717296;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711717296;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 13:03:38", "2024-03-29 13:03:38", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1296", "mailpoet/cron/daemon-run", "complete", "2024-03-29 13:03:33", "2024-03-29 13:03:33", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711717413;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711717413;}", "6", "1", "2024-03-29 13:03:39", "2024-03-29 13:03:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1297", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 13:05:38", "2024-03-29 13:05:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711717538;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711717538;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 13:07:40", "2024-03-29 13:07:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1298", "mailpoet/cron/daemon-run", "complete", "2024-03-29 13:07:35", "2024-03-29 13:07:35", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711717655;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711717655;}", "6", "1", "2024-03-29 13:07:41", "2024-03-29 13:07:41", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1299", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 13:09:40", "2024-03-29 13:09:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711717780;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711717780;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 13:11:42", "2024-03-29 13:11:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1300", "mailpoet/cron/daemon-run", "complete", "2024-03-29 13:11:37", "2024-03-29 13:11:37", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711717897;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711717897;}", "6", "1", "2024-03-29 13:11:43", "2024-03-29 13:11:43", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1301", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 13:13:42", "2024-03-29 13:13:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711718022;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711718022;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 13:15:44", "2024-03-29 13:15:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1302", "mailpoet/cron/daemon-run", "complete", "2024-03-29 13:15:39", "2024-03-29 13:15:39", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711718139;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711718139;}", "6", "1", "2024-03-29 13:15:45", "2024-03-29 13:15:45", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1303", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 13:17:44", "2024-03-29 13:17:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711718264;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711718264;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 13:19:46", "2024-03-29 13:19:46", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1304", "mailpoet/cron/daemon-run", "complete", "2024-03-29 13:19:41", "2024-03-29 13:19:41", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711718381;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711718381;}", "6", "1", "2024-03-29 13:19:46", "2024-03-29 13:19:46", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1305", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 13:21:46", "2024-03-29 13:21:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711718506;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711718506;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 13:23:48", "2024-03-29 13:23:48", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1306", "mailpoet/cron/daemon-run", "complete", "2024-03-29 13:23:43", "2024-03-29 13:23:43", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711718623;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711718623;}", "6", "1", "2024-03-29 13:23:48", "2024-03-29 13:23:48", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1307", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 13:25:48", "2024-03-29 13:25:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711718748;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711718748;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 13:27:50", "2024-03-29 13:27:50", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1308", "mailpoet/cron/daemon-run", "complete", "2024-03-29 13:27:45", "2024-03-29 13:27:45", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711718865;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711718865;}", "6", "1", "2024-03-29 13:27:51", "2024-03-29 13:27:51", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1309", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 13:29:50", "2024-03-29 13:29:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711718990;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711718990;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 13:31:52", "2024-03-29 13:31:52", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1310", "mailpoet/cron/daemon-run", "complete", "2024-03-29 13:31:47", "2024-03-29 13:31:47", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711719107;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711719107;}", "6", "1", "2024-03-29 13:31:52", "2024-03-29 13:31:52", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1311", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 13:33:52", "2024-03-29 13:33:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711719232;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711719232;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 13:35:54", "2024-03-29 13:35:54", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1312", "mailpoet/cron/daemon-run", "complete", "2024-03-29 13:35:49", "2024-03-29 13:35:49", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711719349;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711719349;}", "6", "1", "2024-03-29 13:35:54", "2024-03-29 13:35:54", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1313", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 13:37:54", "2024-03-29 13:37:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711719474;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711719474;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 13:39:57", "2024-03-29 13:39:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1314", "mailpoet/cron/daemon-run", "complete", "2024-03-29 13:39:52", "2024-03-29 13:39:52", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711719592;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711719592;}", "6", "1", "2024-03-29 13:39:57", "2024-03-29 13:39:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1315", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 13:41:57", "2024-03-29 13:41:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711719717;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711719717;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 13:43:58", "2024-03-29 13:43:58", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1316", "mailpoet/cron/daemon-run", "complete", "2024-03-29 13:43:53", "2024-03-29 13:43:53", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711719833;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711719833;}", "6", "1", "2024-03-29 13:43:58", "2024-03-29 13:43:58", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1317", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 13:45:58", "2024-03-29 13:45:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711719958;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711719958;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 13:48:00", "2024-03-29 13:48:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1318", "mailpoet/cron/daemon-run", "complete", "2024-03-29 13:47:55", "2024-03-29 13:47:55", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711720075;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711720075;}", "6", "1", "2024-03-29 13:48:01", "2024-03-29 13:48:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1319", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 13:50:00", "2024-03-29 13:50:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711720200;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711720200;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 13:52:03", "2024-03-29 13:52:03", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1320", "mailpoet/cron/daemon-run", "complete", "2024-03-29 13:51:58", "2024-03-29 13:51:58", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711720318;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711720318;}", "6", "1", "2024-03-29 13:52:03", "2024-03-29 13:52:03", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1321", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 13:54:03", "2024-03-29 13:54:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711720443;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711720443;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 13:56:05", "2024-03-29 13:56:05", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1322", "mailpoet/cron/daemon-run", "complete", "2024-03-29 13:56:00", "2024-03-29 13:56:00", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711720560;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711720560;}", "6", "1", "2024-03-29 13:56:05", "2024-03-29 13:56:05", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1323", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 13:58:05", "2024-03-29 13:58:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711720685;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711720685;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 14:00:07", "2024-03-29 14:00:07", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1324", "mailpoet/cron/daemon-run", "complete", "2024-03-29 14:00:02", "2024-03-29 14:00:02", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711720802;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711720802;}", "6", "1", "2024-03-29 14:00:07", "2024-03-29 14:00:07", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1325", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 14:02:07", "2024-03-29 14:02:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711720927;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711720927;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 14:04:09", "2024-03-29 14:04:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1326", "mailpoet/cron/daemon-run", "complete", "2024-03-29 14:04:04", "2024-03-29 14:04:04", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711721044;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711721044;}", "6", "1", "2024-03-29 14:04:09", "2024-03-29 14:04:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1327", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 14:06:09", "2024-03-29 14:06:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711721169;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711721169;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 14:08:11", "2024-03-29 14:08:11", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1328", "mailpoet/cron/daemon-run", "complete", "2024-03-29 14:08:06", "2024-03-29 14:08:06", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711721286;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711721286;}", "6", "1", "2024-03-29 14:08:11", "2024-03-29 14:08:11", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1329", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 14:10:11", "2024-03-29 14:10:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711721411;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711721411;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 14:10:27", "2024-03-29 14:10:27", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1330", "mailpoet/cron/daemon-run", "complete", "2024-03-29 14:10:27", "2024-03-29 14:10:27", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711721427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711721427;}", "6", "1", "2024-03-29 14:10:27", "2024-03-29 14:10:27", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1331", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 14:12:27", "2024-03-29 14:12:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711721547;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711721547;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 14:12:33", "2024-03-29 14:12:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1332", "mailpoet/cron/daemon-run", "complete", "2024-03-29 14:12:28", "2024-03-29 14:12:28", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711721548;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711721548;}", "6", "1", "2024-03-29 14:12:33", "2024-03-29 14:12:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1333", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 14:14:33", "2024-03-29 14:14:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711721673;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711721673;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 14:14:46", "2024-03-29 14:14:46", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1334", "mailpoet/cron/daemon-run", "complete", "2024-03-29 14:14:41", "2024-03-29 14:14:41", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711721681;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711721681;}", "6", "1", "2024-03-29 14:14:46", "2024-03-29 14:14:46", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1335", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 14:16:46", "2024-03-29 14:16:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711721806;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711721806;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 14:16:50", "2024-03-29 14:16:50", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1336", "mailpoet/cron/daemon-run", "complete", "2024-03-29 14:16:50", "2024-03-29 14:16:50", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711721810;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711721810;}", "6", "1", "2024-03-29 14:16:50", "2024-03-29 14:16:50", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1337", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 14:18:50", "2024-03-29 14:18:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711721930;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711721930;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 14:18:51", "2024-03-29 14:18:51", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1338", "mailpoet/cron/daemon-run", "complete", "2024-03-29 14:18:50", "2024-03-29 14:18:50", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711721930;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711721930;}", "6", "1", "2024-03-29 14:18:51", "2024-03-29 14:18:51", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1339", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 14:20:51", "2024-03-29 14:20:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711722051;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711722051;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 14:20:57", "2024-03-29 14:20:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1340", "mailpoet/cron/daemon-run", "complete", "2024-03-29 14:20:52", "2024-03-29 14:20:52", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711722052;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711722052;}", "6", "1", "2024-03-29 14:20:57", "2024-03-29 14:20:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1341", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 14:22:57", "2024-03-29 14:22:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711722177;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711722177;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 14:24:58", "2024-03-29 14:24:58", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1342", "mailpoet/cron/daemon-run", "complete", "2024-03-29 14:24:53", "2024-03-29 14:24:53", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711722293;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711722293;}", "6", "1", "2024-03-29 14:24:58", "2024-03-29 14:24:58", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1343", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 14:26:58", "2024-03-29 14:26:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711722418;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711722418;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 14:29:00", "2024-03-29 14:29:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1344", "mailpoet/cron/daemon-run", "complete", "2024-03-29 14:28:54", "2024-03-29 14:28:54", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711722534;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711722534;}", "6", "1", "2024-03-29 14:29:00", "2024-03-29 14:29:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1345", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 14:31:00", "2024-03-29 14:31:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711722660;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711722660;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 14:31:04", "2024-03-29 14:31:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1346", "mailpoet/cron/daemon-run", "complete", "2024-03-29 14:31:03", "2024-03-29 14:31:03", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711722663;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711722663;}", "6", "1", "2024-03-29 14:31:04", "2024-03-29 14:31:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1347", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 14:33:04", "2024-03-29 14:33:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711722784;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711722784;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 14:33:12", "2024-03-29 14:33:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1348", "mailpoet/cron/daemon-run", "complete", "2024-03-29 14:33:11", "2024-03-29 14:33:11", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711722791;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711722791;}", "6", "1", "2024-03-29 14:33:12", "2024-03-29 14:33:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1349", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 14:35:12", "2024-03-29 14:35:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711722912;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711722912;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 14:35:30", "2024-03-29 14:35:30", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1350", "mailpoet/cron/daemon-run", "complete", "2024-03-29 14:35:28", "2024-03-29 14:35:28", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711722928;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711722928;}", "6", "1", "2024-03-29 14:35:29", "2024-03-29 14:35:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1351", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 14:37:30", "2024-03-29 14:37:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711723050;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711723050;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 14:37:48", "2024-03-29 14:37:48", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1352", "mailpoet/cron/daemon-run", "complete", "2024-03-29 14:37:43", "2024-03-29 14:37:43", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711723063;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711723063;}", "6", "1", "2024-03-29 14:37:48", "2024-03-29 14:37:48", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1353", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 14:39:48", "2024-03-29 14:39:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711723188;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711723188;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 14:40:26", "2024-03-29 14:40:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1354", "mailpoet/cron/daemon-run", "complete", "2024-03-29 14:40:21", "2024-03-29 14:40:21", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711723221;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711723221;}", "6", "1", "2024-03-29 14:40:26", "2024-03-29 14:40:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1355", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 14:42:26", "2024-03-29 14:42:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711723346;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711723346;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 14:43:16", "2024-03-29 14:43:16", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1356", "mailpoet/cron/daemon-run", "complete", "2024-03-29 14:43:11", "2024-03-29 14:43:11", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711723391;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711723391;}", "6", "1", "2024-03-29 14:43:16", "2024-03-29 14:43:16", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1357", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 14:45:16", "2024-03-29 14:45:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711723516;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711723516;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 14:45:21", "2024-03-29 14:45:21", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1358", "mailpoet/cron/daemon-run", "complete", "2024-03-29 14:45:21", "2024-03-29 14:45:21", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711723521;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711723521;}", "6", "1", "2024-03-29 14:45:21", "2024-03-29 14:45:21", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1359", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 14:47:21", "2024-03-29 14:47:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711723641;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711723641;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 14:47:27", "2024-03-29 14:47:27", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1360", "mailpoet/cron/daemon-run", "complete", "2024-03-29 14:47:22", "2024-03-29 14:47:22", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711723642;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711723642;}", "6", "1", "2024-03-29 14:47:27", "2024-03-29 14:47:27", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1361", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 14:49:27", "2024-03-29 14:49:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711723767;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711723767;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 14:49:37", "2024-03-29 14:49:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1362", "mailpoet/cron/daemon-run", "complete", "2024-03-29 14:49:36", "2024-03-29 14:49:36", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711723776;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711723776;}", "6", "1", "2024-03-29 14:49:37", "2024-03-29 14:49:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1363", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 14:51:37", "2024-03-29 14:51:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711723897;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711723897;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 14:51:39", "2024-03-29 14:51:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1364", "mailpoet/cron/daemon-run", "complete", "2024-03-29 14:51:39", "2024-03-29 14:51:39", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711723899;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711723899;}", "6", "1", "2024-03-29 14:51:39", "2024-03-29 14:51:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1365", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 14:53:39", "2024-03-29 14:53:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711724019;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711724019;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 14:54:21", "2024-03-29 14:54:21", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1366", "mailpoet/cron/daemon-run", "complete", "2024-03-29 14:54:20", "2024-03-29 14:54:20", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711724060;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711724060;}", "6", "1", "2024-03-29 14:54:21", "2024-03-29 14:54:21", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1367", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 14:56:21", "2024-03-29 14:56:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711724181;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711724181;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 14:56:29", "2024-03-29 14:56:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1368", "mailpoet/cron/daemon-run", "complete", "2024-03-29 14:56:28", "2024-03-29 14:56:28", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711724188;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711724188;}", "6", "1", "2024-03-29 14:56:29", "2024-03-29 14:56:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1369", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 14:58:29", "2024-03-29 14:58:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711724309;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711724309;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 14:58:43", "2024-03-29 14:58:43", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1370", "mailpoet/cron/daemon-run", "complete", "2024-03-29 14:58:41", "2024-03-29 14:58:41", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711724321;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711724321;}", "6", "1", "2024-03-29 14:58:43", "2024-03-29 14:58:43", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1371", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 15:00:43", "2024-03-29 15:00:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711724443;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711724443;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 15:00:46", "2024-03-29 15:00:46", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1372", "mailpoet/cron/daemon-run", "complete", "2024-03-29 15:00:45", "2024-03-29 15:00:45", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711724445;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711724445;}", "6", "1", "2024-03-29 15:00:46", "2024-03-29 15:00:46", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1373", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 15:02:46", "2024-03-29 15:02:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711724566;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711724566;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 15:03:06", "2024-03-29 15:03:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1374", "mailpoet/cron/daemon-run", "complete", "2024-03-29 15:03:05", "2024-03-29 15:03:05", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711724585;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711724585;}", "6", "1", "2024-03-29 15:03:06", "2024-03-29 15:03:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1375", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 15:05:06", "2024-03-29 15:05:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711724706;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711724706;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 15:05:45", "2024-03-29 15:05:45", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1376", "mailpoet/cron/daemon-run", "complete", "2024-03-29 15:05:44", "2024-03-29 15:05:44", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711724744;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711724744;}", "6", "1", "2024-03-29 15:05:45", "2024-03-29 15:05:45", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1377", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 15:07:45", "2024-03-29 15:07:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711724865;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711724865;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 15:07:50", "2024-03-29 15:07:50", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1378", "mailpoet/cron/daemon-run", "complete", "2024-03-29 15:07:45", "2024-03-29 15:07:45", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711724865;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711724865;}", "6", "1", "2024-03-29 15:07:51", "2024-03-29 15:07:51", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1379", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 15:09:50", "2024-03-29 15:09:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711724990;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711724990;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 15:10:17", "2024-03-29 15:10:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1380", "mailpoet/cron/daemon-run", "complete", "2024-03-29 15:10:15", "2024-03-29 15:10:15", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711725015;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711725015;}", "6", "1", "2024-03-29 15:10:17", "2024-03-29 15:10:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1381", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 15:12:17", "2024-03-29 15:12:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711725137;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711725137;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 15:12:19", "2024-03-29 15:12:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1382", "mailpoet/cron/daemon-run", "complete", "2024-03-29 15:12:17", "2024-03-29 15:12:17", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711725137;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711725137;}", "6", "1", "2024-03-29 15:12:18", "2024-03-29 15:12:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1383", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 15:14:19", "2024-03-29 15:14:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711725259;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711725259;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 15:14:43", "2024-03-29 15:14:43", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1384", "mailpoet/cron/daemon-run", "complete", "2024-03-29 15:14:42", "2024-03-29 15:14:42", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711725282;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711725282;}", "6", "1", "2024-03-29 15:14:43", "2024-03-29 15:14:43", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1385", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 15:16:43", "2024-03-29 15:16:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711725403;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711725403;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 15:16:57", "2024-03-29 15:16:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1386", "mailpoet/cron/daemon-run", "complete", "2024-03-29 15:16:52", "2024-03-29 15:16:52", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711725412;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711725412;}", "6", "1", "2024-03-29 15:16:57", "2024-03-29 15:16:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1387", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 15:18:57", "2024-03-29 15:18:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711725537;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711725537;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 15:19:52", "2024-03-29 15:19:52", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1388", "mailpoet/cron/daemon-run", "complete", "2024-03-29 15:19:51", "2024-03-29 15:19:51", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711725591;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711725591;}", "6", "1", "2024-03-29 15:19:52", "2024-03-29 15:19:52", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1389", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 15:21:52", "2024-03-29 15:21:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711725712;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711725712;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 15:22:16", "2024-03-29 15:22:16", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1390", "mailpoet/cron/daemon-run", "complete", "2024-03-29 15:22:14", "2024-03-29 15:22:14", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711725734;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711725734;}", "6", "1", "2024-03-29 15:22:15", "2024-03-29 15:22:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1391", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 15:24:16", "2024-03-29 15:24:16", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711725856;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711725856;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 15:25:10", "2024-03-29 15:25:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1392", "mailpoet/cron/daemon-run", "complete", "2024-03-29 15:25:05", "2024-03-29 15:25:05", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711725905;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711725905;}", "6", "1", "2024-03-29 15:25:10", "2024-03-29 15:25:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1393", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 15:27:10", "2024-03-29 15:27:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711726030;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711726030;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 15:29:11", "2024-03-29 15:29:11", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1394", "mailpoet/cron/daemon-run", "complete", "2024-03-29 15:29:06", "2024-03-29 15:29:06", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711726146;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711726146;}", "6", "1", "2024-03-29 15:29:11", "2024-03-29 15:29:11", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1395", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 15:31:11", "2024-03-29 15:31:11", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711726271;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711726271;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 15:33:15", "2024-03-29 15:33:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1396", "mailpoet/cron/daemon-run", "complete", "2024-03-29 15:33:10", "2024-03-29 15:33:10", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711726390;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711726390;}", "6", "1", "2024-03-29 15:33:16", "2024-03-29 15:33:16", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1397", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 15:35:15", "2024-03-29 15:35:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711726515;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711726515;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 15:35:18", "2024-03-29 15:35:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1398", "mailpoet/cron/daemon-run", "complete", "2024-03-29 15:35:17", "2024-03-29 15:35:17", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711726517;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711726517;}", "6", "1", "2024-03-29 15:35:18", "2024-03-29 15:35:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1399", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 15:37:18", "2024-03-29 15:37:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711726638;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711726638;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 15:37:32", "2024-03-29 15:37:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1400", "mailpoet/cron/daemon-run", "complete", "2024-03-29 15:37:30", "2024-03-29 15:37:30", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711726650;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711726650;}", "6", "1", "2024-03-29 15:37:32", "2024-03-29 15:37:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1401", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 15:39:32", "2024-03-29 15:39:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711726772;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711726772;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 15:39:42", "2024-03-29 15:39:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1402", "mailpoet/cron/daemon-run", "complete", "2024-03-29 15:39:37", "2024-03-29 15:39:37", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711726777;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711726777;}", "6", "1", "2024-03-29 15:39:42", "2024-03-29 15:39:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1403", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 15:41:42", "2024-03-29 15:41:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711726902;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711726902;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 15:41:44", "2024-03-29 15:41:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1404", "mailpoet/cron/daemon-run", "complete", "2024-03-29 15:41:44", "2024-03-29 15:41:44", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711726904;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711726904;}", "6", "1", "2024-03-29 15:41:44", "2024-03-29 15:41:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1405", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 15:43:44", "2024-03-29 15:43:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711727024;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711727024;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 15:43:55", "2024-03-29 15:43:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1406", "mailpoet/cron/daemon-run", "complete", "2024-03-29 15:43:54", "2024-03-29 15:43:54", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711727034;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711727034;}", "6", "1", "2024-03-29 15:43:55", "2024-03-29 15:43:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1407", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 15:45:55", "2024-03-29 15:45:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711727155;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711727155;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 15:46:40", "2024-03-29 15:46:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1408", "mailpoet/cron/daemon-run", "complete", "2024-03-29 15:46:35", "2024-03-29 15:46:35", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711727195;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711727195;}", "6", "1", "2024-03-29 15:46:40", "2024-03-29 15:46:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1409", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 15:48:40", "2024-03-29 15:48:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711727320;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711727320;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 15:48:48", "2024-03-29 15:48:48", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1410", "mailpoet/cron/daemon-run", "complete", "2024-03-29 15:48:43", "2024-03-29 15:48:43", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711727323;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711727323;}", "6", "1", "2024-03-29 15:48:48", "2024-03-29 15:48:48", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1411", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 15:50:48", "2024-03-29 15:50:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711727448;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711727448;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 15:50:57", "2024-03-29 15:50:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1412", "mailpoet/cron/daemon-run", "complete", "2024-03-29 15:50:56", "2024-03-29 15:50:56", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711727456;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711727456;}", "6", "1", "2024-03-29 15:50:57", "2024-03-29 15:50:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1413", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 15:52:57", "2024-03-29 15:52:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711727577;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711727577;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 15:54:00", "2024-03-29 15:54:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1414", "mailpoet/cron/daemon-run", "complete", "2024-03-29 15:53:55", "2024-03-29 15:53:55", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711727635;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711727635;}", "6", "1", "2024-03-29 15:54:01", "2024-03-29 15:54:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1415", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 15:56:00", "2024-03-29 15:56:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711727760;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711727760;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 15:56:52", "2024-03-29 15:56:52", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1416", "mailpoet/cron/daemon-run", "complete", "2024-03-29 15:56:47", "2024-03-29 15:56:47", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711727807;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711727807;}", "6", "1", "2024-03-29 15:56:52", "2024-03-29 15:56:52", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1417", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 15:58:52", "2024-03-29 15:58:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711727932;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711727932;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 16:00:01", "2024-03-29 16:00:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1418", "mailpoet/cron/daemon-run", "complete", "2024-03-29 15:59:56", "2024-03-29 15:59:56", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711727996;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711727996;}", "6", "1", "2024-03-29 16:00:01", "2024-03-29 16:00:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1419", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 16:02:01", "2024-03-29 16:02:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711728121;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711728121;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 16:02:51", "2024-03-29 16:02:51", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1420", "mailpoet/cron/daemon-run", "complete", "2024-03-29 16:02:50", "2024-03-29 16:02:50", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711728170;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711728170;}", "6", "1", "2024-03-29 16:02:51", "2024-03-29 16:02:51", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1421", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 16:04:51", "2024-03-29 16:04:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711728291;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711728291;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 16:04:52", "2024-03-29 16:04:52", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1422", "mailpoet/cron/daemon-run", "complete", "2024-03-29 16:04:51", "2024-03-29 16:04:51", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711728291;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711728291;}", "6", "1", "2024-03-29 16:04:52", "2024-03-29 16:04:52", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1423", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 16:06:52", "2024-03-29 16:06:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711728412;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711728412;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 16:06:53", "2024-03-29 16:06:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1424", "mailpoet/cron/daemon-run", "complete", "2024-03-29 16:06:52", "2024-03-29 16:06:52", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711728412;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711728412;}", "6", "1", "2024-03-29 16:06:53", "2024-03-29 16:06:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1425", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 16:08:53", "2024-03-29 16:08:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711728533;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711728533;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 16:08:54", "2024-03-29 16:08:54", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1426", "mailpoet/cron/daemon-run", "complete", "2024-03-29 16:08:54", "2024-03-29 16:08:54", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711728534;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711728534;}", "6", "1", "2024-03-29 16:08:54", "2024-03-29 16:08:54", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1427", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 16:10:54", "2024-03-29 16:10:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711728654;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711728654;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 16:10:55", "2024-03-29 16:10:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1428", "mailpoet/cron/daemon-run", "complete", "2024-03-29 16:10:54", "2024-03-29 16:10:54", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711728654;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711728654;}", "6", "1", "2024-03-29 16:10:55", "2024-03-29 16:10:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1429", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 16:12:55", "2024-03-29 16:12:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711728775;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711728775;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 16:13:00", "2024-03-29 16:13:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1430", "mailpoet/cron/daemon-run", "complete", "2024-03-29 16:12:55", "2024-03-29 16:12:55", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711728775;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711728775;}", "6", "1", "2024-03-29 16:13:00", "2024-03-29 16:13:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1431", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 16:15:00", "2024-03-29 16:15:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711728900;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711728900;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 16:15:57", "2024-03-29 16:15:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1432", "mailpoet/cron/daemon-run", "complete", "2024-03-29 16:15:56", "2024-03-29 16:15:56", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711728956;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711728956;}", "6", "1", "2024-03-29 16:15:57", "2024-03-29 16:15:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1433", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 16:17:57", "2024-03-29 16:17:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711729077;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711729077;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 16:18:57", "2024-03-29 16:18:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1434", "mailpoet/cron/daemon-run", "complete", "2024-03-29 16:18:56", "2024-03-29 16:18:56", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711729136;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711729136;}", "6", "1", "2024-03-29 16:18:57", "2024-03-29 16:18:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1435", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 16:20:57", "2024-03-29 16:20:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711729257;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711729257;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 16:21:28", "2024-03-29 16:21:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1436", "mailpoet/cron/daemon-run", "complete", "2024-03-29 16:21:27", "2024-03-29 16:21:27", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711729287;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711729287;}", "6", "1", "2024-03-29 16:21:28", "2024-03-29 16:21:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1437", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 16:23:28", "2024-03-29 16:23:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711729408;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711729408;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 16:23:57", "2024-03-29 16:23:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1438", "mailpoet/cron/daemon-run", "complete", "2024-03-29 16:23:56", "2024-03-29 16:23:56", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711729436;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711729436;}", "6", "1", "2024-03-29 16:23:57", "2024-03-29 16:23:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1439", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 16:25:57", "2024-03-29 16:25:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711729557;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711729557;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 16:26:13", "2024-03-29 16:26:13", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1440", "mailpoet/cron/daemon-run", "complete", "2024-03-29 16:26:11", "2024-03-29 16:26:11", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711729571;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711729571;}", "6", "1", "2024-03-29 16:26:13", "2024-03-29 16:26:13", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1441", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 16:28:13", "2024-03-29 16:28:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711729693;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711729693;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 16:28:57", "2024-03-29 16:28:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1442", "mailpoet/cron/daemon-run", "complete", "2024-03-29 16:28:56", "2024-03-29 16:28:56", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711729736;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711729736;}", "6", "1", "2024-03-29 16:28:57", "2024-03-29 16:28:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1443", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 16:30:57", "2024-03-29 16:30:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711729857;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711729857;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 16:31:28", "2024-03-29 16:31:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1444", "mailpoet/cron/daemon-run", "complete", "2024-03-29 16:31:27", "2024-03-29 16:31:27", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711729887;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711729887;}", "6", "1", "2024-03-29 16:31:28", "2024-03-29 16:31:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1445", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 16:33:28", "2024-03-29 16:33:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711730008;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711730008;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 16:33:33", "2024-03-29 16:33:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1446", "mailpoet/cron/daemon-run", "complete", "2024-03-29 16:33:32", "2024-03-29 16:33:32", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711730012;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711730012;}", "6", "1", "2024-03-29 16:33:33", "2024-03-29 16:33:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1447", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 16:35:33", "2024-03-29 16:35:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711730133;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711730133;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 16:35:40", "2024-03-29 16:35:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1448", "mailpoet/cron/daemon-run", "complete", "2024-03-29 16:35:38", "2024-03-29 16:35:38", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711730138;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711730138;}", "6", "1", "2024-03-29 16:35:39", "2024-03-29 16:35:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1449", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 16:37:40", "2024-03-29 16:37:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711730260;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711730260;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 16:38:04", "2024-03-29 16:38:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1450", "mailpoet/cron/daemon-run", "complete", "2024-03-29 16:38:03", "2024-03-29 16:38:03", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711730283;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711730283;}", "6", "1", "2024-03-29 16:38:04", "2024-03-29 16:38:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1451", "mailpoet/cron/daemon-trigger", "complete", "2024-03-29 16:40:04", "2024-03-29 16:40:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711730404;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711730404;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "1", "2024-03-29 16:42:09", "2024-03-29 16:42:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1452", "mailpoet/cron/daemon-run", "complete", "2024-03-29 16:42:04", "2024-03-29 16:42:04", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1711730524;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1711730524;}", "6", "1", "2024-03-29 16:42:09", "2024-03-29 16:42:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("1453", "mailpoet/cron/daemon-trigger", "pending", "2024-03-29 16:44:09", "2024-03-29 16:44:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1711730649;s:18:\"\0*\0first_timestamp\";i:1711715938;s:13:\"\0*\0recurrence\";i:120;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1711730649;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:120;}", "6", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "gla");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "pinterest-for-woocommerce");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("6", "mailpoet-cron");
INSERT INTO `wp_actionscheduler_groups` VALUES("7", "woocommerce-remote-inbox-engine");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("210", "149", "action created", "2023-11-15 13:17:15", "2023-11-15 13:17:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("212", "149", "action started via WP Cron", "2023-11-15 13:17:31", "2023-11-15 13:17:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("213", "149", "action failed via WP Cron: Scheduled action for woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications will not be executed as no callbacks are registered.", "2023-11-15 13:17:31", "2023-11-15 13:17:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2972", "1069", "action created", "2023-12-06 11:52:36", "2023-12-06 11:52:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2975", "1070", "action created", "2023-12-06 11:52:36", "2023-12-06 11:52:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3051", "1070", "action lancée via WP Cron", "2023-12-06 12:52:37", "2023-12-06 12:52:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("3052", "1070", "échec de l’action via WP Cron : L’action planifiée pour pinterest_for_woocommerce_hourly_heartbeat ne sera pas exécutée car aucun rappel n’est enregistré.", "2023-12-06 12:52:37", "2023-12-06 12:52:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("3053", "1095", "action créée", "2023-12-06 12:52:37", "2023-12-06 12:52:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("3078", "1095", "action lancée via WP Cron", "2023-12-06 13:53:31", "2023-12-06 13:53:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("3079", "1095", "échec de l’action via WP Cron : L’action planifiée pour pinterest_for_woocommerce_hourly_heartbeat ne sera pas exécutée car aucun rappel n’est enregistré.", "2023-12-06 13:53:31", "2023-12-06 13:53:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("3080", "1104", "action créée", "2023-12-06 13:53:31", "2023-12-06 13:53:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("3081", "1104", "action lancée via WP Cron", "2023-12-06 14:53:40", "2023-12-06 14:53:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("3082", "1104", "échec de l’action via WP Cron : L’action planifiée pour pinterest_for_woocommerce_hourly_heartbeat ne sera pas exécutée car aucun rappel n’est enregistré.", "2023-12-06 14:53:40", "2023-12-06 14:53:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("3083", "1105", "action créée", "2023-12-06 14:53:40", "2023-12-06 14:53:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("3084", "1105", "action lancée via WP Cron", "2023-12-12 09:58:37", "2023-12-12 09:58:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("3085", "1105", "échec de l’action via WP Cron : L’action planifiée pour pinterest_for_woocommerce_hourly_heartbeat ne sera pas exécutée car aucun rappel n’est enregistré.", "2023-12-12 09:58:37", "2023-12-12 09:58:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("3086", "1106", "action créée", "2023-12-12 09:58:37", "2023-12-12 09:58:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("3090", "1069", "action lancée via WP Cron", "2023-12-12 09:58:37", "2023-12-12 09:58:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("3091", "1069", "échec de l’action via WP Cron : L’action planifiée pour pinterest_for_woocommerce_daily_heartbeat ne sera pas exécutée car aucun rappel n’est enregistré.", "2023-12-12 09:58:37", "2023-12-12 09:58:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("3092", "1108", "action créée", "2023-12-12 09:58:37", "2023-12-12 09:58:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("3093", "1106", "action lancée via WP Cron", "2023-12-12 11:00:04", "2023-12-12 11:00:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("3094", "1106", "échec de l’action via WP Cron : L’action planifiée pour pinterest_for_woocommerce_hourly_heartbeat ne sera pas exécutée car aucun rappel n’est enregistré.", "2023-12-12 11:00:04", "2023-12-12 11:00:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("3095", "1109", "action créée", "2023-12-12 11:00:04", "2023-12-12 11:00:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("3096", "1109", "action lancée via WP Cron", "2023-12-12 12:00:04", "2023-12-12 12:00:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("3097", "1109", "échec de l’action via WP Cron : L’action planifiée pour pinterest_for_woocommerce_hourly_heartbeat ne sera pas exécutée car aucun rappel n’est enregistré.", "2023-12-12 12:00:05", "2023-12-12 12:00:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("3098", "1110", "action créée", "2023-12-12 12:00:05", "2023-12-12 12:00:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("3107", "1110", "action lancée via WP Cron", "2023-12-13 10:49:34", "2023-12-13 10:49:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3108", "1110", "échec de l’action via WP Cron : L’action planifiée pour pinterest_for_woocommerce_hourly_heartbeat ne sera pas exécutée car aucun rappel n’est enregistré.", "2023-12-13 10:49:34", "2023-12-13 10:49:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3109", "1119", "action créée", "2023-12-13 10:49:34", "2023-12-13 10:49:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3113", "1108", "action lancée via WP Cron", "2023-12-13 10:49:34", "2023-12-13 10:49:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3114", "1108", "échec de l’action via WP Cron : L’action planifiée pour pinterest_for_woocommerce_daily_heartbeat ne sera pas exécutée car aucun rappel n’est enregistré.", "2023-12-13 10:49:34", "2023-12-13 10:49:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3115", "1121", "action créée", "2023-12-13 10:49:34", "2023-12-13 10:49:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3132", "1119", "action lancée via WP Cron", "2024-01-02 15:44:46", "2024-01-02 15:44:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3133", "1119", "échec de l’action via WP Cron : L’action planifiée pour pinterest_for_woocommerce_hourly_heartbeat ne sera pas exécutée car aucun rappel n’est enregistré.", "2024-01-02 15:44:46", "2024-01-02 15:44:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3134", "1122", "action créée", "2024-01-02 15:44:46", "2024-01-02 15:44:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3138", "1121", "action lancée via WP Cron", "2024-01-02 15:44:46", "2024-01-02 15:44:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3139", "1121", "échec de l’action via WP Cron : L’action planifiée pour pinterest_for_woocommerce_daily_heartbeat ne sera pas exécutée car aucun rappel n’est enregistré.", "2024-01-02 15:44:46", "2024-01-02 15:44:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3140", "1124", "action créée", "2024-01-02 15:44:46", "2024-01-02 15:44:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3141", "1122", "action lancée via WP Cron", "2024-01-02 16:45:57", "2024-01-02 16:45:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("3142", "1122", "échec de l’action via WP Cron : L’action planifiée pour pinterest_for_woocommerce_hourly_heartbeat ne sera pas exécutée car aucun rappel n’est enregistré.", "2024-01-02 16:45:57", "2024-01-02 16:45:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("3143", "1125", "action créée", "2024-01-02 16:45:57", "2024-01-02 16:45:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("3144", "1125", "action lancée via WP Cron", "2024-01-02 17:45:57", "2024-01-02 17:45:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("3145", "1125", "échec de l’action via WP Cron : L’action planifiée pour pinterest_for_woocommerce_hourly_heartbeat ne sera pas exécutée car aucun rappel n’est enregistré.", "2024-01-02 17:45:57", "2024-01-02 17:45:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("3146", "1126", "action créée", "2024-01-02 17:45:57", "2024-01-02 17:45:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("3147", "1126", "action lancée via WP Cron", "2024-01-02 18:45:57", "2024-01-02 18:45:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("3148", "1126", "échec de l’action via WP Cron : L’action planifiée pour pinterest_for_woocommerce_hourly_heartbeat ne sera pas exécutée car aucun rappel n’est enregistré.", "2024-01-02 18:45:57", "2024-01-02 18:45:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("3149", "1127", "action créée", "2024-01-02 18:45:57", "2024-01-02 18:45:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("3150", "1127", "action lancée via WP Cron", "2024-02-05 12:17:39", "2024-02-05 12:17:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3151", "1127", "échec de l’action via WP Cron : L’action planifiée pour pinterest_for_woocommerce_hourly_heartbeat ne sera pas exécutée car aucun rappel n’est enregistré.", "2024-02-05 12:17:39", "2024-02-05 12:17:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3152", "1127", "Cette action semble échouer systématiquement. Une nouvelle instance ne sera pas planifiée.", "2024-02-05 12:17:39", "2024-02-05 12:17:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3156", "1124", "action lancée via WP Cron", "2024-02-05 12:17:39", "2024-02-05 12:17:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3157", "1124", "échec de l’action via WP Cron : L’action planifiée pour pinterest_for_woocommerce_daily_heartbeat ne sera pas exécutée car aucun rappel n’est enregistré.", "2024-02-05 12:17:39", "2024-02-05 12:17:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3158", "1129", "action créée", "2024-02-05 12:17:39", "2024-02-05 12:17:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3198", "1129", "action lancée via WP Cron", "2024-02-07 13:47:18", "2024-02-07 13:47:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("3199", "1129", "échec de l’action via WP Cron : L’action planifiée pour pinterest_for_woocommerce_daily_heartbeat ne sera pas exécutée car aucun rappel n’est enregistré.", "2024-02-07 13:47:18", "2024-02-07 13:47:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("3200", "1129", "Cette action semble échouer systématiquement. Une nouvelle instance ne sera pas planifiée.", "2024-02-07 13:47:18", "2024-02-07 13:47:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("3479", "1235", "action créée", "2024-02-27 13:28:24", "2024-02-27 13:28:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("3480", "1235", "action lancée via WP Cron", "2024-02-29 15:06:41", "2024-02-29 15:06:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("3481", "1235", "action terminée via WP Cron", "2024-02-29 15:06:41", "2024-02-29 15:06:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("3482", "1236", "action créée", "2024-02-29 15:06:41", "2024-02-29 15:06:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("3483", "1237", "action créée", "2024-02-29 15:08:43", "2024-02-29 15:08:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("3484", "1237", "action lancée via Async Request", "2024-02-29 15:09:09", "2024-02-29 15:09:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("3485", "1237", "action terminée via Async Request", "2024-02-29 15:09:09", "2024-02-29 15:09:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("3486", "1236", "action lancée via WP Cron", "2024-03-26 14:42:23", "2024-03-26 14:42:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("3487", "1236", "action terminée via WP Cron", "2024-03-26 14:42:23", "2024-03-26 14:42:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("3488", "1238", "action créée", "2024-03-26 14:42:23", "2024-03-26 14:42:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("3489", "1239", "action créée", "2024-03-26 14:43:05", "2024-03-26 14:43:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("3490", "1239", "action lancée via Async Request", "2024-03-26 15:16:06", "2024-03-26 15:16:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("3491", "1239", "action terminée via Async Request", "2024-03-26 15:16:06", "2024-03-26 15:16:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("3492", "1240", "action créée", "2024-03-26 15:25:46", "2024-03-26 15:25:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3493", "1240", "action lancée via WP Cron", "2024-03-26 15:26:46", "2024-03-26 15:26:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3494", "1240", "action terminée via WP Cron", "2024-03-26 15:26:46", "2024-03-26 15:26:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3495", "1241", "action créée", "2024-03-26 15:27:09", "2024-03-26 15:27:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("3496", "1241", "action lancée via WP Cron", "2024-03-26 15:28:13", "2024-03-26 15:28:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("3497", "1241", "action terminée via WP Cron", "2024-03-26 15:28:13", "2024-03-26 15:28:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("3498", "1242", "action créée", "2024-03-26 15:34:24", "2024-03-26 15:34:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("3499", "1243", "action créée", "2024-03-26 15:34:24", "2024-03-26 15:34:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("3500", "1244", "action créée", "2024-03-26 15:34:24", "2024-03-26 15:34:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("3501", "1242", "action lancée via WP Cron", "2024-03-26 15:34:39", "2024-03-26 15:34:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3502", "1242", "action terminée via WP Cron", "2024-03-26 15:34:39", "2024-03-26 15:34:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3503", "1243", "action lancée via WP Cron", "2024-03-26 15:34:39", "2024-03-26 15:34:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3504", "1243", "action terminée via WP Cron", "2024-03-26 15:34:39", "2024-03-26 15:34:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3505", "1244", "action lancée via WP Cron", "2024-03-26 15:34:39", "2024-03-26 15:34:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3506", "1244", "action terminée via WP Cron", "2024-03-26 15:34:39", "2024-03-26 15:34:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3507", "1245", "action créée", "2024-03-26 15:34:52", "2024-03-26 15:34:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("3508", "1245", "action lancée via WP Cron", "2024-03-26 15:36:22", "2024-03-26 15:36:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("3509", "1246", "action créée", "2024-03-26 15:36:22", "2024-03-26 15:36:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("3510", "1245", "action terminée via WP Cron", "2024-03-26 15:36:27", "2024-03-26 15:36:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("3511", "1247", "action créée", "2024-03-26 15:36:27", "2024-03-26 15:36:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("3512", "1246", "action lancée via WP Cron", "2024-03-26 15:36:27", "2024-03-26 15:36:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("3513", "1246", "action terminée via WP Cron", "2024-03-26 15:36:27", "2024-03-26 15:36:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("3514", "1247", "action lancée via WP Cron", "2024-03-26 15:40:08", "2024-03-26 15:40:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("3515", "1248", "action créée", "2024-03-26 15:40:09", "2024-03-26 15:40:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("3516", "1247", "action terminée via WP Cron", "2024-03-26 15:40:14", "2024-03-26 15:40:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("3517", "1249", "action créée", "2024-03-26 15:40:14", "2024-03-26 15:40:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("3518", "1248", "action lancée via WP Cron", "2024-03-26 15:40:14", "2024-03-26 15:40:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("3519", "1248", "action terminée via WP Cron", "2024-03-26 15:40:14", "2024-03-26 15:40:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("3520", "1249", "action lancée via WP Cron", "2024-03-26 15:42:50", "2024-03-26 15:42:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("3521", "1250", "action créée", "2024-03-26 15:42:50", "2024-03-26 15:42:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("3522", "1250", "action lancée via WP Cron", "2024-03-26 15:42:53", "2024-03-26 15:42:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("3523", "1250", "action terminée via WP Cron", "2024-03-26 15:42:53", "2024-03-26 15:42:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("3524", "1249", "action terminée via WP Cron", "2024-03-26 15:42:53", "2024-03-26 15:42:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("3525", "1251", "action créée", "2024-03-26 15:42:53", "2024-03-26 15:42:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("3526", "1251", "action lancée via WP Cron", "2024-03-26 15:46:11", "2024-03-26 15:46:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("3527", "1252", "action créée", "2024-03-26 15:46:11", "2024-03-26 15:46:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("3528", "1251", "action terminée via WP Cron", "2024-03-26 15:46:16", "2024-03-26 15:46:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("3529", "1253", "action créée", "2024-03-26 15:46:17", "2024-03-26 15:46:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("3530", "1252", "action lancée via WP Cron", "2024-03-26 15:46:17", "2024-03-26 15:46:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("3531", "1252", "action terminée via WP Cron", "2024-03-26 15:46:17", "2024-03-26 15:46:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("3532", "1253", "action lancée via WP Cron", "2024-03-27 14:58:38", "2024-03-27 14:58:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("3533", "1254", "action créée", "2024-03-27 14:58:38", "2024-03-27 14:58:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("3534", "1254", "action lancée via WP Cron", "2024-03-27 14:58:39", "2024-03-27 14:58:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3535", "1254", "action terminée via WP Cron", "2024-03-27 14:58:39", "2024-03-27 14:58:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3536", "1253", "action terminée via WP Cron", "2024-03-27 14:58:39", "2024-03-27 14:58:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3537", "1255", "action créée", "2024-03-27 14:58:39", "2024-03-27 14:58:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3538", "1238", "action lancée via WP Cron", "2024-03-27 14:58:39", "2024-03-27 14:58:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3539", "1238", "action terminée via WP Cron", "2024-03-27 14:58:39", "2024-03-27 14:58:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3540", "1256", "action créée", "2024-03-27 14:58:39", "2024-03-27 14:58:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3541", "1255", "action lancée via WP Cron", "2024-03-27 15:01:44", "2024-03-27 15:01:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3542", "1257", "action créée", "2024-03-27 15:01:44", "2024-03-27 15:01:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3543", "1255", "action terminée via WP Cron", "2024-03-27 15:01:49", "2024-03-27 15:01:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("3544", "1258", "action créée", "2024-03-27 15:01:49", "2024-03-27 15:01:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("3545", "1257", "action lancée via WP Cron", "2024-03-27 15:01:49", "2024-03-27 15:01:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("3546", "1257", "action terminée via WP Cron", "2024-03-27 15:01:49", "2024-03-27 15:01:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("3547", "1258", "action lancée via WP Cron", "2024-03-27 15:05:46", "2024-03-27 15:05:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3548", "1259", "action créée", "2024-03-27 15:05:46", "2024-03-27 15:05:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3549", "1258", "action terminée via WP Cron", "2024-03-27 15:05:51", "2024-03-27 15:05:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("3550", "1260", "action créée", "2024-03-27 15:05:51", "2024-03-27 15:05:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("3551", "1259", "action lancée via WP Cron", "2024-03-27 15:05:51", "2024-03-27 15:05:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("3552", "1259", "action terminée via WP Cron", "2024-03-27 15:05:51", "2024-03-27 15:05:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("3553", "1260", "action lancée via WP Cron", "2024-03-27 15:08:42", "2024-03-27 15:08:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3554", "1261", "action créée", "2024-03-27 15:08:42", "2024-03-27 15:08:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3555", "1260", "action terminée via WP Cron", "2024-03-27 15:08:47", "2024-03-27 15:08:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("3556", "1262", "action créée", "2024-03-27 15:08:47", "2024-03-27 15:08:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("3557", "1261", "action lancée via WP Cron", "2024-03-27 15:08:47", "2024-03-27 15:08:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("3558", "1261", "action terminée via WP Cron", "2024-03-27 15:08:47", "2024-03-27 15:08:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("3559", "1262", "action lancée via WP Cron", "2024-03-27 15:12:44", "2024-03-27 15:12:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3560", "1263", "action créée", "2024-03-27 15:12:44", "2024-03-27 15:12:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3561", "1262", "action terminée via WP Cron", "2024-03-27 15:12:49", "2024-03-27 15:12:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("3562", "1264", "action créée", "2024-03-27 15:12:49", "2024-03-27 15:12:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("3563", "1263", "action lancée via WP Cron", "2024-03-27 15:12:49", "2024-03-27 15:12:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("3564", "1263", "action terminée via WP Cron", "2024-03-27 15:12:49", "2024-03-27 15:12:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("3565", "1264", "action lancée via WP Cron", "2024-03-27 15:16:46", "2024-03-27 15:16:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3566", "1265", "action créée", "2024-03-27 15:16:46", "2024-03-27 15:16:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3567", "1264", "action terminée via WP Cron", "2024-03-27 15:16:51", "2024-03-27 15:16:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("3568", "1266", "action créée", "2024-03-27 15:16:51", "2024-03-27 15:16:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("3569", "1265", "action lancée via WP Cron", "2024-03-27 15:16:51", "2024-03-27 15:16:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("3570", "1265", "action terminée via WP Cron", "2024-03-27 15:16:51", "2024-03-27 15:16:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("3571", "1266", "action lancée via WP Cron", "2024-03-27 15:19:16", "2024-03-27 15:19:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("3572", "1267", "action créée", "2024-03-27 15:19:16", "2024-03-27 15:19:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("3573", "1266", "action terminée via WP Cron", "2024-03-27 15:19:21", "2024-03-27 15:19:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("3574", "1268", "action créée", "2024-03-27 15:19:21", "2024-03-27 15:19:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("3575", "1267", "action lancée via WP Cron", "2024-03-27 15:19:21", "2024-03-27 15:19:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("3576", "1267", "action terminée via WP Cron", "2024-03-27 15:19:21", "2024-03-27 15:19:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("3577", "1268", "action lancée via WP Cron", "2024-03-27 15:23:18", "2024-03-27 15:23:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("3578", "1269", "action créée", "2024-03-27 15:23:18", "2024-03-27 15:23:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("3579", "1268", "action terminée via WP Cron", "2024-03-27 15:23:23", "2024-03-27 15:23:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("3580", "1270", "action créée", "2024-03-27 15:23:23", "2024-03-27 15:23:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("3581", "1269", "action lancée via WP Cron", "2024-03-27 15:23:23", "2024-03-27 15:23:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("3582", "1269", "action terminée via WP Cron", "2024-03-27 15:23:23", "2024-03-27 15:23:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("3583", "1270", "action lancée via WP Cron", "2024-03-27 15:27:20", "2024-03-27 15:27:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("3584", "1271", "action créée", "2024-03-27 15:27:20", "2024-03-27 15:27:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("3585", "1270", "action terminée via WP Cron", "2024-03-27 15:27:25", "2024-03-27 15:27:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("3586", "1272", "action créée", "2024-03-27 15:27:25", "2024-03-27 15:27:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("3587", "1271", "action lancée via WP Cron", "2024-03-27 15:27:25", "2024-03-27 15:27:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("3588", "1271", "action terminée via WP Cron", "2024-03-27 15:27:25", "2024-03-27 15:27:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("3589", "1272", "action lancée via WP Cron", "2024-03-27 15:31:22", "2024-03-27 15:31:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("3590", "1273", "action créée", "2024-03-27 15:31:22", "2024-03-27 15:31:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("3591", "1272", "action terminée via WP Cron", "2024-03-27 15:31:27", "2024-03-27 15:31:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("3592", "1274", "action créée", "2024-03-27 15:31:27", "2024-03-27 15:31:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("3593", "1273", "action lancée via WP Cron", "2024-03-27 15:31:27", "2024-03-27 15:31:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("3594", "1273", "action terminée via WP Cron", "2024-03-27 15:31:27", "2024-03-27 15:31:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("3595", "1274", "action lancée via WP Cron", "2024-03-27 15:35:24", "2024-03-27 15:35:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("3596", "1275", "action créée", "2024-03-27 15:35:24", "2024-03-27 15:35:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("3597", "1274", "action terminée via WP Cron", "2024-03-27 15:35:29", "2024-03-27 15:35:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("3598", "1276", "action créée", "2024-03-27 15:35:29", "2024-03-27 15:35:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("3599", "1275", "action lancée via WP Cron", "2024-03-27 15:35:29", "2024-03-27 15:35:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("3600", "1275", "action terminée via WP Cron", "2024-03-27 15:35:29", "2024-03-27 15:35:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("3601", "1276", "action lancée via WP Cron", "2024-03-27 15:39:26", "2024-03-27 15:39:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("3602", "1277", "action créée", "2024-03-27 15:39:26", "2024-03-27 15:39:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("3603", "1276", "action terminée via WP Cron", "2024-03-27 15:39:31", "2024-03-27 15:39:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("3605", "1277", "action lancée via WP Cron", "2024-03-27 15:39:31", "2024-03-27 15:39:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("3606", "1277", "action terminée via WP Cron", "2024-03-27 15:39:31", "2024-03-27 15:39:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("3608", "1279", "action créée", "2024-03-28 08:33:40", "2024-03-28 08:33:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("3609", "1279", "action lancée via WP Cron", "2024-03-28 08:35:01", "2024-03-28 08:35:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("3610", "1279", "action terminée via WP Cron", "2024-03-28 08:35:01", "2024-03-28 08:35:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("3611", "1280", "action créée", "2024-03-29 12:38:58", "2024-03-29 12:38:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("3612", "1256", "action lancée via WP Cron", "2024-03-29 12:40:06", "2024-03-29 12:40:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("3613", "1256", "action terminée via WP Cron", "2024-03-29 12:40:06", "2024-03-29 12:40:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("3614", "1281", "action créée", "2024-03-29 12:40:06", "2024-03-29 12:40:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("3615", "1280", "action lancée via WP Cron", "2024-03-29 12:40:06", "2024-03-29 12:40:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("3616", "1282", "action créée", "2024-03-29 12:40:06", "2024-03-29 12:40:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("3617", "1280", "action terminée via WP Cron", "2024-03-29 12:40:11", "2024-03-29 12:40:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("3618", "1283", "action créée", "2024-03-29 12:40:11", "2024-03-29 12:40:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("3619", "1282", "action lancée via WP Cron", "2024-03-29 12:40:11", "2024-03-29 12:40:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("3620", "1282", "action terminée via WP Cron", "2024-03-29 12:40:11", "2024-03-29 12:40:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("3621", "1283", "action lancée via WP Cron", "2024-03-29 12:42:34", "2024-03-29 12:42:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3622", "1284", "action créée", "2024-03-29 12:42:34", "2024-03-29 12:42:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3623", "1283", "action terminée via WP Cron", "2024-03-29 12:42:39", "2024-03-29 12:42:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3624", "1285", "action créée", "2024-03-29 12:42:39", "2024-03-29 12:42:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3625", "1284", "action lancée via WP Cron", "2024-03-29 12:42:39", "2024-03-29 12:42:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3626", "1284", "action terminée via WP Cron", "2024-03-29 12:42:39", "2024-03-29 12:42:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3627", "1285", "action lancée via WP Cron", "2024-03-29 12:44:43", "2024-03-29 12:44:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("3628", "1286", "action créée", "2024-03-29 12:44:43", "2024-03-29 12:44:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("3629", "1286", "action lancée via WP Cron", "2024-03-29 12:44:44", "2024-03-29 12:44:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3630", "1286", "action terminée via WP Cron", "2024-03-29 12:44:44", "2024-03-29 12:44:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3631", "1285", "action terminée via WP Cron", "2024-03-29 12:44:44", "2024-03-29 12:44:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3632", "1287", "action créée", "2024-03-29 12:44:44", "2024-03-29 12:44:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3633", "1287", "action lancée via WP Cron", "2024-03-29 12:48:35", "2024-03-29 12:48:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("3634", "1288", "action créée", "2024-03-29 12:48:35", "2024-03-29 12:48:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("3635", "1287", "action terminée via WP Cron", "2024-03-29 12:48:40", "2024-03-29 12:48:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("3636", "1289", "action créée", "2024-03-29 12:48:40", "2024-03-29 12:48:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("3637", "1288", "action lancée via WP Cron", "2024-03-29 12:48:40", "2024-03-29 12:48:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("3638", "1288", "action terminée via WP Cron", "2024-03-29 12:48:41", "2024-03-29 12:48:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("3639", "1289", "action lancée via WP Cron", "2024-03-29 12:52:37", "2024-03-29 12:52:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("3640", "1290", "action créée", "2024-03-29 12:52:37", "2024-03-29 12:52:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("3641", "1289", "action terminée via WP Cron", "2024-03-29 12:52:42", "2024-03-29 12:52:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3642", "1291", "action créée", "2024-03-29 12:52:42", "2024-03-29 12:52:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3643", "1290", "action lancée via WP Cron", "2024-03-29 12:52:42", "2024-03-29 12:52:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3644", "1290", "action terminée via WP Cron", "2024-03-29 12:52:42", "2024-03-29 12:52:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3645", "1291", "action lancée via WP Cron", "2024-03-29 12:55:29", "2024-03-29 12:55:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("3646", "1292", "action créée", "2024-03-29 12:55:29", "2024-03-29 12:55:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("3647", "1291", "action terminée via WP Cron", "2024-03-29 12:55:34", "2024-03-29 12:55:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3648", "1293", "action créée", "2024-03-29 12:55:34", "2024-03-29 12:55:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3649", "1292", "action lancée via WP Cron", "2024-03-29 12:55:34", "2024-03-29 12:55:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3650", "1292", "action terminée via WP Cron", "2024-03-29 12:55:35", "2024-03-29 12:55:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("3651", "1293", "action lancée via WP Cron", "2024-03-29 12:59:31", "2024-03-29 12:59:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("3652", "1294", "action créée", "2024-03-29 12:59:31", "2024-03-29 12:59:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("3653", "1293", "action terminée via WP Cron", "2024-03-29 12:59:36", "2024-03-29 12:59:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3654", "1295", "action créée", "2024-03-29 12:59:36", "2024-03-29 12:59:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3655", "1294", "action lancée via WP Cron", "2024-03-29 12:59:36", "2024-03-29 12:59:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3656", "1294", "action terminée via WP Cron", "2024-03-29 12:59:37", "2024-03-29 12:59:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("3657", "1295", "action lancée via WP Cron", "2024-03-29 13:03:33", "2024-03-29 13:03:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3658", "1296", "action créée", "2024-03-29 13:03:33", "2024-03-29 13:03:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3659", "1295", "action terminée via WP Cron", "2024-03-29 13:03:38", "2024-03-29 13:03:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("3660", "1297", "action créée", "2024-03-29 13:03:38", "2024-03-29 13:03:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("3661", "1296", "action lancée via WP Cron", "2024-03-29 13:03:38", "2024-03-29 13:03:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("3662", "1296", "action terminée via WP Cron", "2024-03-29 13:03:39", "2024-03-29 13:03:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3663", "1297", "action lancée via WP Cron", "2024-03-29 13:07:35", "2024-03-29 13:07:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("3664", "1298", "action créée", "2024-03-29 13:07:35", "2024-03-29 13:07:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("3665", "1297", "action terminée via WP Cron", "2024-03-29 13:07:40", "2024-03-29 13:07:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("3666", "1299", "action créée", "2024-03-29 13:07:40", "2024-03-29 13:07:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("3667", "1298", "action lancée via WP Cron", "2024-03-29 13:07:40", "2024-03-29 13:07:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("3668", "1298", "action terminée via WP Cron", "2024-03-29 13:07:41", "2024-03-29 13:07:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("3669", "1299", "action lancée via WP Cron", "2024-03-29 13:11:37", "2024-03-29 13:11:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("3670", "1300", "action créée", "2024-03-29 13:11:37", "2024-03-29 13:11:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("3671", "1299", "action terminée via WP Cron", "2024-03-29 13:11:42", "2024-03-29 13:11:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3672", "1301", "action créée", "2024-03-29 13:11:42", "2024-03-29 13:11:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3673", "1300", "action lancée via WP Cron", "2024-03-29 13:11:42", "2024-03-29 13:11:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3674", "1300", "action terminée via WP Cron", "2024-03-29 13:11:43", "2024-03-29 13:11:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("3675", "1301", "action lancée via WP Cron", "2024-03-29 13:15:39", "2024-03-29 13:15:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3676", "1302", "action créée", "2024-03-29 13:15:39", "2024-03-29 13:15:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3677", "1301", "action terminée via WP Cron", "2024-03-29 13:15:44", "2024-03-29 13:15:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3678", "1303", "action créée", "2024-03-29 13:15:44", "2024-03-29 13:15:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3679", "1302", "action lancée via WP Cron", "2024-03-29 13:15:44", "2024-03-29 13:15:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3680", "1302", "action terminée via WP Cron", "2024-03-29 13:15:45", "2024-03-29 13:15:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("3681", "1303", "action lancée via WP Cron", "2024-03-29 13:19:41", "2024-03-29 13:19:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("3682", "1304", "action créée", "2024-03-29 13:19:41", "2024-03-29 13:19:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("3683", "1303", "action terminée via WP Cron", "2024-03-29 13:19:46", "2024-03-29 13:19:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3684", "1305", "action créée", "2024-03-29 13:19:46", "2024-03-29 13:19:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3685", "1304", "action lancée via WP Cron", "2024-03-29 13:19:46", "2024-03-29 13:19:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3686", "1304", "action terminée via WP Cron", "2024-03-29 13:19:46", "2024-03-29 13:19:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3687", "1305", "action lancée via WP Cron", "2024-03-29 13:23:43", "2024-03-29 13:23:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("3688", "1306", "action créée", "2024-03-29 13:23:43", "2024-03-29 13:23:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("3689", "1305", "action terminée via WP Cron", "2024-03-29 13:23:48", "2024-03-29 13:23:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("3690", "1307", "action créée", "2024-03-29 13:23:48", "2024-03-29 13:23:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("3691", "1306", "action lancée via WP Cron", "2024-03-29 13:23:48", "2024-03-29 13:23:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("3692", "1306", "action terminée via WP Cron", "2024-03-29 13:23:48", "2024-03-29 13:23:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("3693", "1307", "action lancée via WP Cron", "2024-03-29 13:27:45", "2024-03-29 13:27:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("3694", "1308", "action créée", "2024-03-29 13:27:45", "2024-03-29 13:27:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("3695", "1307", "action terminée via WP Cron", "2024-03-29 13:27:50", "2024-03-29 13:27:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("3696", "1309", "action créée", "2024-03-29 13:27:50", "2024-03-29 13:27:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("3697", "1308", "action lancée via WP Cron", "2024-03-29 13:27:50", "2024-03-29 13:27:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("3698", "1308", "action terminée via WP Cron", "2024-03-29 13:27:51", "2024-03-29 13:27:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("3699", "1309", "action lancée via WP Cron", "2024-03-29 13:31:47", "2024-03-29 13:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("3700", "1310", "action créée", "2024-03-29 13:31:47", "2024-03-29 13:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("3701", "1309", "action terminée via WP Cron", "2024-03-29 13:31:52", "2024-03-29 13:31:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("3702", "1311", "action créée", "2024-03-29 13:31:52", "2024-03-29 13:31:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("3703", "1310", "action lancée via WP Cron", "2024-03-29 13:31:52", "2024-03-29 13:31:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("3704", "1310", "action terminée via WP Cron", "2024-03-29 13:31:52", "2024-03-29 13:31:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("3705", "1311", "action lancée via WP Cron", "2024-03-29 13:35:49", "2024-03-29 13:35:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("3706", "1312", "action créée", "2024-03-29 13:35:49", "2024-03-29 13:35:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("3707", "1311", "action terminée via WP Cron", "2024-03-29 13:35:54", "2024-03-29 13:35:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("3708", "1313", "action créée", "2024-03-29 13:35:54", "2024-03-29 13:35:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("3709", "1312", "action lancée via WP Cron", "2024-03-29 13:35:54", "2024-03-29 13:35:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("3710", "1312", "action terminée via WP Cron", "2024-03-29 13:35:54", "2024-03-29 13:35:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("3711", "1313", "action lancée via WP Cron", "2024-03-29 13:39:52", "2024-03-29 13:39:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("3712", "1314", "action créée", "2024-03-29 13:39:52", "2024-03-29 13:39:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("3713", "1313", "action terminée via WP Cron", "2024-03-29 13:39:57", "2024-03-29 13:39:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("3714", "1315", "action créée", "2024-03-29 13:39:57", "2024-03-29 13:39:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("3715", "1314", "action lancée via WP Cron", "2024-03-29 13:39:57", "2024-03-29 13:39:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("3716", "1314", "action terminée via WP Cron", "2024-03-29 13:39:57", "2024-03-29 13:39:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("3717", "1315", "action lancée via WP Cron", "2024-03-29 13:43:53", "2024-03-29 13:43:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("3718", "1316", "action créée", "2024-03-29 13:43:53", "2024-03-29 13:43:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("3719", "1315", "action terminée via WP Cron", "2024-03-29 13:43:58", "2024-03-29 13:43:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("3720", "1317", "action créée", "2024-03-29 13:43:58", "2024-03-29 13:43:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("3721", "1316", "action lancée via WP Cron", "2024-03-29 13:43:58", "2024-03-29 13:43:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("3722", "1316", "action terminée via WP Cron", "2024-03-29 13:43:58", "2024-03-29 13:43:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("3723", "1317", "action lancée via WP Cron", "2024-03-29 13:47:55", "2024-03-29 13:47:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("3724", "1318", "action créée", "2024-03-29 13:47:55", "2024-03-29 13:47:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("3725", "1317", "action terminée via WP Cron", "2024-03-29 13:48:00", "2024-03-29 13:48:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("3726", "1319", "action créée", "2024-03-29 13:48:00", "2024-03-29 13:48:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("3727", "1318", "action lancée via WP Cron", "2024-03-29 13:48:00", "2024-03-29 13:48:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("3728", "1318", "action terminée via WP Cron", "2024-03-29 13:48:01", "2024-03-29 13:48:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("3729", "1319", "action lancée via WP Cron", "2024-03-29 13:51:58", "2024-03-29 13:51:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("3730", "1320", "action créée", "2024-03-29 13:51:58", "2024-03-29 13:51:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("3731", "1319", "action terminée via WP Cron", "2024-03-29 13:52:03", "2024-03-29 13:52:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("3732", "1321", "action créée", "2024-03-29 13:52:03", "2024-03-29 13:52:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("3733", "1320", "action lancée via WP Cron", "2024-03-29 13:52:03", "2024-03-29 13:52:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("3734", "1320", "action terminée via WP Cron", "2024-03-29 13:52:03", "2024-03-29 13:52:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("3735", "1321", "action lancée via WP Cron", "2024-03-29 13:56:00", "2024-03-29 13:56:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("3736", "1322", "action créée", "2024-03-29 13:56:00", "2024-03-29 13:56:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("3737", "1321", "action terminée via WP Cron", "2024-03-29 13:56:05", "2024-03-29 13:56:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("3738", "1323", "action créée", "2024-03-29 13:56:05", "2024-03-29 13:56:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("3739", "1322", "action lancée via WP Cron", "2024-03-29 13:56:05", "2024-03-29 13:56:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("3740", "1322", "action terminée via WP Cron", "2024-03-29 13:56:05", "2024-03-29 13:56:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("3741", "1323", "action lancée via WP Cron", "2024-03-29 14:00:02", "2024-03-29 14:00:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("3742", "1324", "action créée", "2024-03-29 14:00:02", "2024-03-29 14:00:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("3743", "1323", "action terminée via WP Cron", "2024-03-29 14:00:07", "2024-03-29 14:00:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("3744", "1325", "action créée", "2024-03-29 14:00:07", "2024-03-29 14:00:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("3745", "1324", "action lancée via WP Cron", "2024-03-29 14:00:07", "2024-03-29 14:00:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("3746", "1324", "action terminée via WP Cron", "2024-03-29 14:00:07", "2024-03-29 14:00:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("3747", "1325", "action lancée via WP Cron", "2024-03-29 14:04:04", "2024-03-29 14:04:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("3748", "1326", "action créée", "2024-03-29 14:04:04", "2024-03-29 14:04:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("3749", "1325", "action terminée via WP Cron", "2024-03-29 14:04:09", "2024-03-29 14:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("3750", "1327", "action créée", "2024-03-29 14:04:09", "2024-03-29 14:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("3751", "1326", "action lancée via WP Cron", "2024-03-29 14:04:09", "2024-03-29 14:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("3752", "1326", "action terminée via WP Cron", "2024-03-29 14:04:09", "2024-03-29 14:04:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("3753", "1327", "action lancée via WP Cron", "2024-03-29 14:08:06", "2024-03-29 14:08:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("3754", "1328", "action créée", "2024-03-29 14:08:06", "2024-03-29 14:08:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("3755", "1327", "action terminée via WP Cron", "2024-03-29 14:08:11", "2024-03-29 14:08:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("3756", "1329", "action créée", "2024-03-29 14:08:11", "2024-03-29 14:08:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("3757", "1328", "action lancée via WP Cron", "2024-03-29 14:08:11", "2024-03-29 14:08:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("3758", "1328", "action terminée via WP Cron", "2024-03-29 14:08:11", "2024-03-29 14:08:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("3759", "1329", "action lancée via WP Cron", "2024-03-29 14:10:27", "2024-03-29 14:10:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("3760", "1330", "action créée", "2024-03-29 14:10:27", "2024-03-29 14:10:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("3761", "1330", "action lancée via WP Cron", "2024-03-29 14:10:27", "2024-03-29 14:10:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("3762", "1330", "action terminée via WP Cron", "2024-03-29 14:10:27", "2024-03-29 14:10:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("3763", "1329", "action terminée via WP Cron", "2024-03-29 14:10:27", "2024-03-29 14:10:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("3764", "1331", "action créée", "2024-03-29 14:10:27", "2024-03-29 14:10:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("3765", "1331", "action lancée via WP Cron", "2024-03-29 14:12:28", "2024-03-29 14:12:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("3766", "1332", "action créée", "2024-03-29 14:12:28", "2024-03-29 14:12:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("3767", "1331", "action terminée via WP Cron", "2024-03-29 14:12:33", "2024-03-29 14:12:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3768", "1333", "action créée", "2024-03-29 14:12:33", "2024-03-29 14:12:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3769", "1332", "action lancée via WP Cron", "2024-03-29 14:12:33", "2024-03-29 14:12:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3770", "1332", "action terminée via WP Cron", "2024-03-29 14:12:33", "2024-03-29 14:12:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("3771", "1333", "action lancée via WP Cron", "2024-03-29 14:14:41", "2024-03-29 14:14:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("3772", "1334", "action créée", "2024-03-29 14:14:41", "2024-03-29 14:14:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("3773", "1333", "action terminée via WP Cron", "2024-03-29 14:14:46", "2024-03-29 14:14:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3774", "1335", "action créée", "2024-03-29 14:14:46", "2024-03-29 14:14:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3775", "1334", "action lancée via WP Cron", "2024-03-29 14:14:46", "2024-03-29 14:14:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3776", "1334", "action terminée via WP Cron", "2024-03-29 14:14:46", "2024-03-29 14:14:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3777", "1335", "action lancée via WP Cron", "2024-03-29 14:16:50", "2024-03-29 14:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("3778", "1336", "action créée", "2024-03-29 14:16:50", "2024-03-29 14:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("3779", "1336", "action lancée via WP Cron", "2024-03-29 14:16:50", "2024-03-29 14:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("3780", "1336", "action terminée via WP Cron", "2024-03-29 14:16:50", "2024-03-29 14:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("3781", "1335", "action terminée via WP Cron", "2024-03-29 14:16:50", "2024-03-29 14:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("3782", "1337", "action créée", "2024-03-29 14:16:50", "2024-03-29 14:16:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("3783", "1337", "action lancée via WP Cron", "2024-03-29 14:18:50", "2024-03-29 14:18:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("3784", "1338", "action créée", "2024-03-29 14:18:50", "2024-03-29 14:18:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("3785", "1338", "action lancée via WP Cron", "2024-03-29 14:18:51", "2024-03-29 14:18:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("3786", "1338", "action terminée via WP Cron", "2024-03-29 14:18:51", "2024-03-29 14:18:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("3787", "1337", "action terminée via WP Cron", "2024-03-29 14:18:51", "2024-03-29 14:18:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("3788", "1339", "action créée", "2024-03-29 14:18:51", "2024-03-29 14:18:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("3789", "1339", "action lancée via WP Cron", "2024-03-29 14:20:52", "2024-03-29 14:20:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("3790", "1340", "action créée", "2024-03-29 14:20:52", "2024-03-29 14:20:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("3791", "1339", "action terminée via WP Cron", "2024-03-29 14:20:57", "2024-03-29 14:20:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("3792", "1341", "action créée", "2024-03-29 14:20:57", "2024-03-29 14:20:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("3793", "1340", "action lancée via WP Cron", "2024-03-29 14:20:57", "2024-03-29 14:20:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("3794", "1340", "action terminée via WP Cron", "2024-03-29 14:20:57", "2024-03-29 14:20:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("3795", "1341", "action lancée via WP Cron", "2024-03-29 14:24:53", "2024-03-29 14:24:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("3796", "1342", "action créée", "2024-03-29 14:24:53", "2024-03-29 14:24:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("3797", "1341", "action terminée via WP Cron", "2024-03-29 14:24:58", "2024-03-29 14:24:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("3798", "1343", "action créée", "2024-03-29 14:24:58", "2024-03-29 14:24:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("3799", "1342", "action lancée via WP Cron", "2024-03-29 14:24:58", "2024-03-29 14:24:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("3800", "1342", "action terminée via WP Cron", "2024-03-29 14:24:58", "2024-03-29 14:24:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("3801", "1343", "action lancée via WP Cron", "2024-03-29 14:28:54", "2024-03-29 14:28:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("3802", "1344", "action créée", "2024-03-29 14:28:54", "2024-03-29 14:28:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("3803", "1343", "action terminée via WP Cron", "2024-03-29 14:29:00", "2024-03-29 14:29:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("3804", "1345", "action créée", "2024-03-29 14:29:00", "2024-03-29 14:29:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("3805", "1344", "action lancée via WP Cron", "2024-03-29 14:29:00", "2024-03-29 14:29:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("3806", "1344", "action terminée via WP Cron", "2024-03-29 14:29:00", "2024-03-29 14:29:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("3807", "1345", "action lancée via Async Request", "2024-03-29 14:31:03", "2024-03-29 14:31:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("3808", "1346", "action créée", "2024-03-29 14:31:03", "2024-03-29 14:31:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("3809", "1346", "action lancée via WP Cron", "2024-03-29 14:31:04", "2024-03-29 14:31:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("3810", "1346", "action terminée via WP Cron", "2024-03-29 14:31:04", "2024-03-29 14:31:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("3811", "1345", "action terminée via Async Request", "2024-03-29 14:31:04", "2024-03-29 14:31:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("3812", "1347", "action créée", "2024-03-29 14:31:04", "2024-03-29 14:31:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("3813", "1347", "action lancée via Async Request", "2024-03-29 14:33:11", "2024-03-29 14:33:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("3814", "1348", "action créée", "2024-03-29 14:33:11", "2024-03-29 14:33:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("3815", "1348", "action lancée via WP Cron", "2024-03-29 14:33:12", "2024-03-29 14:33:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("3816", "1348", "action terminée via WP Cron", "2024-03-29 14:33:12", "2024-03-29 14:33:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("3817", "1347", "action terminée via Async Request", "2024-03-29 14:33:12", "2024-03-29 14:33:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("3818", "1349", "action créée", "2024-03-29 14:33:12", "2024-03-29 14:33:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("3819", "1349", "action lancée via Async Request", "2024-03-29 14:35:28", "2024-03-29 14:35:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("3820", "1350", "action créée", "2024-03-29 14:35:28", "2024-03-29 14:35:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("3821", "1350", "action lancée via WP Cron", "2024-03-29 14:35:29", "2024-03-29 14:35:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("3822", "1350", "action terminée via WP Cron", "2024-03-29 14:35:29", "2024-03-29 14:35:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("3823", "1349", "action terminée via Async Request", "2024-03-29 14:35:30", "2024-03-29 14:35:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("3824", "1351", "action créée", "2024-03-29 14:35:30", "2024-03-29 14:35:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("3825", "1351", "action lancée via WP Cron", "2024-03-29 14:37:43", "2024-03-29 14:37:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("3826", "1352", "action créée", "2024-03-29 14:37:43", "2024-03-29 14:37:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("3827", "1351", "action terminée via WP Cron", "2024-03-29 14:37:48", "2024-03-29 14:37:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("3828", "1353", "action créée", "2024-03-29 14:37:48", "2024-03-29 14:37:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("3829", "1352", "action lancée via WP Cron", "2024-03-29 14:37:48", "2024-03-29 14:37:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("3830", "1352", "action terminée via WP Cron", "2024-03-29 14:37:48", "2024-03-29 14:37:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("3831", "1353", "action lancée via WP Cron", "2024-03-29 14:40:21", "2024-03-29 14:40:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("3832", "1354", "action créée", "2024-03-29 14:40:21", "2024-03-29 14:40:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("3833", "1353", "action terminée via WP Cron", "2024-03-29 14:40:26", "2024-03-29 14:40:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("3834", "1355", "action créée", "2024-03-29 14:40:26", "2024-03-29 14:40:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("3835", "1354", "action lancée via WP Cron", "2024-03-29 14:40:26", "2024-03-29 14:40:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("3836", "1354", "action terminée via WP Cron", "2024-03-29 14:40:26", "2024-03-29 14:40:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("3837", "1355", "action lancée via WP Cron", "2024-03-29 14:43:11", "2024-03-29 14:43:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("3838", "1356", "action créée", "2024-03-29 14:43:11", "2024-03-29 14:43:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("3839", "1355", "action terminée via WP Cron", "2024-03-29 14:43:16", "2024-03-29 14:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("3840", "1357", "action créée", "2024-03-29 14:43:16", "2024-03-29 14:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("3841", "1356", "action lancée via WP Cron", "2024-03-29 14:43:16", "2024-03-29 14:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("3842", "1356", "action terminée via WP Cron", "2024-03-29 14:43:16", "2024-03-29 14:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("3843", "1357", "action lancée via WP Cron", "2024-03-29 14:45:21", "2024-03-29 14:45:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("3844", "1358", "action créée", "2024-03-29 14:45:21", "2024-03-29 14:45:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("3845", "1358", "action lancée via WP Cron", "2024-03-29 14:45:21", "2024-03-29 14:45:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("3846", "1358", "action terminée via WP Cron", "2024-03-29 14:45:21", "2024-03-29 14:45:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("3847", "1357", "action terminée via WP Cron", "2024-03-29 14:45:21", "2024-03-29 14:45:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("3848", "1359", "action créée", "2024-03-29 14:45:21", "2024-03-29 14:45:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("3849", "1359", "action lancée via WP Cron", "2024-03-29 14:47:22", "2024-03-29 14:47:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("3850", "1360", "action créée", "2024-03-29 14:47:22", "2024-03-29 14:47:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("3851", "1359", "action terminée via WP Cron", "2024-03-29 14:47:27", "2024-03-29 14:47:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("3852", "1361", "action créée", "2024-03-29 14:47:27", "2024-03-29 14:47:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("3853", "1360", "action lancée via WP Cron", "2024-03-29 14:47:27", "2024-03-29 14:47:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("3854", "1360", "action terminée via WP Cron", "2024-03-29 14:47:27", "2024-03-29 14:47:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("3855", "1361", "action lancée via WP Cron", "2024-03-29 14:49:36", "2024-03-29 14:49:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3856", "1362", "action créée", "2024-03-29 14:49:36", "2024-03-29 14:49:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("3857", "1362", "action lancée via WP Cron", "2024-03-29 14:49:37", "2024-03-29 14:49:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("3858", "1362", "action terminée via WP Cron", "2024-03-29 14:49:37", "2024-03-29 14:49:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("3859", "1361", "action terminée via WP Cron", "2024-03-29 14:49:37", "2024-03-29 14:49:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("3860", "1363", "action créée", "2024-03-29 14:49:37", "2024-03-29 14:49:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("3861", "1363", "action lancée via WP Cron", "2024-03-29 14:51:38", "2024-03-29 14:51:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("3862", "1364", "action créée", "2024-03-29 14:51:39", "2024-03-29 14:51:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3863", "1364", "action lancée via WP Cron", "2024-03-29 14:51:39", "2024-03-29 14:51:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3864", "1364", "action terminée via WP Cron", "2024-03-29 14:51:39", "2024-03-29 14:51:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3865", "1363", "action terminée via WP Cron", "2024-03-29 14:51:39", "2024-03-29 14:51:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3866", "1365", "action créée", "2024-03-29 14:51:39", "2024-03-29 14:51:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("3867", "1365", "action lancée via Async Request", "2024-03-29 14:54:20", "2024-03-29 14:54:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("3868", "1366", "action créée", "2024-03-29 14:54:20", "2024-03-29 14:54:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("3869", "1366", "action lancée via WP Cron", "2024-03-29 14:54:21", "2024-03-29 14:54:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("3870", "1366", "action terminée via WP Cron", "2024-03-29 14:54:21", "2024-03-29 14:54:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("3871", "1365", "action terminée via Async Request", "2024-03-29 14:54:21", "2024-03-29 14:54:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("3872", "1367", "action créée", "2024-03-29 14:54:21", "2024-03-29 14:54:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("3873", "1367", "action lancée via Async Request", "2024-03-29 14:56:28", "2024-03-29 14:56:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("3874", "1368", "action créée", "2024-03-29 14:56:28", "2024-03-29 14:56:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("3875", "1368", "action lancée via WP Cron", "2024-03-29 14:56:29", "2024-03-29 14:56:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("3876", "1368", "action terminée via WP Cron", "2024-03-29 14:56:29", "2024-03-29 14:56:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("3877", "1367", "action terminée via Async Request", "2024-03-29 14:56:29", "2024-03-29 14:56:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("3878", "1369", "action créée", "2024-03-29 14:56:29", "2024-03-29 14:56:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("3879", "1369", "action lancée via WP Cron", "2024-03-29 14:58:41", "2024-03-29 14:58:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("3880", "1370", "action créée", "2024-03-29 14:58:41", "2024-03-29 14:58:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("3881", "1370", "action lancée via WP Cron", "2024-03-29 14:58:43", "2024-03-29 14:58:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("3882", "1370", "action terminée via WP Cron", "2024-03-29 14:58:43", "2024-03-29 14:58:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("3883", "1369", "action terminée via WP Cron", "2024-03-29 14:58:43", "2024-03-29 14:58:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("3884", "1371", "action créée", "2024-03-29 14:58:43", "2024-03-29 14:58:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("3885", "1371", "action lancée via WP Cron", "2024-03-29 15:00:45", "2024-03-29 15:00:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("3886", "1372", "action créée", "2024-03-29 15:00:45", "2024-03-29 15:00:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("3887", "1372", "action lancée via WP Cron", "2024-03-29 15:00:46", "2024-03-29 15:00:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3888", "1372", "action terminée via WP Cron", "2024-03-29 15:00:46", "2024-03-29 15:00:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3889", "1371", "action terminée via WP Cron", "2024-03-29 15:00:46", "2024-03-29 15:00:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3890", "1373", "action créée", "2024-03-29 15:00:46", "2024-03-29 15:00:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("3891", "1373", "action lancée via WP Cron", "2024-03-29 15:03:05", "2024-03-29 15:03:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("3892", "1374", "action créée", "2024-03-29 15:03:05", "2024-03-29 15:03:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("3893", "1374", "action lancée via WP Cron", "2024-03-29 15:03:06", "2024-03-29 15:03:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("3894", "1374", "action terminée via WP Cron", "2024-03-29 15:03:06", "2024-03-29 15:03:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("3895", "1373", "action terminée via WP Cron", "2024-03-29 15:03:06", "2024-03-29 15:03:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("3896", "1375", "action créée", "2024-03-29 15:03:06", "2024-03-29 15:03:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("3897", "1375", "action lancée via WP Cron", "2024-03-29 15:05:44", "2024-03-29 15:05:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3898", "1376", "action créée", "2024-03-29 15:05:44", "2024-03-29 15:05:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3899", "1376", "action lancée via WP Cron", "2024-03-29 15:05:45", "2024-03-29 15:05:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("3900", "1376", "action terminée via WP Cron", "2024-03-29 15:05:45", "2024-03-29 15:05:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("3901", "1375", "action terminée via WP Cron", "2024-03-29 15:05:45", "2024-03-29 15:05:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("3902", "1377", "action créée", "2024-03-29 15:05:45", "2024-03-29 15:05:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("3903", "1377", "action lancée via WP Cron", "2024-03-29 15:07:45", "2024-03-29 15:07:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("3904", "1378", "action créée", "2024-03-29 15:07:45", "2024-03-29 15:07:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("3905", "1377", "action terminée via WP Cron", "2024-03-29 15:07:50", "2024-03-29 15:07:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("3906", "1379", "action créée", "2024-03-29 15:07:50", "2024-03-29 15:07:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("3907", "1378", "action lancée via WP Cron", "2024-03-29 15:07:51", "2024-03-29 15:07:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("3908", "1378", "action terminée via WP Cron", "2024-03-29 15:07:51", "2024-03-29 15:07:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("3909", "1379", "action lancée via Async Request", "2024-03-29 15:10:15", "2024-03-29 15:10:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("3910", "1380", "action créée", "2024-03-29 15:10:15", "2024-03-29 15:10:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("3911", "1380", "action lancée via WP Cron", "2024-03-29 15:10:16", "2024-03-29 15:10:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("3912", "1380", "action terminée via WP Cron", "2024-03-29 15:10:17", "2024-03-29 15:10:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("3913", "1379", "action terminée via Async Request", "2024-03-29 15:10:17", "2024-03-29 15:10:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("3914", "1381", "action créée", "2024-03-29 15:10:17", "2024-03-29 15:10:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("3915", "1381", "action lancée via Async Request", "2024-03-29 15:12:17", "2024-03-29 15:12:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("3916", "1382", "action créée", "2024-03-29 15:12:17", "2024-03-29 15:12:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("3917", "1382", "action lancée via WP Cron", "2024-03-29 15:12:18", "2024-03-29 15:12:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("3918", "1382", "action terminée via WP Cron", "2024-03-29 15:12:18", "2024-03-29 15:12:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("3919", "1381", "action terminée via Async Request", "2024-03-29 15:12:19", "2024-03-29 15:12:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("3920", "1383", "action créée", "2024-03-29 15:12:19", "2024-03-29 15:12:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("3921", "1383", "action lancée via WP Cron", "2024-03-29 15:14:42", "2024-03-29 15:14:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3922", "1384", "action créée", "2024-03-29 15:14:42", "2024-03-29 15:14:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3923", "1384", "action lancée via WP Cron", "2024-03-29 15:14:43", "2024-03-29 15:14:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("3924", "1384", "action terminée via WP Cron", "2024-03-29 15:14:43", "2024-03-29 15:14:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("3925", "1383", "action terminée via WP Cron", "2024-03-29 15:14:43", "2024-03-29 15:14:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("3926", "1385", "action créée", "2024-03-29 15:14:43", "2024-03-29 15:14:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("3927", "1385", "action lancée via WP Cron", "2024-03-29 15:16:52", "2024-03-29 15:16:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("3928", "1386", "action créée", "2024-03-29 15:16:52", "2024-03-29 15:16:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("3929", "1385", "action terminée via WP Cron", "2024-03-29 15:16:57", "2024-03-29 15:16:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("3930", "1387", "action créée", "2024-03-29 15:16:57", "2024-03-29 15:16:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("3931", "1386", "action lancée via WP Cron", "2024-03-29 15:16:57", "2024-03-29 15:16:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("3932", "1386", "action terminée via WP Cron", "2024-03-29 15:16:57", "2024-03-29 15:16:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("3933", "1387", "action lancée via WP Cron", "2024-03-29 15:19:51", "2024-03-29 15:19:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("3934", "1388", "action créée", "2024-03-29 15:19:51", "2024-03-29 15:19:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("3935", "1388", "action lancée via WP Cron", "2024-03-29 15:19:52", "2024-03-29 15:19:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("3936", "1388", "action terminée via WP Cron", "2024-03-29 15:19:52", "2024-03-29 15:19:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("3937", "1387", "action terminée via WP Cron", "2024-03-29 15:19:52", "2024-03-29 15:19:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("3938", "1389", "action créée", "2024-03-29 15:19:52", "2024-03-29 15:19:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("3939", "1389", "action lancée via Async Request", "2024-03-29 15:22:14", "2024-03-29 15:22:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("3940", "1390", "action créée", "2024-03-29 15:22:14", "2024-03-29 15:22:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("3941", "1390", "action lancée via WP Cron", "2024-03-29 15:22:15", "2024-03-29 15:22:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("3942", "1390", "action terminée via WP Cron", "2024-03-29 15:22:15", "2024-03-29 15:22:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("3943", "1389", "action terminée via Async Request", "2024-03-29 15:22:16", "2024-03-29 15:22:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("3944", "1391", "action créée", "2024-03-29 15:22:16", "2024-03-29 15:22:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("3945", "1391", "action lancée via WP Cron", "2024-03-29 15:25:05", "2024-03-29 15:25:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("3946", "1392", "action créée", "2024-03-29 15:25:05", "2024-03-29 15:25:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("3947", "1391", "action terminée via WP Cron", "2024-03-29 15:25:10", "2024-03-29 15:25:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("3948", "1393", "action créée", "2024-03-29 15:25:10", "2024-03-29 15:25:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("3949", "1392", "action lancée via WP Cron", "2024-03-29 15:25:10", "2024-03-29 15:25:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("3950", "1392", "action terminée via WP Cron", "2024-03-29 15:25:10", "2024-03-29 15:25:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("3951", "1393", "action lancée via WP Cron", "2024-03-29 15:29:06", "2024-03-29 15:29:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("3952", "1394", "action créée", "2024-03-29 15:29:06", "2024-03-29 15:29:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("3953", "1393", "action terminée via WP Cron", "2024-03-29 15:29:11", "2024-03-29 15:29:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("3954", "1395", "action créée", "2024-03-29 15:29:11", "2024-03-29 15:29:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("3955", "1394", "action lancée via WP Cron", "2024-03-29 15:29:11", "2024-03-29 15:29:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("3956", "1394", "action terminée via WP Cron", "2024-03-29 15:29:11", "2024-03-29 15:29:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("3957", "1395", "action lancée via WP Cron", "2024-03-29 15:33:10", "2024-03-29 15:33:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("3958", "1396", "action créée", "2024-03-29 15:33:10", "2024-03-29 15:33:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("3959", "1395", "action terminée via WP Cron", "2024-03-29 15:33:15", "2024-03-29 15:33:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("3960", "1397", "action créée", "2024-03-29 15:33:15", "2024-03-29 15:33:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("3961", "1396", "action lancée via WP Cron", "2024-03-29 15:33:15", "2024-03-29 15:33:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("3962", "1396", "action terminée via WP Cron", "2024-03-29 15:33:16", "2024-03-29 15:33:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("3963", "1397", "action lancée via Async Request", "2024-03-29 15:35:17", "2024-03-29 15:35:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("3964", "1398", "action créée", "2024-03-29 15:35:17", "2024-03-29 15:35:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("3965", "1398", "action lancée via WP Cron", "2024-03-29 15:35:18", "2024-03-29 15:35:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("3966", "1398", "action terminée via WP Cron", "2024-03-29 15:35:18", "2024-03-29 15:35:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("3967", "1397", "action terminée via Async Request", "2024-03-29 15:35:18", "2024-03-29 15:35:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("3968", "1399", "action créée", "2024-03-29 15:35:18", "2024-03-29 15:35:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("3969", "1399", "action lancée via Async Request", "2024-03-29 15:37:30", "2024-03-29 15:37:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("3970", "1400", "action créée", "2024-03-29 15:37:30", "2024-03-29 15:37:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("3971", "1400", "action lancée via WP Cron", "2024-03-29 15:37:32", "2024-03-29 15:37:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("3972", "1400", "action terminée via WP Cron", "2024-03-29 15:37:32", "2024-03-29 15:37:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("3973", "1399", "action terminée via Async Request", "2024-03-29 15:37:32", "2024-03-29 15:37:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("3974", "1401", "action créée", "2024-03-29 15:37:32", "2024-03-29 15:37:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("3975", "1401", "action lancée via WP Cron", "2024-03-29 15:39:37", "2024-03-29 15:39:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("3976", "1402", "action créée", "2024-03-29 15:39:37", "2024-03-29 15:39:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("3977", "1401", "action terminée via WP Cron", "2024-03-29 15:39:42", "2024-03-29 15:39:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3978", "1403", "action créée", "2024-03-29 15:39:42", "2024-03-29 15:39:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3979", "1402", "action lancée via WP Cron", "2024-03-29 15:39:42", "2024-03-29 15:39:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3980", "1402", "action terminée via WP Cron", "2024-03-29 15:39:42", "2024-03-29 15:39:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("3981", "1403", "action lancée via WP Cron", "2024-03-29 15:41:44", "2024-03-29 15:41:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3982", "1404", "action créée", "2024-03-29 15:41:44", "2024-03-29 15:41:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3983", "1404", "action lancée via WP Cron", "2024-03-29 15:41:44", "2024-03-29 15:41:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3984", "1404", "action terminée via WP Cron", "2024-03-29 15:41:44", "2024-03-29 15:41:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3985", "1403", "action terminée via WP Cron", "2024-03-29 15:41:44", "2024-03-29 15:41:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3986", "1405", "action créée", "2024-03-29 15:41:44", "2024-03-29 15:41:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("3987", "1405", "action lancée via Async Request", "2024-03-29 15:43:54", "2024-03-29 15:43:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("3988", "1406", "action créée", "2024-03-29 15:43:54", "2024-03-29 15:43:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("3989", "1406", "action lancée via WP Cron", "2024-03-29 15:43:55", "2024-03-29 15:43:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("3990", "1406", "action terminée via WP Cron", "2024-03-29 15:43:55", "2024-03-29 15:43:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("3991", "1405", "action terminée via Async Request", "2024-03-29 15:43:55", "2024-03-29 15:43:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("3992", "1407", "action créée", "2024-03-29 15:43:55", "2024-03-29 15:43:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("3993", "1407", "action lancée via WP Cron", "2024-03-29 15:46:35", "2024-03-29 15:46:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("3994", "1408", "action créée", "2024-03-29 15:46:35", "2024-03-29 15:46:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("3995", "1407", "action terminée via WP Cron", "2024-03-29 15:46:40", "2024-03-29 15:46:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("3996", "1409", "action créée", "2024-03-29 15:46:40", "2024-03-29 15:46:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("3997", "1408", "action lancée via WP Cron", "2024-03-29 15:46:40", "2024-03-29 15:46:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("3998", "1408", "action terminée via WP Cron", "2024-03-29 15:46:40", "2024-03-29 15:46:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("3999", "1409", "action lancée via WP Cron", "2024-03-29 15:48:43", "2024-03-29 15:48:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("4000", "1410", "action créée", "2024-03-29 15:48:43", "2024-03-29 15:48:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("4001", "1409", "action terminée via WP Cron", "2024-03-29 15:48:48", "2024-03-29 15:48:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4002", "1411", "action créée", "2024-03-29 15:48:48", "2024-03-29 15:48:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4003", "1410", "action lancée via WP Cron", "2024-03-29 15:48:48", "2024-03-29 15:48:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4004", "1410", "action terminée via WP Cron", "2024-03-29 15:48:48", "2024-03-29 15:48:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("4005", "1411", "action lancée via Async Request", "2024-03-29 15:50:56", "2024-03-29 15:50:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4006", "1412", "action créée", "2024-03-29 15:50:56", "2024-03-29 15:50:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4007", "1412", "action lancée via WP Cron", "2024-03-29 15:50:57", "2024-03-29 15:50:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4008", "1412", "action terminée via WP Cron", "2024-03-29 15:50:57", "2024-03-29 15:50:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4009", "1411", "action terminée via Async Request", "2024-03-29 15:50:57", "2024-03-29 15:50:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4010", "1413", "action créée", "2024-03-29 15:50:57", "2024-03-29 15:50:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4011", "1413", "action lancée via WP Cron", "2024-03-29 15:53:55", "2024-03-29 15:53:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("4012", "1414", "action créée", "2024-03-29 15:53:55", "2024-03-29 15:53:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("4013", "1413", "action terminée via WP Cron", "2024-03-29 15:54:00", "2024-03-29 15:54:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4014", "1415", "action créée", "2024-03-29 15:54:00", "2024-03-29 15:54:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4015", "1414", "action lancée via WP Cron", "2024-03-29 15:54:00", "2024-03-29 15:54:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4016", "1414", "action terminée via WP Cron", "2024-03-29 15:54:01", "2024-03-29 15:54:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("4017", "1415", "action lancée via WP Cron", "2024-03-29 15:56:47", "2024-03-29 15:56:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("4018", "1416", "action créée", "2024-03-29 15:56:47", "2024-03-29 15:56:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("4019", "1415", "action terminée via WP Cron", "2024-03-29 15:56:52", "2024-03-29 15:56:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4020", "1417", "action créée", "2024-03-29 15:56:52", "2024-03-29 15:56:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4021", "1416", "action lancée via WP Cron", "2024-03-29 15:56:52", "2024-03-29 15:56:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4022", "1416", "action terminée via WP Cron", "2024-03-29 15:56:52", "2024-03-29 15:56:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4023", "1417", "action lancée via WP Cron", "2024-03-29 15:59:56", "2024-03-29 15:59:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4024", "1418", "action créée", "2024-03-29 15:59:56", "2024-03-29 15:59:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4025", "1417", "action terminée via WP Cron", "2024-03-29 16:00:01", "2024-03-29 16:00:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("4026", "1419", "action créée", "2024-03-29 16:00:01", "2024-03-29 16:00:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("4027", "1418", "action lancée via WP Cron", "2024-03-29 16:00:01", "2024-03-29 16:00:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("4028", "1418", "action terminée via WP Cron", "2024-03-29 16:00:01", "2024-03-29 16:00:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("4029", "1419", "action lancée via WP Cron", "2024-03-29 16:02:50", "2024-03-29 16:02:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("4030", "1420", "action créée", "2024-03-29 16:02:50", "2024-03-29 16:02:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("4031", "1420", "action lancée via WP Cron", "2024-03-29 16:02:51", "2024-03-29 16:02:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("4032", "1420", "action terminée via WP Cron", "2024-03-29 16:02:51", "2024-03-29 16:02:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("4033", "1419", "action terminée via WP Cron", "2024-03-29 16:02:51", "2024-03-29 16:02:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("4034", "1421", "action créée", "2024-03-29 16:02:51", "2024-03-29 16:02:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("4035", "1421", "action lancée via WP Cron", "2024-03-29 16:04:51", "2024-03-29 16:04:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("4036", "1422", "action créée", "2024-03-29 16:04:52", "2024-03-29 16:04:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4037", "1422", "action lancée via WP Cron", "2024-03-29 16:04:52", "2024-03-29 16:04:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4038", "1422", "action terminée via WP Cron", "2024-03-29 16:04:52", "2024-03-29 16:04:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4039", "1421", "action terminée via WP Cron", "2024-03-29 16:04:52", "2024-03-29 16:04:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4040", "1423", "action créée", "2024-03-29 16:04:52", "2024-03-29 16:04:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4041", "1423", "action lancée via WP Cron", "2024-03-29 16:06:52", "2024-03-29 16:06:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4042", "1424", "action créée", "2024-03-29 16:06:52", "2024-03-29 16:06:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("4043", "1424", "action lancée via WP Cron", "2024-03-29 16:06:53", "2024-03-29 16:06:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("4044", "1424", "action terminée via WP Cron", "2024-03-29 16:06:53", "2024-03-29 16:06:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("4045", "1423", "action terminée via WP Cron", "2024-03-29 16:06:53", "2024-03-29 16:06:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("4046", "1425", "action créée", "2024-03-29 16:06:53", "2024-03-29 16:06:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("4047", "1425", "action lancée via WP Cron", "2024-03-29 16:08:54", "2024-03-29 16:08:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4048", "1426", "action créée", "2024-03-29 16:08:54", "2024-03-29 16:08:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4049", "1426", "action lancée via WP Cron", "2024-03-29 16:08:54", "2024-03-29 16:08:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4050", "1426", "action terminée via WP Cron", "2024-03-29 16:08:54", "2024-03-29 16:08:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4051", "1425", "action terminée via WP Cron", "2024-03-29 16:08:54", "2024-03-29 16:08:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4052", "1427", "action créée", "2024-03-29 16:08:54", "2024-03-29 16:08:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4053", "1427", "action lancée via WP Cron", "2024-03-29 16:10:54", "2024-03-29 16:10:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4054", "1428", "action créée", "2024-03-29 16:10:54", "2024-03-29 16:10:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("4055", "1428", "action lancée via WP Cron", "2024-03-29 16:10:55", "2024-03-29 16:10:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("4056", "1428", "action terminée via WP Cron", "2024-03-29 16:10:55", "2024-03-29 16:10:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("4057", "1427", "action terminée via WP Cron", "2024-03-29 16:10:55", "2024-03-29 16:10:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("4058", "1429", "action créée", "2024-03-29 16:10:55", "2024-03-29 16:10:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("4059", "1429", "action lancée via WP Cron", "2024-03-29 16:12:55", "2024-03-29 16:12:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("4060", "1430", "action créée", "2024-03-29 16:12:55", "2024-03-29 16:12:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("4061", "1429", "action terminée via WP Cron", "2024-03-29 16:13:00", "2024-03-29 16:13:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4062", "1431", "action créée", "2024-03-29 16:13:00", "2024-03-29 16:13:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4063", "1430", "action lancée via WP Cron", "2024-03-29 16:13:00", "2024-03-29 16:13:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4064", "1430", "action terminée via WP Cron", "2024-03-29 16:13:00", "2024-03-29 16:13:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("4065", "1431", "action lancée via WP Cron", "2024-03-29 16:15:56", "2024-03-29 16:15:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4066", "1432", "action créée", "2024-03-29 16:15:56", "2024-03-29 16:15:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4067", "1432", "action lancée via WP Cron", "2024-03-29 16:15:57", "2024-03-29 16:15:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4068", "1432", "action terminée via WP Cron", "2024-03-29 16:15:57", "2024-03-29 16:15:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4069", "1431", "action terminée via WP Cron", "2024-03-29 16:15:57", "2024-03-29 16:15:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4070", "1433", "action créée", "2024-03-29 16:15:57", "2024-03-29 16:15:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4071", "1433", "action lancée via WP Cron", "2024-03-29 16:18:56", "2024-03-29 16:18:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4072", "1434", "action créée", "2024-03-29 16:18:56", "2024-03-29 16:18:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4073", "1434", "action lancée via WP Cron", "2024-03-29 16:18:57", "2024-03-29 16:18:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4074", "1434", "action terminée via WP Cron", "2024-03-29 16:18:57", "2024-03-29 16:18:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4075", "1433", "action terminée via WP Cron", "2024-03-29 16:18:57", "2024-03-29 16:18:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4076", "1435", "action créée", "2024-03-29 16:18:57", "2024-03-29 16:18:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4077", "1435", "action lancée via Async Request", "2024-03-29 16:21:27", "2024-03-29 16:21:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("4078", "1436", "action créée", "2024-03-29 16:21:27", "2024-03-29 16:21:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("4079", "1436", "action lancée via WP Cron", "2024-03-29 16:21:28", "2024-03-29 16:21:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("4080", "1436", "action terminée via WP Cron", "2024-03-29 16:21:28", "2024-03-29 16:21:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("4081", "1435", "action terminée via Async Request", "2024-03-29 16:21:28", "2024-03-29 16:21:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("4082", "1437", "action créée", "2024-03-29 16:21:28", "2024-03-29 16:21:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("4083", "1437", "action lancée via WP Cron", "2024-03-29 16:23:56", "2024-03-29 16:23:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4084", "1438", "action créée", "2024-03-29 16:23:56", "2024-03-29 16:23:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4085", "1438", "action lancée via WP Cron", "2024-03-29 16:23:57", "2024-03-29 16:23:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4086", "1438", "action terminée via WP Cron", "2024-03-29 16:23:57", "2024-03-29 16:23:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4087", "1437", "action terminée via WP Cron", "2024-03-29 16:23:57", "2024-03-29 16:23:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4088", "1439", "action créée", "2024-03-29 16:23:57", "2024-03-29 16:23:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4089", "1439", "action lancée via Async Request", "2024-03-29 16:26:11", "2024-03-29 16:26:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("4090", "1440", "action créée", "2024-03-29 16:26:11", "2024-03-29 16:26:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("4091", "1440", "action lancée via WP Cron", "2024-03-29 16:26:12", "2024-03-29 16:26:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("4092", "1440", "action terminée via WP Cron", "2024-03-29 16:26:13", "2024-03-29 16:26:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("4093", "1439", "action terminée via Async Request", "2024-03-29 16:26:13", "2024-03-29 16:26:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("4094", "1441", "action créée", "2024-03-29 16:26:13", "2024-03-29 16:26:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("4095", "1441", "action lancée via WP Cron", "2024-03-29 16:28:56", "2024-03-29 16:28:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4096", "1442", "action créée", "2024-03-29 16:28:56", "2024-03-29 16:28:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4097", "1442", "action lancée via WP Cron", "2024-03-29 16:28:57", "2024-03-29 16:28:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4098", "1442", "action terminée via WP Cron", "2024-03-29 16:28:57", "2024-03-29 16:28:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4099", "1441", "action terminée via WP Cron", "2024-03-29 16:28:57", "2024-03-29 16:28:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4100", "1443", "action créée", "2024-03-29 16:28:57", "2024-03-29 16:28:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("4101", "1443", "action lancée via Async Request", "2024-03-29 16:31:27", "2024-03-29 16:31:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("4102", "1444", "action créée", "2024-03-29 16:31:27", "2024-03-29 16:31:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("4103", "1444", "action lancée via WP Cron", "2024-03-29 16:31:28", "2024-03-29 16:31:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("4104", "1444", "action terminée via WP Cron", "2024-03-29 16:31:28", "2024-03-29 16:31:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("4105", "1443", "action terminée via Async Request", "2024-03-29 16:31:28", "2024-03-29 16:31:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("4106", "1445", "action créée", "2024-03-29 16:31:28", "2024-03-29 16:31:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("4107", "1445", "action lancée via Async Request", "2024-03-29 16:33:32", "2024-03-29 16:33:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("4108", "1446", "action créée", "2024-03-29 16:33:32", "2024-03-29 16:33:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("4109", "1446", "action lancée via WP Cron", "2024-03-29 16:33:33", "2024-03-29 16:33:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("4110", "1446", "action terminée via WP Cron", "2024-03-29 16:33:33", "2024-03-29 16:33:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("4111", "1445", "action terminée via Async Request", "2024-03-29 16:33:33", "2024-03-29 16:33:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("4112", "1447", "action créée", "2024-03-29 16:33:33", "2024-03-29 16:33:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("4113", "1447", "action lancée via Async Request", "2024-03-29 16:35:38", "2024-03-29 16:35:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4114", "1448", "action créée", "2024-03-29 16:35:38", "2024-03-29 16:35:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4115", "1448", "action lancée via WP Cron", "2024-03-29 16:35:39", "2024-03-29 16:35:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("4116", "1448", "action terminée via WP Cron", "2024-03-29 16:35:39", "2024-03-29 16:35:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("4117", "1447", "action terminée via Async Request", "2024-03-29 16:35:40", "2024-03-29 16:35:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4118", "1449", "action créée", "2024-03-29 16:35:40", "2024-03-29 16:35:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("4119", "1449", "action lancée via WP Cron", "2024-03-29 16:38:03", "2024-03-29 16:38:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("4120", "1450", "action créée", "2024-03-29 16:38:03", "2024-03-29 16:38:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("4121", "1450", "action lancée via WP Cron", "2024-03-29 16:38:04", "2024-03-29 16:38:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("4122", "1450", "action terminée via WP Cron", "2024-03-29 16:38:04", "2024-03-29 16:38:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("4123", "1449", "action terminée via WP Cron", "2024-03-29 16:38:04", "2024-03-29 16:38:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("4124", "1451", "action créée", "2024-03-29 16:38:04", "2024-03-29 16:38:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("4125", "1451", "action lancée via WP Cron", "2024-03-29 16:42:04", "2024-03-29 16:42:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("4126", "1452", "action créée", "2024-03-29 16:42:04", "2024-03-29 16:42:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("4127", "1451", "action terminée via WP Cron", "2024-03-29 16:42:09", "2024-03-29 16:42:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4128", "1453", "action créée", "2024-03-29 16:42:09", "2024-03-29 16:42:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4129", "1452", "action lancée via WP Cron", "2024-03-29 16:42:09", "2024-03-29 16:42:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4130", "1452", "action terminée via WP Cron", "2024-03-29 16:42:09", "2024-03-29 16:42:09");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "A WordPress Commenter", "wapuu@wordpress.example", "https://wordpress.org/", "", "2023-10-24 10:43:46", "2023-10-24 10:43:46", "Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://en.gravatar.com/\">Gravatar</a>.", "0", "1", "", "comment", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20240329_deblock", "43d434374bbda9216135_20240329164404", "21", "2024-03-29 16:44:17", "Thomas", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-03-29 16:44:04\";s:7:\"Version\";s:7:\"1.5.8.1\";s:9:\"VersionWP\";s:5:\"6.4.3\";s:9:\"VersionDB\";s:6:\"8.0.16\";s:10:\"VersionPHP\";s:6:\"8.1.23\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";i:1;s:4:\"Name\";s:16:\"20240329_deblock\";s:4:\"Hash\";s:35:\"43d434374bbda9216135_20240329164404\";s:8:\"NameHash\";s:52:\"20240329_deblock_43d434374bbda9216135_20240329164404\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:62:\"20240329_deblock_43d434374bbda9216135_20240329164404_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"20.5\";s:6:\"WPUser\";s:6:\"Thomas\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:64:\"20240329_deblock_43d434374bbda9216135_20240329164404_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:41:\"/Users/tom/Local Sites/deblock/app/public\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:3225;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:25075;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Size\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-03-29 16:44:04\";s:7:\"Version\";s:7:\"1.5.8.1\";s:9:\"VersionWP\";s:5:\"6.4.3\";s:9:\"VersionDB\";s:6:\"8.0.16\";s:10:\"VersionPHP\";s:6:\"8.1.23\";s:9:\"VersionOS\";s:6:\"Darwin\";s:2:\"ID\";N;s:4:\"Name\";s:16:\"20240329_deblock\";s:4:\"Hash\";s:35:\"43d434374bbda9216135_20240329164404\";s:8:\"NameHash\";s:52:\"20240329_deblock_43d434374bbda9216135_20240329164404\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:70:\"20240329_deblock_43d434374bbda9216135_20240329164404_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:55:\"/Users/tom/Local Sites/deblock/app/public/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:65:\"20240329_deblock_43d434374bbda9216135_20240329164404_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:139:\"/Users/tom/Local Sites/deblock/app/public/wp-content/backups-dup-lite/tmp/20240329_deblock_43d434374bbda9216135_20240329164404_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:50:\"/Users/tom/Local Sites/deblock/app/public/wp-admin\";i:1;s:53:\"/Users/tom/Local Sites/deblock/app/public/wp-includes\";i:2;s:62:\"/Users/tom/Local Sites/deblock/app/public/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:41:\"/Users/tom/Local Sites/deblock/app/public\";i:1;s:41:\"/Users/tom/Local Sites/deblock/app/public\";i:2;s:52:\"/Users/tom/Local Sites/deblock/app/public/wp-content\";i:3;s:60:\"/Users/tom/Local Sites/deblock/app/public/wp-content/uploads\";i:4;s:60:\"/Users/tom/Local Sites/deblock/app/public/wp-content/plugins\";i:5;s:63:\"/Users/tom/Local Sites/deblock/app/public/wp-content/mu-plugins\";i:6;s:59:\"/Users/tom/Local Sites/deblock/app/public/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:73:\"/Users/tom/Local Sites/deblock/app/public/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_eg_grids */
INSERT INTO `wp_eg_grids` VALUES("1", "Catégories", "categories", "{\"source-type\":\"custom\",\"post_types\":\"post\",\"post_category\":\"\",\"category-relation\":\"OR\",\"additional-query\":\"\",\"selected_pages\":\"\",\"max_entries\":\"-1\",\"max_entries_preview\":\"20\",\"media-source-order\":[\"featured-image\"],\"poster-source-order\":[\"featured-image\"],\"image-source-smart\":\"off\",\"image-source-type\":\"full\",\"image-source-type-mobile\":\"full\",\"default-image\":\"\",\"youtube-default-image\":\"\",\"vimeo-default-image\":\"\",\"html-default-image\":\"\",\"image-source-smart-size\":false}", "{\"layout-sizing\":\"boxed\",\"fullscreen-offset-container\":\"\",\"layout\":\"masonry\",\"content-push\":\"off\",\"x-ratio\":\"4\",\"y-ratio\":\"4\",\"auto-ratio\":\"false\",\"rtl\":\"off\",\"show-even-on-device\":\"0\",\"use-cobbles-pattern\":\"off\",\"videoplaybackingrid\":\"on\",\"videoloopingrid\":\"off\",\"videoplaybackonhover\":\"off\",\"videocontrolsinline\":\"off\",\"videomuteinline\":\"on\",\"keeplayersovermedia\":\"off\",\"columns-advanced\":\"off\",\"columns-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns-width\":[\"1900\",\"1400\",\"1170\",\"1024\",\"960\",\"778\",\"640\",\"480\"],\"mascontent-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns\":[\"4\",\"4\",\"4\",\"4\",\"4\",\"4\",\"4\",\"2\"],\"blank-item-breakpoint\":\"none\",\"rows-unlimited\":\"off\",\"rows\":\"2\",\"enable-rows-mobile\":\"off\",\"rows-mobile\":\"3\",\"pagination-autoplay\":\"off\",\"pagination-autoplay-speed\":\"5000\",\"pagination-touchswipe\":\"off\",\"pagination-dragvertical\":\"on\",\"pagination-swipebuffer\":\"30\",\"load-more\":\"none\",\"load-more-hide\":\"off\",\"load-more-text\":\"Load More\",\"load-more-error\":\"\",\"load-more-show-number\":\"on\",\"load-more-start\":\"3\",\"load-more-amount\":\"3\",\"lazy-loading\":\"off\",\"lazy-loading-blur\":\"on\",\"lazy-load-color\":\"#FFFFFF\",\"spacings\":\"50\",\"grid-padding\":[\"30\",\"30\",\"30\",\"30\"],\"main-background-color\":\"transparent\",\"navigation-skin\":\"minimal-light\",\"navigation-preview-bg\":\"dark\",\"0\":\"\",\"entry-skin\":\"1\",\"grid-start-animation\":\"reveal\",\"hide-markup-before-load\":\"on\",\"grid-start-animation-speed\":\"1000\",\"grid-start-animation-delay\":\"100\",\"grid-start-animation-type\":\"item\",\"start-anime-in-viewport\":\"off\",\"start-anime-viewport-buffer\":\"20\",\"grid-animation\":\"fade\",\"grid-animation-speed\":\"1000\",\"grid-animation-delay\":\"1\",\"grid-animation-type\":\"item\",\"grid-item-animation\":\"none\",\"grid-item-animation-zoomin\":\"125\",\"grid-item-animation-zoomout\":\"75\",\"grid-item-animation-fade\":\"75\",\"grid-item-animation-blur\":\"5\",\"grid-item-animation-rotate\":\"30\",\"grid-item-animation-shift\":\"up\",\"grid-item-animation-shift-amount\":\"10\",\"grid-item-animation-other\":\"none\",\"grid-item-other-zoomin\":\"125\",\"grid-item-other-zoomout\":\"75\",\"grid-item-other-fade\":\"75\",\"grid-item-other-blur\":\"5\",\"grid-item-other-rotate\":\"30\",\"grid-item-other-shift\":\"up\",\"grid-item-other-shift-amount\":\"10\",\"top-1-align\":\"center\",\"top-1-margin-bottom\":\"0\",\"top-2-align\":\"center\",\"top-2-margin-bottom\":\"0\",\"bottom-1-align\":\"center\",\"bottom-1-margin-top\":\"0\",\"bottom-2-align\":\"center\",\"bottom-2-margin-top\":\"0\",\"left-margin-left\":\"0\",\"right-margin-right\":\"0\",\"module-spacings\":\"5\",\"pagination-numbers\":\"smart\",\"pagination-scroll\":\"off\",\"pagination-scroll-offset\":\"0\",\"filter-arrows\":\"single\",\"filter-logic\":\"or\",\"add-filters-by\":\"default\",\"filter-start\":\"\",\"filter-deep-link\":\"off\",\"filter-show-on\":\"hover\",\"convert-mobile-filters\":\"off\",\"convert-mobile-filters-width\":\"768\",\"filter-all-visible\":\"on\",\"filter-all-text\":\"Filter - All\",\"filter-listing\":\"list\",\"filter-dropdown-text\":\"Filter Categories\",\"filter-counter\":\"off\",\"filter-sort-alpha\":\"off\",\"filter-sort-alpha-dir\":\"asc\",\"sort-by-text\":\"Sort By \",\"sorting-order-by\":\"date\",\"sorting-order-by-start\":\"none\",\"sorting-order-by-start-meta\":\"\",\"sorting-order-type\":\"ASC\",\"search-text\":\"Search...\",\"lb-source-order\":[\"featured-image\"],\"lightbox-mode\":\"single\",\"lightbox-exclude-media\":\"off\",\"lightbox-deep-link\":\"group\",\"lightbox-videoautoplay\":\"on\",\"lightbox-override-ui-colors\":\"off\",\"lightbox-overlay-bg-color\":\"rgba(30,30,30,0.9)\",\"lightbox-ui-bg-color\":\"#28303d\",\"lightbox-ui-color\":\"#ffffff\",\"lightbox-ui-hover-bg-color\":\"#000000\",\"lightbox-ui-hover-color\":\"#ffffff\",\"lightbox-ui-text-color\":\"#eeeeee\",\"lightbox-title-strip\":\"on\",\"lightbox-title-position\":\"bottom\",\"lightbox-title\":\"off\",\"lightbox-title-source\":\"title\",\"lightbox-description\":\"off\",\"lightbox-description-source\":\"description\",\"lbox-padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-effect-open-close\":\"fade\",\"lightbox-effect-open-close-speed\":\"500\",\"lightbox-effect-next-prev\":\"fade\",\"lightbox-effect-next-prev-speed\":\"500\",\"lightbox-autoplay\":\"off\",\"lbox-playspeed\":\"3000\",\"lightbox-arrows\":\"on\",\"lightbox-loop\":\"on\",\"lightbox-numbers\":\"on\",\"lightbox-mousewheel\":\"off\",\"lb-button-order\":[\"share\",\"thumbs\",\"close\"],\"lightbox-post-content-min-width\":\"75\",\"lightbox-post-content-min-perc\":\"on\",\"lightbox-post-content-max-width\":\"75\",\"lightbox-post-content-max-perc\":\"on\",\"lightbox-post-content-overflow\":\"on\",\"lbox-content_padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-post-spinner\":\"off\",\"lightbox-post-content-img\":\"off\",\"lightbox-post-content-img-position\":\"top\",\"lightbox-post-content-img-width\":\"50\",\"lightbox-post-content-img-margin\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-post-content-title\":\"off\",\"lightbox-post-content-title-tag\":\"h2\",\"aj-source-order\":[\"post-content\"],\"ajax-container-id\":\"ess-grid-ajax-container-\",\"ajax-container-position\":\"top\",\"ajax-scroll-onload\":\"on\",\"ajax-scrollto-offset\":\"0\",\"ajax-close-button\":\"off\",\"ajax-button-text\":\"Close\",\"ajax-nav-button\":\"off\",\"ajax-button-skin\":\"light\",\"ajax-button-type\":\"type1\",\"ajax-button-inner\":\"false\",\"ajax-button-h-pos\":\"r\",\"ajax-button-v-pos\":\"t\",\"ajax-container-pre\":\"\",\"ajax-container-post\":\"\",\"ajax-container-css\":\"\",\"ajax-callback\":\"\",\"ajax-callback-arg\":\"false\",\"ajax-css-url\":\"\",\"ajax-js-url\":\"\",\"use-spinner\":\"0\",\"spinner-color\":\"#FFFFFF\",\"custom-javascript\":\"\",\"cookie-save-time\":\"30\",\"cookie-save-search\":\"off\",\"cookie-save-filter\":\"off\",\"cookie-save-pagination\":\"off\",\"pg\":\"false\",\"css-id\":\"\",\"navigation-layout\":{\"left\":{\"left\":\"0\"},\"right\":{\"right\":\"0\"}}}", "[\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"21\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/nos-produits\\\\\\/elingues-sur-mesure\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"ELINGUES SUR MESURE\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"160\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/nos-produits\\\\\\/elingues-sur-mesure\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"Structure \\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"301\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/nos-produits\\\\\\/epi-securite\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"EPI S\\\\u00e9curit\\\\u00e9 \\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"youtube\\\",\\\"custom-image\\\":\\\"158\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/cordage-tresse-sandow\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"CORDAGE\\\\\\/TRESSE\\\\\\/ SANDOW\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"40\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/nos-produits\\\\\\/elingues-sur-mesure\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"ARRIMAGE\\\\\\/HAUBANNAGE SUR MESURE\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"36\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/nos-produits\\\\\\/elingues-sur-mesure\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"Appareils\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"52\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/nos-produits\\\\\\/elingues-sur-mesure\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"Accessoires\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"159\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/nos-produits\\\\\\/elingues-sur-mesure\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"TERMINAISONS\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\"]", "{\"bg\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/10\\/elingue-cable-4-brins-grandes-boucles-nues.jpg\"}", "2024-02-21 11:34:58");
INSERT INTO `wp_eg_grids` VALUES("2", "Selection PDT", "selecta", "{\"source-type\":\"custom\",\"post_types\":\"post\",\"post_category\":\"\",\"category-relation\":\"OR\",\"additional-query\":\"\",\"selected_pages\":\"\",\"max_entries\":\"-1\",\"max_entries_preview\":\"20\",\"media-source-order\":[\"featured-image\"],\"poster-source-order\":[\"featured-image\"],\"image-source-smart\":\"off\",\"image-source-type\":\"full\",\"image-source-type-mobile\":\"full\",\"default-image\":\"\",\"youtube-default-image\":\"\",\"vimeo-default-image\":\"\",\"html-default-image\":\"\",\"image-source-smart-size\":false}", "{\"layout-sizing\":\"fullwidth\",\"fullscreen-offset-container\":\"\",\"layout\":\"masonry\",\"content-push\":\"off\",\"x-ratio\":\"4\",\"y-ratio\":\"4\",\"auto-ratio\":\"true\",\"rtl\":\"off\",\"show-even-on-device\":\"0\",\"use-cobbles-pattern\":\"off\",\"videoplaybackingrid\":\"on\",\"videoloopingrid\":\"off\",\"videoplaybackonhover\":\"off\",\"videocontrolsinline\":\"off\",\"videomuteinline\":\"on\",\"keeplayersovermedia\":\"off\",\"columns-advanced\":\"off\",\"columns-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns-width\":[\"1900\",\"1400\",\"1170\",\"1024\",\"960\",\"778\",\"640\",\"480\"],\"mascontent-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns\":[\"5\",\"5\",\"5\",\"5\",\"5\",\"5\",\"5\",\"3\"],\"blank-item-breakpoint\":\"none\",\"rows-unlimited\":\"off\",\"rows\":\"1\",\"enable-rows-mobile\":\"off\",\"rows-mobile\":\"3\",\"pagination-autoplay\":\"off\",\"pagination-autoplay-speed\":\"5000\",\"pagination-touchswipe\":\"off\",\"pagination-dragvertical\":\"on\",\"pagination-swipebuffer\":\"30\",\"load-more\":\"none\",\"load-more-hide\":\"off\",\"load-more-text\":\"Load More\",\"load-more-error\":\"\",\"load-more-show-number\":\"on\",\"load-more-start\":\"3\",\"load-more-amount\":\"3\",\"lazy-loading\":\"off\",\"lazy-loading-blur\":\"on\",\"lazy-load-color\":\"#FFFFFF\",\"spacings\":\"20\",\"grid-padding\":[\"20\",\"20\",\"20\",\"20\"],\"main-background-color\":\"transparent\",\"navigation-skin\":\"minimal-light\",\"navigation-preview-bg\":\"dark\",\"0\":\"\",\"entry-skin\":\"1\",\"grid-start-animation\":\"scale\",\"hide-markup-before-load\":\"off\",\"grid-start-animation-speed\":\"1000\",\"grid-start-animation-delay\":\"1\",\"grid-start-animation-type\":\"item\",\"start-anime-in-viewport\":\"off\",\"start-anime-viewport-buffer\":\"20\",\"grid-animation\":\"fade\",\"grid-animation-speed\":\"1000\",\"grid-animation-delay\":\"1\",\"grid-animation-type\":\"item\",\"grid-item-animation\":\"none\",\"grid-item-animation-zoomin\":\"125\",\"grid-item-animation-zoomout\":\"75\",\"grid-item-animation-fade\":\"75\",\"grid-item-animation-blur\":\"5\",\"grid-item-animation-rotate\":\"30\",\"grid-item-animation-shift\":\"up\",\"grid-item-animation-shift-amount\":\"10\",\"grid-item-animation-other\":\"none\",\"grid-item-other-zoomin\":\"125\",\"grid-item-other-zoomout\":\"75\",\"grid-item-other-fade\":\"75\",\"grid-item-other-blur\":\"5\",\"grid-item-other-rotate\":\"30\",\"grid-item-other-shift\":\"up\",\"grid-item-other-shift-amount\":\"10\",\"top-1-align\":\"center\",\"top-1-margin-bottom\":\"0\",\"top-2-align\":\"center\",\"top-2-margin-bottom\":\"0\",\"bottom-1-align\":\"center\",\"bottom-1-margin-top\":\"0\",\"bottom-2-align\":\"center\",\"bottom-2-margin-top\":\"0\",\"left-margin-left\":\"0\",\"right-margin-right\":\"0\",\"module-spacings\":\"5\",\"pagination-numbers\":\"smart\",\"pagination-scroll\":\"off\",\"pagination-scroll-offset\":\"0\",\"filter-arrows\":\"single\",\"filter-logic\":\"or\",\"add-filters-by\":\"default\",\"filter-start\":\"\",\"filter-deep-link\":\"off\",\"filter-show-on\":\"hover\",\"convert-mobile-filters\":\"off\",\"convert-mobile-filters-width\":\"768\",\"filter-all-visible\":\"on\",\"filter-all-text\":\"Filter - All\",\"filter-listing\":\"list\",\"filter-dropdown-text\":\"Filter Categories\",\"filter-counter\":\"off\",\"filter-sort-alpha\":\"off\",\"filter-sort-alpha-dir\":\"asc\",\"sort-by-text\":\"Sort By \",\"sorting-order-by\":\"date\",\"sorting-order-by-start\":\"none\",\"sorting-order-by-start-meta\":\"\",\"sorting-order-type\":\"ASC\",\"search-text\":\"Search...\",\"lb-source-order\":[\"featured-image\"],\"lightbox-mode\":\"single\",\"lightbox-exclude-media\":\"off\",\"lightbox-deep-link\":\"group\",\"lightbox-videoautoplay\":\"on\",\"lightbox-override-ui-colors\":\"off\",\"lightbox-overlay-bg-color\":\"rgba(30,30,30,0.9)\",\"lightbox-ui-bg-color\":\"#28303d\",\"lightbox-ui-color\":\"#ffffff\",\"lightbox-ui-hover-bg-color\":\"#000000\",\"lightbox-ui-hover-color\":\"#ffffff\",\"lightbox-ui-text-color\":\"#eeeeee\",\"lightbox-title-strip\":\"on\",\"lightbox-title-position\":\"bottom\",\"lightbox-title\":\"off\",\"lightbox-title-source\":\"title\",\"lightbox-description\":\"off\",\"lightbox-description-source\":\"description\",\"lbox-padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-effect-open-close\":\"fade\",\"lightbox-effect-open-close-speed\":\"500\",\"lightbox-effect-next-prev\":\"fade\",\"lightbox-effect-next-prev-speed\":\"500\",\"lightbox-autoplay\":\"off\",\"lbox-playspeed\":\"3000\",\"lightbox-arrows\":\"on\",\"lightbox-loop\":\"on\",\"lightbox-numbers\":\"on\",\"lightbox-mousewheel\":\"off\",\"lb-button-order\":[\"share\",\"thumbs\",\"close\"],\"lightbox-post-content-min-width\":\"75\",\"lightbox-post-content-min-perc\":\"on\",\"lightbox-post-content-max-width\":\"75\",\"lightbox-post-content-max-perc\":\"on\",\"lightbox-post-content-overflow\":\"on\",\"lbox-content_padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-post-spinner\":\"off\",\"lightbox-post-content-img\":\"off\",\"lightbox-post-content-img-position\":\"top\",\"lightbox-post-content-img-width\":\"50\",\"lightbox-post-content-img-margin\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-post-content-title\":\"off\",\"lightbox-post-content-title-tag\":\"h2\",\"aj-source-order\":[\"post-content\"],\"ajax-container-id\":\"ess-grid-ajax-container-\",\"ajax-container-position\":\"top\",\"ajax-scroll-onload\":\"on\",\"ajax-scrollto-offset\":\"0\",\"ajax-close-button\":\"off\",\"ajax-button-text\":\"Close\",\"ajax-nav-button\":\"off\",\"ajax-button-skin\":\"light\",\"ajax-button-type\":\"type1\",\"ajax-button-inner\":\"false\",\"ajax-button-h-pos\":\"r\",\"ajax-button-v-pos\":\"t\",\"ajax-container-pre\":\"\",\"ajax-container-post\":\"\",\"ajax-container-css\":\"\",\"ajax-callback\":\"\",\"ajax-callback-arg\":\"false\",\"ajax-css-url\":\"\",\"ajax-js-url\":\"\",\"use-spinner\":\"0\",\"spinner-color\":\"#FFFFFF\",\"custom-javascript\":\"\",\"cookie-save-time\":\"30\",\"cookie-save-search\":\"off\",\"cookie-save-filter\":\"off\",\"cookie-save-pagination\":\"off\",\"pg\":\"false\",\"css-id\":\"\",\"navigation-layout\":{\"left\":{\"left\":\"0\"},\"right\":{\"right\":\"0\"}}}", "[\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"35\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"pince a fut\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"42\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"tendeur a levier chaine\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"41\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"sangle de levage\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"40\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"sangle\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"34\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"palan manuel a chaine\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\"]", "{\"bg\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/10\\/pince-a-fut-.jpg\"}", "2023-10-24 12:45:34");
INSERT INTO `wp_eg_grids` VALUES("3", "Services", "services", "{\"source-type\":\"custom\",\"post_types\":\"post\",\"post_category\":\"\",\"category-relation\":\"OR\",\"additional-query\":\"\",\"selected_pages\":\"\",\"max_entries\":\"-1\",\"max_entries_preview\":\"20\",\"media-source-order\":[\"featured-image\"],\"poster-source-order\":[\"featured-image\"],\"image-source-smart\":\"off\",\"image-source-type\":\"full\",\"image-source-type-mobile\":\"full\",\"default-image\":\"\",\"youtube-default-image\":\"\",\"vimeo-default-image\":\"\",\"html-default-image\":\"\",\"image-source-smart-size\":false}", "{\"layout-sizing\":\"boxed\",\"fullscreen-offset-container\":\"\",\"layout\":\"even\",\"content-push\":\"off\",\"x-ratio\":\"3\",\"y-ratio\":\"4\",\"auto-ratio\":\"true\",\"rtl\":\"off\",\"show-even-on-device\":\"0\",\"use-cobbles-pattern\":\"off\",\"videoplaybackingrid\":\"on\",\"videoloopingrid\":\"off\",\"videoplaybackonhover\":\"off\",\"videocontrolsinline\":\"off\",\"videomuteinline\":\"on\",\"keeplayersovermedia\":\"off\",\"columns-advanced\":\"off\",\"columns-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns-width\":[\"1900\",\"1400\",\"1170\",\"1024\",\"960\",\"778\",\"640\",\"480\"],\"mascontent-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns\":[\"4\",\"4\",\"4\",\"4\",\"4\",\"4\",\"4\",\"2\"],\"blank-item-breakpoint\":\"none\",\"rows-unlimited\":\"off\",\"rows\":\"2\",\"enable-rows-mobile\":\"off\",\"rows-mobile\":\"3\",\"pagination-autoplay\":\"off\",\"pagination-autoplay-speed\":\"5000\",\"pagination-touchswipe\":\"off\",\"pagination-dragvertical\":\"on\",\"pagination-swipebuffer\":\"30\",\"load-more\":\"none\",\"load-more-hide\":\"off\",\"load-more-text\":\"Load More\",\"load-more-error\":\"\",\"load-more-show-number\":\"on\",\"load-more-start\":\"3\",\"load-more-amount\":\"3\",\"lazy-loading\":\"off\",\"lazy-loading-blur\":\"on\",\"lazy-load-color\":\"#FFFFFF\",\"spacings\":\"50\",\"grid-padding\":[\"15\",\"15\",\"15\",\"15\"],\"main-background-color\":\"transparent\",\"navigation-skin\":\"minimal-light\",\"navigation-preview-bg\":\"dark\",\"0\":\"\",\"entry-skin\":\"8\",\"grid-start-animation\":\"reveal\",\"hide-markup-before-load\":\"on\",\"grid-start-animation-speed\":\"1000\",\"grid-start-animation-delay\":\"100\",\"grid-start-animation-type\":\"item\",\"start-anime-in-viewport\":\"off\",\"start-anime-viewport-buffer\":\"20\",\"grid-animation\":\"fade\",\"grid-animation-speed\":\"1000\",\"grid-animation-delay\":\"1\",\"grid-animation-type\":\"item\",\"grid-item-animation\":\"none\",\"grid-item-animation-zoomin\":\"125\",\"grid-item-animation-zoomout\":\"75\",\"grid-item-animation-fade\":\"75\",\"grid-item-animation-blur\":\"5\",\"grid-item-animation-rotate\":\"30\",\"grid-item-animation-shift\":\"up\",\"grid-item-animation-shift-amount\":\"10\",\"grid-item-animation-other\":\"none\",\"grid-item-other-zoomin\":\"125\",\"grid-item-other-zoomout\":\"75\",\"grid-item-other-fade\":\"75\",\"grid-item-other-blur\":\"5\",\"grid-item-other-rotate\":\"30\",\"grid-item-other-shift\":\"up\",\"grid-item-other-shift-amount\":\"10\",\"top-1-align\":\"center\",\"top-1-margin-bottom\":\"0\",\"top-2-align\":\"center\",\"top-2-margin-bottom\":\"0\",\"bottom-1-align\":\"center\",\"bottom-1-margin-top\":\"0\",\"bottom-2-align\":\"center\",\"bottom-2-margin-top\":\"0\",\"left-margin-left\":\"0\",\"right-margin-right\":\"0\",\"module-spacings\":\"5\",\"pagination-numbers\":\"smart\",\"pagination-scroll\":\"off\",\"pagination-scroll-offset\":\"0\",\"filter-arrows\":\"single\",\"filter-logic\":\"or\",\"add-filters-by\":\"default\",\"filter-start\":\"\",\"filter-deep-link\":\"off\",\"filter-show-on\":\"hover\",\"convert-mobile-filters\":\"off\",\"convert-mobile-filters-width\":\"768\",\"filter-all-visible\":\"on\",\"filter-all-text\":\"Filter - All\",\"filter-listing\":\"list\",\"filter-dropdown-text\":\"Filter Categories\",\"filter-counter\":\"off\",\"filter-sort-alpha\":\"off\",\"filter-sort-alpha-dir\":\"asc\",\"sort-by-text\":\"Sort By \",\"sorting-order-by\":\"date\",\"sorting-order-by-start\":\"none\",\"sorting-order-by-start-meta\":\"\",\"sorting-order-type\":\"ASC\",\"search-text\":\"Search...\",\"lb-source-order\":[\"featured-image\"],\"lightbox-mode\":\"single\",\"lightbox-exclude-media\":\"off\",\"lightbox-deep-link\":\"group\",\"lightbox-videoautoplay\":\"on\",\"lightbox-override-ui-colors\":\"off\",\"lightbox-overlay-bg-color\":\"rgba(30,30,30,0.9)\",\"lightbox-ui-bg-color\":\"#28303d\",\"lightbox-ui-color\":\"#ffffff\",\"lightbox-ui-hover-bg-color\":\"#000000\",\"lightbox-ui-hover-color\":\"#ffffff\",\"lightbox-ui-text-color\":\"#eeeeee\",\"lightbox-title-strip\":\"on\",\"lightbox-title-position\":\"bottom\",\"lightbox-title\":\"off\",\"lightbox-title-source\":\"title\",\"lightbox-description\":\"off\",\"lightbox-description-source\":\"description\",\"lbox-padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-effect-open-close\":\"fade\",\"lightbox-effect-open-close-speed\":\"500\",\"lightbox-effect-next-prev\":\"fade\",\"lightbox-effect-next-prev-speed\":\"500\",\"lightbox-autoplay\":\"off\",\"lbox-playspeed\":\"3000\",\"lightbox-arrows\":\"on\",\"lightbox-loop\":\"on\",\"lightbox-numbers\":\"on\",\"lightbox-mousewheel\":\"off\",\"lb-button-order\":[\"share\",\"thumbs\",\"close\"],\"lightbox-post-content-min-width\":\"75\",\"lightbox-post-content-min-perc\":\"on\",\"lightbox-post-content-max-width\":\"75\",\"lightbox-post-content-max-perc\":\"on\",\"lightbox-post-content-overflow\":\"on\",\"lbox-content_padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-post-spinner\":\"off\",\"lightbox-post-content-img\":\"off\",\"lightbox-post-content-img-position\":\"top\",\"lightbox-post-content-img-width\":\"50\",\"lightbox-post-content-img-margin\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-post-content-title\":\"off\",\"lightbox-post-content-title-tag\":\"h2\",\"aj-source-order\":[\"post-content\"],\"ajax-container-id\":\"ess-grid-ajax-container-\",\"ajax-container-position\":\"top\",\"ajax-scroll-onload\":\"on\",\"ajax-scrollto-offset\":\"0\",\"ajax-close-button\":\"off\",\"ajax-button-text\":\"Close\",\"ajax-nav-button\":\"off\",\"ajax-button-skin\":\"light\",\"ajax-button-type\":\"type1\",\"ajax-button-inner\":\"false\",\"ajax-button-h-pos\":\"r\",\"ajax-button-v-pos\":\"t\",\"ajax-container-pre\":\"\",\"ajax-container-post\":\"\",\"ajax-container-css\":\"\",\"ajax-callback\":\"\",\"ajax-callback-arg\":\"false\",\"ajax-css-url\":\"\",\"ajax-js-url\":\"\",\"use-spinner\":\"0\",\"spinner-color\":\"#FFFFFF\",\"custom-javascript\":\"\",\"cookie-save-time\":\"30\",\"cookie-save-search\":\"off\",\"cookie-save-filter\":\"off\",\"cookie-save-pagination\":\"off\",\"pg\":\"false\",\"css-id\":\"\"}", "[\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"55\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/controle-delingue-mise-en-conformite\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"Stock disponible sur rayon pour un approvisionnement imm\\\\u00e9diat\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"19\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/controle-delingue-mise-en-conformite\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"Contr\\\\u00f4le d\\\\u2019\\\\u00e9lingue - Mise en conformit\\\\u00e9 \\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"57\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/controle-delingue-mise-en-conformite\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"Changement de c\\\\u00e2ble de d\\\\u00e9panneuse \\\\u00e0 la journ\\\\u00e9e\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"54\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/controle-delingue-mise-en-conformite\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"Produit sur-mesure qui r\\\\u00e9pondent \\\\u00e0 un cahier des charges bien pr\\\\u00e9cis\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\"]", "{\"bg\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/10\\/IMG_4913.jpg\"}", "2024-02-20 14:08:12");
INSERT INTO `wp_eg_grids` VALUES("4", "Elingues sur mesures", "grid-1", "{\"source-type\":\"custom\",\"post_types\":\"post\",\"post_category\":\"\",\"category-relation\":\"OR\",\"additional-query\":\"\",\"selected_pages\":\"\",\"max_entries\":\"-1\",\"max_entries_preview\":\"20\",\"media-source-order\":[\"featured-image\"],\"poster-source-order\":[\"featured-image\"],\"image-source-smart\":\"off\",\"image-source-type\":\"full\",\"image-source-type-mobile\":\"full\",\"default-image\":\"\",\"youtube-default-image\":\"\",\"vimeo-default-image\":\"\",\"html-default-image\":\"\",\"image-source-smart-size\":false}", "{\"layout-sizing\":\"boxed\",\"fullscreen-offset-container\":\"\",\"layout\":\"masonry\",\"content-push\":\"off\",\"x-ratio\":\"4\",\"y-ratio\":\"4\",\"auto-ratio\":\"false\",\"rtl\":\"off\",\"show-even-on-device\":\"0\",\"use-cobbles-pattern\":\"off\",\"videoplaybackingrid\":\"on\",\"videoloopingrid\":\"off\",\"videoplaybackonhover\":\"off\",\"videocontrolsinline\":\"off\",\"videomuteinline\":\"on\",\"keeplayersovermedia\":\"off\",\"columns-advanced\":\"off\",\"columns-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns-width\":[\"1900\",\"1400\",\"1170\",\"1024\",\"960\",\"778\",\"640\",\"480\"],\"mascontent-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns\":[\"3\",\"3\",\"3\",\"3\",\"3\",\"3\",\"3\",\"3\"],\"blank-item-breakpoint\":\"none\",\"rows-unlimited\":\"off\",\"rows\":\"1\",\"enable-rows-mobile\":\"off\",\"rows-mobile\":\"3\",\"pagination-autoplay\":\"off\",\"pagination-autoplay-speed\":\"5000\",\"pagination-touchswipe\":\"off\",\"pagination-dragvertical\":\"on\",\"pagination-swipebuffer\":\"30\",\"load-more\":\"none\",\"load-more-hide\":\"off\",\"load-more-text\":\"Load More\",\"load-more-error\":\"\",\"load-more-show-number\":\"on\",\"load-more-start\":\"3\",\"load-more-amount\":\"3\",\"lazy-loading\":\"off\",\"lazy-loading-blur\":\"on\",\"lazy-load-color\":\"#FFFFFF\",\"spacings\":\"20\",\"grid-padding\":[\"30\",\"30\",\"30\",\"30\"],\"main-background-color\":\"transparent\",\"navigation-skin\":\"minimal-light\",\"navigation-preview-bg\":\"dark\",\"0\":\"\",\"entry-skin\":\"1\",\"grid-start-animation\":\"reveal\",\"hide-markup-before-load\":\"on\",\"grid-start-animation-speed\":\"1000\",\"grid-start-animation-delay\":\"100\",\"grid-start-animation-type\":\"item\",\"start-anime-in-viewport\":\"off\",\"start-anime-viewport-buffer\":\"20\",\"grid-animation\":\"fade\",\"grid-animation-speed\":\"1000\",\"grid-animation-delay\":\"1\",\"grid-animation-type\":\"item\",\"grid-item-animation\":\"none\",\"grid-item-animation-zoomin\":\"125\",\"grid-item-animation-zoomout\":\"75\",\"grid-item-animation-fade\":\"75\",\"grid-item-animation-blur\":\"5\",\"grid-item-animation-rotate\":\"30\",\"grid-item-animation-shift\":\"up\",\"grid-item-animation-shift-amount\":\"10\",\"grid-item-animation-other\":\"none\",\"grid-item-other-zoomin\":\"125\",\"grid-item-other-zoomout\":\"75\",\"grid-item-other-fade\":\"75\",\"grid-item-other-blur\":\"5\",\"grid-item-other-rotate\":\"30\",\"grid-item-other-shift\":\"up\",\"grid-item-other-shift-amount\":\"10\",\"top-1-align\":\"center\",\"top-1-margin-bottom\":\"0\",\"top-2-align\":\"center\",\"top-2-margin-bottom\":\"0\",\"bottom-1-align\":\"center\",\"bottom-1-margin-top\":\"0\",\"bottom-2-align\":\"center\",\"bottom-2-margin-top\":\"0\",\"left-margin-left\":\"0\",\"right-margin-right\":\"0\",\"module-spacings\":\"5\",\"pagination-numbers\":\"smart\",\"pagination-scroll\":\"off\",\"pagination-scroll-offset\":\"0\",\"filter-arrows\":\"single\",\"filter-logic\":\"or\",\"add-filters-by\":\"default\",\"filter-start\":\"\",\"filter-deep-link\":\"off\",\"filter-show-on\":\"hover\",\"convert-mobile-filters\":\"off\",\"convert-mobile-filters-width\":\"768\",\"filter-all-visible\":\"on\",\"filter-all-text\":\"Filter - All\",\"filter-listing\":\"list\",\"filter-dropdown-text\":\"Filter Categories\",\"filter-counter\":\"off\",\"filter-sort-alpha\":\"off\",\"filter-sort-alpha-dir\":\"asc\",\"sort-by-text\":\"Sort By \",\"sorting-order-by\":\"date\",\"sorting-order-by-start\":\"none\",\"sorting-order-by-start-meta\":\"\",\"sorting-order-type\":\"ASC\",\"search-text\":\"Search...\",\"lb-source-order\":[\"featured-image\"],\"lightbox-mode\":\"single\",\"lightbox-exclude-media\":\"off\",\"lightbox-deep-link\":\"group\",\"lightbox-videoautoplay\":\"on\",\"lightbox-override-ui-colors\":\"off\",\"lightbox-overlay-bg-color\":\"rgba(30,30,30,0.9)\",\"lightbox-ui-bg-color\":\"#28303d\",\"lightbox-ui-color\":\"#ffffff\",\"lightbox-ui-hover-bg-color\":\"#000000\",\"lightbox-ui-hover-color\":\"#ffffff\",\"lightbox-ui-text-color\":\"#eeeeee\",\"lightbox-title-strip\":\"on\",\"lightbox-title-position\":\"bottom\",\"lightbox-title\":\"off\",\"lightbox-title-source\":\"title\",\"lightbox-description\":\"off\",\"lightbox-description-source\":\"description\",\"lbox-padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-effect-open-close\":\"fade\",\"lightbox-effect-open-close-speed\":\"500\",\"lightbox-effect-next-prev\":\"fade\",\"lightbox-effect-next-prev-speed\":\"500\",\"lightbox-autoplay\":\"off\",\"lbox-playspeed\":\"3000\",\"lightbox-arrows\":\"on\",\"lightbox-loop\":\"on\",\"lightbox-numbers\":\"on\",\"lightbox-mousewheel\":\"off\",\"lb-button-order\":[\"share\",\"thumbs\",\"close\"],\"lightbox-post-content-min-width\":\"75\",\"lightbox-post-content-min-perc\":\"on\",\"lightbox-post-content-max-width\":\"75\",\"lightbox-post-content-max-perc\":\"on\",\"lightbox-post-content-overflow\":\"on\",\"lbox-content_padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-post-spinner\":\"off\",\"lightbox-post-content-img\":\"off\",\"lightbox-post-content-img-position\":\"top\",\"lightbox-post-content-img-width\":\"50\",\"lightbox-post-content-img-margin\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-post-content-title\":\"off\",\"lightbox-post-content-title-tag\":\"h2\",\"aj-source-order\":[\"post-content\"],\"ajax-container-id\":\"ess-grid-ajax-container-\",\"ajax-container-position\":\"top\",\"ajax-scroll-onload\":\"on\",\"ajax-scrollto-offset\":\"0\",\"ajax-close-button\":\"off\",\"ajax-button-text\":\"Close\",\"ajax-nav-button\":\"off\",\"ajax-button-skin\":\"light\",\"ajax-button-type\":\"type1\",\"ajax-button-inner\":\"false\",\"ajax-button-h-pos\":\"r\",\"ajax-button-v-pos\":\"t\",\"ajax-container-pre\":\"\",\"ajax-container-post\":\"\",\"ajax-container-css\":\"\",\"ajax-callback\":\"\",\"ajax-callback-arg\":\"false\",\"ajax-css-url\":\"\",\"ajax-js-url\":\"\",\"use-spinner\":\"0\",\"spinner-color\":\"#FFFFFF\",\"custom-javascript\":\"\",\"cookie-save-time\":\"30\",\"cookie-save-search\":\"off\",\"cookie-save-filter\":\"off\",\"cookie-save-pagination\":\"off\",\"pg\":\"false\",\"css-id\":\"\",\"navigation-layout\":{\"left\":{\"left\":\"0\"},\"right\":{\"right\":\"0\"}}}", "[\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"92\\\",\\\"custom-soundcloud\\\":\\\"\\\",\\\"custom-youtube\\\":\\\"\\\",\\\"custom-vimeo\\\":\\\"\\\",\\\"custom-html5-mp4\\\":\\\"\\\",\\\"custom-html5-ogv\\\":\\\"\\\",\\\"custom-html5-webm\\\":\\\"\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\/\\/deblock.local\\/nos-produits\\/elingues-sur-mesure\\/elingues-chaines-sur-mesure\\/\\\",\\\"custom-filter\\\":\\\"\\\",\\\"custom-filter-list\\\":\\\"\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"Cha\\u00eenes\\\",\\\"cat_list\\\":\\\"\\\",\\\"tag_list\\\":\\\"\\\",\\\"excerpt\\\":\\\"\\\",\\\"meta\\\":\\\"\\\",\\\"num_comments\\\":\\\"\\\",\\\"date\\\":\\\"\\\",\\\"date_day\\\":\\\"\\\",\\\"date_month\\\":\\\"\\\",\\\"date_month_abbr\\\":\\\"\\\",\\\"date_month_name\\\":\\\"\\\",\\\"date_year\\\":\\\"\\\",\\\"date_year_abbr\\\":\\\"\\\",\\\"date_modified\\\":\\\"\\\",\\\"author_name\\\":\\\"\\\",\\\"author_profile\\\":\\\"\\\",\\\"author_posts\\\":\\\"\\\",\\\"author_avatar_32\\\":\\\"\\\",\\\"author_avatar_64\\\":\\\"\\\",\\\"author_avatar_96\\\":\\\"\\\",\\\"author_avatar_512\\\":\\\"\\\",\\\"post_id\\\":\\\"\\\",\\\"post_url\\\":\\\"\\\",\\\"content\\\":\\\"\\\",\\\"eg-alternate-image\\\":\\\"\\\",\\\"alias\\\":\\\"\\\",\\\"taxonomy\\\":\\\"\\\",\\\"caption\\\":\\\"\\\",\\\"description\\\":\\\"\\\",\\\"likespost\\\":\\\"\\\",\\\"likes\\\":\\\"\\\",\\\"likes_short\\\":\\\"\\\",\\\"dislikes\\\":\\\"\\\",\\\"dislikes_short\\\":\\\"\\\",\\\"favorites\\\":\\\"\\\",\\\"favorites_short\\\":\\\"\\\",\\\"retweets\\\":\\\"\\\",\\\"retweets_short\\\":\\\"\\\",\\\"views\\\":\\\"\\\",\\\"views_short\\\":\\\"\\\",\\\"itemCount\\\":\\\"\\\",\\\"channel_title\\\":\\\"\\\",\\\"duration\\\":\\\"\\\",\\\"iframe\\\":\\\"\\\",\\\"revslider\\\":\\\"\\\",\\\"essgrid\\\":\\\"\\\",\\\"wistia\\\":\\\"\\\",\\\"wc_full_price\\\":\\\"\\\",\\\"wc_price\\\":\\\"\\\",\\\"wc_price_no_cur\\\":\\\"\\\",\\\"wc_stock\\\":\\\"\\\",\\\"wc_rating\\\":\\\"\\\",\\\"wc_star_rating\\\":\\\"\\\",\\\"wc_categories\\\":\\\"\\\",\\\"wc_add_to_cart\\\":\\\"\\\",\\\"wc_add_to_cart_button\\\":\\\"\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"161\\\",\\\"custom-soundcloud\\\":\\\"\\\",\\\"custom-youtube\\\":\\\"\\\",\\\"custom-vimeo\\\":\\\"\\\",\\\"custom-html5-mp4\\\":\\\"\\\",\\\"custom-html5-ogv\\\":\\\"\\\",\\\"custom-html5-webm\\\":\\\"\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\/\\/deblock.local\\/nos-produits\\/elingues-sur-mesure\\/elingues-chaines-sur-mesure\\/\\\",\\\"custom-filter\\\":\\\"\\\",\\\"custom-filter-list\\\":\\\"\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"C\\u00e2bles\\\",\\\"cat_list\\\":\\\"\\\",\\\"tag_list\\\":\\\"\\\",\\\"excerpt\\\":\\\"\\\",\\\"meta\\\":\\\"\\\",\\\"num_comments\\\":\\\"\\\",\\\"date\\\":\\\"\\\",\\\"date_day\\\":\\\"\\\",\\\"date_month\\\":\\\"\\\",\\\"date_month_abbr\\\":\\\"\\\",\\\"date_month_name\\\":\\\"\\\",\\\"date_year\\\":\\\"\\\",\\\"date_year_abbr\\\":\\\"\\\",\\\"date_modified\\\":\\\"\\\",\\\"author_name\\\":\\\"\\\",\\\"author_profile\\\":\\\"\\\",\\\"author_posts\\\":\\\"\\\",\\\"author_avatar_32\\\":\\\"\\\",\\\"author_avatar_64\\\":\\\"\\\",\\\"author_avatar_96\\\":\\\"\\\",\\\"author_avatar_512\\\":\\\"\\\",\\\"post_id\\\":\\\"\\\",\\\"post_url\\\":\\\"\\\",\\\"content\\\":\\\"\\\",\\\"eg-alternate-image\\\":\\\"\\\",\\\"alias\\\":\\\"\\\",\\\"taxonomy\\\":\\\"\\\",\\\"caption\\\":\\\"\\\",\\\"description\\\":\\\"\\\",\\\"likespost\\\":\\\"\\\",\\\"likes\\\":\\\"\\\",\\\"likes_short\\\":\\\"\\\",\\\"dislikes\\\":\\\"\\\",\\\"dislikes_short\\\":\\\"\\\",\\\"favorites\\\":\\\"\\\",\\\"favorites_short\\\":\\\"\\\",\\\"retweets\\\":\\\"\\\",\\\"retweets_short\\\":\\\"\\\",\\\"views\\\":\\\"\\\",\\\"views_short\\\":\\\"\\\",\\\"itemCount\\\":\\\"\\\",\\\"channel_title\\\":\\\"\\\",\\\"duration\\\":\\\"\\\",\\\"iframe\\\":\\\"\\\",\\\"revslider\\\":\\\"\\\",\\\"essgrid\\\":\\\"\\\",\\\"wistia\\\":\\\"\\\",\\\"wc_full_price\\\":\\\"\\\",\\\"wc_price\\\":\\\"\\\",\\\"wc_price_no_cur\\\":\\\"\\\",\\\"wc_stock\\\":\\\"\\\",\\\"wc_rating\\\":\\\"\\\",\\\"wc_star_rating\\\":\\\"\\\",\\\"wc_categories\\\":\\\"\\\",\\\"wc_add_to_cart\\\":\\\"\\\",\\\"wc_add_to_cart_button\\\":\\\"\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"162\\\",\\\"custom-soundcloud\\\":\\\"\\\",\\\"custom-youtube\\\":\\\"\\\",\\\"custom-vimeo\\\":\\\"\\\",\\\"custom-html5-mp4\\\":\\\"\\\",\\\"custom-html5-ogv\\\":\\\"\\\",\\\"custom-html5-webm\\\":\\\"\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\/\\/deblock.local\\/nos-produits\\/elingues-sur-mesure\\/elingues-chaines-sur-mesure\\/\\\",\\\"custom-filter\\\":\\\"\\\",\\\"custom-filter-list\\\":\\\"\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"TEXTILE\\\",\\\"cat_list\\\":\\\"\\\",\\\"tag_list\\\":\\\"\\\",\\\"excerpt\\\":\\\"\\\",\\\"meta\\\":\\\"\\\",\\\"num_comments\\\":\\\"\\\",\\\"date\\\":\\\"\\\",\\\"date_day\\\":\\\"\\\",\\\"date_month\\\":\\\"\\\",\\\"date_month_abbr\\\":\\\"\\\",\\\"date_month_name\\\":\\\"\\\",\\\"date_year\\\":\\\"\\\",\\\"date_year_abbr\\\":\\\"\\\",\\\"date_modified\\\":\\\"\\\",\\\"author_name\\\":\\\"\\\",\\\"author_profile\\\":\\\"\\\",\\\"author_posts\\\":\\\"\\\",\\\"author_avatar_32\\\":\\\"\\\",\\\"author_avatar_64\\\":\\\"\\\",\\\"author_avatar_96\\\":\\\"\\\",\\\"author_avatar_512\\\":\\\"\\\",\\\"post_id\\\":\\\"\\\",\\\"post_url\\\":\\\"\\\",\\\"content\\\":\\\"\\\",\\\"eg-alternate-image\\\":\\\"\\\",\\\"alias\\\":\\\"\\\",\\\"taxonomy\\\":\\\"\\\",\\\"caption\\\":\\\"\\\",\\\"description\\\":\\\"\\\",\\\"likespost\\\":\\\"\\\",\\\"likes\\\":\\\"\\\",\\\"likes_short\\\":\\\"\\\",\\\"dislikes\\\":\\\"\\\",\\\"dislikes_short\\\":\\\"\\\",\\\"favorites\\\":\\\"\\\",\\\"favorites_short\\\":\\\"\\\",\\\"retweets\\\":\\\"\\\",\\\"retweets_short\\\":\\\"\\\",\\\"views\\\":\\\"\\\",\\\"views_short\\\":\\\"\\\",\\\"itemCount\\\":\\\"\\\",\\\"channel_title\\\":\\\"\\\",\\\"duration\\\":\\\"\\\",\\\"iframe\\\":\\\"\\\",\\\"revslider\\\":\\\"\\\",\\\"essgrid\\\":\\\"\\\",\\\"wistia\\\":\\\"\\\",\\\"wc_full_price\\\":\\\"\\\",\\\"wc_price\\\":\\\"\\\",\\\"wc_price_no_cur\\\":\\\"\\\",\\\"wc_stock\\\":\\\"\\\",\\\"wc_rating\\\":\\\"\\\",\\\"wc_star_rating\\\":\\\"\\\",\\\"wc_categories\\\":\\\"\\\",\\\"wc_add_to_cart\\\":\\\"\\\",\\\"wc_add_to_cart_button\\\":\\\"\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\"]", "{\"bg\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/11\\/8.jpg\"}", "2024-02-20 14:22:03");
INSERT INTO `wp_eg_grids` VALUES("5", "Métiers", "metiers", "{\"source-type\":\"custom\",\"post_types\":\"post\",\"post_category\":\"\",\"category-relation\":\"OR\",\"additional-query\":\"\",\"selected_pages\":\"\",\"max_entries\":\"-1\",\"max_entries_preview\":\"20\",\"media-source-order\":[\"featured-image\"],\"poster-source-order\":[\"featured-image\"],\"image-source-smart\":\"off\",\"image-source-type\":\"full\",\"image-source-type-mobile\":\"full\",\"default-image\":\"\",\"youtube-default-image\":\"\",\"vimeo-default-image\":\"\",\"html-default-image\":\"\",\"image-source-smart-size\":false}", "{\"layout-sizing\":\"fullwidth\",\"fullscreen-offset-container\":\"\",\"layout\":\"cobbles\",\"content-push\":\"off\",\"x-ratio\":\"4\",\"y-ratio\":\"3\",\"auto-ratio\":\"true\",\"rtl\":\"off\",\"show-even-on-device\":\"0\",\"use-cobbles-pattern\":\"off\",\"videoplaybackingrid\":\"on\",\"videoloopingrid\":\"off\",\"videoplaybackonhover\":\"off\",\"videocontrolsinline\":\"off\",\"videomuteinline\":\"on\",\"keeplayersovermedia\":\"off\",\"columns-advanced\":\"off\",\"columns-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns-width\":[\"1900\",\"1400\",\"1170\",\"1024\",\"960\",\"778\",\"640\",\"480\"],\"mascontent-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns\":[\"6\",\"6\",\"6\",\"6\",\"3\",\"3\",\"3\",\"3\"],\"blank-item-breakpoint\":\"none\",\"rows-unlimited\":\"off\",\"rows\":\"3\",\"enable-rows-mobile\":\"off\",\"rows-mobile\":\"3\",\"pagination-autoplay\":\"off\",\"pagination-autoplay-speed\":\"5000\",\"pagination-touchswipe\":\"off\",\"pagination-dragvertical\":\"on\",\"pagination-swipebuffer\":\"30\",\"load-more\":\"none\",\"load-more-hide\":\"off\",\"load-more-text\":\"Load More\",\"load-more-error\":\"\",\"load-more-show-number\":\"on\",\"load-more-start\":\"3\",\"load-more-amount\":\"3\",\"lazy-loading\":\"off\",\"lazy-loading-blur\":\"on\",\"lazy-load-color\":\"#FFFFFF\",\"spacings\":\"10\",\"grid-padding\":[\"10\",\"10\",\"10\",\"10\"],\"main-background-color\":\"transparent\",\"navigation-skin\":\"minimal-light\",\"navigation-preview-bg\":\"dark\",\"0\":\"\",\"entry-skin\":\"9\",\"grid-start-animation\":\"reveal\",\"hide-markup-before-load\":\"on\",\"grid-start-animation-speed\":\"1000\",\"grid-start-animation-delay\":\"100\",\"grid-start-animation-type\":\"item\",\"start-anime-in-viewport\":\"off\",\"start-anime-viewport-buffer\":\"20\",\"grid-animation\":\"fade\",\"grid-animation-speed\":\"1000\",\"grid-animation-delay\":\"1\",\"grid-animation-type\":\"item\",\"grid-item-animation\":\"none\",\"grid-item-animation-zoomin\":\"125\",\"grid-item-animation-zoomout\":\"75\",\"grid-item-animation-fade\":\"75\",\"grid-item-animation-blur\":\"5\",\"grid-item-animation-rotate\":\"30\",\"grid-item-animation-shift\":\"up\",\"grid-item-animation-shift-amount\":\"10\",\"grid-item-animation-other\":\"none\",\"grid-item-other-zoomin\":\"125\",\"grid-item-other-zoomout\":\"75\",\"grid-item-other-fade\":\"75\",\"grid-item-other-blur\":\"5\",\"grid-item-other-rotate\":\"30\",\"grid-item-other-shift\":\"up\",\"grid-item-other-shift-amount\":\"10\",\"top-1-align\":\"center\",\"top-1-margin-bottom\":\"0\",\"top-2-align\":\"center\",\"top-2-margin-bottom\":\"0\",\"bottom-1-align\":\"center\",\"bottom-1-margin-top\":\"0\",\"bottom-2-align\":\"center\",\"bottom-2-margin-top\":\"0\",\"left-margin-left\":\"0\",\"right-margin-right\":\"0\",\"module-spacings\":\"5\",\"pagination-numbers\":\"smart\",\"pagination-scroll\":\"off\",\"pagination-scroll-offset\":\"0\",\"filter-arrows\":\"single\",\"filter-logic\":\"or\",\"add-filters-by\":\"default\",\"filter-start\":\"\",\"filter-deep-link\":\"off\",\"filter-show-on\":\"hover\",\"convert-mobile-filters\":\"off\",\"convert-mobile-filters-width\":\"768\",\"filter-all-visible\":\"on\",\"filter-all-text\":\"Filter - All\",\"filter-listing\":\"list\",\"filter-dropdown-text\":\"Filter Categories\",\"filter-counter\":\"off\",\"filter-sort-alpha\":\"off\",\"filter-sort-alpha-dir\":\"asc\",\"sort-by-text\":\"Sort By \",\"sorting-order-by\":\"date\",\"sorting-order-by-start\":\"none\",\"sorting-order-by-start-meta\":\"\",\"sorting-order-type\":\"ASC\",\"search-text\":\"Search...\",\"lb-source-order\":[\"featured-image\"],\"lightbox-mode\":\"single\",\"lightbox-exclude-media\":\"off\",\"lightbox-deep-link\":\"group\",\"lightbox-videoautoplay\":\"on\",\"lightbox-override-ui-colors\":\"off\",\"lightbox-overlay-bg-color\":\"rgba(30,30,30,0.9)\",\"lightbox-ui-bg-color\":\"#28303d\",\"lightbox-ui-color\":\"#ffffff\",\"lightbox-ui-hover-bg-color\":\"#000000\",\"lightbox-ui-hover-color\":\"#ffffff\",\"lightbox-ui-text-color\":\"#eeeeee\",\"lightbox-title-strip\":\"on\",\"lightbox-title-position\":\"bottom\",\"lightbox-title\":\"off\",\"lightbox-title-source\":\"title\",\"lightbox-description\":\"off\",\"lightbox-description-source\":\"description\",\"lbox-padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-effect-open-close\":\"fade\",\"lightbox-effect-open-close-speed\":\"500\",\"lightbox-effect-next-prev\":\"fade\",\"lightbox-effect-next-prev-speed\":\"500\",\"lightbox-autoplay\":\"off\",\"lbox-playspeed\":\"3000\",\"lightbox-arrows\":\"on\",\"lightbox-loop\":\"on\",\"lightbox-numbers\":\"on\",\"lightbox-mousewheel\":\"off\",\"lb-button-order\":[\"share\",\"thumbs\",\"close\"],\"lightbox-post-content-min-width\":\"75\",\"lightbox-post-content-min-perc\":\"on\",\"lightbox-post-content-max-width\":\"75\",\"lightbox-post-content-max-perc\":\"on\",\"lightbox-post-content-overflow\":\"on\",\"lbox-content_padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-post-spinner\":\"off\",\"lightbox-post-content-img\":\"off\",\"lightbox-post-content-img-position\":\"top\",\"lightbox-post-content-img-width\":\"50\",\"lightbox-post-content-img-margin\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-post-content-title\":\"off\",\"lightbox-post-content-title-tag\":\"h2\",\"aj-source-order\":[\"post-content\"],\"ajax-container-id\":\"ess-grid-ajax-container-\",\"ajax-container-position\":\"top\",\"ajax-scroll-onload\":\"on\",\"ajax-scrollto-offset\":\"0\",\"ajax-close-button\":\"off\",\"ajax-button-text\":\"Close\",\"ajax-nav-button\":\"off\",\"ajax-button-skin\":\"light\",\"ajax-button-type\":\"type1\",\"ajax-button-inner\":\"false\",\"ajax-button-h-pos\":\"r\",\"ajax-button-v-pos\":\"t\",\"ajax-container-pre\":\"\",\"ajax-container-post\":\"\",\"ajax-container-css\":\"\",\"ajax-callback\":\"\",\"ajax-callback-arg\":\"false\",\"ajax-css-url\":\"\",\"ajax-js-url\":\"\",\"use-spinner\":\"0\",\"spinner-color\":\"#FFFFFF\",\"custom-javascript\":\"\",\"cookie-save-time\":\"30\",\"cookie-save-search\":\"off\",\"cookie-save-filter\":\"off\",\"cookie-save-pagination\":\"off\",\"pg\":\"false\",\"css-id\":\"\"}", "[\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"262\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/nos-services\\\\\\/forestier\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"Forestier \\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"266\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/nos-services\\\\\\/metallurgie-345\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"Chaudronnerie  \\\\\\/  M\\\\u00e9tallurgie \\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"264\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/nos-services\\\\\\/evenementiel\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"Ev\\\\u00e9nementiel \\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"265\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/transport\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"Transport \\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"263\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/nos-services\\\\\\/industrie-du-beton\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"Industrie du b\\\\u00e9ton \\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"261\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/nos-services\\\\\\/automobile\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"Automobile\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"260\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/nos-services\\\\\\/militaire\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"Arm\\\\u00e9e \\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"256\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/nos-services\\\\\\/aeronautique\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"A\\\\u00e9ronautique \\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"258\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/nos-services\\\\\\/agricole\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"Agricole \\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"257\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/nos-services\\\\\\/domaine-ferroviaire\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"Domaine ferroviaire \\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"255\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/nos-services\\\\\\/btp\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"BTP \\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"253\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/nos-services\\\\\\/parc-de-loisir\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"Parc de loisir \\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\"]", "{\"bg\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2024\\/02\\/geranimo-qzgN45hseN0-unsplash-scaled.jpg\"}", "2024-03-29 16:33:41");
INSERT INTO `wp_eg_grids` VALUES("6", "Elingues", "elingues", "{\"source-type\":\"post\",\"post_types\":\"product\",\"post_category\":\"product_cat_16\",\"category-relation\":\"OR\",\"additional-query\":\"\",\"selected_pages\":\"\",\"max_entries\":\"-1\",\"max_entries_preview\":\"20\",\"media-source-order\":[\"featured-image\"],\"poster-source-order\":[\"featured-image\"],\"image-source-smart\":\"off\",\"image-source-type\":\"full\",\"image-source-type-mobile\":\"full\",\"default-image\":\"\",\"youtube-default-image\":\"\",\"vimeo-default-image\":\"\",\"html-default-image\":\"\",\"image-source-smart-size\":false}", "{\"layout-sizing\":\"boxed\",\"fullscreen-offset-container\":\"\",\"layout\":\"masonry\",\"content-push\":\"off\",\"x-ratio\":\"4\",\"y-ratio\":\"4\",\"auto-ratio\":\"false\",\"rtl\":\"off\",\"show-even-on-device\":\"0\",\"use-cobbles-pattern\":\"off\",\"videoplaybackingrid\":\"on\",\"videoloopingrid\":\"off\",\"videoplaybackonhover\":\"off\",\"videocontrolsinline\":\"off\",\"videomuteinline\":\"on\",\"keeplayersovermedia\":\"off\",\"columns-advanced\":\"off\",\"columns-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns-width\":[\"1900\",\"1400\",\"1170\",\"1024\",\"960\",\"778\",\"640\",\"480\"],\"mascontent-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns\":[\"4\",\"4\",\"4\",\"4\",\"4\",\"4\",\"4\",\"3\"],\"blank-item-breakpoint\":\"none\",\"rows-unlimited\":\"off\",\"rows\":\"1\",\"enable-rows-mobile\":\"off\",\"rows-mobile\":\"3\",\"pagination-autoplay\":\"off\",\"pagination-autoplay-speed\":\"5000\",\"pagination-touchswipe\":\"off\",\"pagination-dragvertical\":\"on\",\"pagination-swipebuffer\":\"30\",\"load-more\":\"none\",\"load-more-hide\":\"off\",\"load-more-text\":\"Load More\",\"load-more-error\":\"\",\"load-more-show-number\":\"on\",\"load-more-start\":\"3\",\"load-more-amount\":\"3\",\"lazy-loading\":\"off\",\"lazy-loading-blur\":\"on\",\"lazy-load-color\":\"#FFFFFF\",\"spacings\":\"20\",\"grid-padding\":[\"30\",\"30\",\"30\",\"30\"],\"main-background-color\":\"transparent\",\"navigation-skin\":\"minimal-light\",\"navigation-preview-bg\":\"dark\",\"0\":\"\",\"entry-skin\":\"1\",\"grid-start-animation\":\"reveal\",\"hide-markup-before-load\":\"on\",\"grid-start-animation-speed\":\"1000\",\"grid-start-animation-delay\":\"100\",\"grid-start-animation-type\":\"item\",\"start-anime-in-viewport\":\"off\",\"start-anime-viewport-buffer\":\"20\",\"grid-animation\":\"fade\",\"grid-animation-speed\":\"1000\",\"grid-animation-delay\":\"1\",\"grid-animation-type\":\"item\",\"grid-item-animation\":\"none\",\"grid-item-animation-zoomin\":\"125\",\"grid-item-animation-zoomout\":\"75\",\"grid-item-animation-fade\":\"75\",\"grid-item-animation-blur\":\"5\",\"grid-item-animation-rotate\":\"30\",\"grid-item-animation-shift\":\"up\",\"grid-item-animation-shift-amount\":\"10\",\"grid-item-animation-other\":\"none\",\"grid-item-other-zoomin\":\"125\",\"grid-item-other-zoomout\":\"75\",\"grid-item-other-fade\":\"75\",\"grid-item-other-blur\":\"5\",\"grid-item-other-rotate\":\"30\",\"grid-item-other-shift\":\"up\",\"grid-item-other-shift-amount\":\"10\",\"top-1-align\":\"center\",\"top-1-margin-bottom\":\"0\",\"top-2-align\":\"center\",\"top-2-margin-bottom\":\"0\",\"bottom-1-align\":\"center\",\"bottom-1-margin-top\":\"0\",\"bottom-2-align\":\"center\",\"bottom-2-margin-top\":\"0\",\"left-margin-left\":\"0\",\"right-margin-right\":\"0\",\"module-spacings\":\"5\",\"pagination-numbers\":\"smart\",\"pagination-scroll\":\"off\",\"pagination-scroll-offset\":\"0\",\"filter-arrows\":\"single\",\"filter-logic\":\"or\",\"add-filters-by\":\"default\",\"filter-start\":\"\",\"filter-deep-link\":\"off\",\"filter-show-on\":\"hover\",\"convert-mobile-filters\":\"off\",\"convert-mobile-filters-width\":\"768\",\"filter-all-visible\":\"on\",\"filter-all-text\":\"Filter - All\",\"filter-listing\":\"list\",\"filter-dropdown-text\":\"Filter Categories\",\"filter-counter\":\"off\",\"filter-sort-alpha\":\"off\",\"filter-sort-alpha-dir\":\"asc\",\"filter-selected\":[\"product_cat_16\"],\"sort-by-text\":\"Sort By \",\"sorting-order-by\":\"meta__sku\",\"sorting-order-by-start\":\"none\",\"sorting-order-by-start-meta\":\"\",\"sorting-order-type\":\"ASC\",\"search-text\":\"Search...\",\"lb-source-order\":[\"featured-image\"],\"lightbox-mode\":\"single\",\"lightbox-exclude-media\":\"off\",\"lightbox-deep-link\":\"group\",\"lightbox-videoautoplay\":\"on\",\"lightbox-override-ui-colors\":\"off\",\"lightbox-overlay-bg-color\":\"rgba(30,30,30,0.9)\",\"lightbox-ui-bg-color\":\"#28303d\",\"lightbox-ui-color\":\"#ffffff\",\"lightbox-ui-hover-bg-color\":\"#000000\",\"lightbox-ui-hover-color\":\"#ffffff\",\"lightbox-ui-text-color\":\"#eeeeee\",\"lightbox-title-strip\":\"on\",\"lightbox-title-position\":\"bottom\",\"lightbox-title\":\"off\",\"lightbox-title-source\":\"title\",\"lightbox-description\":\"off\",\"lightbox-description-source\":\"description\",\"lbox-padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-effect-open-close\":\"fade\",\"lightbox-effect-open-close-speed\":\"500\",\"lightbox-effect-next-prev\":\"fade\",\"lightbox-effect-next-prev-speed\":\"500\",\"lightbox-autoplay\":\"off\",\"lbox-playspeed\":\"3000\",\"lightbox-arrows\":\"on\",\"lightbox-loop\":\"on\",\"lightbox-numbers\":\"on\",\"lightbox-mousewheel\":\"off\",\"lb-button-order\":[\"share\",\"thumbs\",\"close\"],\"lightbox-post-content-min-width\":\"75\",\"lightbox-post-content-min-perc\":\"on\",\"lightbox-post-content-max-width\":\"75\",\"lightbox-post-content-max-perc\":\"on\",\"lightbox-post-content-overflow\":\"on\",\"lbox-content_padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-post-spinner\":\"off\",\"lightbox-post-content-img\":\"off\",\"lightbox-post-content-img-position\":\"top\",\"lightbox-post-content-img-width\":\"50\",\"lightbox-post-content-img-margin\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-post-content-title\":\"off\",\"lightbox-post-content-title-tag\":\"h2\",\"aj-source-order\":[\"post-content\"],\"ajax-container-id\":\"ess-grid-ajax-container-\",\"ajax-container-position\":\"top\",\"ajax-scroll-onload\":\"on\",\"ajax-scrollto-offset\":\"0\",\"ajax-close-button\":\"off\",\"ajax-button-text\":\"Close\",\"ajax-nav-button\":\"off\",\"ajax-button-skin\":\"light\",\"ajax-button-type\":\"type1\",\"ajax-button-inner\":\"false\",\"ajax-button-h-pos\":\"r\",\"ajax-button-v-pos\":\"t\",\"ajax-container-pre\":\"\",\"ajax-container-post\":\"\",\"ajax-container-css\":\"\",\"ajax-callback\":\"\",\"ajax-callback-arg\":\"false\",\"ajax-css-url\":\"\",\"ajax-js-url\":\"\",\"use-spinner\":\"0\",\"spinner-color\":\"#FFFFFF\",\"custom-javascript\":\"\",\"cookie-save-time\":\"30\",\"cookie-save-search\":\"off\",\"cookie-save-filter\":\"off\",\"cookie-save-pagination\":\"off\",\"pg\":\"false\",\"css-id\":\"\",\"navigation-layout\":{\"left\":{\"left\":\"0\"},\"right\":{\"right\":\"0\"}}}", "[]", "{\"bg\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2024\\/02\\/eling1_05.jpg\"}", "2024-02-20 14:18:15");
INSERT INTO `wp_eg_grids` VALUES("7", "Structures", "structures", "{\"source-type\":\"custom\",\"post_types\":\"post\",\"post_category\":\"\",\"category-relation\":\"OR\",\"additional-query\":\"\",\"selected_pages\":\"\",\"max_entries\":\"-1\",\"max_entries_preview\":\"20\",\"media-source-order\":[\"featured-image\"],\"poster-source-order\":[\"featured-image\"],\"image-source-smart\":\"off\",\"image-source-type\":\"full\",\"image-source-type-mobile\":\"full\",\"default-image\":\"\",\"youtube-default-image\":\"\",\"vimeo-default-image\":\"\",\"html-default-image\":\"\",\"image-source-smart-size\":false}", "{\"layout-sizing\":\"boxed\",\"fullscreen-offset-container\":\"\",\"layout\":\"even\",\"content-push\":\"off\",\"x-ratio\":\"4\",\"y-ratio\":\"3\",\"auto-ratio\":\"true\",\"rtl\":\"off\",\"show-even-on-device\":\"0\",\"use-cobbles-pattern\":\"off\",\"videoplaybackingrid\":\"on\",\"videoloopingrid\":\"off\",\"videoplaybackonhover\":\"off\",\"videocontrolsinline\":\"off\",\"videomuteinline\":\"on\",\"keeplayersovermedia\":\"off\",\"columns-advanced\":\"off\",\"columns-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns-width\":[\"1900\",\"1400\",\"1170\",\"1024\",\"960\",\"778\",\"640\",\"480\"],\"mascontent-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns\":[\"4\",\"4\",\"4\",\"4\",\"4\",\"4\",\"4\",\"2\"],\"blank-item-breakpoint\":\"none\",\"rows-unlimited\":\"off\",\"rows\":\"3\",\"enable-rows-mobile\":\"off\",\"rows-mobile\":\"3\",\"pagination-autoplay\":\"off\",\"pagination-autoplay-speed\":\"5000\",\"pagination-touchswipe\":\"off\",\"pagination-dragvertical\":\"on\",\"pagination-swipebuffer\":\"30\",\"load-more\":\"none\",\"load-more-hide\":\"off\",\"load-more-text\":\"Load More\",\"load-more-error\":\"\",\"load-more-show-number\":\"on\",\"load-more-start\":\"3\",\"load-more-amount\":\"3\",\"lazy-loading\":\"off\",\"lazy-loading-blur\":\"on\",\"lazy-load-color\":\"#FFFFFF\",\"spacings\":\"20\",\"grid-padding\":[\"20\",\"20\",\"20\",\"20\"],\"main-background-color\":\"transparent\",\"navigation-skin\":\"minimal-light\",\"navigation-preview-bg\":\"dark\",\"0\":\"\",\"entry-skin\":\"1\",\"grid-start-animation\":\"reveal\",\"hide-markup-before-load\":\"on\",\"grid-start-animation-speed\":\"1000\",\"grid-start-animation-delay\":\"100\",\"grid-start-animation-type\":\"item\",\"start-anime-in-viewport\":\"off\",\"start-anime-viewport-buffer\":\"20\",\"grid-animation\":\"fade\",\"grid-animation-speed\":\"1000\",\"grid-animation-delay\":\"1\",\"grid-animation-type\":\"item\",\"grid-item-animation\":\"none\",\"grid-item-animation-zoomin\":\"125\",\"grid-item-animation-zoomout\":\"75\",\"grid-item-animation-fade\":\"75\",\"grid-item-animation-blur\":\"5\",\"grid-item-animation-rotate\":\"30\",\"grid-item-animation-shift\":\"up\",\"grid-item-animation-shift-amount\":\"10\",\"grid-item-animation-other\":\"none\",\"grid-item-other-zoomin\":\"125\",\"grid-item-other-zoomout\":\"75\",\"grid-item-other-fade\":\"75\",\"grid-item-other-blur\":\"5\",\"grid-item-other-rotate\":\"30\",\"grid-item-other-shift\":\"up\",\"grid-item-other-shift-amount\":\"10\",\"top-1-align\":\"center\",\"top-1-margin-bottom\":\"0\",\"top-2-align\":\"center\",\"top-2-margin-bottom\":\"0\",\"bottom-1-align\":\"center\",\"bottom-1-margin-top\":\"0\",\"bottom-2-align\":\"center\",\"bottom-2-margin-top\":\"0\",\"left-margin-left\":\"0\",\"right-margin-right\":\"0\",\"module-spacings\":\"5\",\"pagination-numbers\":\"smart\",\"pagination-scroll\":\"off\",\"pagination-scroll-offset\":\"0\",\"filter-arrows\":\"single\",\"filter-logic\":\"or\",\"add-filters-by\":\"default\",\"filter-start\":\"\",\"filter-deep-link\":\"off\",\"filter-show-on\":\"hover\",\"convert-mobile-filters\":\"off\",\"convert-mobile-filters-width\":\"768\",\"filter-all-visible\":\"on\",\"filter-all-text\":\"Filter - All\",\"filter-listing\":\"list\",\"filter-dropdown-text\":\"Filter Categories\",\"filter-counter\":\"off\",\"filter-sort-alpha\":\"off\",\"filter-sort-alpha-dir\":\"asc\",\"sort-by-text\":\"Sort By \",\"sorting-order-by\":\"date\",\"sorting-order-by-start\":\"none\",\"sorting-order-by-start-meta\":\"\",\"sorting-order-type\":\"ASC\",\"search-text\":\"Search...\",\"lb-source-order\":[\"featured-image\"],\"lightbox-mode\":\"single\",\"lightbox-exclude-media\":\"off\",\"lightbox-deep-link\":\"group\",\"lightbox-videoautoplay\":\"on\",\"lightbox-override-ui-colors\":\"off\",\"lightbox-overlay-bg-color\":\"rgba(30,30,30,0.9)\",\"lightbox-ui-bg-color\":\"#28303d\",\"lightbox-ui-color\":\"#ffffff\",\"lightbox-ui-hover-bg-color\":\"#000000\",\"lightbox-ui-hover-color\":\"#ffffff\",\"lightbox-ui-text-color\":\"#eeeeee\",\"lightbox-title-strip\":\"on\",\"lightbox-title-position\":\"bottom\",\"lightbox-title\":\"off\",\"lightbox-title-source\":\"title\",\"lightbox-description\":\"off\",\"lightbox-description-source\":\"description\",\"lbox-padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-effect-open-close\":\"fade\",\"lightbox-effect-open-close-speed\":\"500\",\"lightbox-effect-next-prev\":\"fade\",\"lightbox-effect-next-prev-speed\":\"500\",\"lightbox-autoplay\":\"off\",\"lbox-playspeed\":\"3000\",\"lightbox-arrows\":\"on\",\"lightbox-loop\":\"on\",\"lightbox-numbers\":\"on\",\"lightbox-mousewheel\":\"off\",\"lb-button-order\":[\"share\",\"thumbs\",\"close\"],\"lightbox-post-content-min-width\":\"75\",\"lightbox-post-content-min-perc\":\"on\",\"lightbox-post-content-max-width\":\"75\",\"lightbox-post-content-max-perc\":\"on\",\"lightbox-post-content-overflow\":\"on\",\"lbox-content_padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-post-spinner\":\"off\",\"lightbox-post-content-img\":\"off\",\"lightbox-post-content-img-position\":\"top\",\"lightbox-post-content-img-width\":\"50\",\"lightbox-post-content-img-margin\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-post-content-title\":\"off\",\"lightbox-post-content-title-tag\":\"h2\",\"aj-source-order\":[\"post-content\"],\"ajax-container-id\":\"ess-grid-ajax-container-\",\"ajax-container-position\":\"top\",\"ajax-scroll-onload\":\"on\",\"ajax-scrollto-offset\":\"0\",\"ajax-close-button\":\"off\",\"ajax-button-text\":\"Close\",\"ajax-nav-button\":\"off\",\"ajax-button-skin\":\"light\",\"ajax-button-type\":\"type1\",\"ajax-button-inner\":\"false\",\"ajax-button-h-pos\":\"r\",\"ajax-button-v-pos\":\"t\",\"ajax-container-pre\":\"\",\"ajax-container-post\":\"\",\"ajax-container-css\":\"\",\"ajax-callback\":\"\",\"ajax-callback-arg\":\"false\",\"ajax-css-url\":\"\",\"ajax-js-url\":\"\",\"use-spinner\":\"0\",\"spinner-color\":\"#FFFFFF\",\"custom-javascript\":\"\",\"cookie-save-time\":\"30\",\"cookie-save-search\":\"off\",\"cookie-save-filter\":\"off\",\"cookie-save-pagination\":\"off\",\"pg\":\"false\",\"css-id\":\"\"}", "[\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"272\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/product\\\\\\/potence-fixe-pour-charriot-elevateur\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"potence fixe\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"276\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/product\\\\\\/ce-de-levage\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"c\\\\u00e9 de levage\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"290\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/product\\\\\\/palonnier-en-h-fixe\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"palonnier\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\"]", "{\"bg\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2024\\/02\\/potence-fixe-pour-chariot-elevateur.png\"}", "2024-02-20 16:18:32");
INSERT INTO `wp_eg_grids` VALUES("8", "EPI Securité", "epi", "{\"source-type\":\"custom\",\"post_types\":\"product\",\"post_category\":\"product_cat_36\",\"category-relation\":\"OR\",\"additional-query\":\"\",\"selected_pages\":\"\",\"max_entries\":\"-1\",\"max_entries_preview\":\"20\",\"media-source-order\":[\"featured-image\"],\"poster-source-order\":[\"featured-image\"],\"image-source-smart\":\"off\",\"image-source-type\":\"full\",\"image-source-type-mobile\":\"full\",\"default-image\":\"\",\"youtube-default-image\":\"\",\"vimeo-default-image\":\"\",\"html-default-image\":\"\",\"image-source-smart-size\":false}", "{\"layout-sizing\":\"boxed\",\"fullscreen-offset-container\":\"\",\"layout\":\"even\",\"content-push\":\"off\",\"x-ratio\":\"4\",\"y-ratio\":\"3\",\"auto-ratio\":\"true\",\"rtl\":\"off\",\"show-even-on-device\":\"0\",\"use-cobbles-pattern\":\"off\",\"videoplaybackingrid\":\"on\",\"videoloopingrid\":\"off\",\"videoplaybackonhover\":\"off\",\"videocontrolsinline\":\"off\",\"videomuteinline\":\"on\",\"keeplayersovermedia\":\"off\",\"columns-advanced\":\"off\",\"columns-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns-width\":[\"1900\",\"1400\",\"1170\",\"1024\",\"960\",\"778\",\"640\",\"480\"],\"mascontent-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns\":[\"4\",\"4\",\"4\",\"4\",\"4\",\"4\",\"2\",\"2\"],\"blank-item-breakpoint\":\"none\",\"rows-unlimited\":\"off\",\"rows\":\"3\",\"enable-rows-mobile\":\"off\",\"rows-mobile\":\"3\",\"pagination-autoplay\":\"off\",\"pagination-autoplay-speed\":\"5000\",\"pagination-touchswipe\":\"off\",\"pagination-dragvertical\":\"on\",\"pagination-swipebuffer\":\"30\",\"load-more\":\"none\",\"load-more-hide\":\"off\",\"load-more-text\":\"Load More\",\"load-more-error\":\"\",\"load-more-show-number\":\"on\",\"load-more-start\":\"3\",\"load-more-amount\":\"3\",\"lazy-loading\":\"off\",\"lazy-loading-blur\":\"on\",\"lazy-load-color\":\"#FFFFFF\",\"spacings\":\"20\",\"grid-padding\":[\"20\",\"20\",\"20\",\"20\"],\"main-background-color\":\"transparent\",\"navigation-skin\":\"minimal-light\",\"navigation-preview-bg\":\"dark\",\"0\":\"\",\"entry-skin\":\"1\",\"grid-start-animation\":\"reveal\",\"hide-markup-before-load\":\"on\",\"grid-start-animation-speed\":\"1000\",\"grid-start-animation-delay\":\"100\",\"grid-start-animation-type\":\"item\",\"start-anime-in-viewport\":\"off\",\"start-anime-viewport-buffer\":\"20\",\"grid-animation\":\"fade\",\"grid-animation-speed\":\"1000\",\"grid-animation-delay\":\"1\",\"grid-animation-type\":\"item\",\"grid-item-animation\":\"none\",\"grid-item-animation-zoomin\":\"125\",\"grid-item-animation-zoomout\":\"75\",\"grid-item-animation-fade\":\"75\",\"grid-item-animation-blur\":\"5\",\"grid-item-animation-rotate\":\"30\",\"grid-item-animation-shift\":\"up\",\"grid-item-animation-shift-amount\":\"10\",\"grid-item-animation-other\":\"none\",\"grid-item-other-zoomin\":\"125\",\"grid-item-other-zoomout\":\"75\",\"grid-item-other-fade\":\"75\",\"grid-item-other-blur\":\"5\",\"grid-item-other-rotate\":\"30\",\"grid-item-other-shift\":\"up\",\"grid-item-other-shift-amount\":\"10\",\"top-1-align\":\"center\",\"top-1-margin-bottom\":\"0\",\"top-2-align\":\"center\",\"top-2-margin-bottom\":\"0\",\"bottom-1-align\":\"center\",\"bottom-1-margin-top\":\"0\",\"bottom-2-align\":\"center\",\"bottom-2-margin-top\":\"0\",\"left-margin-left\":\"0\",\"right-margin-right\":\"0\",\"module-spacings\":\"5\",\"pagination-numbers\":\"smart\",\"pagination-scroll\":\"off\",\"pagination-scroll-offset\":\"0\",\"filter-arrows\":\"single\",\"filter-logic\":\"or\",\"add-filters-by\":\"default\",\"filter-start\":\"\",\"filter-deep-link\":\"off\",\"filter-show-on\":\"hover\",\"convert-mobile-filters\":\"off\",\"convert-mobile-filters-width\":\"768\",\"filter-all-visible\":\"on\",\"filter-all-text\":\"Filter - All\",\"filter-listing\":\"list\",\"filter-dropdown-text\":\"Filter Categories\",\"filter-counter\":\"off\",\"filter-sort-alpha\":\"off\",\"filter-sort-alpha-dir\":\"asc\",\"sort-by-text\":\"Sort By \",\"sorting-order-by\":\"date\",\"sorting-order-by-start\":\"none\",\"sorting-order-by-start-meta\":\"\",\"sorting-order-type\":\"ASC\",\"search-text\":\"Search...\",\"lb-source-order\":[\"featured-image\"],\"lightbox-mode\":\"single\",\"lightbox-exclude-media\":\"off\",\"lightbox-deep-link\":\"group\",\"lightbox-videoautoplay\":\"on\",\"lightbox-override-ui-colors\":\"off\",\"lightbox-overlay-bg-color\":\"rgba(30,30,30,0.9)\",\"lightbox-ui-bg-color\":\"#28303d\",\"lightbox-ui-color\":\"#ffffff\",\"lightbox-ui-hover-bg-color\":\"#000000\",\"lightbox-ui-hover-color\":\"#ffffff\",\"lightbox-ui-text-color\":\"#eeeeee\",\"lightbox-title-strip\":\"on\",\"lightbox-title-position\":\"bottom\",\"lightbox-title\":\"off\",\"lightbox-title-source\":\"title\",\"lightbox-description\":\"off\",\"lightbox-description-source\":\"description\",\"lbox-padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-effect-open-close\":\"fade\",\"lightbox-effect-open-close-speed\":\"500\",\"lightbox-effect-next-prev\":\"fade\",\"lightbox-effect-next-prev-speed\":\"500\",\"lightbox-autoplay\":\"off\",\"lbox-playspeed\":\"3000\",\"lightbox-arrows\":\"on\",\"lightbox-loop\":\"on\",\"lightbox-numbers\":\"on\",\"lightbox-mousewheel\":\"off\",\"lb-button-order\":[\"share\",\"thumbs\",\"close\"],\"lightbox-post-content-min-width\":\"75\",\"lightbox-post-content-min-perc\":\"on\",\"lightbox-post-content-max-width\":\"75\",\"lightbox-post-content-max-perc\":\"on\",\"lightbox-post-content-overflow\":\"on\",\"lbox-content_padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-post-spinner\":\"off\",\"lightbox-post-content-img\":\"off\",\"lightbox-post-content-img-position\":\"top\",\"lightbox-post-content-img-width\":\"50\",\"lightbox-post-content-img-margin\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-post-content-title\":\"off\",\"lightbox-post-content-title-tag\":\"h2\",\"aj-source-order\":[\"post-content\"],\"ajax-container-id\":\"ess-grid-ajax-container-\",\"ajax-container-position\":\"top\",\"ajax-scroll-onload\":\"on\",\"ajax-scrollto-offset\":\"0\",\"ajax-close-button\":\"off\",\"ajax-button-text\":\"Close\",\"ajax-nav-button\":\"off\",\"ajax-button-skin\":\"light\",\"ajax-button-type\":\"type1\",\"ajax-button-inner\":\"false\",\"ajax-button-h-pos\":\"r\",\"ajax-button-v-pos\":\"t\",\"ajax-container-pre\":\"\",\"ajax-container-post\":\"\",\"ajax-container-css\":\"\",\"ajax-callback\":\"\",\"ajax-callback-arg\":\"false\",\"ajax-css-url\":\"\",\"ajax-js-url\":\"\",\"use-spinner\":\"0\",\"spinner-color\":\"#FFFFFF\",\"custom-javascript\":\"\",\"cookie-save-time\":\"30\",\"cookie-save-search\":\"off\",\"cookie-save-filter\":\"off\",\"cookie-save-pagination\":\"off\",\"pg\":\"false\",\"css-id\":\"\"}", "[\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"301\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/product\\\\\\/harnais-gamme-expert-ht-45\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"harnais\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"305\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/product\\\\\\/longe-double-dassujettissement-sans-absorbeur-150-kg\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"longe\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"307\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/product\\\\\\/casque\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"casques\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"312\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/product\\\\\\/antichute-stopforksp-150kg\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"antichute - ligne de vie\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\"]", "{\"bg\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2024\\/02\\/harnais-gamme-expert-ht-45.png\"}", "2024-02-20 16:35:05");
INSERT INTO `wp_eg_grids` VALUES("9", "Cordage tresse sandow", "coradage", "{\"source-type\":\"custom\",\"post_types\":\"post\",\"post_category\":\"\",\"category-relation\":\"OR\",\"additional-query\":\"\",\"selected_pages\":\"\",\"max_entries\":\"-1\",\"max_entries_preview\":\"20\",\"media-source-order\":[\"featured-image\"],\"poster-source-order\":[\"featured-image\"],\"image-source-smart\":\"off\",\"image-source-type\":\"full\",\"image-source-type-mobile\":\"full\",\"default-image\":\"\",\"youtube-default-image\":\"\",\"vimeo-default-image\":\"\",\"html-default-image\":\"\",\"image-source-smart-size\":false}", "{\"layout-sizing\":\"boxed\",\"fullscreen-offset-container\":\"\",\"layout\":\"even\",\"content-push\":\"off\",\"x-ratio\":\"4\",\"y-ratio\":\"3\",\"auto-ratio\":\"true\",\"rtl\":\"off\",\"show-even-on-device\":\"0\",\"use-cobbles-pattern\":\"off\",\"videoplaybackingrid\":\"on\",\"videoloopingrid\":\"off\",\"videoplaybackonhover\":\"off\",\"videocontrolsinline\":\"off\",\"videomuteinline\":\"on\",\"keeplayersovermedia\":\"off\",\"columns-advanced\":\"off\",\"columns-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns-width\":[\"1900\",\"1400\",\"1170\",\"1024\",\"960\",\"778\",\"640\",\"480\"],\"mascontent-height\":[\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\",\"0\"],\"columns\":[\"4\",\"4\",\"4\",\"4\",\"4\",\"4\",\"2\",\"2\"],\"blank-item-breakpoint\":\"none\",\"rows-unlimited\":\"off\",\"rows\":\"3\",\"enable-rows-mobile\":\"off\",\"rows-mobile\":\"3\",\"pagination-autoplay\":\"off\",\"pagination-autoplay-speed\":\"5000\",\"pagination-touchswipe\":\"off\",\"pagination-dragvertical\":\"on\",\"pagination-swipebuffer\":\"30\",\"load-more\":\"none\",\"load-more-hide\":\"off\",\"load-more-text\":\"Load More\",\"load-more-error\":\"\",\"load-more-show-number\":\"on\",\"load-more-start\":\"3\",\"load-more-amount\":\"3\",\"lazy-loading\":\"off\",\"lazy-loading-blur\":\"on\",\"lazy-load-color\":\"#FFFFFF\",\"spacings\":\"20\",\"grid-padding\":[\"20\",\"20\",\"20\",\"20\"],\"main-background-color\":\"transparent\",\"navigation-skin\":\"minimal-light\",\"navigation-preview-bg\":\"dark\",\"0\":\"\",\"entry-skin\":\"1\",\"grid-start-animation\":\"reveal\",\"hide-markup-before-load\":\"on\",\"grid-start-animation-speed\":\"1000\",\"grid-start-animation-delay\":\"100\",\"grid-start-animation-type\":\"item\",\"start-anime-in-viewport\":\"off\",\"start-anime-viewport-buffer\":\"20\",\"grid-animation\":\"fade\",\"grid-animation-speed\":\"1000\",\"grid-animation-delay\":\"1\",\"grid-animation-type\":\"item\",\"grid-item-animation\":\"none\",\"grid-item-animation-zoomin\":\"125\",\"grid-item-animation-zoomout\":\"75\",\"grid-item-animation-fade\":\"75\",\"grid-item-animation-blur\":\"5\",\"grid-item-animation-rotate\":\"30\",\"grid-item-animation-shift\":\"up\",\"grid-item-animation-shift-amount\":\"10\",\"grid-item-animation-other\":\"none\",\"grid-item-other-zoomin\":\"125\",\"grid-item-other-zoomout\":\"75\",\"grid-item-other-fade\":\"75\",\"grid-item-other-blur\":\"5\",\"grid-item-other-rotate\":\"30\",\"grid-item-other-shift\":\"up\",\"grid-item-other-shift-amount\":\"10\",\"top-1-align\":\"center\",\"top-1-margin-bottom\":\"0\",\"top-2-align\":\"center\",\"top-2-margin-bottom\":\"0\",\"bottom-1-align\":\"center\",\"bottom-1-margin-top\":\"0\",\"bottom-2-align\":\"center\",\"bottom-2-margin-top\":\"0\",\"left-margin-left\":\"0\",\"right-margin-right\":\"0\",\"module-spacings\":\"5\",\"pagination-numbers\":\"smart\",\"pagination-scroll\":\"off\",\"pagination-scroll-offset\":\"0\",\"filter-arrows\":\"single\",\"filter-logic\":\"or\",\"add-filters-by\":\"default\",\"filter-start\":\"\",\"filter-deep-link\":\"off\",\"filter-show-on\":\"hover\",\"convert-mobile-filters\":\"off\",\"convert-mobile-filters-width\":\"768\",\"filter-all-visible\":\"on\",\"filter-all-text\":\"Filter - All\",\"filter-listing\":\"list\",\"filter-dropdown-text\":\"Filter Categories\",\"filter-counter\":\"off\",\"filter-sort-alpha\":\"off\",\"filter-sort-alpha-dir\":\"asc\",\"sort-by-text\":\"Sort By \",\"sorting-order-by\":\"date\",\"sorting-order-by-start\":\"none\",\"sorting-order-by-start-meta\":\"\",\"sorting-order-type\":\"ASC\",\"search-text\":\"Search...\",\"lb-source-order\":[\"featured-image\"],\"lightbox-mode\":\"single\",\"lightbox-exclude-media\":\"off\",\"lightbox-deep-link\":\"group\",\"lightbox-videoautoplay\":\"on\",\"lightbox-override-ui-colors\":\"off\",\"lightbox-overlay-bg-color\":\"rgba(30,30,30,0.9)\",\"lightbox-ui-bg-color\":\"#28303d\",\"lightbox-ui-color\":\"#ffffff\",\"lightbox-ui-hover-bg-color\":\"#000000\",\"lightbox-ui-hover-color\":\"#ffffff\",\"lightbox-ui-text-color\":\"#eeeeee\",\"lightbox-title-strip\":\"on\",\"lightbox-title-position\":\"bottom\",\"lightbox-title\":\"off\",\"lightbox-title-source\":\"title\",\"lightbox-description\":\"off\",\"lightbox-description-source\":\"description\",\"lbox-padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-effect-open-close\":\"fade\",\"lightbox-effect-open-close-speed\":\"500\",\"lightbox-effect-next-prev\":\"fade\",\"lightbox-effect-next-prev-speed\":\"500\",\"lightbox-autoplay\":\"off\",\"lbox-playspeed\":\"3000\",\"lightbox-arrows\":\"on\",\"lightbox-loop\":\"on\",\"lightbox-numbers\":\"on\",\"lightbox-mousewheel\":\"off\",\"lb-button-order\":[\"share\",\"thumbs\",\"close\"],\"lightbox-post-content-min-width\":\"75\",\"lightbox-post-content-min-perc\":\"on\",\"lightbox-post-content-max-width\":\"75\",\"lightbox-post-content-max-perc\":\"on\",\"lightbox-post-content-overflow\":\"on\",\"lbox-content_padding\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-post-spinner\":\"off\",\"lightbox-post-content-img\":\"off\",\"lightbox-post-content-img-position\":\"top\",\"lightbox-post-content-img-width\":\"50\",\"lightbox-post-content-img-margin\":[\"0\",\"0\",\"0\",\"0\"],\"lightbox-post-content-title\":\"off\",\"lightbox-post-content-title-tag\":\"h2\",\"aj-source-order\":[\"post-content\"],\"ajax-container-id\":\"ess-grid-ajax-container-\",\"ajax-container-position\":\"top\",\"ajax-scroll-onload\":\"on\",\"ajax-scrollto-offset\":\"0\",\"ajax-close-button\":\"off\",\"ajax-button-text\":\"Close\",\"ajax-nav-button\":\"off\",\"ajax-button-skin\":\"light\",\"ajax-button-type\":\"type1\",\"ajax-button-inner\":\"false\",\"ajax-button-h-pos\":\"r\",\"ajax-button-v-pos\":\"t\",\"ajax-container-pre\":\"\",\"ajax-container-post\":\"\",\"ajax-container-css\":\"\",\"ajax-callback\":\"\",\"ajax-callback-arg\":\"false\",\"ajax-css-url\":\"\",\"ajax-js-url\":\"\",\"use-spinner\":\"0\",\"spinner-color\":\"#FFFFFF\",\"custom-javascript\":\"\",\"cookie-save-time\":\"30\",\"cookie-save-search\":\"off\",\"cookie-save-filter\":\"off\",\"cookie-save-pagination\":\"off\",\"pg\":\"false\",\"css-id\":\"\"}", "[\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"319\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"post-link\\\":\\\"http:\\\\\\/\\\\\\/deblock.local\\\\\\/product\\\\\\/cordage-polypropylene\\\\\\/\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"cordage\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"322\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"Tresse\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\",\"{\\\"custom-type\\\":\\\"image\\\",\\\"custom-image\\\":\\\"323\\\",\\\"custom-ratio\\\":\\\"1\\\",\\\"cobbles-size\\\":\\\"1:1\\\",\\\"use-skin\\\":\\\"-1\\\",\\\"title\\\":\\\"SANDOW\\\",\\\"image-fit\\\":\\\"-1\\\",\\\"image-repeat\\\":\\\"-1\\\",\\\"image-align-horizontal\\\":\\\"-1\\\",\\\"image-align-vertical\\\":\\\"-1\\\"}\"]", "{\"bg\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2024\\/02\\/cordage-3-torons.jpg\"}", "2024-02-20 16:52:51");

/* INSERT TABLE DATA: wp_eg_item_skins */
INSERT INTO `wp_eg_item_skins` VALUES("1", "Washington", "washington", "{\"eg-item-skin-element-last-id\":\"11\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"splitted-item\":\"none\",\"cover-type\":\"full\",\"cover-blend-mode\":\"normal\",\"container-background-color\":\"rgba(255, 255, 255, 0)\",\"cover-always-visible-desktop\":\"false\",\"cover-always-visible-mobile\":\"false\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius-type\":\"px\",\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius-type\":\"px\",\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"content-box-shadow-inset\":\"false\",\"content-box-shadow-hover\":\"false\",\"cover-animation-top\":\"falldown\",\"cover-animation-duration-top\":\"200\",\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-color-top\":\"#FFFFFF\",\"cover-animation-center\":\"zoomback\",\"cover-animation-duration-center\":\"default\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-color-center\":\"#FFFFFF\",\"cover-animation-bottom\":\"fade\",\"cover-animation-duration-bottom\":\"default\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-color-bottom\":\"#FFFFFF\",\"cover-group-animation\":\"zoomback\",\"cover-group-animation-duration\":\"default\",\"cover-group-animation-delay\":\"0\",\"media-animation\":\"grayscalein\",\"media-animation-duration\":\"200\",\"media-animation-delay\":\"0\",\"media-animation-blur\":\"5\",\"element-hover-image\":\"false\",\"hover-image-animation\":\"fade\",\"hover-image-animation-duration\":\"default\",\"hover-image-animation-delay\":\"0\",\"link-set-to\":\"cover\",\"link-link-type\":\"post\",\"link-target\":\"_self\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\"}", "[{\"id\":\"8\",\"order\":0,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"false\",\"enable-hover\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"min-height\":\"0\",\"max-height\":\"none\",\"duration\":\"default\",\"letter-spacing\":\"normal\",\"letter-spacing-hover\":\"normal\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"show-on-lightbox-video\":\"false\",\"rel-nofollow\":\"\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"3\",\"order\":0,\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"22\",\"line-height\":\"20\",\"color\":\"#000000\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"false\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"min-height\":\"0\",\"max-height\":\"none\",\"duration\":\"default\",\"letter-spacing\":\"normal\",\"letter-spacing-hover\":\"normal\",\"source-taxonomy\":\"post_tag\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"show-on-lightbox-video\":\"false\",\"rel-nofollow\":\"\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"source-post\":\"title\"}},{\"id\":\"9\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"false\",\"enable-hover\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"min-height\":\"0\",\"max-height\":\"none\",\"duration\":\"default\",\"letter-spacing\":\"normal\",\"letter-spacing-hover\":\"normal\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"show-on-lightbox-video\":\"false\",\"rel-nofollow\":\"\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"10\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"background-color\":\"#FFFFFF\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"letter-spacing\":\"normal\",\"source\":\"text\",\"special\":\"true\",\"special-type\":\"line-break\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-unit\":\"px\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000000\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-function\":\"link\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"min-height\":\"0\",\"max-height\":\"none\",\"transition-type\":\"\",\"delay\":\"10\",\"duration\":\"default\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"hide-on-video\":\"false\",\"show-on-lightbox-video\":\"false\",\"enable-hover\":\"\",\"tag-type\":\"div\",\"rel-nofollow\":\"\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"letter-spacing-hover\":\"normal\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFFFFF\",\"shadow-color-hover\":\"#000000\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"source-text\":\"LINE-BREAK\"}},{\"id\":\"11\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"20\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#000000\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"347.9999694824219\",\"left-right\":\"160\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"shadow-color\":\"rgba(0,0,0,1)\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"false\",\"show-on-sale\":\"false\",\"show-if-featured\":\"false\",\"transition\":\"none\",\"transition-type\":\"\",\"duration\":\"default\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"font-family\":\"\",\"letter-spacing\":\"normal\",\"margin-unit\":\"px\",\"source-taxonomy\":\"post_tag\",\"source-function\":\"link\",\"min-height\":\"0\",\"max-height\":\"none\",\"hideunderheight\":\"0\",\"hidetype\":\"display\",\"show-on-lightbox-video\":\"false\",\"rel-nofollow\":\"\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"letter-spacing-hover\":\"normal\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-text\":\"23 Mod\\u00e8les\"}}]", "{\"favorite\":true}");
INSERT INTO `wp_eg_item_skins` VALUES("2", "Adams", "adams", "{\"eg-item-skin-element-last-id\":\"8\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(137,175,114,1)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"transparent\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"10\",\"cover-animation-center\":\"flipleft\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"turnout\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":0,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideright\",\"delay\":\"10\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"css\":\".eg-adams-element-0{}\",\"css-hover\":\".eg-adams-element-0{}\",\"transition-type\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":1,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"2\",\"2\",\"2\",\"2\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideleft\",\"delay\":\"20\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},null,{\"id\":\"3\",\"order\":4,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"css\":\".eg-adams-element-3{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-adams-element-3{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},null,{\"id\":\"5\",\"order\":7,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"20\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\".eg-adams-element-5{}\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\".eg-adams-element-5{}\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"words\",\"limit-num\":\"6\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":2,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}},{\"id\":\"8\",\"order\":5,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"true\",\"always-visible-mobile\":\"true\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("3", "Jefferson", "jefferson", "{\"eg-item-skin-element-last-id\":\"8\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(227,58,12,1)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"fliphorizontal\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"fliphorizontalout\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":0,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#e33a0c\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"46\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":1,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"17\",\"17\",\"17\",\"17\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#e33a0c\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"50\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},null,{\"id\":\"3\",\"order\":3,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"17\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"800\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"10\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"transparent\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"17\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"60\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},null,{\"id\":\"5\",\"order\":6,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"on\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"1\",\"5\",\"1\",\"5\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"3\",\"3\",\"3\",\"3\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"12\",\"line-height-hover\":\"20\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"3\",\"3\",\"3\",\"3\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"70\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\"   \",\"limit-type\":\"words\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"border-unit-hover\":\"px\",\"box-shadow-unit-hover\":\"px\",\"source-post\":\"cat_list\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":2,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"8\",\"order\":4,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("4", "Madison", "madison", "{\"eg-item-skin-element-last-id\":\"7\",\"choose-layout\":\"even\",\"show-content\":\"bottom\",\"content-align\":\"left\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(88,92,103,1)\",\"0\":\"Default\",\"element-container-background-color-opacity\":\"100\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#585c67\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-shadow-alpha\":\"100\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"flipvertical\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"fade\",\"media-animation\":\"flipverticalout\",\"media-animation-delay\":\"0\"}", "[{\"id\":\"0\",\"order\":0,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"10\",\"0\",\"0\"],\"padding\":[\"19\",\"19\",\"19\",\"19\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.25)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"50\",\"link-type\":\"lightbox\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-search\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"1\",\"order\":1,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"icon\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"19\",\"19\",\"19\",\"19\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit\":\"px\",\"border-color\":\"#ffffff\",\"border-style\":\"solid\",\"font-size-hover\":\"16\",\"line-height-hover\":\"22\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(0,0,0,0.25)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"60\",\"60\",\"60\",\"60\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"#ffffff\",\"border-style-hover\":\"solid\",\"hideunder\":\"0\",\"transition\":\"zoomfront\",\"delay\":\"35\",\"link-type\":\"post\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"transition-type\":\"\",\"css\":\"\",\"position\":\"relative\",\"top\":\"0\",\"right\":\"0\",\"bottom\":\"0\",\"left\":\"0\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"align\":\"t_l\",\"css-hover\":\"\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"force-important\":\"true\",\"absolute-unit\":\"px\",\"hide-on-video\":\"\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"source-icon\":\"eg-icon-link\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},null,{\"id\":\"3\",\"order\":4,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"13\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slideup\",\"delay\":\"35\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"title\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},null,{\"id\":\"5\",\"order\":7,\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"12\",\"line-height\":\"20\",\"color\":\"#ffffff\",\"font-family\":\"\",\"font-weight\":\"400\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"none\",\"display\":\"inline-block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"bg-alpha\":\"100\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"300\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"bg-alpha-hover\":\"100\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"slidedown\",\"delay\":\"45\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"words\",\"limit-num\":\"6\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"source-post\":\"excerpt\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"6\",\"order\":2,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}},{\"id\":\"7\",\"order\":5,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"bg-alpha\":\"100\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"shadow-alpha\":\"100\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"\",\"enable-hover\":\"\",\"attribute\":\"\",\"class\":\"\",\"rel\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"bg-alpha-hover\":\"100\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"shadow-alpha-hover\":\"100\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"source-text\":\"LINE-BREAK\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("5", "ESGBlankSkin", "esgblankskin", "{\"eg-item-skin-element-last-id\":\"0\",\"choose-layout\":\"even\",\"show-content\":\"none\",\"content-align\":\"left\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"splitted-item\":\"none\",\"cover-type\":\"full\",\"container-background-color\":\"rgba(0, 0, 0, 0)\",\"cover-always-visible-desktop\":\"false\",\"cover-always-visible-mobile\":\"false\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"rgba(255, 255, 255, 0)\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"rgba(255, 255, 255, 0)\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-color\":\"transparent\",\"content-border-style\":\"none\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"#000000\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-top\":\"fade\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-center\":\"none\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-bottom\":\"fade\",\"cover-group-animation\":\"none\",\"media-animation\":\"none\",\"media-animation-delay\":\"0\",\"element-hover-image\":\"false\",\"hover-image-animation\":\"fade\",\"hover-image-animation-delay\":\"0\",\"link-set-to\":\"none\",\"link-link-type\":\"none\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\",\"link-target\":\"_self\"}", "[]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("6", "Item Skin 1", "item-skin-1", "{\"eg-item-skin-element-last-id\":\"11\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"splitted-item\":\"none\",\"cover-type\":\"full\",\"cover-blend-mode\":\"normal\",\"container-background-color\":\"rgba(255, 255, 255, 0)\",\"cover-always-visible-desktop\":\"false\",\"cover-always-visible-mobile\":\"false\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius-type\":\"px\",\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius-type\":\"px\",\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"content-box-shadow-inset\":\"false\",\"content-box-shadow-hover\":\"false\",\"cover-animation-top\":\"falldown\",\"cover-animation-duration-top\":\"200\",\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-color-top\":\"#FFFFFF\",\"cover-animation-center\":\"zoomback\",\"cover-animation-duration-center\":\"default\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-color-center\":\"#FFFFFF\",\"cover-animation-bottom\":\"fade\",\"cover-animation-duration-bottom\":\"default\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-color-bottom\":\"#FFFFFF\",\"cover-group-animation\":\"zoomback\",\"cover-group-animation-duration\":\"default\",\"cover-group-animation-delay\":\"0\",\"media-animation\":\"grayscalein\",\"media-animation-duration\":\"200\",\"media-animation-delay\":\"0\",\"media-animation-blur\":\"2\",\"element-hover-image\":\"false\",\"hover-image-animation\":\"fade\",\"hover-image-animation-duration\":\"default\",\"hover-image-animation-delay\":\"0\",\"link-set-to\":\"none\",\"link-link-type\":\"none\",\"link-target\":\"_self\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\"}", "[{\"id\":\"8\",\"order\":0,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"false\",\"enable-hover\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"min-height\":\"0\",\"max-height\":\"none\",\"duration\":\"default\",\"letter-spacing\":\"normal\",\"letter-spacing-hover\":\"normal\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"show-on-lightbox-video\":\"false\",\"rel-nofollow\":\"\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"3\",\"order\":0,\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"22\",\"line-height\":\"20\",\"color\":\"#000000\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"false\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"min-height\":\"0\",\"max-height\":\"none\",\"duration\":\"default\",\"letter-spacing\":\"normal\",\"letter-spacing-hover\":\"normal\",\"source-taxonomy\":\"post_tag\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"show-on-lightbox-video\":\"false\",\"rel-nofollow\":\"\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"source-post\":\"title\"}},{\"id\":\"9\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"false\",\"enable-hover\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"min-height\":\"0\",\"max-height\":\"none\",\"duration\":\"default\",\"letter-spacing\":\"normal\",\"letter-spacing-hover\":\"normal\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"show-on-lightbox-video\":\"false\",\"rel-nofollow\":\"\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"10\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"background-color\":\"#FFFFFF\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"letter-spacing\":\"normal\",\"source\":\"text\",\"special\":\"true\",\"special-type\":\"line-break\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-unit\":\"px\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000000\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-function\":\"link\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"min-height\":\"0\",\"max-height\":\"none\",\"transition-type\":\"\",\"delay\":\"10\",\"duration\":\"default\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"hide-on-video\":\"false\",\"show-on-lightbox-video\":\"false\",\"enable-hover\":\"\",\"tag-type\":\"div\",\"rel-nofollow\":\"\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"letter-spacing-hover\":\"normal\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFFFFF\",\"shadow-color-hover\":\"#000000\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"source-text\":\"LINE-BREAK\"}},{\"id\":\"11\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"20\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#000000\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"347.9999694824219\",\"left-right\":\"160\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"shadow-color\":\"rgba(0,0,0,1)\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"false\",\"show-on-sale\":\"false\",\"show-if-featured\":\"false\",\"transition\":\"none\",\"transition-type\":\"\",\"duration\":\"default\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"font-family\":\"\",\"letter-spacing\":\"normal\",\"margin-unit\":\"px\",\"source-taxonomy\":\"post_tag\",\"source-function\":\"link\",\"min-height\":\"0\",\"max-height\":\"none\",\"hideunderheight\":\"0\",\"hidetype\":\"display\",\"show-on-lightbox-video\":\"false\",\"rel-nofollow\":\"\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"letter-spacing-hover\":\"normal\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-text\":\"23 Mod\\u00e8les\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("7", "Item Skin 2", "item-skin-2", "{\"eg-item-skin-element-last-id\":\"11\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"splitted-item\":\"none\",\"cover-type\":\"full\",\"cover-blend-mode\":\"normal\",\"container-background-color\":\"rgba(255, 255, 255, 0)\",\"cover-always-visible-desktop\":\"false\",\"cover-always-visible-mobile\":\"false\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"#ffffff\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius-type\":\"px\",\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius-type\":\"px\",\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"content-box-shadow-inset\":\"false\",\"content-box-shadow-hover\":\"false\",\"cover-animation-top\":\"falldown\",\"cover-animation-duration-top\":\"200\",\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-color-top\":\"#FFFFFF\",\"cover-animation-center\":\"zoomback\",\"cover-animation-duration-center\":\"default\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-color-center\":\"#FFFFFF\",\"cover-animation-bottom\":\"fade\",\"cover-animation-duration-bottom\":\"default\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-color-bottom\":\"#FFFFFF\",\"cover-group-animation\":\"zoomback\",\"cover-group-animation-duration\":\"default\",\"cover-group-animation-delay\":\"0\",\"media-animation\":\"grayscalein\",\"media-animation-duration\":\"200\",\"media-animation-delay\":\"0\",\"media-animation-blur\":\"2\",\"element-hover-image\":\"false\",\"hover-image-animation\":\"fade\",\"hover-image-animation-duration\":\"default\",\"hover-image-animation-delay\":\"0\",\"link-set-to\":\"none\",\"link-link-type\":\"none\",\"link-target\":\"_self\",\"link-url-link\":\"\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\"}", "[{\"id\":\"8\",\"order\":0,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"false\",\"enable-hover\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"min-height\":\"0\",\"max-height\":\"none\",\"duration\":\"default\",\"letter-spacing\":\"normal\",\"letter-spacing-hover\":\"normal\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"show-on-lightbox-video\":\"false\",\"rel-nofollow\":\"\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"3\",\"order\":0,\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"22\",\"line-height\":\"20\",\"color\":\"#000000\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"false\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"min-height\":\"0\",\"max-height\":\"none\",\"duration\":\"default\",\"letter-spacing\":\"normal\",\"letter-spacing-hover\":\"normal\",\"source-taxonomy\":\"post_tag\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"show-on-lightbox-video\":\"false\",\"rel-nofollow\":\"\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"source-post\":\"title\"}},{\"id\":\"9\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"false\",\"enable-hover\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"min-height\":\"0\",\"max-height\":\"none\",\"duration\":\"default\",\"letter-spacing\":\"normal\",\"letter-spacing-hover\":\"normal\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"show-on-lightbox-video\":\"false\",\"rel-nofollow\":\"\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"10\",\"order\":\"1\",\"container\":\"m\",\"settings\":{\"background-color\":\"#FFFFFF\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"letter-spacing\":\"normal\",\"source\":\"text\",\"special\":\"true\",\"special-type\":\"line-break\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-unit\":\"px\",\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"#000000\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"box-shadow-unit\":\"px\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"source-function\":\"link\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"min-height\":\"0\",\"max-height\":\"none\",\"transition-type\":\"\",\"delay\":\"10\",\"duration\":\"default\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"hide-on-video\":\"false\",\"show-on-lightbox-video\":\"false\",\"enable-hover\":\"\",\"tag-type\":\"div\",\"rel-nofollow\":\"\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"letter-spacing-hover\":\"normal\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"#FFFFFF\",\"shadow-color-hover\":\"#000000\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"source-text\":\"LINE-BREAK\"}},{\"id\":\"11\",\"order\":\"2\",\"container\":\"m\",\"settings\":{\"0\":\"Default\",\"source\":\"text\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"20\",\"enable-hover\":\"on\",\"font-size\":\"16\",\"line-height\":\"22\",\"color\":\"#000000\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"capitalize\",\"position\":\"relative\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"top-bottom\":\"347.9999694824219\",\"left-right\":\"160\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"none\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"background-color\":\"#ffffff\",\"shadow-color\":\"rgba(0,0,0,1)\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"false\",\"show-on-sale\":\"false\",\"show-if-featured\":\"false\",\"transition\":\"none\",\"transition-type\":\"\",\"duration\":\"default\",\"delay\":\"30\",\"link-type\":\"post\",\"url-link\":\"\",\"meta-link\":\"\",\"javascript-link\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"font-family\":\"\",\"letter-spacing\":\"normal\",\"margin-unit\":\"px\",\"source-taxonomy\":\"post_tag\",\"source-function\":\"link\",\"min-height\":\"0\",\"max-height\":\"none\",\"hideunderheight\":\"0\",\"hidetype\":\"display\",\"show-on-lightbox-video\":\"false\",\"rel-nofollow\":\"\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"letter-spacing-hover\":\"normal\",\"border-hover-unit\":\"px\",\"border-radius-hover-unit\":\"px\",\"box-shadow-hover-unit\":\"px\",\"source-text\":\"23 Mod\\u00e8les\"}}]", NULL);
INSERT INTO `wp_eg_item_skins` VALUES("8", "Services", "services", "{\"eg-item-skin-element-last-id\":\"11\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"splitted-item\":\"none\",\"cover-type\":\"full\",\"cover-blend-mode\":\"normal\",\"container-background-color\":\"rgba(255, 255, 255, 0)\",\"cover-always-visible-desktop\":\"false\",\"cover-always-visible-mobile\":\"false\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"rgba(255, 255, 255, 0)\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius-type\":\"px\",\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius-type\":\"px\",\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"content-box-shadow-inset\":\"false\",\"content-box-shadow-hover\":\"false\",\"cover-animation-top\":\"falldown\",\"cover-animation-duration-top\":\"200\",\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-color-top\":\"#FFFFFF\",\"cover-animation-center\":\"zoomback\",\"cover-animation-duration-center\":\"default\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-color-center\":\"#FFFFFF\",\"cover-animation-bottom\":\"fade\",\"cover-animation-duration-bottom\":\"default\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-color-bottom\":\"#FFFFFF\",\"cover-group-animation\":\"zoomback\",\"cover-group-animation-duration\":\"default\",\"cover-group-animation-delay\":\"0\",\"media-animation\":\"grayscalein\",\"media-animation-duration\":\"200\",\"media-animation-delay\":\"0\",\"media-animation-blur\":\"5\",\"element-hover-image\":\"false\",\"hover-image-animation\":\"fade\",\"hover-image-animation-duration\":\"default\",\"hover-image-animation-delay\":\"0\",\"link-set-to\":\"cover\",\"link-link-type\":\"url\",\"link-target\":\"_self\",\"link-url-link\":\"http:\\/\\/deblock.local\\/controle-delingue-mise-en-conformite\\/\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\"}", "[{\"id\":\"8\",\"order\":0,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"false\",\"enable-hover\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"min-height\":\"0\",\"max-height\":\"none\",\"duration\":\"default\",\"letter-spacing\":\"normal\",\"letter-spacing-hover\":\"normal\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"show-on-lightbox-video\":\"false\",\"rel-nofollow\":\"\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"22\",\"line-height\":\"35\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"false\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"min-height\":\"0\",\"max-height\":\"none\",\"duration\":\"default\",\"letter-spacing\":\"normal\",\"letter-spacing-hover\":\"normal\",\"source-taxonomy\":\"post_tag\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"show-on-lightbox-video\":\"false\",\"rel-nofollow\":\"\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"source-post\":\"title\"}},{\"id\":\"9\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"false\",\"enable-hover\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"min-height\":\"0\",\"max-height\":\"none\",\"duration\":\"default\",\"letter-spacing\":\"normal\",\"letter-spacing-hover\":\"normal\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"show-on-lightbox-video\":\"false\",\"rel-nofollow\":\"\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"source-text\":\"LINE-BREAK\"}}]", "{\"favorite\":true}");
INSERT INTO `wp_eg_item_skins` VALUES("9", "Métiers", "metiers", "{\"eg-item-skin-element-last-id\":\"11\",\"choose-layout\":\"masonry\",\"show-content\":\"bottom\",\"content-align\":\"center\",\"image-repeat\":\"no-repeat\",\"image-fit\":\"cover\",\"image-align-horizontal\":\"center\",\"image-align-vertical\":\"center\",\"element-x-ratio\":\"4\",\"element-y-ratio\":\"3\",\"splitted-item\":\"none\",\"cover-type\":\"full\",\"cover-blend-mode\":\"normal\",\"container-background-color\":\"rgba(255, 255, 255, 0)\",\"cover-always-visible-desktop\":\"false\",\"cover-always-visible-mobile\":\"false\",\"cover-background-size\":\"cover\",\"cover-background-repeat\":\"no-repeat\",\"cover-background-image\":\"0\",\"cover-background-image-url\":\"\",\"full-bg-color\":\"rgba(255, 255, 255, 0)\",\"full-padding\":[\"0\",\"0\",\"0\",\"0\"],\"full-border\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"full-border-radius-type\":\"px\",\"full-border-color\":\"transparent\",\"full-border-style\":\"none\",\"full-overflow-hidden\":\"false\",\"content-bg-color\":\"#ffffff\",\"content-padding\":[\"0\",\"0\",\"0\",\"0\"],\"content-border\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"content-border-radius-type\":\"px\",\"content-border-color\":\"transparent\",\"content-border-style\":\"double\",\"all-shadow-used\":\"none\",\"content-shadow-color\":\"rgba(0,0,0,1)\",\"content-box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"content-box-shadow-inset\":\"false\",\"content-box-shadow-hover\":\"false\",\"cover-animation-top\":\"falldown\",\"cover-animation-duration-top\":\"200\",\"cover-animation-top-type\":\"\",\"cover-animation-delay-top\":\"0\",\"cover-animation-color-top\":\"#FFFFFF\",\"cover-animation-center\":\"zoomback\",\"cover-animation-duration-center\":\"default\",\"cover-animation-center-type\":\"\",\"cover-animation-delay-center\":\"0\",\"cover-animation-color-center\":\"#FFFFFF\",\"cover-animation-bottom\":\"fade\",\"cover-animation-duration-bottom\":\"default\",\"cover-animation-bottom-type\":\"\",\"cover-animation-delay-bottom\":\"0\",\"cover-animation-color-bottom\":\"#FFFFFF\",\"cover-group-animation\":\"zoomback\",\"cover-group-animation-duration\":\"default\",\"cover-group-animation-delay\":\"0\",\"media-animation\":\"grayscalein\",\"media-animation-duration\":\"200\",\"media-animation-delay\":\"0\",\"media-animation-blur\":\"5\",\"element-hover-image\":\"false\",\"hover-image-animation\":\"fade\",\"hover-image-animation-duration\":\"default\",\"hover-image-animation-delay\":\"0\",\"link-set-to\":\"cover\",\"link-link-type\":\"post\",\"link-target\":\"_self\",\"link-url-link\":\"http:\\/\\/deblock.local\\/transport\\/\",\"link-meta-link\":\"\",\"link-javascript-link\":\"\"}", "[{\"id\":\"8\",\"order\":0,\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"padding\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"box-shadow\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"false\",\"enable-hover\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-radius-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"box-shadow-hover\":{\"0\":\"0\",\"1\":\"0\",\"2\":\"0\",\"3\":\"0\"},\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"min-height\":\"0\",\"max-height\":\"none\",\"duration\":\"default\",\"letter-spacing\":\"normal\",\"letter-spacing-hover\":\"normal\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"show-on-lightbox-video\":\"false\",\"rel-nofollow\":\"\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"source-text\":\"LINE-BREAK\"}},{\"id\":\"3\",\"order\":\"1\",\"container\":\"c\",\"settings\":{\"0\":\"Default\",\"source\":\"post\",\"enable-hover\":\"\",\"font-size\":\"22\",\"line-height\":\"35\",\"color\":\"#ffffff\",\"font-family\":\"\\\"Open Sans\\\"\",\"font-weight\":\"700\",\"text-decoration\":\"none\",\"font-style\":\"\",\"text-transform\":\"uppercase\",\"display\":\"block\",\"text-align\":\"center\",\"float\":\"none\",\"clear\":\"both\",\"margin\":[\"15\",\"0\",\"0\",\"0\"],\"padding\":[\"5\",\"10\",\"5\",\"10\"],\"background-color\":\"rgba(255,255,255,0.15)\",\"background-size\":\"cover\",\"background-repeat\":\"no-repeat\",\"shadow-color\":\"rgba(0,0,0,1)\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"none\",\"font-size-hover\":\"13\",\"line-height-hover\":\"14\",\"color-hover\":\"#ffffff\",\"font-family-hover\":\"\",\"font-weight-hover\":\"700\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"uppercase\",\"background-color-hover\":\"rgba(255,255,255,0.15)\",\"background-size-hover\":\"cover\",\"background-size-x-hover\":\"100\",\"background-size-y-hover\":\"100\",\"background-repeat-hover\":\"no-repeat\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit-hover\":\"px\",\"border-color-hover\":\"transparent\",\"border-style-hover\":\"none\",\"hideunder\":\"0\",\"transition\":\"flipup\",\"delay\":\"10\",\"link-type\":\"none\",\"url-link\":\"\",\"javascript-link\":\"\",\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"transition-type\":\"\",\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"tag-type\":\"div\",\"force-important\":\"\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"hide-on-video\":\"false\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"min-height\":\"0\",\"max-height\":\"none\",\"duration\":\"default\",\"letter-spacing\":\"normal\",\"letter-spacing-hover\":\"normal\",\"source-taxonomy\":\"post_tag\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"show-on-lightbox-video\":\"false\",\"rel-nofollow\":\"\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"source-post\":\"title\"}},{\"id\":\"9\",\"order\":\"2\",\"container\":\"c\",\"settings\":{\"background-color\":\"rgba(255,255,255,0.20)\",\"clear\":\"both\",\"border-width\":\"0\",\"color\":\"transparent\",\"display\":\"block\",\"font-size\":\"10\",\"font-style\":\"italic\",\"font-weight\":\"700\",\"line-height\":\"5\",\"margin\":[\"0\",\"0\",\"0\",\"0\"],\"padding\":[\"0\",\"0\",\"0\",\"0\"],\"text-align\":\"center\",\"transition\":\"none\",\"text-transform\":\"uppercase\",\"source\":\"text\",\"special\":\"true\",\"font-family\":\"\",\"text-decoration\":\"none\",\"float\":\"none\",\"border\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-unit\":\"px\",\"border-color\":\"transparent\",\"border-style\":\"solid\",\"shadow-color\":\"rgba(0,0,0,1)\",\"box-shadow\":[\"0\",\"0\",\"0\",\"0\"],\"position\":\"relative\",\"top-bottom\":\"0\",\"left-right\":\"0\",\"source-separate\":\",\",\"source-catmax\":\"-1\",\"limit-type\":\"none\",\"limit-num\":\"10\",\"transition-type\":\"\",\"delay\":\"10\",\"link-type\":\"none\",\"hideunder\":\"0\",\"hide-on-video\":\"false\",\"enable-hover\":\"\",\"tag-type\":\"div\",\"force-important\":\"true\",\"align\":\"t_l\",\"absolute-unit\":\"px\",\"show-on-sale\":\"\",\"show-if-featured\":\"\",\"font-size-hover\":\"12\",\"line-height-hover\":\"14\",\"color-hover\":\"#000000\",\"font-family-hover\":\"\",\"font-weight-hover\":\"400\",\"text-decoration-hover\":\"none\",\"font-style-hover\":\"\",\"text-transform-hover\":\"none\",\"border-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-radius-hover\":[\"0\",\"0\",\"0\",\"0\"],\"border-color-hover\":\"transparent\",\"border-style-hover\":\"solid\",\"background-color-hover\":\"rgba(255,255,255,1)\",\"shadow-color-hover\":\"rgba(0,0,0,1)\",\"box-shadow-hover\":[\"0\",\"0\",\"0\",\"0\"],\"margin-unit\":\"px\",\"padding-unit\":\"px\",\"border-unit\":\"px\",\"box-shadow-unit\":\"px\",\"always-visible-desktop\":\"\",\"always-visible-mobile\":\"\",\"min-height\":\"0\",\"max-height\":\"none\",\"duration\":\"default\",\"letter-spacing\":\"normal\",\"letter-spacing-hover\":\"normal\",\"source-function\":\"link\",\"hideunderheight\":\"0\",\"hidetype\":\"visibility\",\"show-on-lightbox-video\":\"false\",\"rel-nofollow\":\"\",\"link-target\":\"_self\",\"source-text-style-disable\":\"\",\"source-text\":\"LINE-BREAK\"}}]", "{\"favorite\":true}");

/* INSERT TABLE DATA: wp_eg_navigation_skins */
INSERT INTO `wp_eg_navigation_skins` VALUES("1", "Flat Light", "flat-light", "/*************************************\n	-	FLAT LIGHT 3.0.0 SKIN -\n*************************************/\n\n.flat-light .navigationbuttons,\n.flat-light .esg-pagination,\n.flat-light .esg-filters {\n	text-transform: uppercase;\n	text-align: center;\n}\n\n.flat-light .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.flat-light input.eg-search-input,\n.flat-light .esg-filterbutton,\n.flat-light .esg-navigationbutton,\n.flat-light .esg-sortbutton,\n.flat-light .esg-cartbutton,\n.flat-light .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.flat-light .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #999;\n	margin-right: 5px;\n	cursor: pointer;\n	position: relative;\n	z-index: 2;\n	padding: 0px 30px;\n	border: 1px solid rgba(0,0,0,0.15);\n	line-height: 40px;\n	border-radius: 5px;\n	font-size: 12px;\n	font-weight: 700;\n	font-family: \"Open Sans\", sans-serif;\n	display: inline-block;\n	background: #fff;\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 40px;\n	vertical-align: middle;\n}\n\n.flat-light .esg-cartbutton a {\n	color: #999;\n}\n\n.flat-light input.eg-search-input::placeholder {\n	line-height: 40px;\n	vertical-align: middle;\n	color:#999;\n}\n\n.flat-light .esg-navigationbutton {\n	padding: 0px;\n	width:40px;\n}\n\n.flat-light .esg-navigationbutton * {\n	color: #999;\n}\n\n.flat-light .esg-navigationbutton.esg-loadmore {\n	margin: 15px;\n	padding: 0 15px;\n	width: auto;\n}\n\n.flat-light .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.flat-light .esg-sortbutton-wrapper,\n.flat-light .esg-cartbutton-wrapper {\n	display: inline-block;\n}\n\n.flat-light .esg-sortbutton-order,\n.flat-light .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: top;\n	border: 1px solid rgba(0,0,0,0.15);\n	width: 40px;\n	line-height: 40px;\n	border-radius: 5px;\n	font-size: 12px;\n	font-weight: 700;\n	color: #999;\n	cursor: pointer;\n	background: #eee;\n	background: #fff;\n	margin-left: 5px;\n}\n\n.flat-light .esg-cartbutton {\n	color: #999;\n	cursor: default !important;\n}\n\n.flat-light .esg-cartbutton .esgicon-basket {\n	color: #999;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.flat-light .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.flat-light .esg-sortbutton,\n.flat-light .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 0px;\n	border-radius: 5px;\n}\n\n.flat-light input.eg-search-input.hovered,\n.flat-light input.eg-search-input:focus,\n.flat-light .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.flat-light .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.flat-light .esg-navigationbutton.hovered,\n.flat-light .esg-filterbutton.hovered,\n.flat-light .esg-sortbutton.hovered,\n.flat-light .esg-sortbutton-order.hovered,\n.flat-light .esg-cartbutton-order.hovered,\n.flat-light .esg-filterbutton.selected,\n.flat-light .esg-cartbutton.hovered,\n.flat-light .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.flat-light .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	color: #000;\n	background: #fff;\n    box-shadow: 0px 3px 5px 0px rgba(0,0,0,0.13);\n}\n\n.flat-light .esg-navigationbutton.hovered * {\n	color: #000;\n}\n\n.flat-light .esg-sortbutton-order.hovered.tp-desc {\n	color: #000;\n}\n\n.flat-light .esg-filter-checked {\n	color: #cbcbcb;\n	background: #cbcbcb;\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 300;\n	line-height: 9px;\n	vertical-align: middle;\n}\n\n.flat-light .esg-filterbutton.selected .esg-filter-checked,\n.flat-light .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n	background: #000;\n}\n\n.flat-light .esg-filter-wrapper.eg-search-wrapper {\n	white-space: nowrap;\n}\n\n.flat-light .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.flat-light .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.flat-light .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:40px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.flat-light .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n}\n\n.flat-light .esg-dropdown-wrapper {\n	transform: translateZ(10px) translateX(-50%);\n	left: 50%;\n	background:transparent;\n	padding:0px;\n}\n\n.flat-light .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative\n}\n\n.flat-light .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 12px;\n	color:#999;\n}\n.flat-light .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open,\n.flat-light .esg-selected-filterbutton.hovered .eg-icon-down-open {\n	color:#000;\n}\n\n.flat-light .esg-navigationbutton.esg-loadmore {\n	margin: 15px;\n	padding: 0 15px;\n	width: auto;\n}", NULL);
INSERT INTO `wp_eg_navigation_skins` VALUES("2", "Flat Dark", "flat-dark", "/********************************\n	-	FLAT DARK 3.0.0 SKIN -\n*********************************/\n\n.flat-dark .navigationbuttons,\n.flat-dark .esg-pagination,\n.flat-dark .esg-filters {\n	text-transform: uppercase;\n	text-align: center;\n}\n\n.flat-dark .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.flat-dark input.eg-search-input,\n.flat-dark .esg-filterbutton,\n.flat-dark .esg-navigationbutton,\n.flat-dark .esg-sortbutton,\n.flat-dark .esg-cartbutton,\n.flat-dark .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.flat-dark .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #fff;\n	margin-right: 5px;\n	cursor: pointer;\n	position: relative;\n	z-index: 2;\n	padding: 1px 30px;\n	border: none;\n	line-height: 38px;\n	border-radius: 5px;\n	font-size: 12px;\n	font-weight: 700;\n	font-family: \"Open Sans\", sans-serif;\n	display: inline-block;\n	background: rgba(0, 0, 0, 0.2);\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 38px;\n	vertical-align: middle;\n}\n\n.flat-dark .esg-cartbutton a {\n	color:#fff;\n}\n\n.flat-dark input.eg-search-input::placeholder {\n	line-height: 38px;\n	vertical-align: middle;\n	color:#fff;\n}\n\n.flat-dark .esg-navigationbutton {\n	padding: 2px 12px;\n}\n\n.flat-dark .esg-navigationbutton * {\n	color: #fff;\n}\n\n.flat-dark .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.flat-dark .esg-sortbutton-wrapper,\n.flat-dark .esg-cartbutton-wrapper {\n	display: inline-block;\n}\n\n.flat-dark .esg-sortbutton-order,\n.flat-dark .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: top;\n	border: none;\n	width: 40px;\n	line-height: 40px;\n	border-radius: 5px;\n	font-size: 12px;\n	font-weight: 700;\n	color: #fff;\n	cursor: pointer;\n	background: rgba(0, 0, 0, 0.2);\n	margin-left: 5px;\n}\n\n.flat-dark .esg-cartbutton {\n	color: #fff;\n	cursor: default !important;\n}\n\n.flat-dark .esg-cartbutton .esgicon-basket {\n	color: #fff;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.flat-dark .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.flat-dark .esg-sortbutton,\n.flat-dark .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 0px;\n	border-radius: 5px;\n}\n\n.flat-dark input.eg-search-input.hovered,\n.flat-dark input.eg-search-input:focus,\n.flat-dark .esg-navigationbutton.hovered,\n.flat-dark .esg-filterbutton.hovered,\n.flat-dark .esg-sortbutton.hovered,\n.flat-dark .esg-sortbutton-order.hovered,\n.flat-dark .esg-cartbutton-order.hovered,\n.flat-dark .esg-filterbutton.selected,\n.flat-dark .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.flat-dark .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.flat-dark .esg-cartbutton.hovered,\n.flat-dark .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.flat-dark .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	border-color: none;\n	color: #fff;\n	background: rgba(0, 0, 0, 0.5);\n}\n\n.flat-dark .esg-navigationbutton.hovered * {\n	color: #333;\n}\n\n.flat-dark .esg-sortbutton-order.hovered .tp-desc {\n	color: #333;\n}\n\n.flat-dark .esg-filter-checked {\n	color: transparent;\n	background: rgba(0, 0, 0, 0.2);\n	margin-left: 7px;\n	font-size: 9px;\n	font-weight: 300;\n	line-height: 9px;\n	vertical-align: middle;\n}\n\n.flat-dark .esg-filterbutton.selected .esg-filter-checked,\n.flat-dark .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n	background: rgba(0, 0, 0, 0.2);\n}\n\n.flat-dark .esg-filter-wrapper.eg-search-wrapper {\n	white-space: nowrap;\n}\n\n.flat-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.flat-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.flat-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:40px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.flat-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n}\n\n.flat-dark .esg-dropdown-wrapper {\n	transform: translateZ(10px) translateX(-50%);\n	left: 50%;\n	background:transparent;\n	padding:0px;\n}\n\n.flat-dark .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	background:rgba(0,0,0,0.5);\n}\n\n.flat-dark .esg-dropdown-wrapper .esg-filterbutton.selected,\n.flat-dark .esg-dropdown-wrapper .esg-filterbutton.hovered {\n	background:rgba(0,0,0,0.75);\n}\n\n\n.flat-dark .esg-dropdown-wrapper .esg-filterbutton .esg-filter-checked {\n	position: absolute;\n	left: 10px;\n	top: 50%;\n	transform: translateY(-50%);\n	width: 12px;\n	height: 12px;\n	text-align: center;\n	line-height: 12px\n}\n\n.flat-dark .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right:-10px;\n	font-size:12px;\n	color:#fff;\n}", NULL);
INSERT INTO `wp_eg_navigation_skins` VALUES("3", "Minimal Dark", "minimal-dark", "/**************************************\n	-	MINIMAL DARK V3.0.0 SKIN    -\n**************************************/\n\n.minimal-dark .navigationbuttons,\n.minimal-dark .esg-pagination,\n.minimal-dark .esg-filters {\n	text-align: center;\n}\n\n.minimal-dark .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.minimal-dark input.eg-search-input,\n.minimal-dark .esg-filterbutton,\n.minimal-dark .esg-navigationbutton,\n.minimal-dark .esg-sortbutton,\n.minimal-dark .esg-cartbutton,\n.minimal-dark .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.minimal-dark .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: rgba(255, 255, 255, 1);\n	margin-right: 5px;\n	cursor: pointer;\n	padding: 0px 17px;\n	border: 1px solid rgba(255, 255, 255, 0.1);\n	line-height: 38px;\n	border-radius: 5px;\n	font-size: 12px;\n	font-weight: 600;\n	font-family: \"Open Sans\", sans-serif;\n	display: inline-block;\n	background: transparent;\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 38px;\n	vertical-align: middle;\n}\n\n.minimal-dark .esg-cartbutton a {\n	color:#fff;\n}\n\n.minimal-dark input.eg-search-input::placeholder {\n	line-height: 38px;\n	vertical-align: middle;\n	color:#fff;\n}\n\n.minimal-dark .esg-navigationbutton * {\n	color: rgba(255, 255, 255, 1);\n}\n\n.minimal-dark .esg-navigationbutton {\n	padding: 0px 11px;\n}\n\n.minimal-dark .esg-pagination-button {\n	padding: 0px 16px;\n}\n\n.minimal-dark .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.minimal-dark .esg-sortbutton-wrapper,\n.minimal-dark .esg-cartbutton-wrapper {\n	display: inline-block;\n}\n\n.minimal-dark .esg-sortbutton-order,\n.minimal-dark .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: top;\n	border: 1px solid rgba(255, 255, 255, 0.1);\n	width: 40px;\n	line-height: 38px;\n	border-radius: 0px 5px 5px 0px;\n	font-size: 12px;\n	font-weight: 600;\n	color: #fff;\n	cursor: pointer;\n	background: transparent;\n}\n\n.minimal-dark .esg-cartbutton {\n	color: #fff;\n	cursor: default !important;\n}\n\n.minimal-dark .esg-cartbutton .esgicon-basket {\n	color: #fff;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.minimal-dark .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.minimal-dark .esg-sortbutton,\n.minimal-dark .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 0px;\n	border-right: none;\n	border-radius: 5px 0px 0px 5px;\n}\n\n.minimal-dark .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.minimal-dark .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.minimal-dark .esg-navigationbutton.hovered,\n.minimal-dark .esg-filterbutton.hovered,\n.minimal-dark .esg-sortbutton.hovered,\n.minimal-dark .esg-sortbutton-order.hovered,\n.minimal-dark .esg-cartbutton-order.hovered,\n.minimal-dark .esg-filterbutton.selected,\n.minimal-dark .esg-cartbutton.hovered,\n.minimal-dark .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.minimal-dark .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	border-color: rgba(255, 255, 255, 0.2);\n	color: #fff;\n	box-shadow: 0px 3px 5px 0px rgba(0, 0, 0, 0.13);\n	background: rgba(255, 255, 255, 0.1);\n}\n\n.minimal-dark .esg-navigationbutton.hovered * {\n	color: #fff;\n}\n\n.minimal-dark .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #fff;\n	border-color: rgba(255, 255, 255, 0.2);\n	color: #fff;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.minimal-dark .esg-filter-checked {\n	color: transparent;\n	background: rgba(0, 0, 0, 0.10);\n	font-size: 9px;\n	font-weight: 300;\n	line-height: 9px;\n	vertical-align: middle;\n	margin-left:7px;\n}\n\n.minimal-dark .esg-filter-wrapper.dropdownstyle .esg-filter-checked {\n	margin-left:-22px;\n	margin-right:10px;\n	border:1px solid rgba(255,255,255,.2);\n}\n\n.minimal-dark .esg-filterbutton.selected .esg-filter-checked,\n.minimal-dark .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n	background: rgba(0, 0, 0, 0.10);\n}\n\n/* */\n.minimal-dark .esg-filter-wrapper.eg-search-wrapper {\n	white-space: nowrap;\n}\n\n\n.minimal-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.minimal-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:40px;\n	padding:0px;\n	margin-left:5px;\n	margin-right:0px;\n}\n\n.minimal-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n}\n\n.minimal-dark .esg-dropdown-wrapper {\n	transform: translateZ(10px) translateX(-50%);\n	left: 50%;\n	background:rgba(0,0,0,0.95);\n	border-radius: 5px;\n}\n\n.minimal-dark .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	border:none;\n	box-shadow: none;\n	text-align: left;\n	color:rgba(255,255,255,0.5);\n	background:transparent;\n	line-height: 25px;\n	min-height: 25px;\n}\n\n.minimal-dark .esg-dropdown-wrapper .esg-filterbutton.hovered,\n.minimal-dark .esg-dropdown-wrapper .esg-filterbutton.selected {\n	color:#fff;\n}\n\n\n.minimal-dark .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	color:#fff;\n	font-size:12px;\n}", NULL);
INSERT INTO `wp_eg_navigation_skins` VALUES("4", "Minimal Light", "minimal-light", "/*************************************\n	-	MINIMAL LIGHT 3.0.0 SKIN	-\n*************************************/\n\n.minimal-light .navigationbuttons,\n.minimal-light .esg-pagination,\n.minimal-light .esg-filters {\n	text-align: center;\n}\n\n.minimal-light .esg-filter-wrapper.dropdownstyle >.esg-selected-filterbutton,\n.minimal-light input.eg-search-input,\n.minimal-light .esg-filterbutton,\n.minimal-light .esg-navigationbutton,\n.minimal-light .esg-sortbutton,\n.minimal-light .esg-cartbutton a,\n.minimal-light .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.minimal-light .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #999;\n	margin-right: 5px;\n	cursor: pointer;\n	padding: 0px 16px;\n	border: 1px solid #e5e5e5;\n	line-height: 38px;\n	border-radius: 5px;\n	font-size: 12px;\n	font-weight: 700;\n	font-family: \"Open Sans\", sans-serif;\n	display: inline-block;\n	background: #fff;\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 38px;\n	vertical-align: middle;\n}\n\n .minimal-light input.eg-search-input::placeholder {\n	line-height: 38px;\n	vertical-align: middle;\n}\n\n.minimal-light .esg-navigationbutton * {\n	color: #999;\n}\n\n.minimal-light .esg-navigationbutton {\n	padding: 0px 16px;\n}\n\n.minimal-light .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.minimal-light .esg-left,\n.minimal-light .esg-right {\n	padding: 0px 11px;\n}\n\n.minimal-light .esg-sortbutton-wrapper,\n.minimal-light .esg-cartbutton-wrapper {\n	display: inline-block;\n}\n\n.minimal-light .esg-sortbutton-order,\n.minimal-light .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: top;\n	border: 1px solid #e5e5e5;\n	width: 40px;\n	line-height: 38px;\n	border-radius: 0px 5px 5px 0px;\n	font-size: 12px;\n	font-weight: 700;\n	color: #999;\n	cursor: pointer;\n	background: #fff;\n}\n\n.minimal-light .esg-cartbutton {\n	color: #333;\n	cursor: default !important;\n}\n\n.minimal-light .esg-cartbutton .esgicon-basket {\n	color: #333;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.minimal-light .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.minimal-light .esg-sortbutton,\n.minimal-light .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 0px;\n	border-right: none;\n	border-radius: 5px 0px 0px 5px;\n}\n\n.minimal-light input.eg-search-input.hovered,\n.minimal-light input.eg-search-input:focus,\n.minimal-light .esg-navigationbutton.hovered,\n.minimal-light .esg-filterbutton.hovered,\n.minimal-light .esg-sortbutton.hovered,\n.minimal-light .esg-sortbutton-order.hovered,\n.minimal-light .esg-cartbutton.hovered a,\n.minimal-light .esg-filter-wrapper.dropdownstyle >.esg-selected-filterbutton.hovered,\n.minimal-light .esg-filterbutton.selected,\n.minimal-light .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.minimal-light .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	background-color: #fff;\n	border-color: #bbb;\n	color: #333;\n	box-shadow: 0px 3px 5px 0px rgba(0, 0, 0, 0.13);\n}\n\n.minimal-light .esg-navigationbutton.hovered * {\n	color: #333;\n}\n\n.minimal-light .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #bbb;\n	color: #333;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.minimal-light .esg-filter-checked {\n	color: #cbcbcb;\n	background: #cbcbcb;\n	margin-left:10px;\n	font-size: 9px;\n	font-weight: 300;\n	line-height: 9px;\n	vertical-align: middle;\n}\n\n.minimal-light .esg-filter-wrapper.dropdownstyle .esg-filter-checked {\n	margin-left:-22px;\n	margin-right:10px;\n}\n\n.minimal-light .esg-filterbutton.selected .esg-filter-checked,\n.minimal-light .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n	background: #000;\n}\n\n.minimal-light .esg-filter-wrapper.eg-search-wrapper {\n	white-space: nowrap;\n}\n\n\n\n.minimal-light .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.minimal-light .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:40px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.minimal-light .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n}\n\n.minimal-light .esg-dropdown-wrapper {\n	transform: translateZ(10px) translateX(-50%);\n	left:50%;\n	background:rgba(255,255,255,0.95);\n	border-radius: 5px;\n	border: 1px solid #e5e5e5;\n}\n\n.minimal-light .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	border:none;\n	box-shadow: none;\n	text-align: left;\n	color:#999;\n	background:transparent;\n	line-height: 25px;\n	min-height: 25px;\n}\n\n.minimal-light .esg-dropdown-wrapper .esg-filterbutton.hovered,\n.minimal-light .esg-dropdown-wrapper .esg-filterbutton.selected {\n	color:#333;\n}\n\n.minimal-light .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right:-10px;\n	font-size:12px;\n}\n\n.minimal-light .esg-selected-filterbutton.hovered .eg-icon-down-open {\n	color:#333;\n}", NULL);
INSERT INTO `wp_eg_navigation_skins` VALUES("5", "Simple Light", "simple-light", "/*************************************\n	-	SIMPLE LIGHT 3.0.0 SKIN   -\n*************************************/\n\n.simple-light .navigationbuttons,\n.simple-light .esg-pagination,\n.simple-light .esg-filters {\n	text-align: center;\n}\n\n.simple-light .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.simple-light input.eg-search-input,\n.simple-light .esg-filterbutton,\n.simple-light .esg-navigationbutton,\n.simple-light .esg-sortbutton,\n.simple-light .esg-cartbutton,\n.simple-light .esg-sortbutton-order,\n.simple-light .esg-cartbutton-order,\n.simple-light .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.simple-light .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #000;\n	margin-right: 5px;\n	cursor: pointer;\n	padding: 0px 11px;\n	border: 1px solid #e5e5e5;\n	line-height: 30px;\n	font-size: 12px;\n	font-weight: 400;\n	font-family: \"Open Sans\",sans-serif;\n 	display: inline-block;\n	background: #eee;\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 30px;\n	vertical-align: middle;\n}\n\n.simple-light .esg-cartbutton a {\n	color:#000;\n}\n\n.simple-light input.eg-search-input::placeholder {\n	line-height: 30px;\n	vertical-align: middle;\n	color:#000;\n}\n\n.simple-light .esg-navigationbutton * {\n	color: #000;\n}\n\n.simple-light .esg-left,\n.simple-light .esg-right {\n	color: #000;\n	padding: 0px 7px;\n}\n\n.simple-light .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.simple-light .esg-sortbutton-wrapper,\n.simple-light .esg-cartbutton-wrapper {\n	display: inline-block;\n	vertical-align: top;\n}\n\n.simple-light .esg-sortbutton-order,\n.simple-light .esg-cartbutton-order {\n	padding: 0px;\n	width: 29px;\n	font-size: 9px;\n}\n\n.simple-light .esg-cartbutton {\n	color: #333;\n	cursor: default !important;\n}\n\n.simple-light .esg-cartbutton .esgicon-basket {\n	color: #333;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.simple-light .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.simple-light .esg-sortbutton,\n.simple-light .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 5px;\n}\n\n.simple-light input.eg-search-input.hovered,\n.simple-light input.eg-search-input:focus,\n.simple-light .esg-navigationbutton.hovered,\n.simple-light .esg-filterbutton.hovered,\n.simple-light .esg-sortbutton.hovered,\n.simple-light .esg-sortbutton-order.hovered,\n.simple-light .esg-cartbutton.hovered,\n.simple-light .esg-filterbutton.selected,\n.simple-light .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.simple-light .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.simple-light .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.simple-light .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	background-color: #fff;\n	border-color: #bbb;\n	color: #333;\n	box-shadow: 0px 3px 5px 0px rgba(0, 0, 0, 0.13);\n}\n\n.simple-light .esg-cartbutton.hovered a {\n	color:#000;\n}\n\n.simple-light .esg-navigationbutton.hovered * {\n	color: #333;\n}\n\n.simple-light .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #bbb;\n	color: #333;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.simple-light .esg-filter-checked {\n	color: #c5c5c5;\n	background: #ddd;\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 400;\n	line-height: 20px;\n	vertical-align: middle;\n}\n\n.simple-light .esg-filterbutton.selected .esg-filter-checked,\n.simple-light .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n	background: #000;\n}\n\n.simple-light .esg-filter-wrapper.eg-search-wrapper {\n	line-height: 30px;\n	white-space: nowrap;\n}\n\n.simple-light .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.simple-light .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.simple-light .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:29px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.simple-light .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n	border-radius:0px;\n}\n\n.simple-light .esg-dropdown-wrapper {\n	left: 0px;\n	background:#fff;\n}\n\n.simple-light .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	text-align: left;\n	background:transparent;\n	padding:0px;\n	border:none;\n	box-shadow: none;\n}\n\n.simple-light .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 9px;\n	color:#000;\n}\n.simple-light .esg-selected-filterbutton.hovered .eg-icon-down-open,\n.simple-light .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open{\n	color:#333;\n}", NULL);
INSERT INTO `wp_eg_navigation_skins` VALUES("6", "Simple Dark", "simple-dark", "/*************************************\n	-	SIMPLE DARK 3.0.0 SKIN   -\n*************************************/\n\n.simple-dark .navigationbuttons,\n.simple-dark .esg-pagination,\n.simple-dark .esg-filters {\n	text-align: center;\n}\n\n.simple-dark .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.simple-dark input.eg-search-input,\n.simple-dark .esg-filterbutton,\n.simple-dark .esg-navigationbutton,\n.simple-dark .esg-sortbutton,\n.simple-dark .esg-cartbutton,\n.simple-dark .esg-sortbutton-order,\n.simple-dark .esg-cartbutton-order,\n.simple-dark .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.simple-dark .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #fff;\n	margin-right: 5px;\n	cursor: pointer;\n	padding: 0px 10px;\n	border:1px solid rgba(255,255,255,0.15);\n	line-height: 29px;\n	font-size: 12px;\n	font-weight: 600;\n	font-family: \"Open Sans\",sans-serif;\n 	display: inline-block;\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 29px;\n	background: rgba(255,255,255,0.08 );\n	vertical-align: middle;\n}\n\n.simple-dark .esg-cartbutton a {\n	color:#fff;\n}\n\n.simple-dark input.eg-search-input::placeholder {\n	line-height: 29px;\n	vertical-align: middle;\n	color:#fff;\n}\n\n\n\n.simple-dark .esg-navigationbutton * {\n	color: #fff;\n}\n\n.simple-dark .esg-left,\n.simple-dark .esg-right {\n	color: #fff;\n	padding: 0px 7px;\n}\n\n.simple-dark .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.simple-dark .esg-sortbutton-wrapper,\n.simple-dark .esg-cartbutton-wrapper {\n	display: inline-block;\n	vertical-align: top;\n}\n\n.simple-dark .esg-sortbutton-order,\n.simple-dark .esg-cartbutton-order {\n	padding: 0px;\n	width: 29px;\n	font-size: 9px;\n}\n\n.simple-dark .esg-cartbutton {\n	color: #000;\n	cursor: default !important;\n}\n\n.simple-dark .esg-cartbutton .esgicon-basket {\n	color: #000;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.simple-dark .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.simple-dark .esg-sortbutton,\n.simple-dark .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 5px;\n}\n\n.simple-dark input.eg-search-input.hovered,\n.simple-dark input.eg-search-input:focus,\n.simple-dark .esg-navigationbutton.hovered,\n.simple-dark .esg-filterbutton.hovered,\n.simple-dark .esg-sortbutton.hovered,\n.simple-dark .esg-sortbutton-order.hovered,\n.simple-dark .esg-cartbutton.hovered,\n.simple-dark .esg-filterbutton.selected,\n.simple-dark .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.simple-dark .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.simple-dark .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.simple-dark .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	background-color: #fff;\n	border-color: #fff;\n	color: #000;\n	box-shadow: 0px 3px 5px 0px rgba(0, 0, 0, 0.13);\n}\n\n.simple-dark .esg-cartbutton.hovered a,\n.simple-dark input.eg-search-input.hovered::placeholder {\n	color:#000;\n}\n\n.simple-dark .esg-navigationbutton.hovered * {\n	color: #000;\n}\n\n.simple-dark .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #fff;\n	color: #000;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.simple-dark .esg-filter-checked {\n	color: transparent;\n	background: rgba(255,255,255,0.15);\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 400;\n	vertical-align: top;\n}\n\n.simple-dark .esg-filterbutton.selected .esg-filter-checked,\n.simple-dark .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n	background: #000;\n}\n\n\n\n.simple-dark .esg-filter-wrapper.eg-search-wrapper {\n	line-height: 29px;\n	white-space: nowrap;\n}\n\n.simple-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.simple-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.simple-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:29px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.simple-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n    border-radius:0px;\n}\n\n.simple-dark .esg-dropdown-wrapper {\n	left: 0px;\n	background:#fff;\n	border:1px solid rgba(255,255,255,0.15);\n}\n\n.simple-dark .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	text-align: left;\n	background:transparent;\n	padding:0px;\n	border:none;\n	box-shadow: none;\n	color:#777;\n}\n\n.simple-dark .esg-dropdown-wrapper .esg-filterbutton .esg-filter-checked {\n	border: 1px solid rgba(0,0,0,0.2);\n}\n\n.simple-dark .esg-dropdown-wrapper .esg-filterbutton.hovered,\n.simple-dark .esg-dropdown-wrapper .esg-filterbutton.selected {\n	color:#000;\n}\n\n.simple-dark .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 9px;\n	color:#fff;\n}\n.simple-dark .esg-selected-filterbutton.hovered .eg-icon-down-open,\n.simple-dark .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open{\n	color:#000;\n}", NULL);
INSERT INTO `wp_eg_navigation_skins` VALUES("7", "Text Dark", "text-dark", "/*************************************\n	-	TEXT DARK 3.0.0 SKIN   -\n*************************************/\n\n.text-dark .navigationbuttons,\n.text-dark .esg-pagination,\n.text-dark .esg-filters {\n	text-align: center;\n}\n\n.text-dark .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.text-dark input.eg-search-input,\n.text-dark .esg-filterbutton,\n.text-dark .esg-navigationbutton,\n.text-dark .esg-sortbutton,\n.text-dark .esg-cartbutton,\n.text-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.text-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	color: rgba(255, 255, 255, 0.4);\n	margin-right: 5px;\n	cursor: pointer;\n	padding: 0px 15px 0px 10px;\n	line-height: 20px;\n	font-size: 12px;\n	font-weight: 600;\n	font-family: \"Open Sans\", sans-serif;\n	display: inline-block;\n	background: transparent;\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 20px;\n	vertical-align: top;\n}\n\n.text-dark .esg-cartbutton a {\n	color: #fff;\n}\n\n.text-dark input.eg-search-input::placeholder {\n	line-height: 29px;\n	vertical-align: middle;\n	color: rgba(255, 255, 255, 0.4);\n}\n\n.text-dark .esg-navigationbutton * {\n	color: rgba(255, 255, 255, 0.4);\n}\n\n.text-dark .esg-sortbutton-wrapper,\n.text-dark .esg-cartbutton-wrapper {\n	display: inline-block;\n}\n\n.text-dark .esg-sortbutton-order,\n.text-dark .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: top;\n	width: 29px;\n	line-height: 20px;\n	font-size: 9px;\n	font-weight: 700;\n	color: #fff;\n	color: rgba(255, 255, 255, 0.4);\n	cursor: pointer;\n	background: transparent;\n}\n\n.text-dark .esg-cartbutton {\n	color: rgba(255, 255, 255, 0.4);\n	cursor: default !important;\n}\n\n.text-dark .esg-cartbutton .esgicon-basket {\n	color: rgba(255, 255, 255, 0.4);\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.text-dark .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.text-dark .esg-sortbutton,\n.text-dark .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 0px;\n}\n\n.text-dark input.eg-search-input.hovered,\n.text-dark input.eg-search-input:focus,\n.text-dark .esg-navigationbutton.hovered,\n.text-dark .esg-filterbutton.hovered,\n.text-dark .esg-sortbutton.hovered,\n.text-dark .esg-filterbutton.selected,\n.text-dark .esg-sortbutton-order.hovered,\n.text-dark .esg-cartbutton-order.hovered,\n.text-dark .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.text-dark .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.text-dark .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.text-dark .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	color: #fff;\n}\n\n.text-dark .esg-navigationbutton.hovered,\n.text-dark .esg-filterbutton:hover span:first-child,\n.text-dark .esg-filterbutton.selected span:first-child {\n	text-decoration: none;\n}\n\n.text-dark .esg-filterbutton {\n	border-right: 1px solid #fff;\n	border-right: 1px solid rgba(255, 255, 255, 0.15);\n}\n\n.text-dark .esg-filterbutton-last {\n	border-right: none;\n}\n\n.text-dark .esg-sortbutton-order {\n	padding-left: 10px;\n	border-left: 1px solid #fff;\n	border-left: 1px solid rgba(255, 255, 255, 0.15);\n}\n\n.text-dark .esg-navigationbutton.hovered * {\n	color: #fff;\n}\n\n.text-dark .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #fff;\n	border-color: rgba(255, 255, 255, 0.15);\n	color: #fff;\n}\n\n.text-dark .esg-filter-checked {\n	color: transparent;\n	background: rgba(0, 0, 0, 0.10);\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 300;\n	line-height: 9px;\n	vertical-align: middle;\n}\n\n\n.text-dark .esg-filterbutton.selected .esg-filter-checked,\n.text-dark .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n}\n\n.text-dark .esg-filter-wrapper.eg-search-wrapper {\n	line-height: 20px;\n	white-space: nowrap;\n}\n\n.text-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.text-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.text-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:20px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.text-dark .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n	border:none !important;\n	line-height: 20px;\n	height: 20px;\n}\n\n.text-dark .esg-dropdown-wrapper {\n	left: 0px;\n	background:rgba(0, 0, 0, 0.85);\n}\n\n.text-dark .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	text-align: left;\n	background:transparent;\n	padding:0px;\n	border:none;\n	box-shadow: none;\n	color: rgba(255, 255, 255, 0.4);\n}\n\n\n.text-dark .esg-dropdown-wrapper .esg-filterbutton.hovered,\n.text-dark .esg-dropdown-wrapper .esg-filterbutton.selected {\n	color: #fff;\n}\n\n.text-dark .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 9px;\n	color: rgba(255, 255, 255, 0.4);\n}\n.text-dark .esg-selected-filterbutton.hovered .eg-icon-down-open,\n.text-dark .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open{\n	color:#fff;\n}\n.text-dark .esg-pagination-button:last-child{\n  border-right: none;\n}\n.text-dark .esg-pagination-button:last-child { \n	border-right: none; \n}", NULL);
INSERT INTO `wp_eg_navigation_skins` VALUES("8", "Text Light", "text-light", "/*************************************\n	-	TEXT LIGHT 3.0.0 SKIN   -\n*************************************/\n\n.text-light .navigationbuttons,\n.text-light .esg-pagination,\n.text-light .esg-filters {\n	text-align: center;\n}\n\n.text-light .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.text-light input.eg-search-input,\n.text-light .esg-filterbutton,\n.text-light .esg-navigationbutton,\n.text-light .esg-sortbutton,\n.text-light .esg-cartbutton,\n.text-light .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.text-light .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	color: #999;\n	margin-right: 5px;\n	cursor: pointer;\n	padding: 0px 15px 0px 10px;\n	line-height: 20px;\n	font-size: 12px;\n	font-weight: 600;\n	font-family: \"Open Sans\", sans-serif;\n	display: inline-block;\n	background: transparent;\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 20px;\n	vertical-align: top;\n}\n\n.text-light .esg-cartbutton a {\n	color: #999;\n}\n\n.text-light input.eg-search-input::placeholder {\n	line-height: 29px;\n	vertical-align: middle;\n	color: #999;\n}\n\n.text-light .esg-navigationbutton * {\n	color: #999;\n}\n\n.text-light .esg-sortbutton-wrapper,\n.text-light .esg-cartbutton-wrapper {\n	display: inline-block;\n}\n\n.text-light .esg-sortbutton-order,\n.text-light .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: top;\n	width: 29px;\n	line-height: 20px;\n	font-size: 9px;\n	font-weight: 700;\n	color: #999;\n	cursor: pointer;\n	background: transparent;\n}\n\n.text-light .esg-cartbutton {\n	color: #999;\n	cursor: default !important;\n}\n\n.text-light .esg-cartbutton .esgicon-basket {\n	color: #999;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.text-light .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.text-light .esg-sortbutton,\n.text-light .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 0px;\n}\n\n.text-light input.eg-search-input.hovered,\n.text-light input.eg-search-input:focus,\n.text-light .esg-navigationbutton.hovered,\n.text-light .esg-filterbutton.hovered,\n.text-light .esg-sortbutton.hovered,\n.text-light .esg-filterbutton.selected,\n.text-light .esg-sortbutton-order.hovered,\n.text-light .esg-cartbutton-order.hovered,\n.text-light .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.text-light .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.text-light .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.text-light .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	color: #444;\n}\n\n.text-light .esg-cartbutton.hovered a,\n.text-light input.eg-search-input.hovered::placeholder {\n	color: #999;\n}\n\n.text-light .esg-navigationbutton.hovered,\n.text-light .esg-filterbutton:hover span:first-child,\n.text-light .esg-filterbutton.selected span:first-child {\n	text-decoration: none;\n}\n\n.text-light .esg-filterbutton {\n	border-right: 1px solid rgba(0, 0, 0, 0.15);\n}\n\n.text-light .esg-filterbutton-last {\n	border-right: none;\n}\n\n.text-light .esg-sortbutton-order {\n	padding-left: 10px;\n	border-left: 1px solid rgba(0, 0, 0, 0.15);\n}\n\n.text-light .esg-navigationbutton.hovered * {\n	color: #444;\n}\n\n.text-light .esg-sortbutton-order.hovered .tp-desc {\n	border-color: rgba(0, 0, 0, 0.15);\n	color: #444;\n}\n\n.text-light .esg-filter-checked {\n	color: transparent;\n	background: rgba(0, 0, 0, 0.10);\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 300;\n	line-height: 9px;\n	vertical-align: middle;\n}\n\n\n.text-light .esg-filterbutton.selected .esg-filter-checked,\n.text-light .esg-filterbutton.hovered .esg-filter-checked {\n	color: #444;\n}\n\n.text-light .esg-filter-wrapper.eg-search-wrapper {\n	line-height: 20px;\n	white-space: nowrap;\n}\n\n.text-light .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.text-light .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.text-light .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:20px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.text-light .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n	border:none !important;\n	line-height: 20px;\n	height: 20px;\n}\n\n.text-light .esg-dropdown-wrapper {\n	left: 0px;\n	background:rgba(255, 255, 255, 0.85);\n}\n\n.text-light .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	text-align: left;\n	background:transparent;\n	padding:0px;\n	border:none;\n	box-shadow: none;\n	color: #999;\n}\n\n\n.text-light .esg-dropdown-wrapper .esg-filterbutton.hovered,\n.text-light .esg-dropdown-wrapper .esg-filterbutton.selected {\n	color: #444;\n}\n\n.text-light .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 9px;\n	color: #999;\n}\n.text-light .esg-selected-filterbutton.hovered .eg-icon-down-open,\n.text-light .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open{\n	color:#444;\n}\n.text-light .esg-pagination-button:last-child{\n  border-right: none;\n}\n.text-light .esg-pagination-button:last-child { \n	border-right: none; \n}", NULL);
INSERT INTO `wp_eg_navigation_skins` VALUES("9", "Pat LaFontaine", "pat-lafontaine", "/*************************************\n	-	Pat LaFontaine 3.0.0 SKIN -\n*************************************/\n@import url(\"https://fonts.googleapis.com/css2?family=Barlow+Condensed:ital,wght@0,400;0,500;0,600;1,400&display=swap\");\n@import url(\"https://fonts.googleapis.com/icon?family=Material+Icons\");\n\n\n\n.pat-lafontaine .esg-overflowtrick {\n  margin: 20px 0\n}\n\n.pat-lafontaine .navigationbuttons,\n.pat-lafontaine .esg-pagination,\n.pat-lafontaine .esg-filters {\n	text-transform: uppercase;\n	text-align: center;\n}\n\n.pat-lafontaine .esg-filters {margin-bottom: 1px !important}\n\n.pat-lafontaine .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.pat-lafontaine input.eg-search-input,\n.pat-lafontaine .esg-filterbutton,\n.pat-lafontaine .esg-navigationbutton,\n.pat-lafontaine .esg-sortbutton,\n.pat-lafontaine .esg-cartbutton,\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #000;\n	margin-right: 1px;\n	cursor: pointer;\n	position: relative;\n	z-index: 2;\n	padding: 0px 20px;\n	border: none;\n	line-height: 50px;\n	border-radius: 0;\n	font-size: 14px;\n	font-weight: 400;\n	font-family: \"Barlow Condensed\", sans-serif;\n	display: inline-block;\n	background: #eaedf1;\n	margin-bottom: 0 !important;\n	white-space: nowrap;\n	min-height: 50px;\n	vertical-align: middle;\n  	transition: all 0.3s ease;\n  	min-width: 50px;\n}\n\n.pat-lafontaine .esg-filter-wrapper {\n  margin: 0 !important\n    }\n\n.pat-lafontaine .esg-allfilter {\n  background: #f03e3f !important;\n  color: #fff !important\n}\n\n.pat-lafontaine .esg-allfilter.hovered {\n  background: #000 !important;\n  color: #fff !important\n}\n\n.pat-lafontaine span.eg-el-amount {\n  letter-spacing: 1px\n}\n\n.pat-lafontaine span.eg-el-amount:before {\n  content: \"[\";\n  opacity: 0.5\n}\n\n.pat-lafontaine span.eg-el-amount:after {\n  content: \"]\";\n  opacity: 0.5\n}\n\n.pat-lafontaine .esg-cartbutton a {\n	color: #000;\n}\n\n.pat-lafontaine input.eg-search-input::placeholder {\n	line-height: 40px;\n	vertical-align: middle;\n	color:#999;\n}\n\n.pat-lafontaine .esg-navigationbutton {\n	padding: 0px;\n	min-width: 50px;\n}\n\n.pat-lafontaine .esg-navigationbutton.esg-loadmore {\n  padding: 0 20px;\n  text-transform: uppercase;\n}\n\n.pat-lafontaine .esg-navigationbutton * {\n	color: #000;\n}\n\n.pat-lafontaine .esg-navigationbutton.hovered i {\n  	color: #fff;\n}\n\n.pat-lafontaine .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.pat-lafontaine .esg-sortbutton-wrapper,\n.pat-lafontaine .esg-cartbutton-wrapper {\n	display: inline-block;\n  	margin-right: 1px !important;\n  	margin-left: 0 !important;\n}\n\n.pat-lafontaine .esg-sortbutton-order,\n.pat-lafontaine .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: middle;\n	border: none;\n	width: 50px;\n	line-height: 50px;\n	font-size: 12px;\n	font-weight: 700;\n	color: #999;\n	cursor: pointer;\n	background: #eaedf1;\n	margin-left: 1px;\n  	border-radius: 0;\n}\n\n.pat-lafontaine .esg-sortbutton-order.eg-icon-down-open:before {\n  	content: \"arrow_downward\";\n 	font-family: \"Material Icons\";\n  	font-size: 18px;\n  	color: #000;\n  	vertical-align: middle;\n}\n\n.pat-lafontaine .esg-sortbutton-order.hovered.eg-icon-down-open:before {\n  color: #fff\n}\n\n.pat-lafontaine .esg-cartbutton {\n	color: #999;\n	cursor: default !important;\n 	border-radius: 0 !important;\n  	padding: 0 20px 0 16px\n}\n\n.pat-lafontaine .esg-cartbutton.hovered .eg-icon-basket,\n.pat-lafontaine .esg-cartbutton.hovered .ess-cart-content {\n  color: #fff\n}\n\n.pat-lafontaine .esg-cartbutton .esgicon-basket {\n	color: #999;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.pat-lafontaine .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.pat-lafontaine .esg-sortbutton,\n.pat-lafontaine .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 0px;\n	border-radius: 5px;\n}\n\n.pat-lafontaine input.eg-search-input.hovered,\n.pat-lafontaine input.eg-search-input:focus,\n.pat-lafontaine .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.pat-lafontaine .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.pat-lafontaine .esg-navigationbutton.hovered,\n.pat-lafontaine .esg-filterbutton.hovered,\n.pat-lafontaine .esg-sortbutton.hovered,\n.pat-lafontaine .esg-sortbutton-order.hovered,\n.pat-lafontaine .esg-cartbutton-order.hovered,\n.pat-lafontaine .esg-filterbutton.selected,\n.pat-lafontaine .esg-cartbutton.hovered,\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	border-color: none;\n	color: #fff;\n	background: #000;\n}\n\n.pat-lafontaine .esg-navigationbutton.hovered * {\n	color: #000;\n}\n\n.pat-lafontaine .esg-sortbutton-order.hovered.tp-desc {\n	color: #000;\n}\n\n.pat-lafontaine .esg-filter-checked {\n	color: #cbcbcb;\n	background: none;\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 300;\n	line-height: 13px;\n	vertical-align: middle;\n  	display: inline-block;\n    transform: translateY(-1px);\n  	border: 1px solid #cbcbcb;\n}\n.pat-lafontaine .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n	background: #000;\n}\n\n.pat-lafontaine .esg-filterbutton.selected .esg-filter-checked {\n  background: #fff;\n  color: #000;\n  border: 1px solid #fff;\n}\n\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper {\n	white-space: nowrap;\n}\n\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:40px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n}\n\n.pat-lafontaine .esg-sortbutton {\n  	border-radius: 0;\n  	padding-right: 40px\n}\n\n.pat-lafontaine .esg-sortbutton:after,\n.pat-lafontaine .esg-selected-filterbutton .eg-icon-down-open:before{\n  	content: \"\";\n  	position: absolute;\n  	width: 5px;\n  	height: 5px;\n  	border-left: 1px solid #000;\n  	border-bottom: 1px solid #000;\n  	transform: rotate(-45deg) translateY(-6px);\n  	right: 15px;\n  	top: 50%\n}\n\n.pat-lafontaine .esg-sortbutton.hovered:after {\n  	border-left: 1px solid #fff;\n  	border-bottom: 1px solid #fff;\n}\n\n.pat-lafontaine .esg-dropdown-wrapper {\n	transform: translateZ(10px) translateX(-50%);\n	left: 50%;\n	background:transparent;\n	padding:0px;\n}\n\n.pat-lafontaine .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n  	width: 100%;\n}\n\n.pat-lafontaine .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 12px;\n	color:#999;\n}\n\n.pat-lafontaine .dropdownstyle .esg-filterbutton .esg-filter-checked {\n  margin-left: 0;\n  transform: translateY(-2px);\n}\n\n.pat-lafontaine .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open,\n.pat-lafontaine .esg-selected-filterbutton.hovered .eg-icon-down-open {\n	color:#000;\n}\n\n.pat-lafontaine .eg-search-wrapper {background: #3d3b3e}\n.pat-lafontaine .eg-search-wrapper .eg-search-input {\n  background: #3d3b3e;\n  font-style: italic;\n  border-bottom: 1px solid #868689;\n  line-height: 22px;\n  min-height: 22px;\n  padding: 0;\n  margin: 0 0 0 20px !important;\n}\n\n.pat-lafontaine .eg-search-wrapper .eg-search-input.hovered,\n.pat-lafontaine .eg-search-wrapper .eg-search-input:focus,\n.pat-lafontaine .eg-search-wrapper .eg-search-input:active,\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n  background-color: #3d3b3e !important;\n  color: #fff !important;\n}\n\n.pat-lafontaine .eg-search-wrapper .eg-search-input.hovered,\n.pat-lafontaine .eg-search-wrapper input:-webkit-autofill,\n.pat-lafontaine .eg-search-wrapper input:-webkit-autofill:hover,\n.pat-lafontaine .eg-search-wrapper input:-webkit-autofill:focus {\n  border-bottom: 1px solid #fff;\n  -webkit-text-fill-color: #fff;\n  -webkit-box-shadow: 0 0 0px 1000px #3d3b3e inset;\n}\n\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n  margin-left: 0;\n  width: 46px;\n}\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper .eg-search-submit.hovered {\n  background: #000;\n}\n\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper .eg-search-clean {\n  margin-left: 0;\n  width: 46px;\n  background: #000;\n  color: #fff\n}\n\n.pat-lafontaine .esg-filter-wrapper.eg-search-wrapper .eg-search-clean.hovered {\n  background: #f03e3f;\n}\n\n", NULL);
INSERT INTO `wp_eg_navigation_skins` VALUES("10", "Grant Fuhr", "grant-fuhr", "/*************************************\n	-	Grant Fuhr 3.0.0 SKIN -\n*************************************/\n@import url(\"https://fonts.googleapis.com/icon?family=Material+Icons\");\n\n\n\n.grant-fuhr .esg-filters {\n  margin-bottom: 20px !important;\n}\n\n.grant-fuhr .navigationbuttons,\n.grant-fuhr .esg-pagination,\n.grant-fuhr .esg-filters {\n	text-transform: uppercase;\n	text-align: center;\n}\n\n\n.grant-fuhr .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.grant-fuhr input.eg-search-input,\n.grant-fuhr .esg-filterbutton,\n.grant-fuhr .esg-navigationbutton,\n.grant-fuhr .esg-sortbutton,\n.grant-fuhr .esg-cartbutton,\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #fff;\n	margin-right: 13px;\n	cursor: pointer;\n	position: relative;\n	z-index: 2;\n	padding: 0px 15px;\n	border: none;\n	line-height: 50px;\n	font-size: 12px;\n	font-weight: 400;\n	font-family: \"Open Sans\", sans-serif;\n  	font-style: italic;\n  	letter-spacing: 1px;\n	display: inline-block;\n	background: #2e2e34;\n	margin-bottom: 1px;\n	white-space: nowrap;\n	min-height: 50px;\n	vertical-align: top;\n  	border-radius: 0px !important;\n  	min-width: 42px;\n  	text-transform: none;\n}\n.grant-fuhr .esg-cartbutton-wrapper {\n  margin: 0 11px !important;\n}\n\n.grant-fuhr .esg-filterbutton.esg-allfilter {\n  	text-decoration: underline;\n}\n\n.grant-fuhr .esg-sortbutton-wrapper {\n  position: relative;\n  margin: 0 2px 0 8px !important;\n}\n\n.grant-fuhr .esg-sortbutton-wrapper .esg-sortbutton {\n  padding-right: 35px;\n}\n\n.grant-fuhr .esg-filterbutton:before,\n.grant-fuhr .eg-search-wrapper:before,\n.grant-fuhr .esg-cartbutton:before,\n.grant-fuhr .esg-sortbutton-wrapper .esg-sortbutton:before,\n.grant-fuhr .esg-filter-wrapper.dropdownstyle:before {\n  	width: 0;\n	height: 0;\n	border-style: solid;\n	border-width: 0 0 50px 12px;\n	border-color: transparent transparent #2e2e34 transparent;\n  	position: absolute;\n  	content:\"\";\n  	top: 0;\n  	left: -12px\n}\n\n.grant-fuhr .esg-sortbutton-wrapper .esg-sortbutton.hovered:before {\n  border-color: transparent transparent #fff157 transparent;\n}\n\n.grant-fuhr .esg-filterbutton:after,\n.grant-fuhr .eg-search-wrapper .eg-search-clean:after,\n.grant-fuhr .esg-cartbutton:after,\n.grant-fuhr .esg-sortbutton-order:after,\n.grant-fuhr .esg-filter-wrapper.dropdownstyle:after {\n  	width: 0;\n	height: 0;\n	border-style: solid;\n	border-width: 50px 12px 0 0;\n	border-color: #2e2e34 transparent transparent transparent;\n  	position: absolute;\n  	content:\"\";\n  	top: 0;\n  	right: -12px\n}\n\n.grant-fuhr .esg-filter-wrapper.dropdownstyle:after {\n  right: 1px\n}\n\n.grant-fuhr .esg-filterbutton.hovered:before,\n.grant-fuhr .esg-filterbutton.selected:before,\n.grant-fuhr .esg-cartbutton.hovered:before,\n.grant-fuhr .esg-sortbutton-wrapper.hovered:before,\n.grant-fuhr .esg-filter-wrapper.dropdownstyle:hover:before {\n  border-color: transparent transparent #fff157 transparent;\n}\n\n.grant-fuhr .esg-filterbutton.hovered:after,\n.grant-fuhr .esg-filterbutton.selected:after,\n.grant-fuhr .esg-cartbutton.hovered:after,\n.grant-fuhr .esg-sortbutton-wrapper.hovered:after,\n.grant-fuhr .esg-filter-wrapper.dropdownstyle:hover:after {\n  border-color: #fff157 transparent transparent transparent;\n}\n\n.esg-sortbutton-order.tp-desc {\n  transform: none;\n}\n\n.esg-sortbutton-order.tp-desc:before {\n  transform: scaleY(-1);\n}\n\n.grant-fuhr .esg-filterbutton .eg-el-amount {\n  position: absolute;\n  line-height: 27px;\n  min-width: 27px;\n  border-radius: 50%;\n  background: #fff157;\n  color: #000;\n  top: -13px;\n  right: -5px;\n  text-align: center;\n  z-index: 2;\n  font-style: normal;\n  font-weight: 600;\n\n}\n\n.grant-fuhr .esg-filterbutton .eg-el-amount:before,\n.grant-fuhr .esg-filterbutton .eg-el-amount:after {\n  display: none\n}\n\n.grant-fuhr .esg-filterbutton.selected .eg-el-amount {\n  background: #2e2e34;\n  color: #fff;\n}\n\n.grant-fuhr .esg-cartbutton a {\n	color: #fff;\n}\n\n.grant-fuhr .esg-cartbutton.hovered a {\n  color: #000;\n}\n\n.grant-fuhr .eg-search-wrapper {\n  position: relative\n}\n\n.grant-fuhr .eg-search-wrapper:before {\n  border-color: transparent transparent #fff157 transparent;\n}\n\n.grant-fuhr input.eg-search-input {\n  background: #fff157;\n  outline-style: none;\n  margin-bottom: 0 !important;\n}\n\n.grant-fuhr input.eg-search-input::placeholder {\n	line-height: 40px;\n	vertical-align: middle;\n	color:#000;\n}\n\n.grant-fuhr input.eg-search-input:focus::placeholder {\n  opacity: 0;\n}\n\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n  margin-left: 0 !important;\n  min-width: 50px;\n  background: #fff157;\n  color: #000;\n}\n\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper .eg-search-submit.hovered {\n  background: #2e2e34 !important;\n  color: #fff157 !important;\n}\n\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper .eg-search-clean {\n  margin-left: 0 !important;\n  min-width: 50px;\n}\n\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper .eg-search-clean.hovered:after {\n	border-color: #fff157 transparent transparent transparent;\n}\n\n.grant-fuhr .esg-sortbutton-order.eg-icon-down-open:before {\n  	content: \"arrow_downward\";\n 	font-family: \"Material Icons\";\n  	font-size: 18px;\n  	color: #000;\n  	vertical-align: middle;\n}\n\n.grant-fuhr .esg-sortbutton-order.hovered.eg-icon-down-open:before {\n  color: #fff\n}\n\n.grant-fuhr .esg-navigationbutton {\n	padding: 0px;\n	width:40px;\n}\n\n.grant-fuhr .esg-navigationbutton.esg-loadmore {\n  	width: auto;\n  	padding: 0 20px\n}\n\n.grant-fuhr .esg-navigationbutton * {\n	color: #999;\n}\n\n.grant-fuhr .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.grant-fuhr .esg-navigationbutton.selected,\n.grant-fuhr .esg-navigationbutton.hovered {\n  color: #000 !important;\n}\n\n.grant-fuhr .esg-navigationbutton.esg-right,\n.grant-fuhr .esg-navigationbutton.esg-left {\n  width: 50px;\n}\n\n.grant-fuhr .esg-navigationbutton.esg-right i,\n.grant-fuhr .esg-navigationbutton.esg-left i {\n  color: #fff;\n}\n\n.grant-fuhr .esg-navigationbutton.esg-right.hovered i,\n.grant-fuhr .esg-navigationbutton.esg-left.hovered i {\n  color: #000;\n}\n\n.grant-fuhr .esg-sortbutton-wrapper,\n.grant-fuhr .esg-cartbutton-wrapper {\n	display: inline-block;\n}\n\n.grant-fuhr .esg-sortbutton-order,\n.grant-fuhr .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: top;\n	border: none;\n	width: 50px;\n	line-height: 40px;\n	border-radius: 0;\n	font-size: 12px;\n	font-weight: 700;\n	color: #999;\n	cursor: pointer;\n	background: #fff157;\n	margin-left: 0;\n  	line-height: 50px;\n}\n\n.grant-fuhr .esg-sortbutton-order.hovered,\n.grant-fuhr .esg-cartbutton-order.hovered {\n  	color: #fff157 !important;\n  	background: #2e2e34 !important;\n}\n\n.grant-fuhr .esg-sortbutton-order:after {\n	border-color: #fff157 transparent transparent transparent;\n}\n\n.grant-fuhr .esg-sortbutton-order.hovered:after {\n  border-color: #2e2e34 transparent transparent transparent;\n}\n\n.grant-fuhr .esg-cartbutton {\n	color: #999;\n	cursor: default !important;\n}\n\n.grant-fuhr .esg-cartbutton .esgicon-basket {\n	color: #999;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.grant-fuhr .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.grant-fuhr .esg-sortbutton,\n.grant-fuhr .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 0px;\n	border-radius: 5px;\n}\n\n.grant-fuhr input.eg-search-input.hovered,\n.grant-fuhr input.eg-search-input:focus,\n.grant-fuhr .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.grant-fuhr .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.grant-fuhr .esg-navigationbutton.hovered,\n.grant-fuhr .esg-filterbutton.hovered,\n.grant-fuhr .esg-sortbutton.hovered,\n.grant-fuhr .esg-sortbutton-order.hovered,\n.grant-fuhr .esg-cartbutton-order.hovered,\n.grant-fuhr .esg-filterbutton.selected,\n.grant-fuhr .esg-cartbutton.hovered,\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	border-color: none;\n	color: #000;\n	background: #fff157;\n}\n\n.grant-fuhr .esg-navigationbutton.hovered * {\n	color: #000;\n}\n\n.grant-fuhr .esg-sortbutton-order.hovered.tp-desc {\n	color: #000;\n}\n\n.grant-fuhr .esg-allfilter.esg-allfilter {\n}\n\n.grant-fuhr .esg-filter-checked {\n	color: #cbcbcb;\n	background: #cbcbcb;\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 300;\n	line-height: 9px;\n	vertical-align: middle;\n}\n\n.grant-fuhr .esg-filterbutton.selected .esg-filter-checked,\n.grant-fuhr .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n	background: #000;\n}\n\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper {\n	white-space: nowrap;\n}\n\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:40px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.grant-fuhr .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n}\n\n.grant-fuhr .esg-dropdown-wrapper {\n	transform: translateZ(10px) translateX(-50%);\n	left: 50%;\n	background:transparent;\n	padding:0px;\n}\n\n.grant-fuhr .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative\n}\n\n.grant-fuhr .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 12px;\n	color:#999;\n}\n.grant-fuhr .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open,\n.grant-fuhr .esg-selected-filterbutton.hovered .eg-icon-down-open {\n	color:#000;\n}\n\n.grant-fuhr .esg-sortbutton:after,\n.grant-fuhr .esg-selected-filterbutton .eg-icon-down-open:before {\n  	content: \"\";\n  	position: absolute;\n  	width: 5px;\n  	height: 5px;\n  	border-left: 1px solid #fff157;\n  	border-bottom: 1px solid #fff157;\n  	transform: rotate(-45deg) translateY(-6px);\n  	right: 15px;\n  	top: 50%\n}\n\n.grant-fuhr .esg-sortbutton.hovered:after,\n.grant-fuhr .esg-selected-filterbutton.hovered .eg-icon-down-open:before,\n.grant-fuhr .esg-filter-wrapper.dropdownstyle:hover .esg-selected-filterbutton .eg-icon-down-open:before {\n  	border-left: 1px solid #000;\n  	border-bottom: 1px solid #000;\n}\n\n.grant-fuhr .esg-dropdown-wrapper .esg-filterbutton {\n  width: 100%;\n  margin: 0;\n}\n\n.grant-fuhr .esg-dropdown-wrapper .esg-filterbutton:before,\n.grant-fuhr .esg-dropdown-wrapper .esg-filterbutton:after {\n  display: none;\n}\n\n.grant-fuhr .esg-filter-wrapper.dropdownstyle:hover .esg-selected-filterbutton {\n  background: #fff157;\n  color: #000;\n}\n\n", NULL);
INSERT INTO `wp_eg_navigation_skins` VALUES("11", "Leon Draisaitl", "leon-draisaitl", "/*************************************\n	-	LEON DRAISAITL 3.0.0 SKIN   -\n*************************************/\n@import url(\"https://fonts.googleapis.com/css2?family=Roboto+Mono:wght@400;500&display=swap\");\n@import url(\"https://fonts.googleapis.com/icon?family=Material+Icons\");\n\n\n\n.leon-draisaitl .esg-overflowtrick {\n  margin: 20px 0;\n}\n\n.leon-draisaitl .navigationbuttons,\n.leon-draisaitl .esg-pagination,\n.leon-draisaitl .esg-filters {\n	text-align: center;\n}\n\n.leon-draisaitl .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.leon-draisaitl input.eg-search-input,\n.leon-draisaitl .esg-filterbutton,\n.leon-draisaitl .esg-navigationbutton,\n.leon-draisaitl .esg-sortbutton,\n.leon-draisaitl .esg-cartbutton,\n.leon-draisaitl .esg-sortbutton-order,\n.leon-draisaitl .esg-cartbutton-order,\n.leon-draisaitl .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.leon-draisaitl .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #000;\n	cursor: pointer;\n	padding: 0px 20px;\n	border: 2px solid #000;\n	line-height: 50px;\n	font-size: 16px;\n	font-weight: 500;\n	font-family: \"Roboto Mono\", monospace;\n 	display: inline-block;\n	background: transparent;\n	margin: -2px -2px 0 0 !important;\n	white-space: nowrap;\n	min-height: 50px;\n	vertical-align: middle;\n  	min-width: 54px;\n  	box-shadow: inset 0px 0px 0px 0px #000;\n  	transition: all 0.4s ease;\n}\n\n.leon-draisaitl .esg-sortbutton-wrapper,\n.leon-draisaitl .esg-filter-wrapper,\n.leon-draisaitl .esg-cartbutton-wrapper {\n  margin: 0 !important;\n}\n\n.leon-draisaitl .esg-cartbutton a {\n	color:#000;\n}\n\n.leon-draisaitl input.eg-search-input::placeholder {\n	line-height: 30px;\n	vertical-align: middle;\n	color:#000;\n}\n\n.leon-draisaitl input.eg-search-input.hovered::placeholder {\n  color: #fff;\n}\n\n.leon-draisaitl .esg-navigationbutton * {\n	color: #000;\n}\n\n.leon-draisaitl .esg-left,\n.leon-draisaitl .esg-right {\n	color: #000;\n	padding: 0px 7px;\n}\n\n.leon-draisaitl .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.leon-draisaitl .esg-sortbutton-wrapper,\n.leon-draisaitl .esg-cartbutton-wrapper {\n	display: inline-block;\n	vertical-align: top;\n}\n\n.leon-draisaitl .esg-sortbutton-order,\n.leon-draisaitl .esg-cartbutton-order {\n	padding: 0px;\n	width: 29px;\n	font-size: 9px;\n}\n\n.leon-draisaitl .esg-cartbutton {\n	color: #333;\n	cursor: default !important;\n}\n\n.leon-draisaitl .esg-cartbutton.hovered *,\n.leon-draisaitl .esg-navigationbutton.hovered * {\n  color: #fff !important;\n}\n\n.leon-draisaitl .esg-cartbutton .esgicon-basket {\n	color: #333;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.leon-draisaitl .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.leon-draisaitl .esg-sortbutton,\n.leon-draisaitl .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 5px;\n}\n\n.leon-draisaitl input.eg-search-input.hovered,\n.leon-draisaitl input.eg-search-input:focus,\n.leon-draisaitl .esg-navigationbutton.hovered,\n.leon-draisaitl .esg-filterbutton.hovered,\n.leon-draisaitl .esg-sortbutton.hovered,\n.leon-draisaitl .esg-sortbutton-order.hovered,\n.leon-draisaitl .esg-cartbutton.hovered,\n.leon-draisaitl .esg-filterbutton.selected,\n.leon-draisaitl .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.leon-draisaitl .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.leon-draisaitl .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.leon-draisaitl .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	background-color: #fff;\n	border-color: #000;\n	color: #fff;\n	box-shadow: inset 0px 0px 0px 50px #000;\n}\n\n.leon-draisaitl .esg-cartbutton.hovered a {\n	color:#000;\n}\n\n.leon-draisaitl .esg-navigationbutton.hovered * {\n	color: #333;\n}\n\n.leon-draisaitl .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #bbb;\n	color: #333;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.leon-draisaitl .esg-filter-checked {\n	color: #aaa;\n  	border: 2px solid #000;\n	background: transparent;\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 400;\n	line-height: 14px;\n	vertical-align: middle;\n  	text-align: center;\n  	min-width: 18px;\n  	display: inline-block;\n}\n\n.leon-draisaitl .esg-filterbutton.selected .esg-filter-checked,\n.leon-draisaitl .esg-filterbutton.hovered .esg-filter-checked {\n	color: #000;\n	background: #fff;\n}\n\n.leon-draisaitl .esg-filter-wrapper.eg-search-wrapper {\n	line-height: 30px;\n	white-space: nowrap;\n}\n\n.leon-draisaitl .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.leon-draisaitl .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.leon-draisaitl .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:29px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.leon-draisaitl .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n	border-radius:0px;\n}\n\n.leon-draisaitl .esg-dropdown-wrapper {\n	left: 0px;\n	background: #fff;\n  	border: 2px solid #000;\n  	margin-top: -2px;\n  	padding: 0;\n}\n\n.leon-draisaitl .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	text-align: left;\n	background:transparent;\n	padding: 5px 20px;\n	border:none;\n	box-shadow: none;\n  	box-sizing: border-box;\n}\n\n.leon-draisaitl .esg-dropdown-wrapper .esg-filterbutton.esg-allfilter {\n  width: 100%;\n}\n\n.leon-draisaitl .esg-dropdown-wrapper .esg-filterbutton.selected,\n.leon-draisaitl .esg-dropdown-wrapper .esg-filterbutton.hovered {\n  background: #000;\n}\n\n.leon-draisaitl .esg-dropdown-wrapper .esg-filterbutton .esg-filter-checked {\n  margin: 0 10px 0 -2px;\n}\n\n.leon-draisaitl .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 9px;\n	color:#000;\n}\n.leon-draisaitl .esg-selected-filterbutton.hovered .eg-icon-down-open,\n.leon-draisaitl .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open {\n	color: #fff;\n}\n\n.leon-draisaitl .esg-sortbutton-order.eg-icon-down-open:before {\n    content: \"arrow_downward\";\n    font-family: \"Material Icons\";\n  	font-size: 19px;\n  	vertical-align: middle;\n}\n\n", NULL);
INSERT INTO `wp_eg_navigation_skins` VALUES("12", "Uwe Krupp", "uwe-krupp", "/*************************************\n	-	UWE KRUPP 3.0.0 SKIN   -\n*************************************/\n@import url(\"https://fonts.googleapis.com/css2?family=Arvo:wght@400;700&display=swap\");\n@import url(\"https://fonts.googleapis.com/icon?family=Material+Icons\");\n\n\n\n.uwe-krupp .esg-overflowtrick {\n  margin: 50px 0;\n}\n\n.uwe-krupp .navigationbuttons,\n.uwe-krupp .esg-pagination,\n.uwe-krupp .esg-filters {\n	text-align: center;\n}\n\n.uwe-krupp .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.uwe-krupp input.eg-search-input,\n.uwe-krupp .esg-filterbutton,\n.uwe-krupp .esg-navigationbutton,\n.uwe-krupp .esg-sortbutton,\n.uwe-krupp .esg-cartbutton,\n.uwe-krupp .esg-sortbutton-order,\n.uwe-krupp .esg-cartbutton-order,\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #6a666b;\n  	letter-spacing: 1px;\n	margin-right: 5px;\n	cursor: pointer;\n	padding: 0px 15px;\n	line-height: 40px;\n	font-size: 13px;\n	font-weight: 400;\n	font-family: \"Arvo\", serif;\n 	display: inline-block;\n	background: rgba(255, 255, 255, 0.65);\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 40px;\n	vertical-align: middle;\n  	min-width: 40px;\n  	border-radius: 12px;\n}\n\n.uwe-krupp .esg-cartbutton a {\n	color:#000;\n}\n\n.uwe-krupp input.eg-search-input::placeholder {\n	line-height: 30px;\n	vertical-align: middle;\n	color: #6a666b;\n}\n\n.uwe-krupp input.eg-search-input:focus::placeholder {\n  opacity: 0;\n}\n\n.uwe-krupp .esg-navigationbutton.esg-right,\n.uwe-krupp .esg-navigationbutton.esg-left {\n  background: #b0a5b4;\n}\n\n.uwe-krupp .esg-navigationbutton.esg-left {\n  border-radius: 0 12px 12px 0px;\n}\n\n.uwe-krupp .esg-navigationbutton.esg-right {\n  border-radius: 12px 0px 0px 12px;\n}\n\n.uwe-krupp .esg-navigationbutton * {\n	color: #000;\n}\n\n.uwe-krupp .esg-left,\n.uwe-krupp .esg-right {\n	color: #000;\n	padding: 0px 7px;\n}\n\n.uwe-krupp .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.uwe-krupp .esg-sortbutton-wrapper,\n.uwe-krupp .esg-cartbutton-wrapper {\n	display: inline-block;\n	vertical-align: top;\n}\n\n.uwe-krupp .esg-sortbutton-order,\n.uwe-krupp .esg-cartbutton-order {\n	padding: 0px;\n	width: 29px;\n	font-size: 9px;\n}\n\n.uwe-krupp .esg-cartbutton {\n	color: #757176;\n	cursor: default !important;\n}\n\n.uwe-krupp .esg-cartbutton .esgicon-basket {\n	color: #757176;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.uwe-krupp .esg-cartbutton .ess-cart-content {\n  color: #757176;\n}\n\n.uwe-krupp .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.uwe-krupp .esg-sortbutton,\n.uwe-krupp .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 5px;\n}\n\n.uwe-krupp input.eg-search-input.hovered,\n.uwe-krupp input.eg-search-input:focus,\n.uwe-krupp .esg-navigationbutton.hovered,\n.uwe-krupp .esg-filterbutton.hovered,\n.uwe-krupp .esg-sortbutton.hovered,\n.uwe-krupp .esg-sortbutton-order.hovered,\n.uwe-krupp .esg-cartbutton.hovered,\n.uwe-krupp .esg-filterbutton.selected,\n.uwe-krupp .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.uwe-krupp .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	background-color: #fff;\n	color: #333;\n}\n\n.uwe-krupp .esg-cartbutton.hovered a {\n	color:#000;\n}\n\n.uwe-krupp .esg-navigationbutton.hovered * {\n	color: #333;\n}\n\n.uwe-krupp .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #bbb;\n	color: #333;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.uwe-krupp .esg-filter-checked {\n	color: #b0a5b4;\n	background: transparent;\n  	border: 1px solid #b0a5b4;\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 400;\n	line-height: 12px;\n 	min-width: 12px;\n	vertical-align: middle;\n  	display: inline-block;\n  	transform: translateY(-1px);\n}\n\n.uwe-krupp .esg-filterbutton.selected .esg-filter-checked,\n.uwe-krupp .esg-filterbutton.hovered .esg-filter-checked {\n	color: #fff;\n	background: #000;\n  	border: 1px solid #000;\n}\n\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper {\n	line-height: 30px;\n	white-space: nowrap;\n}\n\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 5px;\n}\n\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:29px;\n	padding:0px;\n	margin-left: 5px;\n	margin-right:0px;\n}\n\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n	border-radius: 12px 0px 0px 12px;\n  	border: none;\n}\n\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n  border-radius: 0px 12px 12px 0px;\n  margin-left: 0;\n}\n\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper .eg-search-submit.hovered,\n.uwe-krupp .esg-filter-wrapper.eg-search-wrapper .eg-search-clean {\n  background: #b0a5b4;\n  color: #fff;\n}\n\n.uwe-krupp .esg-dropdown-wrapper {\n	left: 0px;\n	background:#fff;\n}\n\n.uwe-krupp .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	text-align: left;\n	background:transparent;\n	padding:0px;\n	border:none;\n	box-shadow: none;\n}\n\n.uwe-krupp .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 9px;\n	color:#000;\n}\n.uwe-krupp .esg-selected-filterbutton.hovered .eg-icon-down-open,\n.uwe-krupp .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open{\n	color:#333;\n}\n\n.uwe-krupp .esg-sortbutton-order.eg-icon-down-open {\n  background: #b0a5b4;\n  color: #fff;\n}\n\n.uwe-krupp .esg-sortbutton-order.eg-icon-down-open:before {\n    content: \"arrow_downward\";\n    font-family: \"Material Icons\";\n  	font-size: 19px;\n  	vertical-align: middle;\n}\n\n", NULL);
INSERT INTO `wp_eg_navigation_skins` VALUES("13", "Clark Gillies", "clark-gillies", "/*************************************\n	-	CLARK GILLIES 3.0.0 SKIN   -\n*************************************/\n@import url(\"https://fonts.googleapis.com/css2?family=Arvo:wght@400;700&display=swap\");\n@import url(\"https://fonts.googleapis.com/icon?family=Material+Icons\");\n\n\n.clark-gillies .navigationbuttons,\n.clark-gillies .esg-pagination,\n.clark-gillies .esg-filters {\n	text-align: center;\n}\n\n.clark-gillies .esg-filters {\n  margin-bottom: 20px !important;\n}\n\n.clark-gillies .esg-filter-wrapper {\n  margin: 0 !important;\n}\n\n.clark-gillies .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.clark-gillies input.eg-search-input,\n.clark-gillies .esg-filterbutton,\n.clark-gillies .esg-navigationbutton,\n.clark-gillies .esg-sortbutton,\n.clark-gillies .esg-cartbutton,\n.clark-gillies .esg-sortbutton-order,\n.clark-gillies .esg-cartbutton-order,\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #000;\n	margin: 0 10px 0 0 !important;\n	cursor: pointer;\n	padding: 0px 10px;\n  	border: none;\n	line-height: 28px;\n	font-size: 13px;\n	font-weight: 400;\n	font-family: \"Arvo\", serif;\n 	display: inline-block;\n	background: transparent;\n	white-space: nowrap;\n	min-height: 28px;\n	vertical-align: middle;\n  	letter-spacing: -0.5px;\n  	min-width: 24px;\n  	position: relative;\n  	transition: all 0.3s ease;\n}\n\n.clark-gillies .esg-filterbutton:before,\n.clark-gillies .esg-selected-filterbutton:before,\n.clark-gillies .esg-sortbutton:before {\n  content: \"\";\n  position: absolute;\n  z-index: -1;\n  height: 2px;\n  width: calc(100% - 20px);\n  left: 10px;\n  bottom: 0;\n  background: #000;\n  transition: all 0.3s ease;\n}\n\n.clark-gillies .esg-filterbutton.hovered:before,\n.clark-gillies .esg-filterbutton.selected:before,\n.clark-gillies .esg-filter-wrapper:hover .esg-selected-filterbutton:before,\n.clark-gillies .esg-sortbutton.hovered:before{\n  width: 100%;\n  height: 100%;\n  left: 0;\n}\n\n.clark-gillies .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open {\n  color: #fff !important;\n}\n\n.clark-gillies .esg-cartbutton a {\n	color:#fff;\n}\n\n.clark-gillies input.eg-search-input::placeholder {\n	line-height: 30px;\n	vertical-align: middle;\n	color:#000;\n}\n\n.clark-gillies input.eg-search-input:focus::placeholder {\n  opacity: 0;\n}\n\n.clark-gillies .esg-navigationbutton {\n  min-width: 28px;\n}\n\n.clark-gillies .esg-navigationbutton * {\n	color: #fff;\n}\n\n.clark-gillies .esg-left,\n.clark-gillies .esg-right,\n.clark-gillies .esg-loadmore {\n	color: #fff;\n	padding: 2px 7px;\n  	transition: all 0.3s ease;\n  	box-shadow: inset 0 0 0 20px #000;\n}\n.clark-gillies .esg-left.hovered,\n.clark-gillies .esg-right.hovered,\n.clark-gillies .esg-loadmore.hovered {\n  color: #000 !important;\n  box-shadow: inset 0 0 0 2px #000;\n}\n\n.clark-gillies .esg-loadmore {\n  padding: 0 10px;\n}\n\n.clark-gillies .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.clark-gillies .esg-sortbutton-wrapper,\n.clark-gillies .esg-cartbutton-wrapper {\n	display: inline-block;\n	vertical-align: top;\n}\n\n.clark-gillies .esg-sortbutton-order,\n.clark-gillies .esg-cartbutton-order,\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper .eg-search-clean {\n	padding: 0px;\n	min-width: 30px;\n	font-size: 9px;\n  	transition: all 0.3s ease;\n  	box-shadow: inset 0 0 0 2px #000;\n  	margin-right: 20px !important;\n}\n\n.clark-gillies .esg-sortbutton-order.hovered,\n.clark-gillies .esg-cartbutton-order.hovered,\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper .eg-search-clean.hovered {\n  	box-shadow: inset 0 0 0 20px #000\n}\n\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper .eg-search-clean {\n  font-size: 12px;\n  line-height: 28px !important;\n}\n\n.clark-gillies .esg-sortbutton-order.eg-icon-down-open:before {\n    content: \"arrow_downward\";\n    font-family: \"Material Icons\";\n  	font-size: 19px;\n  	vertical-align: middle;\n}\n\n.clark-gillies .esg-cartbutton {\n	color: #fff;\n	cursor: default !important;\n  	transition: all 0.3s ease;\n  	box-shadow: inset 0 0 0 20px #000;\n}\n\n.clark-gillies .esg-cartbutton.hovered {\n  	box-shadow: inset 0 0 0 2px #000;\n}\n\n.clark-gillies .esg-cartbutton .ess-cart-content {\n  	color: #fff;\n}\n\n.clark-gillies .esg-cartbutton.hovered .ess-cart-content {\n  	color: #000;\n}\n\n.clark-gillies .esg-cartbutton .esgicon-basket {\n	color: #fff;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.clark-gillies .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.clark-gillies .esg-sortbutton,\n.clark-gillies .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n	margin-right: 0 !important;\n}\n\n.clark-gillies input.eg-search-input.hovered,\n.clark-gillies input.eg-search-input:focus,\n.clark-gillies .esg-navigationbutton.hovered,\n.clark-gillies .esg-filterbutton.hovered,\n.clark-gillies .esg-sortbutton.hovered,\n.clark-gillies .esg-sortbutton-order.hovered,\n.clark-gillies .esg-cartbutton.hovered,\n.clark-gillies .esg-filterbutton.selected,\n.clark-gillies .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.clark-gillies .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	color: #fff;\n}\n\n.clark-gillies .esg-cartbutton.hovered a {\n	color:#000;\n}\n\n.clark-gillies .esg-navigationbutton.hovered * {\n	color: #333;\n}\n\n.clark-gillies .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #bbb;\n	color: #333;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.clark-gillies .esg-filter-checked {\n	color: #000;\n	margin-left: 10px;\n	font-size: 9px;\n	font-weight: 400;\n	line-height: 20px;\n	vertical-align: middle;\n  	border: 1px solid #000;\n  	background: transparent;\n  	padding: 1px 0;\n}\n\n.clark-gillies .esg-filterbutton.selected .esg-filter-checked,\n.clark-gillies .esg-filterbutton.hovered .esg-filter-checked,\n.clark-gillies .esg-dropdown-wrapper .esg-filter-checked {\n	color: #000;\n	background: #fff;\n}\n\n.clark-gillies .esg-dropdown-wrapper .esg-filter-checked {\n  margin-left: 0;\n}\n\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper {\n	line-height: 22px;\n	white-space: nowrap;\n}\n\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	margin-left: 0;\n  	border-bottom: 2px solid #000;\n}\n\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width: 29px;\n	padding: 0px;\n	margin-left: 0px;\n	margin-right: 0px;\n  	min-height: 26px;\n  	line-height: 26px;\n}\n\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width: auto;\n	border-radius: 0px;\n  	border-bottom: 2px solid #000;\n  	margin: 0 !important;\n  	padding: 2px 0;\n  	min-height: 22px;\n  	line-height: 22px;\n  	font-size: 13px;\n}\n\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper .eg-search-input:focus,\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper .eg-search-input:active,\n.clark-gillies .esg-filter-wrapper.eg-search-wrapper .eg-search-input.hovered {\n  color: #000;\n}\n\n.clark-gillies .esg-dropdown-wrapper {\n	left: 0px;\n	background: #000;\n 	width: 100%;\n}\n\n.clark-gillies .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	text-align: left;\n	background: transparent;\n	padding: 0px;\n	border: none;\n	box-shadow: none;\n  	color: #fff;\n}\n\n.clark-gillies .esg-dropdown-wrapper .esg-filterbutton.hovered {\n  opacity: 0.6;\n}\n\n.clark-gillies .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	font-size: 9px;\n	color:#000;\n}\n.clark-gillies .esg-selected-filterbutton.hovered .eg-icon-down-open,\n.clark-gillies .esg-selected-filterbutton.hoveredfilter .eg-icon-down-open{\n	color:#333;\n}\n\n.clark-gillies .esg-filterbutton .eg-el-amount:before,\n.clark-gillies .esg-filterbutton .eg-el-amount:after {\n  content: \"\";\n}\n\n", NULL);
INSERT INTO `wp_eg_navigation_skins` VALUES("14", "Rod Langway", "rod-langway", "/*************************************\n	-	ROD LANGWAY 3.0.0 SKIN	-\n*************************************/\n@import url(\"https://fonts.googleapis.com/css2?family=Josefin+Sans:wght@400;500;700&display=swap\");\n@import url(\"https://fonts.googleapis.com/icon?family=Material+Icons\");\n\n\n\n.rod-langway .esg-overflowtrick {\n  margin: 20px 0;\n}\n\n.rod-langway .navigationbuttons,\n.rod-langway .esg-pagination,\n.rod-langway .esg-filters {\n	text-align: center;\n}\n\n.rod-langway .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.rod-langway input.eg-search-input,\n.rod-langway .esg-filterbutton,\n.rod-langway .esg-navigationbutton,\n.rod-langway .esg-sortbutton,\n.rod-langway .esg-cartbutton,\n.rod-langway .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.rod-langway .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: #000;\n	margin-right: 0;\n	cursor: pointer;\n	padding: 4px 17px 0;\n	border: none;\n  	box-sizing: border-box;\n	line-height: 35px;\n	font-size: 10px;\n  	text-transform: uppercase;\n  	letter-spacing: 3px;\n	font-weight: 700;\n	font-family: \"Josefin Sans\", sans-serif;\n	display: inline-block;\n	background: #fff;\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 40px;\n	vertical-align: middle;\n  	border-radius: 0;\n}\n.rod-langway  .esg-filterbutton .eg-el-amount {\n  background: #ced3d7;\n  display: inline-block;\n  line-height: 24px;\n  min-width: 26px;\n  padding-top: 2px;\n  text-align: center;\n  font-weight: 500;\n  font-size: 12px;\n  letter-spacing: 0;\n}\n\n.rod-langway  .esg-filterbutton.hovered .eg-el-amount,\n.rod-langway  .esg-filterbutton.selected .eg-el-amount {\n  background: #2f2f3a;\n  color: #fff;\n}\n\n.rod-langway .esg-filterbutton .eg-el-amount:before,\n.rod-langway .esg-filterbutton .eg-el-amount:after {\n  content: \"\";\n}\n\n.rod-langway .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.rod-langway .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n  margin-left: 0 !important;\n  font-size: 14px;\n  letter-spacing: 0;\n  line-height: 40px;\n}\n\n.rod-langway .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.rod-langway .esg-cartbutton {\n  background: #ced3d7;\n}\n\n.rod-langway .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.rod-langway .esg-cartbutton.hovered {\n  background: #b0b5b9 !important;\n}\n\n.rod-langway .esg-cartbutton a {\n	color: #000;\n}\n\n.rod-langway .esg-cartbutton a:hover {\n	color: #000;\n}\n\n.rod-langway input.eg-search-input::placeholder {\n	line-height: 38px;\n	vertical-align: middle;\n	color: #b0b5b9;\n}\n\n.rod-langway input.eg-search-input:focus::placeholder {\n  opacity: 0;\n}\n\n.rod-langway .esg-navigationbutton {\n  line-height: 40px;\n  min-width: 40px;\n  letter-spacing: 0;\n  font-size: 14px;\n  font-weight: 400;\n}\n\n.rod-langway .esg-navigationbutton.esg-left {\n  transform: translateX(-40px)\n}\n\n.rod-langway .esg-navigationbutton.esg-right {\n  transform: translateX(40px)\n}\n\n.rod-langway .esg-navigationbutton * {\n	color: #000;\n\n}\n\n.rod-langway .esg-navigationbutton.hovered i {\n	color: #000;\n}\n\n.rod-langway .esg-navigationbutton {\n	padding: 0px 11px;\n}\n\n.rod-langway .esg-pagination-button {\n	padding: 0px 16px;\n}\n\n.rod-langway .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.rod-langway .esg-sortbutton-wrapper,\n.rod-langway .esg-cartbutton-wrapper {\n	display: inline-block;\n}\n\n.rod-langway .esg-sortbutton-order,\n.rod-langway .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: top;\n	width: 40px;\n	line-height: 40px;\n	border-radius: 0;\n  	border: none;\n	font-size: 12px;\n	font-weight: 600;\n	color: #000;\n	cursor: pointer;\n  	background: #ced3d7;\n}\n\n.rod-langway .esg-sortbutton-order.hovered,\n.rod-langway .esg-cartbutton-order.hovered {\n  background: #b0b5b9 !important;\n}\n\n.rod-langway .esg-cartbutton {\n	color: #fff;\n	cursor: default !important;\n}\n\n.rod-langway .esg-cartbutton .esgicon-basket {\n	color: #fff;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.rod-langway .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.rod-langway .esg-sortbutton,\n.rod-langway .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n}\n\n.rod-langway .esg-sortbutton{\n	margin-right: 0px;\n	border-right: none;\n	border-radius: 0;\n}\n\n.rod-langway .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.rod-langway .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.rod-langway .esg-navigationbutton.hovered,\n.rod-langway .esg-filterbutton.hovered,\n.rod-langway .esg-sortbutton.hovered,\n.rod-langway .esg-sortbutton-order.hovered,\n.rod-langway .esg-cartbutton-order.hovered,\n.rod-langway .esg-filterbutton.selected,\n.rod-langway .esg-cartbutton.hovered,\n.rod-langway .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.rod-langway .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	color: #000;\n	box-shadow: none;\n	background: #ced3d7;\n}\n\n.rod-langway .esg-navigationbutton.hovered * {\n	color: #fff;\n}\n\n.rod-langway .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #fff;\n	border-color: rgba(255, 255, 255, 0.2);\n	color: #fff;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.rod-langway .esg-filter-checked {\n	color: #ced3d7;\n  	border: 1px solid #333;\n  	letter-spacing: 0;\n	background: transparent;\n	font-size: 9px;\n	font-weight: 300;\n	vertical-align: middle;\n  	line-height: 14px;\n	margin-left: 7px;\n  	display: inline-block;\n  	width: 14px;\n  	height: 14px;\n  	transform: translateY(-2px);\n}\n\n.rod-langway .esg-filter-wrapper.dropdownstyle .esg-filter-checked {\n	margin-left: 0;\n	margin-right: 10px;\n	border:1px solid rgba(255,255,255,.2);\n}\n\n.rod-langway .esg-filterbutton.selected .esg-filter-checked,\n.rod-langway .esg-filterbutton.hovered .esg-filter-checked {\n	color: #000;\n  	border: 1px solid #000;\n}\n\n/* */\n.rod-langway .esg-filter-wrapper.eg-search-wrapper {\n	white-space: nowrap;\n}\n\n\n.rod-langway .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.rod-langway .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:40px;\n	padding:0px;\n	margin-left:5px;\n	margin-right:0px;\n}\n\n.rod-langway .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n}\n\n.rod-langway .esg-dropdown-wrapper {\n	transform: translateZ(10px) translateX(-50%);\n	left: 50%;\n	background: #000;\n	border-radius: 0;\n  	padding: 0;\n}\n\n.rod-langway .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	border: none;\n	box-shadow: none;\n	text-align: left;\n	color: #fff;\n	background: transparent;\n	line-height: 25px;\n	min-height: 25px;\n  	padding: 10px 20px;\n  	display: inline-block;\n  	width: 100%;\n  	box-sizing: border-box;\n  	margin: 0;\n}\n\n.rod-langway .esg-dropdown-wrapper .esg-filterbutton.hovered,\n.rod-langway .esg-dropdown-wrapper .esg-filterbutton.selected {\n	color: #000;\n  	background: #fff;\n}\n\n\n.rod-langway .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	color: #000;\n	font-size: 11px;\n}\n\n.rod-langway .esg-sortbutton-order.eg-icon-down-open:before {\n    content: \"arrow_downward\";\n    font-family: \"Material Icons\";\n  	font-size: 19px;\n  	vertical-align: middle;\n}\n\n", NULL);
INSERT INTO `wp_eg_navigation_skins` VALUES("15", "Ray Bourge", "ray-bourque", "/**************************************\n	-	RAY BOURGE V3.0.0 SKIN    -\n**************************************/\n@import url(\"https://fonts.googleapis.com/css2?family=Barlow+Condensed:wght@400;500&display=swap\");\n@import url(\"https://fonts.googleapis.com/icon?family=Material+Icons\");\n\n\n\n.ray-bourque .esg-overflowtrick {\n  margin: 20px 0;\n}\n\n.ray-bourque .navigationbuttons,\n.ray-bourque .esg-pagination,\n.ray-bourque .esg-filters {\n	text-align: center;\n}\n\n.ray-bourque .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton,\n.ray-bourque input.eg-search-input,\n.ray-bourque .esg-filterbutton,\n.ray-bourque .esg-navigationbutton,\n.ray-bourque .esg-sortbutton,\n.ray-bourque .esg-cartbutton,\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n	color: rgba(255, 255, 255, 1);\n	margin-right: 0;\n	cursor: pointer;\n	padding: 0px 17px;\n	border: none;\n	line-height: 40px;\n	font-size: 13px;\n  	letter-spacing: 1px;\n	font-weight: 400;\n	font-family: \"Barlow Condensed\", sans-serif;\n	display: inline-block;\n	background: #000;\n	margin-bottom: 5px;\n	white-space: nowrap;\n	min-height: 40px;\n	vertical-align: middle;\n  	border-radius: 0;\n}\n.ray-bourque  .esg-filterbutton .eg-el-amount {\n  background: #2d2b2b;\n  display: inline-block;\n  line-height: 22px;\n  min-width: 22px;\n  text-align: center;\n  font-weight: 500;\n}\n\n.ray-bourque  .esg-filterbutton.hovered .eg-el-amount,\n.ray-bourque  .esg-filterbutton.selected .eg-el-amount {\n  background: #eaedf1;\n}\n\n.ray-bourque  .esg-filterbutton .eg-el-amount:before,\n.ray-bourque  .esg-filterbutton .eg-el-amount:after {\n  content: \"\";\n}\n\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean,\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit {\n  margin-left: 0 !important;\n}\n\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean {\n  background: #434242;\n}\n\n.ray-bourque .esg-cartbutton a {\n	color: #fff;\n}\n\n.ray-bourque .esg-cartbutton a:hover {\n	color: #000;\n}\n\n.ray-bourque input.eg-search-input::placeholder {\n	line-height: 38px;\n	vertical-align: middle;\n	color:#fff;\n}\n\n.ray-bourque input.eg-search-input:focus::placeholder {\n  opacity: 0;\n}\n\n.ray-bourque .esg-navigationbutton * {\n	color: rgba(255, 255, 255, 1);\n}\n\n.ray-bourque .esg-navigationbutton.hovered i {\n	color: #000;\n}\n\n.ray-bourque .esg-navigationbutton {\n	padding: 0px 11px;\n}\n\n.ray-bourque .esg-pagination-button {\n	padding: 0px 16px;\n}\n\n.ray-bourque .esg-pagination-button:last-child {\n	margin-right: 0;\n}\n\n.ray-bourque .esg-sortbutton-wrapper,\n.ray-bourque .esg-cartbutton-wrapper {\n	display: inline-block;\n}\n\n.ray-bourque .esg-sortbutton-order,\n.ray-bourque .esg-cartbutton-order {\n	display: inline-block;\n	vertical-align: top;\n	width: 40px;\n	line-height: 38px;\n	border-radius: 0;\n  	border: none;\n	font-size: 12px;\n	font-weight: 600;\n	color: #fff;\n	cursor: pointer;\n	background: #434242;\n}\n\n.ray-bourque .esg-cartbutton {\n	color: #fff;\n	cursor: default !important;\n}\n\n.ray-bourque .esg-cartbutton .esgicon-basket {\n	color: #fff;\n	font-size: 15px;\n	line-height: 15px;\n	margin-right: 10px;\n}\n\n.ray-bourque .esg-cartbutton-wrapper {\n	cursor: default !important;\n}\n\n.ray-bourque .esg-sortbutton,\n.ray-bourque .esg-cartbutton {\n	display: inline-block;\n	position: relative;\n	cursor: pointer;\n}\n.ray-bourque .esg-sortbutton{\n	margin-right: 0px;\n	border-right: none;\n	border-radius: 0;\n}\n\n.ray-bourque .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hovered,\n.ray-bourque .esg-filter-wrapper.dropdownstyle>.esg-selected-filterbutton.hoveredfilter,\n.ray-bourque .esg-navigationbutton.hovered,\n.ray-bourque .esg-filterbutton.hovered,\n.ray-bourque .esg-sortbutton.hovered,\n.ray-bourque .esg-sortbutton-order.hovered,\n.ray-bourque .esg-cartbutton-order.hovered,\n.ray-bourque .esg-filterbutton.selected,\n.ray-bourque .esg-cartbutton.hovered,\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper  .eg-search-clean.hovered,\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper  .eg-search-submit.hovered {\n	color: #000;\n	box-shadow: none;\n	background: #fff;\n}\n\n.ray-bourque .esg-navigationbutton.hovered * {\n	color: #fff;\n}\n\n.ray-bourque .esg-sortbutton-order.hovered .tp-desc {\n	border-color: #fff;\n	border-color: rgba(255, 255, 255, 0.2);\n	color: #fff;\n	box-shadow: 0px -3px 5px 0px rgba(0, 0, 0, 0.13) !important;\n}\n\n.ray-bourque .esg-filter-checked {\n	color: rgba(255,255,255,.5);\n  	border: 1px solid rgba(255,255,255,.5);\n	background: transparent;\n	font-size: 9px;\n	font-weight: 300;\n	vertical-align: middle;\n  	line-height: 12px;\n	margin-left: 7px;\n  	display: inline-block;\n  	width: 14px;\n  	height: 14px;\n  	transform: translateY(-2px);\n}\n\n.ray-bourque .esg-filter-wrapper.dropdownstyle .esg-filter-checked {\n	margin-left: 0;\n	margin-right: 10px;\n	border:1px solid rgba(255,255,255,.2);\n}\n\n.ray-bourque .esg-filterbutton.selected .esg-filter-checked,\n.ray-bourque .esg-filterbutton.hovered .esg-filter-checked {\n	color: #000;\n  	border: 1px solid #000;\n}\n\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper {\n	white-space: nowrap;\n}\n\n\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper .eg-search-clean,\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper .eg-search-submit {\n	width:40px;\n	padding:0px;\n	margin-left:5px;\n	margin-right:0px;\n}\n\n.ray-bourque .esg-filter-wrapper.eg-search-wrapper .eg-search-input {\n	width:auto;\n}\n\n.ray-bourque .esg-dropdown-wrapper {\n	transform: translateZ(10px) translateX(-50%);\n	left: 50%;\n	background: #000;\n	border-radius: 0;\n  	padding: 0;\n}\n\n.ray-bourque .esg-dropdown-wrapper .esg-filterbutton {\n	position: relative;\n	border: none;\n	box-shadow: none;\n	text-align: left;\n	color: #fff;\n	background: transparent;\n	line-height: 25px;\n	min-height: 25px;\n  	padding: 10px 20px;\n  	display: inline-block;\n  	width: 100%;\n  	box-sizing: border-box;\n  	margin: 0;\n}\n\n.ray-bourque .esg-dropdown-wrapper .esg-filterbutton.hovered,\n.ray-bourque .esg-dropdown-wrapper .esg-filterbutton.selected {\n	color: #000;\n  	background: #fff;\n}\n\n\n.ray-bourque .esg-selected-filterbutton .eg-icon-down-open {\n	margin-right: -10px;\n	color:#fff;\n	font-size:12px;\n}\n\n.ray-bourque .esg-sortbutton-order.eg-icon-down-open:before {\n    content: \"arrow_downward\";\n    font-family: \"Material Icons\";\n  	font-size: 19px;\n  	vertical-align: middle;\n}\n\n", NULL);

/* INSERT TABLE DATA: wp_gla_budget_recommendations */
INSERT INTO `wp_gla_budget_recommendations` VALUES("1", "AED", "US", "80", "225");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2", "AED", "CH", "75", "195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3", "AED", "AU", "70", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4", "AED", "GB", "60", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("5", "AED", "DE", "60", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("6", "AED", "DK", "55", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("7", "AED", "AT", "40", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("8", "AED", "NO", "45", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("9", "AED", "CA", "50", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("10", "AED", "NL", "55", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("11", "AED", "SE", "40", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("12", "AED", "IE", "40", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("13", "AED", "BE", "40", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("14", "AED", "FI", "30", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("15", "AED", "FR", "35", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("16", "AED", "NZ", "35", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("17", "AED", "HK", "35", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("18", "AED", "CZ", "30", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("19", "AED", "SK", "30", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("20", "AED", "AE", "30", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("21", "AED", "SG", "35", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("22", "AED", "IL", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("23", "AED", "KW", "15", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("24", "AED", "IT", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("25", "AED", "JP", "25", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("26", "AED", "ES", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("27", "AED", "VE", "5", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("28", "AED", "HU", "20", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("29", "AED", "PT", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("30", "AED", "GR", "25", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("31", "AED", "KR", "30", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("32", "AED", "TW", "25", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("33", "AED", "PL", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("34", "AED", "ZM", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("35", "AED", "PR", "5", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("36", "AED", "CI", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("37", "AED", "RO", "20", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("38", "AED", "BH", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("39", "AED", "PA", "5", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("40", "AED", "GH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("41", "AED", "KH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("42", "AED", "SN", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("43", "AED", "SA", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("44", "AED", "RU", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("45", "AED", "UG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("46", "AED", "BR", "15", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("47", "AED", "NI", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("48", "AED", "MG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("49", "AED", "DO", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("50", "AED", "MX", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("51", "AED", "OM", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("52", "AED", "CM", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("53", "AED", "ZA", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("54", "AED", "CL", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("55", "AED", "KE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("56", "AED", "NP", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("57", "AED", "PE", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("58", "AED", "UA", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("59", "AED", "MZ", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("60", "AED", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("61", "AED", "AO", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("62", "AED", "JO", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("63", "AED", "ZW", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("64", "AED", "TR", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("65", "AED", "MU", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("66", "AED", "SV", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("67", "AED", "TH", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("68", "AED", "CO", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("69", "AED", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("70", "AED", "CR", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("71", "AED", "AR", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("72", "AED", "MA", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("73", "AED", "MY", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("74", "AED", "KZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("75", "AED", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("76", "AED", "ID", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("77", "AED", "NG", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("78", "AED", "GT", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("79", "AED", "VN", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("80", "AED", "BY", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("81", "AED", "EG", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("82", "AED", "UY", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("83", "AED", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("84", "AED", "PK", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("85", "AED", "PH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("86", "AED", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("87", "AED", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("88", "AED", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("89", "AED", "IN", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("90", "AED", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("91", "AED", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("92", "AED", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("93", "AED", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("94", "AED", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("95", "ARS", "US", "1860", "5245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("96", "ARS", "CH", "1735", "4560");
INSERT INTO `wp_gla_budget_recommendations` VALUES("97", "ARS", "AU", "1575", "4050");
INSERT INTO `wp_gla_budget_recommendations` VALUES("98", "ARS", "GB", "1375", "3520");
INSERT INTO `wp_gla_budget_recommendations` VALUES("99", "ARS", "DE", "1365", "3490");
INSERT INTO `wp_gla_budget_recommendations` VALUES("100", "ARS", "DK", "1255", "3115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("101", "ARS", "AT", "915", "2845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("102", "ARS", "NO", "1040", "2900");
INSERT INTO `wp_gla_budget_recommendations` VALUES("103", "ARS", "CA", "1150", "3520");
INSERT INTO `wp_gla_budget_recommendations` VALUES("104", "ARS", "NL", "1230", "3115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("105", "ARS", "SE", "985", "2660");
INSERT INTO `wp_gla_budget_recommendations` VALUES("106", "ARS", "IE", "975", "2565");
INSERT INTO `wp_gla_budget_recommendations` VALUES("107", "ARS", "BE", "895", "2620");
INSERT INTO `wp_gla_budget_recommendations` VALUES("108", "ARS", "FI", "670", "2030");
INSERT INTO `wp_gla_budget_recommendations` VALUES("109", "ARS", "FR", "830", "2215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("110", "ARS", "NZ", "845", "2480");
INSERT INTO `wp_gla_budget_recommendations` VALUES("111", "ARS", "HK", "765", "2165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("112", "ARS", "CZ", "730", "1755");
INSERT INTO `wp_gla_budget_recommendations` VALUES("113", "ARS", "SK", "690", "1495");
INSERT INTO `wp_gla_budget_recommendations` VALUES("114", "ARS", "AE", "650", "2040");
INSERT INTO `wp_gla_budget_recommendations` VALUES("115", "ARS", "SG", "850", "2510");
INSERT INTO `wp_gla_budget_recommendations` VALUES("116", "ARS", "IL", "740", "1810");
INSERT INTO `wp_gla_budget_recommendations` VALUES("117", "ARS", "KW", "335", "1630");
INSERT INTO `wp_gla_budget_recommendations` VALUES("118", "ARS", "IT", "505", "1330");
INSERT INTO `wp_gla_budget_recommendations` VALUES("119", "ARS", "JP", "630", "1795");
INSERT INTO `wp_gla_budget_recommendations` VALUES("120", "ARS", "ES", "520", "1370");
INSERT INTO `wp_gla_budget_recommendations` VALUES("121", "ARS", "VE", "70", "1050");
INSERT INTO `wp_gla_budget_recommendations` VALUES("122", "ARS", "HU", "435", "1015");
INSERT INTO `wp_gla_budget_recommendations` VALUES("123", "ARS", "PT", "435", "1135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("124", "ARS", "GR", "540", "1100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("125", "ARS", "KR", "665", "1755");
INSERT INTO `wp_gla_budget_recommendations` VALUES("126", "ARS", "TW", "540", "1440");
INSERT INTO `wp_gla_budget_recommendations` VALUES("127", "ARS", "PL", "460", "1140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("128", "ARS", "ZM", "65", "380");
INSERT INTO `wp_gla_budget_recommendations` VALUES("129", "ARS", "PR", "165", "1530");
INSERT INTO `wp_gla_budget_recommendations` VALUES("130", "ARS", "CI", "90", "365");
INSERT INTO `wp_gla_budget_recommendations` VALUES("131", "ARS", "RO", "425", "1025");
INSERT INTO `wp_gla_budget_recommendations` VALUES("132", "ARS", "BH", "190", "1065");
INSERT INTO `wp_gla_budget_recommendations` VALUES("133", "ARS", "PA", "130", "1465");
INSERT INTO `wp_gla_budget_recommendations` VALUES("134", "ARS", "GH", "155", "430");
INSERT INTO `wp_gla_budget_recommendations` VALUES("135", "ARS", "KH", "90", "425");
INSERT INTO `wp_gla_budget_recommendations` VALUES("136", "ARS", "SN", "65", "465");
INSERT INTO `wp_gla_budget_recommendations` VALUES("137", "ARS", "SA", "275", "1060");
INSERT INTO `wp_gla_budget_recommendations` VALUES("138", "ARS", "RU", "275", "875");
INSERT INTO `wp_gla_budget_recommendations` VALUES("139", "ARS", "UG", "65", "340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("140", "ARS", "BR", "295", "720");
INSERT INTO `wp_gla_budget_recommendations` VALUES("141", "ARS", "NI", "65", "460");
INSERT INTO `wp_gla_budget_recommendations` VALUES("142", "ARS", "MG", "65", "330");
INSERT INTO `wp_gla_budget_recommendations` VALUES("143", "ARS", "DO", "80", "545");
INSERT INTO `wp_gla_budget_recommendations` VALUES("144", "ARS", "MX", "220", "800");
INSERT INTO `wp_gla_budget_recommendations` VALUES("145", "ARS", "OM", "140", "800");
INSERT INTO `wp_gla_budget_recommendations` VALUES("146", "ARS", "CM", "65", "595");
INSERT INTO `wp_gla_budget_recommendations` VALUES("147", "ARS", "ZA", "265", "845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("148", "ARS", "CL", "275", "820");
INSERT INTO `wp_gla_budget_recommendations` VALUES("149", "ARS", "KE", "80", "340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("150", "ARS", "NP", "65", "310");
INSERT INTO `wp_gla_budget_recommendations` VALUES("151", "ARS", "PE", "165", "690");
INSERT INTO `wp_gla_budget_recommendations` VALUES("152", "ARS", "UA", "155", "490");
INSERT INTO `wp_gla_budget_recommendations` VALUES("153", "ARS", "MZ", "65", "645");
INSERT INTO `wp_gla_budget_recommendations` VALUES("154", "ARS", "TZ", "10", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("155", "ARS", "AO", "145", "370");
INSERT INTO `wp_gla_budget_recommendations` VALUES("156", "ARS", "JO", "105", "500");
INSERT INTO `wp_gla_budget_recommendations` VALUES("157", "ARS", "ZW", "65", "355");
INSERT INTO `wp_gla_budget_recommendations` VALUES("158", "ARS", "TR", "170", "460");
INSERT INTO `wp_gla_budget_recommendations` VALUES("159", "ARS", "MU", "85", "295");
INSERT INTO `wp_gla_budget_recommendations` VALUES("160", "ARS", "SV", "65", "355");
INSERT INTO `wp_gla_budget_recommendations` VALUES("161", "ARS", "TH", "250", "790");
INSERT INTO `wp_gla_budget_recommendations` VALUES("162", "ARS", "CO", "125", "495");
INSERT INTO `wp_gla_budget_recommendations` VALUES("163", "ARS", "LK", "60", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("164", "ARS", "CR", "80", "515");
INSERT INTO `wp_gla_budget_recommendations` VALUES("165", "ARS", "AR", "175", "470");
INSERT INTO `wp_gla_budget_recommendations` VALUES("166", "ARS", "MA", "80", "305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("167", "ARS", "MY", "220", "810");
INSERT INTO `wp_gla_budget_recommendations` VALUES("168", "ARS", "KZ", "95", "345");
INSERT INTO `wp_gla_budget_recommendations` VALUES("169", "ARS", "DZ", "75", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("170", "ARS", "ID", "195", "730");
INSERT INTO `wp_gla_budget_recommendations` VALUES("171", "ARS", "NG", "110", "700");
INSERT INTO `wp_gla_budget_recommendations` VALUES("172", "ARS", "GT", "75", "545");
INSERT INTO `wp_gla_budget_recommendations` VALUES("173", "ARS", "VN", "160", "610");
INSERT INTO `wp_gla_budget_recommendations` VALUES("174", "ARS", "BY", "75", "295");
INSERT INTO `wp_gla_budget_recommendations` VALUES("175", "ARS", "EG", "100", "620");
INSERT INTO `wp_gla_budget_recommendations` VALUES("176", "ARS", "UY", "80", "370");
INSERT INTO `wp_gla_budget_recommendations` VALUES("177", "ARS", "BD", "65", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("178", "ARS", "PK", "70", "415");
INSERT INTO `wp_gla_budget_recommendations` VALUES("179", "ARS", "PH", "125", "460");
INSERT INTO `wp_gla_budget_recommendations` VALUES("180", "ARS", "ET", "20", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("181", "ARS", "TN", "75", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("182", "ARS", "LB", "80", "235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("183", "ARS", "IN", "70", "325");
INSERT INTO `wp_gla_budget_recommendations` VALUES("184", "ARS", "PY", "75", "250");
INSERT INTO `wp_gla_budget_recommendations` VALUES("185", "ARS", "UZ", "75", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("186", "ARS", "EC", "75", "260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("187", "ARS", "MM", "75", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("188", "ARS", "GE", "80", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("189", "AUD", "US", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("190", "AUD", "CH", "25", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("191", "AUD", "AU", "25", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("192", "AUD", "GB", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("193", "AUD", "DE", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("194", "AUD", "DK", "20", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("195", "AUD", "AT", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("196", "AUD", "NO", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("197", "AUD", "CA", "15", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("198", "AUD", "NL", "20", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("199", "AUD", "SE", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("200", "AUD", "IE", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("201", "AUD", "BE", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("202", "AUD", "FI", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("203", "AUD", "FR", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("204", "AUD", "NZ", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("205", "AUD", "HK", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("206", "AUD", "CZ", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("207", "AUD", "SK", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("208", "AUD", "AE", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("209", "AUD", "SG", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("210", "AUD", "IL", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("211", "AUD", "KW", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("212", "AUD", "IT", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("213", "AUD", "JP", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("214", "AUD", "ES", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("215", "AUD", "VE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("216", "AUD", "HU", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("217", "AUD", "PT", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("218", "AUD", "GR", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("219", "AUD", "KR", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("220", "AUD", "TW", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("221", "AUD", "PL", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("222", "AUD", "ZM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("223", "AUD", "PR", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("224", "AUD", "CI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("225", "AUD", "RO", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("226", "AUD", "BH", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("227", "AUD", "PA", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("228", "AUD", "GH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("229", "AUD", "KH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("230", "AUD", "SN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("231", "AUD", "SA", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("232", "AUD", "RU", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("233", "AUD", "UG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("234", "AUD", "BR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("235", "AUD", "NI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("236", "AUD", "MG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("237", "AUD", "DO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("238", "AUD", "MX", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("239", "AUD", "OM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("240", "AUD", "CM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("241", "AUD", "ZA", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("242", "AUD", "CL", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("243", "AUD", "KE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("244", "AUD", "NP", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("245", "AUD", "PE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("246", "AUD", "UA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("247", "AUD", "MZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("248", "AUD", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("249", "AUD", "AO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("250", "AUD", "JO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("251", "AUD", "ZW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("252", "AUD", "TR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("253", "AUD", "MU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("254", "AUD", "SV", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("255", "AUD", "TH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("256", "AUD", "CO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("257", "AUD", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("258", "AUD", "CR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("259", "AUD", "AR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("260", "AUD", "MA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("261", "AUD", "MY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("262", "AUD", "KZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("263", "AUD", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("264", "AUD", "ID", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("265", "AUD", "NG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("266", "AUD", "GT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("267", "AUD", "VN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("268", "AUD", "BY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("269", "AUD", "EG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("270", "AUD", "UY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("271", "AUD", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("272", "AUD", "PK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("273", "AUD", "PH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("274", "AUD", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("275", "AUD", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("276", "AUD", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("277", "AUD", "IN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("278", "AUD", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("279", "AUD", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("280", "AUD", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("281", "AUD", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("282", "AUD", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("283", "BGN", "US", "35", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("284", "BGN", "CH", "35", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("285", "BGN", "AU", "30", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("286", "BGN", "GB", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("287", "BGN", "DE", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("288", "BGN", "DK", "25", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("289", "BGN", "AT", "15", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("290", "BGN", "NO", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("291", "BGN", "CA", "20", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("292", "BGN", "NL", "25", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("293", "BGN", "SE", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("294", "BGN", "IE", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("295", "BGN", "BE", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("296", "BGN", "FI", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("297", "BGN", "FR", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("298", "BGN", "NZ", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("299", "BGN", "HK", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("300", "BGN", "CZ", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("301", "BGN", "SK", "15", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("302", "BGN", "AE", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("303", "BGN", "SG", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("304", "BGN", "IL", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("305", "BGN", "KW", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("306", "BGN", "IT", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("307", "BGN", "JP", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("308", "BGN", "ES", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("309", "BGN", "VE", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("310", "BGN", "HU", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("311", "BGN", "PT", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("312", "BGN", "GR", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("313", "BGN", "KR", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("314", "BGN", "TW", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("315", "BGN", "PL", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("316", "BGN", "ZM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("317", "BGN", "PR", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("318", "BGN", "CI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("319", "BGN", "RO", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("320", "BGN", "BH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("321", "BGN", "PA", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("322", "BGN", "GH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("323", "BGN", "KH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("324", "BGN", "SN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("325", "BGN", "SA", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("326", "BGN", "RU", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("327", "BGN", "UG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("328", "BGN", "BR", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("329", "BGN", "NI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("330", "BGN", "MG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("331", "BGN", "DO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("332", "BGN", "MX", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("333", "BGN", "OM", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("334", "BGN", "CM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("335", "BGN", "ZA", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("336", "BGN", "CL", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("337", "BGN", "KE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("338", "BGN", "NP", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("339", "BGN", "PE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("340", "BGN", "UA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("341", "BGN", "MZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("342", "BGN", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("343", "BGN", "AO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("344", "BGN", "JO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("345", "BGN", "ZW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("346", "BGN", "TR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("347", "BGN", "MU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("348", "BGN", "SV", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("349", "BGN", "TH", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("350", "BGN", "CO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("351", "BGN", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("352", "BGN", "CR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("353", "BGN", "AR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("354", "BGN", "MA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("355", "BGN", "MY", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("356", "BGN", "KZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("357", "BGN", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("358", "BGN", "ID", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("359", "BGN", "NG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("360", "BGN", "GT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("361", "BGN", "VN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("362", "BGN", "BY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("363", "BGN", "EG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("364", "BGN", "UY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("365", "BGN", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("366", "BGN", "PK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("367", "BGN", "PH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("368", "BGN", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("369", "BGN", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("370", "BGN", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("371", "BGN", "IN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("372", "BGN", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("373", "BGN", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("374", "BGN", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("375", "BGN", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("376", "BGN", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("377", "BOB", "US", "150", "420");
INSERT INTO `wp_gla_budget_recommendations` VALUES("378", "BOB", "CH", "140", "365");
INSERT INTO `wp_gla_budget_recommendations` VALUES("379", "BOB", "AU", "125", "325");
INSERT INTO `wp_gla_budget_recommendations` VALUES("380", "BOB", "GB", "110", "280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("381", "BOB", "DE", "110", "280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("382", "BOB", "DK", "100", "250");
INSERT INTO `wp_gla_budget_recommendations` VALUES("383", "BOB", "AT", "75", "230");
INSERT INTO `wp_gla_budget_recommendations` VALUES("384", "BOB", "NO", "85", "235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("385", "BOB", "CA", "90", "285");
INSERT INTO `wp_gla_budget_recommendations` VALUES("386", "BOB", "NL", "100", "250");
INSERT INTO `wp_gla_budget_recommendations` VALUES("387", "BOB", "SE", "80", "215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("388", "BOB", "IE", "80", "205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("389", "BOB", "BE", "70", "210");
INSERT INTO `wp_gla_budget_recommendations` VALUES("390", "BOB", "FI", "55", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("391", "BOB", "FR", "65", "180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("392", "BOB", "NZ", "70", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("393", "BOB", "HK", "60", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("394", "BOB", "CZ", "60", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("395", "BOB", "SK", "55", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("396", "BOB", "AE", "50", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("397", "BOB", "SG", "70", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("398", "BOB", "IL", "60", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("399", "BOB", "KW", "25", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("400", "BOB", "IT", "40", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("401", "BOB", "JP", "50", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("402", "BOB", "ES", "40", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("403", "BOB", "VE", "5", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("404", "BOB", "HU", "35", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("405", "BOB", "PT", "35", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("406", "BOB", "GR", "45", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("407", "BOB", "KR", "55", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("408", "BOB", "TW", "45", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("409", "BOB", "PL", "35", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("410", "BOB", "ZM", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("411", "BOB", "PR", "15", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("412", "BOB", "CI", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("413", "BOB", "RO", "35", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("414", "BOB", "BH", "15", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("415", "BOB", "PA", "10", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("416", "BOB", "GH", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("417", "BOB", "KH", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("418", "BOB", "SN", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("419", "BOB", "SA", "20", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("420", "BOB", "RU", "20", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("421", "BOB", "UG", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("422", "BOB", "BR", "25", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("423", "BOB", "NI", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("424", "BOB", "MG", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("425", "BOB", "DO", "5", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("426", "BOB", "MX", "20", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("427", "BOB", "OM", "10", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("428", "BOB", "CM", "5", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("429", "BOB", "ZA", "20", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("430", "BOB", "CL", "20", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("431", "BOB", "KE", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("432", "BOB", "NP", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("433", "BOB", "PE", "15", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("434", "BOB", "UA", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("435", "BOB", "MZ", "5", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("436", "BOB", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("437", "BOB", "AO", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("438", "BOB", "JO", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("439", "BOB", "ZW", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("440", "BOB", "TR", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("441", "BOB", "MU", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("442", "BOB", "SV", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("443", "BOB", "TH", "20", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("444", "BOB", "CO", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("445", "BOB", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("446", "BOB", "CR", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("447", "BOB", "AR", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("448", "BOB", "MA", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("449", "BOB", "MY", "20", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("450", "BOB", "KZ", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("451", "BOB", "DZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("452", "BOB", "ID", "15", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("453", "BOB", "NG", "10", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("454", "BOB", "GT", "5", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("455", "BOB", "VN", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("456", "BOB", "BY", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("457", "BOB", "EG", "10", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("458", "BOB", "UY", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("459", "BOB", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("460", "BOB", "PK", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("461", "BOB", "PH", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("462", "BOB", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("463", "BOB", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("464", "BOB", "LB", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("465", "BOB", "IN", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("466", "BOB", "PY", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("467", "BOB", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("468", "BOB", "EC", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("469", "BOB", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("470", "BOB", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("471", "BRL", "US", "115", "325");
INSERT INTO `wp_gla_budget_recommendations` VALUES("472", "BRL", "CH", "105", "285");
INSERT INTO `wp_gla_budget_recommendations` VALUES("473", "BRL", "AU", "100", "250");
INSERT INTO `wp_gla_budget_recommendations` VALUES("474", "BRL", "GB", "85", "220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("475", "BRL", "DE", "85", "215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("476", "BRL", "DK", "80", "195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("477", "BRL", "AT", "55", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("478", "BRL", "NO", "65", "180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("479", "BRL", "CA", "70", "220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("480", "BRL", "NL", "75", "195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("481", "BRL", "SE", "60", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("482", "BRL", "IE", "60", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("483", "BRL", "BE", "55", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("484", "BRL", "FI", "40", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("485", "BRL", "FR", "50", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("486", "BRL", "NZ", "50", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("487", "BRL", "HK", "45", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("488", "BRL", "CZ", "45", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("489", "BRL", "SK", "45", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("490", "BRL", "AE", "40", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("491", "BRL", "SG", "55", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("492", "BRL", "IL", "45", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("493", "BRL", "KW", "20", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("494", "BRL", "IT", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("495", "BRL", "JP", "40", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("496", "BRL", "ES", "30", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("497", "BRL", "VE", "5", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("498", "BRL", "HU", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("499", "BRL", "PT", "25", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("500", "BRL", "GR", "35", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("501", "BRL", "KR", "40", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("502", "BRL", "TW", "35", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("503", "BRL", "PL", "30", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("504", "BRL", "ZM", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("505", "BRL", "PR", "10", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("506", "BRL", "CI", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("507", "BRL", "RO", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("508", "BRL", "BH", "10", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("509", "BRL", "PA", "10", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("510", "BRL", "GH", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("511", "BRL", "KH", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("512", "BRL", "SN", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("513", "BRL", "SA", "15", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("514", "BRL", "RU", "15", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("515", "BRL", "UG", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("516", "BRL", "BR", "20", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("517", "BRL", "NI", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("518", "BRL", "MG", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("519", "BRL", "DO", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("520", "BRL", "MX", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("521", "BRL", "OM", "10", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("522", "BRL", "CM", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("523", "BRL", "ZA", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("524", "BRL", "CL", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("525", "BRL", "KE", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("526", "BRL", "NP", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("527", "BRL", "PE", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("528", "BRL", "UA", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("529", "BRL", "MZ", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("530", "BRL", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("531", "BRL", "AO", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("532", "BRL", "JO", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("533", "BRL", "ZW", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("534", "BRL", "TR", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("535", "BRL", "MU", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("536", "BRL", "SV", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("537", "BRL", "TH", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("538", "BRL", "CO", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("539", "BRL", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("540", "BRL", "CR", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("541", "BRL", "AR", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("542", "BRL", "MA", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("543", "BRL", "MY", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("544", "BRL", "KZ", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("545", "BRL", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("546", "BRL", "ID", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("547", "BRL", "NG", "5", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("548", "BRL", "GT", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("549", "BRL", "VN", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("550", "BRL", "BY", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("551", "BRL", "EG", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("552", "BRL", "UY", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("553", "BRL", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("554", "BRL", "PK", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("555", "BRL", "PH", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("556", "BRL", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("557", "BRL", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("558", "BRL", "LB", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("559", "BRL", "IN", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("560", "BRL", "PY", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("561", "BRL", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("562", "BRL", "EC", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("563", "BRL", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("564", "BRL", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("565", "CAD", "US", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("566", "CAD", "CH", "25", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("567", "CAD", "AU", "25", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("568", "CAD", "GB", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("569", "CAD", "DE", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("570", "CAD", "DK", "20", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("571", "CAD", "AT", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("572", "CAD", "NO", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("573", "CAD", "CA", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("574", "CAD", "NL", "20", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("575", "CAD", "SE", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("576", "CAD", "IE", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("577", "CAD", "BE", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("578", "CAD", "FI", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("579", "CAD", "FR", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("580", "CAD", "NZ", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("581", "CAD", "HK", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("582", "CAD", "CZ", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("583", "CAD", "SK", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("584", "CAD", "AE", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("585", "CAD", "SG", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("586", "CAD", "IL", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("587", "CAD", "KW", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("588", "CAD", "IT", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("589", "CAD", "JP", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("590", "CAD", "ES", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("591", "CAD", "VE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("592", "CAD", "HU", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("593", "CAD", "PT", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("594", "CAD", "GR", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("595", "CAD", "KR", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("596", "CAD", "TW", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("597", "CAD", "PL", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("598", "CAD", "ZM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("599", "CAD", "PR", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("600", "CAD", "CI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("601", "CAD", "RO", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("602", "CAD", "BH", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("603", "CAD", "PA", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("604", "CAD", "GH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("605", "CAD", "KH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("606", "CAD", "SN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("607", "CAD", "SA", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("608", "CAD", "RU", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("609", "CAD", "UG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("610", "CAD", "BR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("611", "CAD", "NI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("612", "CAD", "MG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("613", "CAD", "DO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("614", "CAD", "MX", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("615", "CAD", "OM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("616", "CAD", "CM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("617", "CAD", "ZA", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("618", "CAD", "CL", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("619", "CAD", "KE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("620", "CAD", "NP", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("621", "CAD", "PE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("622", "CAD", "UA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("623", "CAD", "MZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("624", "CAD", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("625", "CAD", "AO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("626", "CAD", "JO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("627", "CAD", "ZW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("628", "CAD", "TR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("629", "CAD", "MU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("630", "CAD", "SV", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("631", "CAD", "TH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("632", "CAD", "CO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("633", "CAD", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("634", "CAD", "CR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("635", "CAD", "AR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("636", "CAD", "MA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("637", "CAD", "MY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("638", "CAD", "KZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("639", "CAD", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("640", "CAD", "ID", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("641", "CAD", "NG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("642", "CAD", "GT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("643", "CAD", "VN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("644", "CAD", "BY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("645", "CAD", "EG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("646", "CAD", "UY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("647", "CAD", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("648", "CAD", "PK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("649", "CAD", "PH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("650", "CAD", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("651", "CAD", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("652", "CAD", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("653", "CAD", "IN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("654", "CAD", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("655", "CAD", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("656", "CAD", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("657", "CAD", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("658", "CAD", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("659", "CHF", "US", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("660", "CHF", "CH", "20", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("661", "CHF", "AU", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("662", "CHF", "GB", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("663", "CHF", "DE", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("664", "CHF", "DK", "15", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("665", "CHF", "AT", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("666", "CHF", "NO", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("667", "CHF", "CA", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("668", "CHF", "NL", "15", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("669", "CHF", "SE", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("670", "CHF", "IE", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("671", "CHF", "BE", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("672", "CHF", "FI", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("673", "CHF", "FR", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("674", "CHF", "NZ", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("675", "CHF", "HK", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("676", "CHF", "CZ", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("677", "CHF", "SK", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("678", "CHF", "AE", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("679", "CHF", "SG", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("680", "CHF", "IL", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("681", "CHF", "KW", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("682", "CHF", "IT", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("683", "CHF", "JP", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("684", "CHF", "ES", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("685", "CHF", "VE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("686", "CHF", "HU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("687", "CHF", "PT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("688", "CHF", "GR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("689", "CHF", "KR", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("690", "CHF", "TW", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("691", "CHF", "PL", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("692", "CHF", "ZM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("693", "CHF", "PR", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("694", "CHF", "CI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("695", "CHF", "RO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("696", "CHF", "BH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("697", "CHF", "PA", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("698", "CHF", "GH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("699", "CHF", "KH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("700", "CHF", "SN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("701", "CHF", "SA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("702", "CHF", "RU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("703", "CHF", "UG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("704", "CHF", "BR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("705", "CHF", "NI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("706", "CHF", "MG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("707", "CHF", "DO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("708", "CHF", "MX", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("709", "CHF", "OM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("710", "CHF", "CM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("711", "CHF", "ZA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("712", "CHF", "CL", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("713", "CHF", "KE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("714", "CHF", "NP", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("715", "CHF", "PE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("716", "CHF", "UA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("717", "CHF", "MZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("718", "CHF", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("719", "CHF", "AO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("720", "CHF", "JO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("721", "CHF", "ZW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("722", "CHF", "TR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("723", "CHF", "MU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("724", "CHF", "SV", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("725", "CHF", "TH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("726", "CHF", "CO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("727", "CHF", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("728", "CHF", "CR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("729", "CHF", "AR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("730", "CHF", "MA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("731", "CHF", "MY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("732", "CHF", "KZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("733", "CHF", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("734", "CHF", "ID", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("735", "CHF", "NG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("736", "CHF", "GT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("737", "CHF", "VN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("738", "CHF", "BY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("739", "CHF", "EG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("740", "CHF", "UY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("741", "CHF", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("742", "CHF", "PK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("743", "CHF", "PH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("744", "CHF", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("745", "CHF", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("746", "CHF", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("747", "CHF", "IN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("748", "CHF", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("749", "CHF", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("750", "CHF", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("751", "CHF", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("752", "CHF", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("753", "CLP", "US", "16030", "45230");
INSERT INTO `wp_gla_budget_recommendations` VALUES("754", "CLP", "CH", "14950", "39340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("755", "CLP", "AU", "13600", "34925");
INSERT INTO `wp_gla_budget_recommendations` VALUES("756", "CLP", "GB", "11860", "30350");
INSERT INTO `wp_gla_budget_recommendations` VALUES("757", "CLP", "DE", "11770", "30105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("758", "CLP", "DK", "10830", "26875");
INSERT INTO `wp_gla_budget_recommendations` VALUES("759", "CLP", "AT", "7900", "24555");
INSERT INTO `wp_gla_budget_recommendations` VALUES("760", "CLP", "NO", "8955", "25005");
INSERT INTO `wp_gla_budget_recommendations` VALUES("761", "CLP", "CA", "9900", "30360");
INSERT INTO `wp_gla_budget_recommendations` VALUES("762", "CLP", "NL", "10590", "26885");
INSERT INTO `wp_gla_budget_recommendations` VALUES("763", "CLP", "SE", "8480", "22925");
INSERT INTO `wp_gla_budget_recommendations` VALUES("764", "CLP", "IE", "8390", "22115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("765", "CLP", "BE", "7715", "22610");
INSERT INTO `wp_gla_budget_recommendations` VALUES("766", "CLP", "FI", "5770", "17515");
INSERT INTO `wp_gla_budget_recommendations` VALUES("767", "CLP", "FR", "7140", "19115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("768", "CLP", "NZ", "7270", "21400");
INSERT INTO `wp_gla_budget_recommendations` VALUES("769", "CLP", "HK", "6610", "18695");
INSERT INTO `wp_gla_budget_recommendations` VALUES("770", "CLP", "CZ", "6300", "15130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("771", "CLP", "SK", "5945", "12885");
INSERT INTO `wp_gla_budget_recommendations` VALUES("772", "CLP", "AE", "5610", "17610");
INSERT INTO `wp_gla_budget_recommendations` VALUES("773", "CLP", "SG", "7320", "21635");
INSERT INTO `wp_gla_budget_recommendations` VALUES("774", "CLP", "IL", "6390", "15630");
INSERT INTO `wp_gla_budget_recommendations` VALUES("775", "CLP", "KW", "2880", "14045");
INSERT INTO `wp_gla_budget_recommendations` VALUES("776", "CLP", "IT", "4350", "11480");
INSERT INTO `wp_gla_budget_recommendations` VALUES("777", "CLP", "JP", "5455", "15495");
INSERT INTO `wp_gla_budget_recommendations` VALUES("778", "CLP", "ES", "4470", "11820");
INSERT INTO `wp_gla_budget_recommendations` VALUES("779", "CLP", "VE", "585", "9055");
INSERT INTO `wp_gla_budget_recommendations` VALUES("780", "CLP", "HU", "3765", "8765");
INSERT INTO `wp_gla_budget_recommendations` VALUES("781", "CLP", "PT", "3760", "9805");
INSERT INTO `wp_gla_budget_recommendations` VALUES("782", "CLP", "GR", "4635", "9495");
INSERT INTO `wp_gla_budget_recommendations` VALUES("783", "CLP", "KR", "5715", "15140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("784", "CLP", "TW", "4645", "12440");
INSERT INTO `wp_gla_budget_recommendations` VALUES("785", "CLP", "PL", "3975", "9840");
INSERT INTO `wp_gla_budget_recommendations` VALUES("786", "CLP", "ZM", "575", "3275");
INSERT INTO `wp_gla_budget_recommendations` VALUES("787", "CLP", "PR", "1405", "13200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("788", "CLP", "CI", "765", "3165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("789", "CLP", "RO", "3650", "8835");
INSERT INTO `wp_gla_budget_recommendations` VALUES("790", "CLP", "BH", "1660", "9195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("791", "CLP", "PA", "1110", "12620");
INSERT INTO `wp_gla_budget_recommendations` VALUES("792", "CLP", "GH", "1330", "3715");
INSERT INTO `wp_gla_budget_recommendations` VALUES("793", "CLP", "KH", "770", "3685");
INSERT INTO `wp_gla_budget_recommendations` VALUES("794", "CLP", "SN", "560", "4005");
INSERT INTO `wp_gla_budget_recommendations` VALUES("795", "CLP", "SA", "2385", "9130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("796", "CLP", "RU", "2370", "7560");
INSERT INTO `wp_gla_budget_recommendations` VALUES("797", "CLP", "UG", "555", "2925");
INSERT INTO `wp_gla_budget_recommendations` VALUES("798", "CLP", "BR", "2525", "6230");
INSERT INTO `wp_gla_budget_recommendations` VALUES("799", "CLP", "NI", "555", "3990");
INSERT INTO `wp_gla_budget_recommendations` VALUES("800", "CLP", "MG", "560", "2825");
INSERT INTO `wp_gla_budget_recommendations` VALUES("801", "CLP", "DO", "675", "4685");
INSERT INTO `wp_gla_budget_recommendations` VALUES("802", "CLP", "MX", "1905", "6895");
INSERT INTO `wp_gla_budget_recommendations` VALUES("803", "CLP", "OM", "1195", "6895");
INSERT INTO `wp_gla_budget_recommendations` VALUES("804", "CLP", "CM", "555", "5135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("805", "CLP", "ZA", "2270", "7305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("806", "CLP", "CL", "2365", "7065");
INSERT INTO `wp_gla_budget_recommendations` VALUES("807", "CLP", "KE", "685", "2950");
INSERT INTO `wp_gla_budget_recommendations` VALUES("808", "CLP", "NP", "555", "2680");
INSERT INTO `wp_gla_budget_recommendations` VALUES("809", "CLP", "PE", "1410", "5945");
INSERT INTO `wp_gla_budget_recommendations` VALUES("810", "CLP", "UA", "1345", "4205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("811", "CLP", "MZ", "555", "5580");
INSERT INTO `wp_gla_budget_recommendations` VALUES("812", "CLP", "TZ", "70", "1280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("813", "CLP", "AO", "1230", "3205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("814", "CLP", "JO", "905", "4310");
INSERT INTO `wp_gla_budget_recommendations` VALUES("815", "CLP", "ZW", "560", "3055");
INSERT INTO `wp_gla_budget_recommendations` VALUES("816", "CLP", "TR", "1445", "3955");
INSERT INTO `wp_gla_budget_recommendations` VALUES("817", "CLP", "MU", "740", "2530");
INSERT INTO `wp_gla_budget_recommendations` VALUES("818", "CLP", "SV", "555", "3065");
INSERT INTO `wp_gla_budget_recommendations` VALUES("819", "CLP", "TH", "2170", "6820");
INSERT INTO `wp_gla_budget_recommendations` VALUES("820", "CLP", "CO", "1100", "4255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("821", "CLP", "LK", "535", "735");
INSERT INTO `wp_gla_budget_recommendations` VALUES("822", "CLP", "CR", "670", "4450");
INSERT INTO `wp_gla_budget_recommendations` VALUES("823", "CLP", "AR", "1495", "4055");
INSERT INTO `wp_gla_budget_recommendations` VALUES("824", "CLP", "MA", "670", "2625");
INSERT INTO `wp_gla_budget_recommendations` VALUES("825", "CLP", "MY", "1895", "6975");
INSERT INTO `wp_gla_budget_recommendations` VALUES("826", "CLP", "KZ", "810", "2970");
INSERT INTO `wp_gla_budget_recommendations` VALUES("827", "CLP", "DZ", "665", "1410");
INSERT INTO `wp_gla_budget_recommendations` VALUES("828", "CLP", "ID", "1695", "6280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("829", "CLP", "NG", "950", "6020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("830", "CLP", "GT", "665", "4715");
INSERT INTO `wp_gla_budget_recommendations` VALUES("831", "CLP", "VN", "1385", "5250");
INSERT INTO `wp_gla_budget_recommendations` VALUES("832", "CLP", "BY", "650", "2530");
INSERT INTO `wp_gla_budget_recommendations` VALUES("833", "CLP", "EG", "875", "5355");
INSERT INTO `wp_gla_budget_recommendations` VALUES("834", "CLP", "UY", "690", "3185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("835", "CLP", "BD", "570", "1260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("836", "CLP", "PK", "625", "3590");
INSERT INTO `wp_gla_budget_recommendations` VALUES("837", "CLP", "PH", "1080", "3990");
INSERT INTO `wp_gla_budget_recommendations` VALUES("838", "CLP", "ET", "175", "1320");
INSERT INTO `wp_gla_budget_recommendations` VALUES("839", "CLP", "TN", "665", "1205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("840", "CLP", "LB", "670", "2010");
INSERT INTO `wp_gla_budget_recommendations` VALUES("841", "CLP", "IN", "620", "2800");
INSERT INTO `wp_gla_budget_recommendations` VALUES("842", "CLP", "PY", "665", "2140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("843", "CLP", "UZ", "665", "1300");
INSERT INTO `wp_gla_budget_recommendations` VALUES("844", "CLP", "EC", "650", "2220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("845", "CLP", "MM", "665", "730");
INSERT INTO `wp_gla_budget_recommendations` VALUES("846", "CLP", "GE", "670", "850");
INSERT INTO `wp_gla_budget_recommendations` VALUES("847", "CNY", "US", "140", "395");
INSERT INTO `wp_gla_budget_recommendations` VALUES("848", "CNY", "CH", "130", "345");
INSERT INTO `wp_gla_budget_recommendations` VALUES("849", "CNY", "AU", "120", "305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("850", "CNY", "GB", "105", "265");
INSERT INTO `wp_gla_budget_recommendations` VALUES("851", "CNY", "DE", "105", "265");
INSERT INTO `wp_gla_budget_recommendations` VALUES("852", "CNY", "DK", "95", "235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("853", "CNY", "AT", "70", "215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("854", "CNY", "NO", "80", "220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("855", "CNY", "CA", "85", "265");
INSERT INTO `wp_gla_budget_recommendations` VALUES("856", "CNY", "NL", "95", "235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("857", "CNY", "SE", "75", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("858", "CNY", "IE", "75", "195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("859", "CNY", "BE", "70", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("860", "CNY", "FI", "50", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("861", "CNY", "FR", "65", "170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("862", "CNY", "NZ", "65", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("863", "CNY", "HK", "60", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("864", "CNY", "CZ", "55", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("865", "CNY", "SK", "50", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("866", "CNY", "AE", "50", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("867", "CNY", "SG", "65", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("868", "CNY", "IL", "55", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("869", "CNY", "KW", "25", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("870", "CNY", "IT", "40", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("871", "CNY", "JP", "50", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("872", "CNY", "ES", "40", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("873", "CNY", "VE", "5", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("874", "CNY", "HU", "35", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("875", "CNY", "PT", "35", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("876", "CNY", "GR", "40", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("877", "CNY", "KR", "50", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("878", "CNY", "TW", "40", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("879", "CNY", "PL", "35", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("880", "CNY", "ZM", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("881", "CNY", "PR", "10", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("882", "CNY", "CI", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("883", "CNY", "RO", "30", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("884", "CNY", "BH", "15", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("885", "CNY", "PA", "10", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("886", "CNY", "GH", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("887", "CNY", "KH", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("888", "CNY", "SN", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("889", "CNY", "SA", "20", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("890", "CNY", "RU", "20", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("891", "CNY", "UG", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("892", "CNY", "BR", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("893", "CNY", "NI", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("894", "CNY", "MG", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("895", "CNY", "DO", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("896", "CNY", "MX", "15", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("897", "CNY", "OM", "10", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("898", "CNY", "CM", "5", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("899", "CNY", "ZA", "20", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("900", "CNY", "CL", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("901", "CNY", "KE", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("902", "CNY", "NP", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("903", "CNY", "PE", "10", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("904", "CNY", "UA", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("905", "CNY", "MZ", "5", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("906", "CNY", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("907", "CNY", "AO", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("908", "CNY", "JO", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("909", "CNY", "ZW", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("910", "CNY", "TR", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("911", "CNY", "MU", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("912", "CNY", "SV", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("913", "CNY", "TH", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("914", "CNY", "CO", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("915", "CNY", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("916", "CNY", "CR", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("917", "CNY", "AR", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("918", "CNY", "MA", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("919", "CNY", "MY", "15", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("920", "CNY", "KZ", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("921", "CNY", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("922", "CNY", "ID", "15", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("923", "CNY", "NG", "10", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("924", "CNY", "GT", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("925", "CNY", "VN", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("926", "CNY", "BY", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("927", "CNY", "EG", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("928", "CNY", "UY", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("929", "CNY", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("930", "CNY", "PK", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("931", "CNY", "PH", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("932", "CNY", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("933", "CNY", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("934", "CNY", "LB", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("935", "CNY", "IN", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("936", "CNY", "PY", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("937", "CNY", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("938", "CNY", "EC", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("939", "CNY", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("940", "CNY", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("941", "COP", "US", "75545", "213150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("942", "COP", "CH", "70445", "185375");
INSERT INTO `wp_gla_budget_recommendations` VALUES("943", "COP", "AU", "64100", "164575");
INSERT INTO `wp_gla_budget_recommendations` VALUES("944", "COP", "GB", "55885", "143015");
INSERT INTO `wp_gla_budget_recommendations` VALUES("945", "COP", "DE", "55460", "141860");
INSERT INTO `wp_gla_budget_recommendations` VALUES("946", "COP", "DK", "51030", "126635");
INSERT INTO `wp_gla_budget_recommendations` VALUES("947", "COP", "AT", "37235", "115710");
INSERT INTO `wp_gla_budget_recommendations` VALUES("948", "COP", "NO", "42205", "117830");
INSERT INTO `wp_gla_budget_recommendations` VALUES("949", "COP", "CA", "46655", "143060");
INSERT INTO `wp_gla_budget_recommendations` VALUES("950", "COP", "NL", "49915", "126685");
INSERT INTO `wp_gla_budget_recommendations` VALUES("951", "COP", "SE", "39955", "108040");
INSERT INTO `wp_gla_budget_recommendations` VALUES("952", "COP", "IE", "39535", "104220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("953", "COP", "BE", "36360", "106555");
INSERT INTO `wp_gla_budget_recommendations` VALUES("954", "COP", "FI", "27180", "82545");
INSERT INTO `wp_gla_budget_recommendations` VALUES("955", "COP", "FR", "33655", "90085");
INSERT INTO `wp_gla_budget_recommendations` VALUES("956", "COP", "NZ", "34255", "100840");
INSERT INTO `wp_gla_budget_recommendations` VALUES("957", "COP", "HK", "31150", "88090");
INSERT INTO `wp_gla_budget_recommendations` VALUES("958", "COP", "CZ", "29700", "71300");
INSERT INTO `wp_gla_budget_recommendations` VALUES("959", "COP", "SK", "28020", "60720");
INSERT INTO `wp_gla_budget_recommendations` VALUES("960", "COP", "AE", "26440", "82980");
INSERT INTO `wp_gla_budget_recommendations` VALUES("961", "COP", "SG", "34500", "101960");
INSERT INTO `wp_gla_budget_recommendations` VALUES("962", "COP", "IL", "30105", "73645");
INSERT INTO `wp_gla_budget_recommendations` VALUES("963", "COP", "KW", "13580", "66195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("964", "COP", "IT", "20495", "54100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("965", "COP", "JP", "25695", "73030");
INSERT INTO `wp_gla_budget_recommendations` VALUES("966", "COP", "ES", "21065", "55710");
INSERT INTO `wp_gla_budget_recommendations` VALUES("967", "COP", "VE", "2760", "42675");
INSERT INTO `wp_gla_budget_recommendations` VALUES("968", "COP", "HU", "17750", "41305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("969", "COP", "PT", "17720", "46195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("970", "COP", "GR", "21850", "44750");
INSERT INTO `wp_gla_budget_recommendations` VALUES("971", "COP", "KR", "26940", "71345");
INSERT INTO `wp_gla_budget_recommendations` VALUES("972", "COP", "TW", "21895", "58620");
INSERT INTO `wp_gla_budget_recommendations` VALUES("973", "COP", "PL", "18735", "46380");
INSERT INTO `wp_gla_budget_recommendations` VALUES("974", "COP", "ZM", "2705", "15440");
INSERT INTO `wp_gla_budget_recommendations` VALUES("975", "COP", "PR", "6620", "62215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("976", "COP", "CI", "3610", "14925");
INSERT INTO `wp_gla_budget_recommendations` VALUES("977", "COP", "RO", "17210", "41645");
INSERT INTO `wp_gla_budget_recommendations` VALUES("978", "COP", "BH", "7815", "43325");
INSERT INTO `wp_gla_budget_recommendations` VALUES("979", "COP", "PA", "5235", "59470");
INSERT INTO `wp_gla_budget_recommendations` VALUES("980", "COP", "GH", "6275", "17510");
INSERT INTO `wp_gla_budget_recommendations` VALUES("981", "COP", "KH", "3615", "17370");
INSERT INTO `wp_gla_budget_recommendations` VALUES("982", "COP", "SN", "2635", "18870");
INSERT INTO `wp_gla_budget_recommendations` VALUES("983", "COP", "SA", "11235", "43010");
INSERT INTO `wp_gla_budget_recommendations` VALUES("984", "COP", "RU", "11165", "35625");
INSERT INTO `wp_gla_budget_recommendations` VALUES("985", "COP", "UG", "2625", "13790");
INSERT INTO `wp_gla_budget_recommendations` VALUES("986", "COP", "BR", "11905", "29345");
INSERT INTO `wp_gla_budget_recommendations` VALUES("987", "COP", "NI", "2620", "18790");
INSERT INTO `wp_gla_budget_recommendations` VALUES("988", "COP", "MG", "2650", "13320");
INSERT INTO `wp_gla_budget_recommendations` VALUES("989", "COP", "DO", "3175", "22085");
INSERT INTO `wp_gla_budget_recommendations` VALUES("990", "COP", "MX", "8975", "32480");
INSERT INTO `wp_gla_budget_recommendations` VALUES("991", "COP", "OM", "5640", "32485");
INSERT INTO `wp_gla_budget_recommendations` VALUES("992", "COP", "CM", "2615", "24205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("993", "COP", "ZA", "10695", "34425");
INSERT INTO `wp_gla_budget_recommendations` VALUES("994", "COP", "CL", "11145", "33300");
INSERT INTO `wp_gla_budget_recommendations` VALUES("995", "COP", "KE", "3215", "13900");
INSERT INTO `wp_gla_budget_recommendations` VALUES("996", "COP", "NP", "2615", "12625");
INSERT INTO `wp_gla_budget_recommendations` VALUES("997", "COP", "PE", "6655", "28015");
INSERT INTO `wp_gla_budget_recommendations` VALUES("998", "COP", "UA", "6345", "19820");
INSERT INTO `wp_gla_budget_recommendations` VALUES("999", "COP", "MZ", "2615", "26290");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1000", "COP", "TZ", "330", "6035");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1001", "COP", "AO", "5795", "15115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1002", "COP", "JO", "4275", "20300");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1003", "COP", "ZW", "2625", "14405");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1004", "COP", "TR", "6810", "18630");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1005", "COP", "MU", "3485", "11915");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1006", "COP", "SV", "2615", "14435");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1007", "COP", "TH", "10215", "32140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1008", "COP", "CO", "5180", "20050");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1009", "COP", "LK", "2515", "3475");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1010", "COP", "CR", "3160", "20980");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1011", "COP", "AR", "7055", "19110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1012", "COP", "MA", "3150", "12365");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1013", "COP", "MY", "8940", "32875");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1014", "COP", "KZ", "3825", "13995");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1015", "COP", "DZ", "3135", "6635");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1016", "COP", "ID", "7975", "29590");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1017", "COP", "NG", "4485", "28365");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1018", "COP", "GT", "3140", "22210");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1019", "COP", "VN", "6525", "24735");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1020", "COP", "BY", "3065", "11930");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1021", "COP", "EG", "4135", "25245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1022", "COP", "UY", "3260", "15015");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1023", "COP", "BD", "2680", "5940");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1024", "COP", "PK", "2940", "16930");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1025", "COP", "PH", "5095", "18795");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1026", "COP", "ET", "815", "6225");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1027", "COP", "TN", "3140", "5685");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1028", "COP", "LB", "3170", "9470");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1029", "COP", "IN", "2920", "13195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1030", "COP", "PY", "3140", "10095");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1031", "COP", "UZ", "3140", "6130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1032", "COP", "EC", "3050", "10470");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1033", "COP", "MM", "3140", "3430");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1034", "COP", "GE", "3150", "4015");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1035", "CZK", "US", "470", "1320");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1036", "CZK", "CH", "435", "1145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1037", "CZK", "AU", "395", "1020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1038", "CZK", "GB", "345", "885");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1039", "CZK", "DE", "345", "880");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1040", "CZK", "DK", "315", "785");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1041", "CZK", "AT", "230", "715");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1042", "CZK", "NO", "260", "730");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1043", "CZK", "CA", "290", "885");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1044", "CZK", "NL", "310", "785");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1045", "CZK", "SE", "245", "670");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1046", "CZK", "IE", "245", "645");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1047", "CZK", "BE", "225", "660");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1048", "CZK", "FI", "170", "510");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1049", "CZK", "FR", "210", "560");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1050", "CZK", "NZ", "210", "625");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1051", "CZK", "HK", "195", "545");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1052", "CZK", "CZ", "185", "440");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1053", "CZK", "SK", "175", "375");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1054", "CZK", "AE", "165", "515");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1055", "CZK", "SG", "215", "630");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1056", "CZK", "IL", "185", "455");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1057", "CZK", "KW", "85", "410");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1058", "CZK", "IT", "125", "335");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1059", "CZK", "JP", "160", "450");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1060", "CZK", "ES", "130", "345");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1061", "CZK", "VE", "15", "265");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1062", "CZK", "HU", "110", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1063", "CZK", "PT", "110", "285");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1064", "CZK", "GR", "135", "275");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1065", "CZK", "KR", "165", "440");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1066", "CZK", "TW", "135", "365");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1067", "CZK", "PL", "115", "285");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1068", "CZK", "ZM", "15", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1069", "CZK", "PR", "40", "385");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1070", "CZK", "CI", "20", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1071", "CZK", "RO", "105", "260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1072", "CZK", "BH", "50", "270");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1073", "CZK", "PA", "30", "370");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1074", "CZK", "GH", "40", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1075", "CZK", "KH", "20", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1076", "CZK", "SN", "15", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1077", "CZK", "SA", "70", "265");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1078", "CZK", "RU", "70", "220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1079", "CZK", "UG", "15", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1080", "CZK", "BR", "75", "180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1081", "CZK", "NI", "15", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1082", "CZK", "MG", "15", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1083", "CZK", "DO", "20", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1084", "CZK", "MX", "55", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1085", "CZK", "OM", "35", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1086", "CZK", "CM", "15", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1087", "CZK", "ZA", "65", "215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1088", "CZK", "CL", "70", "205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1089", "CZK", "KE", "20", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1090", "CZK", "NP", "15", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1091", "CZK", "PE", "40", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1092", "CZK", "UA", "40", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1093", "CZK", "MZ", "15", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1094", "CZK", "TZ", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1095", "CZK", "AO", "35", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1096", "CZK", "JO", "25", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1097", "CZK", "ZW", "15", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1098", "CZK", "TR", "40", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1099", "CZK", "MU", "20", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1100", "CZK", "SV", "15", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1101", "CZK", "TH", "65", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1102", "CZK", "CO", "30", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1103", "CZK", "LK", "15", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1104", "CZK", "CR", "20", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1105", "CZK", "AR", "45", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1106", "CZK", "MA", "20", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1107", "CZK", "MY", "55", "205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1108", "CZK", "KZ", "25", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1109", "CZK", "DZ", "20", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1110", "CZK", "ID", "50", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1111", "CZK", "NG", "30", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1112", "CZK", "GT", "20", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1113", "CZK", "VN", "40", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1114", "CZK", "BY", "20", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1115", "CZK", "EG", "25", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1116", "CZK", "UY", "20", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1117", "CZK", "BD", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1118", "CZK", "PK", "20", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1119", "CZK", "PH", "30", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1120", "CZK", "ET", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1121", "CZK", "TN", "20", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1122", "CZK", "LB", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1123", "CZK", "IN", "20", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1124", "CZK", "PY", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1125", "CZK", "UZ", "20", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1126", "CZK", "EC", "20", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1127", "CZK", "MM", "20", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1128", "CZK", "GE", "20", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1129", "DKK", "US", "135", "375");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1130", "DKK", "CH", "125", "325");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1131", "DKK", "AU", "115", "290");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1132", "DKK", "GB", "100", "250");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1133", "DKK", "DE", "100", "250");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1134", "DKK", "DK", "90", "225");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1135", "DKK", "AT", "65", "205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1136", "DKK", "NO", "75", "205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1137", "DKK", "CA", "80", "250");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1138", "DKK", "NL", "90", "225");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1139", "DKK", "SE", "70", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1140", "DKK", "IE", "70", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1141", "DKK", "BE", "65", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1142", "DKK", "FI", "50", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1143", "DKK", "FR", "60", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1144", "DKK", "NZ", "60", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1145", "DKK", "HK", "55", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1146", "DKK", "CZ", "50", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1147", "DKK", "SK", "50", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1148", "DKK", "AE", "45", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1149", "DKK", "SG", "60", "180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1150", "DKK", "IL", "55", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1151", "DKK", "KW", "25", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1152", "DKK", "IT", "35", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1153", "DKK", "JP", "45", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1154", "DKK", "ES", "35", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1155", "DKK", "VE", "5", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1156", "DKK", "HU", "30", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1157", "DKK", "PT", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1158", "DKK", "GR", "40", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1159", "DKK", "KR", "45", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1160", "DKK", "TW", "40", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1161", "DKK", "PL", "35", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1162", "DKK", "ZM", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1163", "DKK", "PR", "10", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1164", "DKK", "CI", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1165", "DKK", "RO", "30", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1166", "DKK", "BH", "15", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1167", "DKK", "PA", "10", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1168", "DKK", "GH", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1169", "DKK", "KH", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1170", "DKK", "SN", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1171", "DKK", "SA", "20", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1172", "DKK", "RU", "20", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1173", "DKK", "UG", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1174", "DKK", "BR", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1175", "DKK", "NI", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1176", "DKK", "MG", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1177", "DKK", "DO", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1178", "DKK", "MX", "15", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1179", "DKK", "OM", "10", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1180", "DKK", "CM", "5", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1181", "DKK", "ZA", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1182", "DKK", "CL", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1183", "DKK", "KE", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1184", "DKK", "NP", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1185", "DKK", "PE", "10", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1186", "DKK", "UA", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1187", "DKK", "MZ", "5", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1188", "DKK", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1189", "DKK", "AO", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1190", "DKK", "JO", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1191", "DKK", "ZW", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1192", "DKK", "TR", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1193", "DKK", "MU", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1194", "DKK", "SV", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1195", "DKK", "TH", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1196", "DKK", "CO", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1197", "DKK", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1198", "DKK", "CR", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1199", "DKK", "AR", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1200", "DKK", "MA", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1201", "DKK", "MY", "15", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1202", "DKK", "KZ", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1203", "DKK", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1204", "DKK", "ID", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1205", "DKK", "NG", "10", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1206", "DKK", "GT", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1207", "DKK", "VN", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1208", "DKK", "BY", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1209", "DKK", "EG", "5", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1210", "DKK", "UY", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1211", "DKK", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1212", "DKK", "PK", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1213", "DKK", "PH", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1214", "DKK", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1215", "DKK", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1216", "DKK", "LB", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1217", "DKK", "IN", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1218", "DKK", "PY", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1219", "DKK", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1220", "DKK", "EC", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1221", "DKK", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1222", "DKK", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1223", "EGP", "US", "340", "960");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1224", "EGP", "CH", "315", "835");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1225", "EGP", "AU", "290", "740");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1226", "EGP", "GB", "250", "645");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1227", "EGP", "DE", "250", "640");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1228", "EGP", "DK", "230", "570");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1229", "EGP", "AT", "170", "520");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1230", "EGP", "NO", "190", "530");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1231", "EGP", "CA", "210", "645");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1232", "EGP", "NL", "225", "570");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1233", "EGP", "SE", "180", "485");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1234", "EGP", "IE", "180", "470");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1235", "EGP", "BE", "165", "480");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1236", "EGP", "FI", "120", "370");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1237", "EGP", "FR", "150", "405");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1238", "EGP", "NZ", "155", "455");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1239", "EGP", "HK", "140", "395");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1240", "EGP", "CZ", "135", "320");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1241", "EGP", "SK", "125", "275");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1242", "EGP", "AE", "120", "375");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1243", "EGP", "SG", "155", "460");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1244", "EGP", "IL", "135", "330");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1245", "EGP", "KW", "60", "300");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1246", "EGP", "IT", "90", "245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1247", "EGP", "JP", "115", "330");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1248", "EGP", "ES", "95", "250");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1249", "EGP", "VE", "10", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1250", "EGP", "HU", "80", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1251", "EGP", "PT", "80", "210");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1252", "EGP", "GR", "100", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1253", "EGP", "KR", "120", "320");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1254", "EGP", "TW", "100", "265");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1255", "EGP", "PL", "85", "210");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1256", "EGP", "ZM", "10", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1257", "EGP", "PR", "30", "280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1258", "EGP", "CI", "15", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1259", "EGP", "RO", "80", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1260", "EGP", "BH", "35", "195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1261", "EGP", "PA", "25", "270");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1262", "EGP", "GH", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1263", "EGP", "KH", "15", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1264", "EGP", "SN", "10", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1265", "EGP", "SA", "50", "195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1266", "EGP", "RU", "50", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1267", "EGP", "UG", "10", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1268", "EGP", "BR", "55", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1269", "EGP", "NI", "10", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1270", "EGP", "MG", "10", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1271", "EGP", "DO", "15", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1272", "EGP", "MX", "40", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1273", "EGP", "OM", "25", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1274", "EGP", "CM", "10", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1275", "EGP", "ZA", "50", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1276", "EGP", "CL", "50", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1277", "EGP", "KE", "15", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1278", "EGP", "NP", "10", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1279", "EGP", "PE", "30", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1280", "EGP", "UA", "30", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1281", "EGP", "MZ", "10", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1282", "EGP", "TZ", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1283", "EGP", "AO", "25", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1284", "EGP", "JO", "20", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1285", "EGP", "ZW", "10", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1286", "EGP", "TR", "30", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1287", "EGP", "MU", "15", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1288", "EGP", "SV", "10", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1289", "EGP", "TH", "45", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1290", "EGP", "CO", "25", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1291", "EGP", "LK", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1292", "EGP", "CR", "15", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1293", "EGP", "AR", "30", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1294", "EGP", "MA", "15", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1295", "EGP", "MY", "40", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1296", "EGP", "KZ", "15", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1297", "EGP", "DZ", "15", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1298", "EGP", "ID", "35", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1299", "EGP", "NG", "20", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1300", "EGP", "GT", "15", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1301", "EGP", "VN", "30", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1302", "EGP", "BY", "15", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1303", "EGP", "EG", "20", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1304", "EGP", "UY", "15", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1305", "EGP", "BD", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1306", "EGP", "PK", "15", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1307", "EGP", "PH", "25", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1308", "EGP", "ET", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1309", "EGP", "TN", "15", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1310", "EGP", "LB", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1311", "EGP", "IN", "15", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1312", "EGP", "PY", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1313", "EGP", "UZ", "15", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1314", "EGP", "EC", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1315", "EGP", "MM", "15", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1316", "EGP", "GE", "15", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1317", "EUR", "US", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1318", "EUR", "CH", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1319", "EUR", "AU", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1320", "EUR", "GB", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1321", "EUR", "DE", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1322", "EUR", "DK", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1323", "EUR", "AT", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1324", "EUR", "NO", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1325", "EUR", "CA", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1326", "EUR", "NL", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1327", "EUR", "SE", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1328", "EUR", "IE", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1329", "EUR", "BE", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1330", "EUR", "FI", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1331", "EUR", "FR", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1332", "EUR", "NZ", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1333", "EUR", "HK", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1334", "EUR", "CZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1335", "EUR", "SK", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1336", "EUR", "AE", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1337", "EUR", "SG", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1338", "EUR", "IL", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1339", "EUR", "KW", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1340", "EUR", "IT", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1341", "EUR", "JP", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1342", "EUR", "ES", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1343", "EUR", "VE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1344", "EUR", "HU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1345", "EUR", "PT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1346", "EUR", "GR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1347", "EUR", "KR", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1348", "EUR", "TW", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1349", "EUR", "PL", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1350", "EUR", "ZM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1351", "EUR", "PR", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1352", "EUR", "CI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1353", "EUR", "RO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1354", "EUR", "BH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1355", "EUR", "PA", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1356", "EUR", "GH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1357", "EUR", "KH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1358", "EUR", "SN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1359", "EUR", "SA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1360", "EUR", "RU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1361", "EUR", "UG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1362", "EUR", "BR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1363", "EUR", "NI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1364", "EUR", "MG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1365", "EUR", "DO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1366", "EUR", "MX", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1367", "EUR", "OM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1368", "EUR", "CM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1369", "EUR", "ZA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1370", "EUR", "CL", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1371", "EUR", "KE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1372", "EUR", "NP", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1373", "EUR", "PE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1374", "EUR", "UA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1375", "EUR", "MZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1376", "EUR", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1377", "EUR", "AO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1378", "EUR", "JO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1379", "EUR", "ZW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1380", "EUR", "TR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1381", "EUR", "MU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1382", "EUR", "SV", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1383", "EUR", "TH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1384", "EUR", "CO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1385", "EUR", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1386", "EUR", "CR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1387", "EUR", "AR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1388", "EUR", "MA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1389", "EUR", "MY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1390", "EUR", "KZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1391", "EUR", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1392", "EUR", "ID", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1393", "EUR", "NG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1394", "EUR", "GT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1395", "EUR", "VN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1396", "EUR", "BY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1397", "EUR", "EG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1398", "EUR", "UY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1399", "EUR", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1400", "EUR", "PK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1401", "EUR", "PH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1402", "EUR", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1403", "EUR", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1404", "EUR", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1405", "EUR", "IN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1406", "EUR", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1407", "EUR", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1408", "EUR", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1409", "EUR", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1410", "EUR", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1411", "GBP", "US", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1412", "GBP", "CH", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1413", "GBP", "AU", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1414", "GBP", "GB", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1415", "GBP", "DE", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1416", "GBP", "DK", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1417", "GBP", "AT", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1418", "GBP", "NO", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1419", "GBP", "CA", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1420", "GBP", "NL", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1421", "GBP", "SE", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1422", "GBP", "IE", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1423", "GBP", "BE", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1424", "GBP", "FI", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1425", "GBP", "FR", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1426", "GBP", "NZ", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1427", "GBP", "HK", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1428", "GBP", "CZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1429", "GBP", "SK", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1430", "GBP", "AE", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1431", "GBP", "SG", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1432", "GBP", "IL", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1433", "GBP", "KW", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1434", "GBP", "IT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1435", "GBP", "JP", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1436", "GBP", "ES", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1437", "GBP", "VE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1438", "GBP", "HU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1439", "GBP", "PT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1440", "GBP", "GR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1441", "GBP", "KR", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1442", "GBP", "TW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1443", "GBP", "PL", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1444", "GBP", "ZM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1445", "GBP", "PR", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1446", "GBP", "CI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1447", "GBP", "RO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1448", "GBP", "BH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1449", "GBP", "PA", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1450", "GBP", "GH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1451", "GBP", "KH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1452", "GBP", "SN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1453", "GBP", "SA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1454", "GBP", "RU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1455", "GBP", "UG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1456", "GBP", "BR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1457", "GBP", "NI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1458", "GBP", "MG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1459", "GBP", "DO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1460", "GBP", "MX", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1461", "GBP", "OM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1462", "GBP", "CM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1463", "GBP", "ZA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1464", "GBP", "CL", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1465", "GBP", "KE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1466", "GBP", "NP", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1467", "GBP", "PE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1468", "GBP", "UA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1469", "GBP", "MZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1470", "GBP", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1471", "GBP", "AO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1472", "GBP", "JO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1473", "GBP", "ZW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1474", "GBP", "TR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1475", "GBP", "MU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1476", "GBP", "SV", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1477", "GBP", "TH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1478", "GBP", "CO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1479", "GBP", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1480", "GBP", "CR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1481", "GBP", "AR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1482", "GBP", "MA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1483", "GBP", "MY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1484", "GBP", "KZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1485", "GBP", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1486", "GBP", "ID", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1487", "GBP", "NG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1488", "GBP", "GT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1489", "GBP", "VN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1490", "GBP", "BY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1491", "GBP", "EG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1492", "GBP", "UY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1493", "GBP", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1494", "GBP", "PK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1495", "GBP", "PH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1496", "GBP", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1497", "GBP", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1498", "GBP", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1499", "GBP", "IN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1500", "GBP", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1501", "GBP", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1502", "GBP", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1503", "GBP", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1504", "GBP", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1505", "HKD", "US", "170", "475");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1506", "HKD", "CH", "155", "415");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1507", "HKD", "AU", "145", "365");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1508", "HKD", "GB", "125", "320");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1509", "HKD", "DE", "125", "315");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1510", "HKD", "DK", "115", "280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1511", "HKD", "AT", "85", "260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1512", "HKD", "NO", "95", "265");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1513", "HKD", "CA", "105", "320");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1514", "HKD", "NL", "110", "285");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1515", "HKD", "SE", "90", "240");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1516", "HKD", "IE", "90", "230");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1517", "HKD", "BE", "80", "240");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1518", "HKD", "FI", "60", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1519", "HKD", "FR", "75", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1520", "HKD", "NZ", "75", "225");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1521", "HKD", "HK", "70", "195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1522", "HKD", "CZ", "65", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1523", "HKD", "SK", "60", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1524", "HKD", "AE", "60", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1525", "HKD", "SG", "75", "225");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1526", "HKD", "IL", "65", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1527", "HKD", "KW", "30", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1528", "HKD", "IT", "45", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1529", "HKD", "JP", "55", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1530", "HKD", "ES", "45", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1531", "HKD", "VE", "5", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1532", "HKD", "HU", "40", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1533", "HKD", "PT", "40", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1534", "HKD", "GR", "50", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1535", "HKD", "KR", "60", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1536", "HKD", "TW", "50", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1537", "HKD", "PL", "40", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1538", "HKD", "ZM", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1539", "HKD", "PR", "15", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1540", "HKD", "CI", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1541", "HKD", "RO", "40", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1542", "HKD", "BH", "15", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1543", "HKD", "PA", "10", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1544", "HKD", "GH", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1545", "HKD", "KH", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1546", "HKD", "SN", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1547", "HKD", "SA", "25", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1548", "HKD", "RU", "25", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1549", "HKD", "UG", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1550", "HKD", "BR", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1551", "HKD", "NI", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1552", "HKD", "MG", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1553", "HKD", "DO", "5", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1554", "HKD", "MX", "20", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1555", "HKD", "OM", "15", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1556", "HKD", "CM", "5", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1557", "HKD", "ZA", "25", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1558", "HKD", "CL", "25", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1559", "HKD", "KE", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1560", "HKD", "NP", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1561", "HKD", "PE", "15", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1562", "HKD", "UA", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1563", "HKD", "MZ", "5", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1564", "HKD", "TZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1565", "HKD", "AO", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1566", "HKD", "JO", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1567", "HKD", "ZW", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1568", "HKD", "TR", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1569", "HKD", "MU", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1570", "HKD", "SV", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1571", "HKD", "TH", "25", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1572", "HKD", "CO", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1573", "HKD", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1574", "HKD", "CR", "5", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1575", "HKD", "AR", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1576", "HKD", "MA", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1577", "HKD", "MY", "20", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1578", "HKD", "KZ", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1579", "HKD", "DZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1580", "HKD", "ID", "20", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1581", "HKD", "NG", "10", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1582", "HKD", "GT", "5", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1583", "HKD", "VN", "15", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1584", "HKD", "BY", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1585", "HKD", "EG", "10", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1586", "HKD", "UY", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1587", "HKD", "BD", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1588", "HKD", "PK", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1589", "HKD", "PH", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1590", "HKD", "ET", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1591", "HKD", "TN", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1592", "HKD", "LB", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1593", "HKD", "IN", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1594", "HKD", "PY", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1595", "HKD", "UZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1596", "HKD", "EC", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1597", "HKD", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1598", "HKD", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1599", "HUF", "US", "6445", "18185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1600", "HUF", "CH", "6010", "15815");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1601", "HUF", "AU", "5470", "14040");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1602", "HUF", "GB", "4765", "12200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1603", "HUF", "DE", "4730", "12100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1604", "HUF", "DK", "4355", "10805");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1605", "HUF", "AT", "3175", "9870");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1606", "HUF", "NO", "3600", "10050");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1607", "HUF", "CA", "3980", "12205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1608", "HUF", "NL", "4260", "10805");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1609", "HUF", "SE", "3410", "9215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1610", "HUF", "IE", "3375", "8890");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1611", "HUF", "BE", "3100", "9090");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1612", "HUF", "FI", "2320", "7040");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1613", "HUF", "FR", "2870", "7685");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1614", "HUF", "NZ", "2920", "8600");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1615", "HUF", "HK", "2655", "7515");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1616", "HUF", "CZ", "2535", "6080");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1617", "HUF", "SK", "2390", "5180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1618", "HUF", "AE", "2255", "7080");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1619", "HUF", "SG", "2945", "8700");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1620", "HUF", "IL", "2570", "6280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1621", "HUF", "KW", "1160", "5645");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1622", "HUF", "IT", "1750", "4615");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1623", "HUF", "JP", "2190", "6230");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1624", "HUF", "ES", "1795", "4755");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1625", "HUF", "VE", "235", "3640");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1626", "HUF", "HU", "1515", "3525");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1627", "HUF", "PT", "1510", "3940");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1628", "HUF", "GR", "1865", "3820");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1629", "HUF", "KR", "2300", "6085");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1630", "HUF", "TW", "1870", "5000");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1631", "HUF", "PL", "1600", "3955");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1632", "HUF", "ZM", "230", "1315");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1633", "HUF", "PR", "565", "5305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1634", "HUF", "CI", "310", "1275");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1635", "HUF", "RO", "1470", "3555");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1636", "HUF", "BH", "665", "3695");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1637", "HUF", "PA", "445", "5075");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1638", "HUF", "GH", "535", "1495");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1639", "HUF", "KH", "310", "1480");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1640", "HUF", "SN", "225", "1610");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1641", "HUF", "SA", "960", "3670");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1642", "HUF", "RU", "950", "3040");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1643", "HUF", "UG", "225", "1175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1644", "HUF", "BR", "1015", "2505");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1645", "HUF", "NI", "225", "1605");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1646", "HUF", "MG", "225", "1135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1647", "HUF", "DO", "270", "1885");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1648", "HUF", "MX", "765", "2770");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1649", "HUF", "OM", "480", "2770");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1650", "HUF", "CM", "225", "2065");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1651", "HUF", "ZA", "910", "2935");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1652", "HUF", "CL", "950", "2840");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1653", "HUF", "KE", "275", "1185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1654", "HUF", "NP", "225", "1075");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1655", "HUF", "PE", "570", "2390");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1656", "HUF", "UA", "540", "1690");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1657", "HUF", "MZ", "225", "2245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1658", "HUF", "TZ", "30", "515");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1659", "HUF", "AO", "495", "1290");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1660", "HUF", "JO", "365", "1730");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1661", "HUF", "ZW", "225", "1230");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1662", "HUF", "TR", "580", "1590");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1663", "HUF", "MU", "295", "1015");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1664", "HUF", "SV", "225", "1230");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1665", "HUF", "TH", "870", "2740");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1666", "HUF", "CO", "440", "1710");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1667", "HUF", "LK", "215", "295");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1668", "HUF", "CR", "270", "1790");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1669", "HUF", "AR", "600", "1630");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1670", "HUF", "MA", "270", "1055");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1671", "HUF", "MY", "765", "2805");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1672", "HUF", "KZ", "325", "1195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1673", "HUF", "DZ", "265", "565");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1674", "HUF", "ID", "680", "2525");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1675", "HUF", "NG", "385", "2420");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1676", "HUF", "GT", "270", "1895");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1677", "HUF", "VN", "555", "2110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1678", "HUF", "BY", "260", "1020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1679", "HUF", "EG", "355", "2155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1680", "HUF", "UY", "280", "1280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1681", "HUF", "BD", "230", "505");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1682", "HUF", "PK", "250", "1445");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1683", "HUF", "PH", "435", "1605");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1684", "HUF", "ET", "70", "530");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1685", "HUF", "TN", "270", "485");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1686", "HUF", "LB", "270", "810");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1687", "HUF", "IN", "250", "1125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1688", "HUF", "PY", "270", "860");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1689", "HUF", "UZ", "270", "525");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1690", "HUF", "EC", "260", "895");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1691", "HUF", "MM", "270", "295");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1692", "HUF", "GE", "270", "345");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1693", "IDR", "US", "305805", "862850");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1694", "IDR", "CH", "285175", "750420");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1695", "IDR", "AU", "259480", "666220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1696", "IDR", "GB", "226230", "578945");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1697", "IDR", "DE", "224510", "574265");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1698", "IDR", "DK", "206565", "512635");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1699", "IDR", "AT", "150725", "468395");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1700", "IDR", "NO", "170840", "476995");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1701", "IDR", "CA", "188855", "579125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1702", "IDR", "NL", "202060", "512840");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1703", "IDR", "SE", "161735", "437360");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1704", "IDR", "IE", "160045", "421890");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1705", "IDR", "BE", "147180", "431340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1706", "IDR", "FI", "110030", "334155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1707", "IDR", "FR", "136245", "364680");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1708", "IDR", "NZ", "138660", "408205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1709", "IDR", "HK", "126095", "356600");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1710", "IDR", "CZ", "120220", "288620");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1711", "IDR", "SK", "113420", "245805");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1712", "IDR", "AE", "107035", "335905");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1713", "IDR", "SG", "139655", "412750");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1714", "IDR", "IL", "121875", "298120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1715", "IDR", "KW", "54975", "267955");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1716", "IDR", "IT", "82960", "219010");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1717", "IDR", "JP", "104020", "295625");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1718", "IDR", "ES", "85280", "225525");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1719", "IDR", "VE", "11180", "172745");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1720", "IDR", "HU", "71860", "167205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1721", "IDR", "PT", "71735", "187005");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1722", "IDR", "GR", "88455", "181160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1723", "IDR", "KR", "109060", "288805");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1724", "IDR", "TW", "88640", "237295");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1725", "IDR", "PL", "75845", "187750");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1726", "IDR", "ZM", "10955", "62500");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1727", "IDR", "PR", "26790", "251850");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1728", "IDR", "CI", "14620", "60420");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1729", "IDR", "RO", "69670", "168580");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1730", "IDR", "BH", "31635", "175390");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1731", "IDR", "PA", "21190", "240735");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1732", "IDR", "GH", "25400", "70875");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1733", "IDR", "KH", "14640", "70310");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1734", "IDR", "SN", "10660", "76395");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1735", "IDR", "SA", "45475", "174115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1736", "IDR", "RU", "45190", "144210");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1737", "IDR", "UG", "10620", "55825");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1738", "IDR", "BR", "48185", "118800");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1739", "IDR", "NI", "10595", "76070");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1740", "IDR", "MG", "10720", "53925");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1741", "IDR", "DO", "12860", "89405");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1742", "IDR", "MX", "36335", "131490");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1743", "IDR", "OM", "22840", "131495");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1744", "IDR", "CM", "10585", "97990");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1745", "IDR", "ZA", "43300", "139355");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1746", "IDR", "CL", "45110", "134805");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1747", "IDR", "KE", "13020", "56270");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1748", "IDR", "NP", "10585", "51110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1749", "IDR", "PE", "26945", "113410");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1750", "IDR", "UA", "25685", "80225");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1751", "IDR", "MZ", "10585", "106420");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1752", "IDR", "TZ", "1335", "24420");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1753", "IDR", "AO", "23465", "61185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1754", "IDR", "JO", "17305", "82175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1755", "IDR", "ZW", "10635", "58315");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1756", "IDR", "TR", "27565", "75415");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1757", "IDR", "MU", "14115", "48240");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1758", "IDR", "SV", "10585", "58430");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1759", "IDR", "TH", "41350", "130110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1760", "IDR", "CO", "20970", "81160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1761", "IDR", "LK", "10185", "14065");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1762", "IDR", "CR", "12785", "84925");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1763", "IDR", "AR", "28555", "77350");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1764", "IDR", "MA", "12755", "50060");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1765", "IDR", "MY", "36190", "133085");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1766", "IDR", "KZ", "15480", "56655");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1767", "IDR", "DZ", "12690", "26860");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1768", "IDR", "ID", "32290", "119790");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1769", "IDR", "NG", "18150", "114815");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1770", "IDR", "GT", "12715", "89915");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1771", "IDR", "VN", "26420", "100125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1772", "IDR", "BY", "12405", "48295");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1773", "IDR", "EG", "16730", "102190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1774", "IDR", "UY", "13190", "60785");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1775", "IDR", "BD", "10860", "24040");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1776", "IDR", "PK", "11905", "68530");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1777", "IDR", "PH", "20615", "76080");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1778", "IDR", "ET", "3305", "25200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1779", "IDR", "TN", "12700", "23015");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1780", "IDR", "LB", "12825", "38335");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1781", "IDR", "IN", "11825", "53405");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1782", "IDR", "PY", "12710", "40865");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1783", "IDR", "UZ", "12715", "24810");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1784", "IDR", "EC", "12355", "42380");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1785", "IDR", "MM", "12720", "13890");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1786", "IDR", "GE", "12760", "16260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1787", "ILS", "US", "70", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1788", "ILS", "CH", "65", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1789", "ILS", "AU", "60", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1790", "ILS", "GB", "50", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1791", "ILS", "DE", "50", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1792", "ILS", "DK", "45", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1793", "ILS", "AT", "35", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1794", "ILS", "NO", "40", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1795", "ILS", "CA", "40", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1796", "ILS", "NL", "45", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1797", "ILS", "SE", "35", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1798", "ILS", "IE", "35", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1799", "ILS", "BE", "35", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1800", "ILS", "FI", "25", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1801", "ILS", "FR", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1802", "ILS", "NZ", "30", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1803", "ILS", "HK", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1804", "ILS", "CZ", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1805", "ILS", "SK", "25", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1806", "ILS", "AE", "25", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1807", "ILS", "SG", "30", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1808", "ILS", "IL", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1809", "ILS", "KW", "10", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1810", "ILS", "IT", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1811", "ILS", "JP", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1812", "ILS", "ES", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1813", "ILS", "VE", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1814", "ILS", "HU", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1815", "ILS", "PT", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1816", "ILS", "GR", "20", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1817", "ILS", "KR", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1818", "ILS", "TW", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1819", "ILS", "PL", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1820", "ILS", "ZM", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1821", "ILS", "PR", "5", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1822", "ILS", "CI", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1823", "ILS", "RO", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1824", "ILS", "BH", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1825", "ILS", "PA", "5", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1826", "ILS", "GH", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1827", "ILS", "KH", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1828", "ILS", "SN", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1829", "ILS", "SA", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1830", "ILS", "RU", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1831", "ILS", "UG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1832", "ILS", "BR", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1833", "ILS", "NI", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1834", "ILS", "MG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1835", "ILS", "DO", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1836", "ILS", "MX", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1837", "ILS", "OM", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1838", "ILS", "CM", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1839", "ILS", "ZA", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1840", "ILS", "CL", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1841", "ILS", "KE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1842", "ILS", "NP", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1843", "ILS", "PE", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1844", "ILS", "UA", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1845", "ILS", "MZ", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1846", "ILS", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1847", "ILS", "AO", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1848", "ILS", "JO", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1849", "ILS", "ZW", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1850", "ILS", "TR", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1851", "ILS", "MU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1852", "ILS", "SV", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1853", "ILS", "TH", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1854", "ILS", "CO", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1855", "ILS", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1856", "ILS", "CR", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1857", "ILS", "AR", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1858", "ILS", "MA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1859", "ILS", "MY", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1860", "ILS", "KZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1861", "ILS", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1862", "ILS", "ID", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1863", "ILS", "NG", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1864", "ILS", "GT", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1865", "ILS", "VN", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1866", "ILS", "BY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1867", "ILS", "EG", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1868", "ILS", "UY", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1869", "ILS", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1870", "ILS", "PK", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1871", "ILS", "PH", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1872", "ILS", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1873", "ILS", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1874", "ILS", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1875", "ILS", "IN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1876", "ILS", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1877", "ILS", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1878", "ILS", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1879", "ILS", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1880", "ILS", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1881", "INR", "US", "1590", "4485");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1882", "INR", "CH", "1480", "3900");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1883", "INR", "AU", "1350", "3460");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1884", "INR", "GB", "1175", "3010");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1885", "INR", "DE", "1165", "2985");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1886", "INR", "DK", "1075", "2665");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1887", "INR", "AT", "785", "2435");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1888", "INR", "NO", "890", "2480");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1889", "INR", "CA", "980", "3010");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1890", "INR", "NL", "1050", "2665");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1891", "INR", "SE", "840", "2275");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1892", "INR", "IE", "830", "2195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1893", "INR", "BE", "765", "2240");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1894", "INR", "FI", "570", "1735");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1895", "INR", "FR", "710", "1895");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1896", "INR", "NZ", "720", "2120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1897", "INR", "HK", "655", "1855");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1898", "INR", "CZ", "625", "1500");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1899", "INR", "SK", "590", "1280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1900", "INR", "AE", "555", "1745");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1901", "INR", "SG", "725", "2145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1902", "INR", "IL", "635", "1550");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1903", "INR", "KW", "285", "1395");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1904", "INR", "IT", "430", "1140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1905", "INR", "JP", "540", "1535");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1906", "INR", "ES", "445", "1170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1907", "INR", "VE", "60", "900");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1908", "INR", "HU", "375", "870");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1909", "INR", "PT", "375", "970");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1910", "INR", "GR", "460", "940");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1911", "INR", "KR", "565", "1500");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1912", "INR", "TW", "460", "1235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1913", "INR", "PL", "395", "975");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1914", "INR", "ZM", "55", "325");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1915", "INR", "PR", "140", "1310");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1916", "INR", "CI", "75", "315");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1917", "INR", "RO", "360", "875");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1918", "INR", "BH", "165", "910");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1919", "INR", "PA", "110", "1250");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1920", "INR", "GH", "130", "370");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1921", "INR", "KH", "75", "365");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1922", "INR", "SN", "55", "395");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1923", "INR", "SA", "235", "905");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1924", "INR", "RU", "235", "750");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1925", "INR", "UG", "55", "290");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1926", "INR", "BR", "250", "615");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1927", "INR", "NI", "55", "395");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1928", "INR", "MG", "55", "280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1929", "INR", "DO", "65", "465");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1930", "INR", "MX", "190", "685");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1931", "INR", "OM", "120", "685");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1932", "INR", "CM", "55", "510");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1933", "INR", "ZA", "225", "725");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1934", "INR", "CL", "235", "700");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1935", "INR", "KE", "70", "290");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1936", "INR", "NP", "55", "265");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1937", "INR", "PE", "140", "590");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1938", "INR", "UA", "135", "415");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1939", "INR", "MZ", "55", "555");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1940", "INR", "TZ", "5", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1941", "INR", "AO", "120", "320");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1942", "INR", "JO", "90", "425");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1943", "INR", "ZW", "55", "305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1944", "INR", "TR", "145", "390");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1945", "INR", "MU", "75", "250");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1946", "INR", "SV", "55", "305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1947", "INR", "TH", "215", "675");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1948", "INR", "CO", "110", "420");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1949", "INR", "LK", "55", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1950", "INR", "CR", "65", "440");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1951", "INR", "AR", "150", "400");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1952", "INR", "MA", "65", "260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1953", "INR", "MY", "190", "690");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1954", "INR", "KZ", "80", "295");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1955", "INR", "DZ", "65", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1956", "INR", "ID", "170", "625");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1957", "INR", "NG", "95", "595");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1958", "INR", "GT", "65", "465");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1959", "INR", "VN", "135", "520");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1960", "INR", "BY", "65", "250");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1961", "INR", "EG", "85", "530");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1962", "INR", "UY", "70", "315");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1963", "INR", "BD", "55", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1964", "INR", "PK", "60", "355");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1965", "INR", "PH", "105", "395");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1966", "INR", "ET", "15", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1967", "INR", "TN", "65", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1968", "INR", "LB", "65", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1969", "INR", "IN", "60", "280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1970", "INR", "PY", "65", "210");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1971", "INR", "UZ", "65", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1972", "INR", "EC", "65", "220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1973", "INR", "MM", "65", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1974", "INR", "GE", "65", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1975", "JPY", "US", "2255", "6370");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1976", "JPY", "CH", "2105", "5540");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1977", "JPY", "AU", "1915", "4915");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1978", "JPY", "GB", "1670", "4275");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1979", "JPY", "DE", "1655", "4240");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1980", "JPY", "DK", "1525", "3785");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1981", "JPY", "AT", "1110", "3455");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1982", "JPY", "NO", "1260", "3520");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1983", "JPY", "CA", "1395", "4275");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1984", "JPY", "NL", "1490", "3785");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1985", "JPY", "SE", "1195", "3230");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1986", "JPY", "IE", "1180", "3115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1987", "JPY", "BE", "1085", "3185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1988", "JPY", "FI", "810", "2465");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1989", "JPY", "FR", "1005", "2690");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1990", "JPY", "NZ", "1025", "3015");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1991", "JPY", "HK", "930", "2630");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1992", "JPY", "CZ", "885", "2130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1993", "JPY", "SK", "835", "1815");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1994", "JPY", "AE", "790", "2480");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1995", "JPY", "SG", "1030", "3045");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1996", "JPY", "IL", "900", "2200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1997", "JPY", "KW", "405", "1980");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1998", "JPY", "IT", "610", "1615");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1999", "JPY", "JP", "770", "2180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2000", "JPY", "ES", "630", "1665");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2001", "JPY", "VE", "85", "1275");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2002", "JPY", "HU", "530", "1235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2003", "JPY", "PT", "530", "1380");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2004", "JPY", "GR", "655", "1335");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2005", "JPY", "KR", "805", "2130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2006", "JPY", "TW", "655", "1750");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2007", "JPY", "PL", "560", "1385");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2008", "JPY", "ZM", "80", "460");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2009", "JPY", "PR", "200", "1860");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2010", "JPY", "CI", "110", "445");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2011", "JPY", "RO", "515", "1245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2012", "JPY", "BH", "235", "1295");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2013", "JPY", "PA", "155", "1775");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2014", "JPY", "GH", "185", "525");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2015", "JPY", "KH", "110", "520");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2016", "JPY", "SN", "80", "565");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2017", "JPY", "SA", "335", "1285");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2018", "JPY", "RU", "335", "1065");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2019", "JPY", "UG", "80", "410");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2020", "JPY", "BR", "355", "875");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2021", "JPY", "NI", "80", "560");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2022", "JPY", "MG", "80", "400");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2023", "JPY", "DO", "95", "660");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2024", "JPY", "MX", "270", "970");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2025", "JPY", "OM", "170", "970");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2026", "JPY", "CM", "80", "725");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2027", "JPY", "ZA", "320", "1030");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2028", "JPY", "CL", "335", "995");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2029", "JPY", "KE", "95", "415");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2030", "JPY", "NP", "80", "375");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2031", "JPY", "PE", "200", "835");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2032", "JPY", "UA", "190", "590");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2033", "JPY", "MZ", "80", "785");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2034", "JPY", "TZ", "10", "180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2035", "JPY", "AO", "175", "450");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2036", "JPY", "JO", "130", "605");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2037", "JPY", "ZW", "80", "430");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2038", "JPY", "TR", "205", "555");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2039", "JPY", "MU", "105", "355");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2040", "JPY", "SV", "80", "430");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2041", "JPY", "TH", "305", "960");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2042", "JPY", "CO", "155", "600");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2043", "JPY", "LK", "75", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2044", "JPY", "CR", "95", "625");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2045", "JPY", "AR", "210", "570");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2046", "JPY", "MA", "95", "370");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2047", "JPY", "MY", "265", "980");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2048", "JPY", "KZ", "115", "420");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2049", "JPY", "DZ", "95", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2050", "JPY", "ID", "240", "885");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2051", "JPY", "NG", "135", "845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2052", "JPY", "GT", "95", "665");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2053", "JPY", "VN", "195", "740");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2054", "JPY", "BY", "90", "355");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2055", "JPY", "EG", "125", "755");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2056", "JPY", "UY", "95", "450");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2057", "JPY", "BD", "80", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2058", "JPY", "PK", "90", "505");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2059", "JPY", "PH", "150", "560");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2060", "JPY", "ET", "25", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2061", "JPY", "TN", "95", "170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2062", "JPY", "LB", "95", "285");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2063", "JPY", "IN", "85", "395");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2064", "JPY", "PY", "95", "300");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2065", "JPY", "UZ", "95", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2066", "JPY", "EC", "90", "315");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2067", "JPY", "MM", "95", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2068", "JPY", "GE", "95", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2069", "KRW", "US", "23860", "67325");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2070", "KRW", "CH", "22250", "58550");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2071", "KRW", "AU", "20245", "51980");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2072", "KRW", "GB", "17650", "45170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2073", "KRW", "DE", "17515", "44805");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2074", "KRW", "DK", "16115", "40000");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2075", "KRW", "AT", "11760", "36545");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2076", "KRW", "NO", "13330", "37215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2077", "KRW", "CA", "14735", "45185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2078", "KRW", "NL", "15765", "40015");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2079", "KRW", "SE", "12620", "34125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2080", "KRW", "IE", "12490", "32920");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2081", "KRW", "BE", "11485", "33655");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2082", "KRW", "FI", "8585", "26070");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2083", "KRW", "FR", "10630", "28455");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2084", "KRW", "NZ", "10820", "31850");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2085", "KRW", "HK", "9840", "27825");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2086", "KRW", "CZ", "9380", "22520");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2087", "KRW", "SK", "8850", "19180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2088", "KRW", "AE", "8350", "26210");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2089", "KRW", "SG", "10895", "32205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2090", "KRW", "IL", "9510", "23260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2091", "KRW", "KW", "4290", "20905");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2092", "KRW", "IT", "6475", "17090");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2093", "KRW", "JP", "8115", "23065");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2094", "KRW", "ES", "6655", "17595");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2095", "KRW", "VE", "870", "13480");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2096", "KRW", "HU", "5605", "13045");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2097", "KRW", "PT", "5595", "14590");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2098", "KRW", "GR", "6900", "14135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2099", "KRW", "KR", "8510", "22535");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2100", "KRW", "TW", "6915", "18515");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2101", "KRW", "PL", "5920", "14650");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2102", "KRW", "ZM", "855", "4875");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2103", "KRW", "PR", "2090", "19650");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2104", "KRW", "CI", "1140", "4715");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2105", "KRW", "RO", "5435", "13155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2106", "KRW", "BH", "2470", "13685");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2107", "KRW", "PA", "1655", "18785");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2108", "KRW", "GH", "1980", "5530");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2109", "KRW", "KH", "1140", "5485");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2110", "KRW", "SN", "830", "5960");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2111", "KRW", "SA", "3550", "13585");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2112", "KRW", "RU", "3525", "11250");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2113", "KRW", "UG", "830", "4355");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2114", "KRW", "BR", "3760", "9270");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2115", "KRW", "NI", "825", "5935");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2116", "KRW", "MG", "835", "4205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2117", "KRW", "DO", "1005", "6975");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2118", "KRW", "MX", "2835", "10260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2119", "KRW", "OM", "1780", "10260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2120", "KRW", "CM", "825", "7645");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2121", "KRW", "ZA", "3380", "10875");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2122", "KRW", "CL", "3520", "10520");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2123", "KRW", "KE", "1015", "4390");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2124", "KRW", "NP", "825", "3990");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2125", "KRW", "PE", "2100", "8850");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2126", "KRW", "UA", "2005", "6260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2127", "KRW", "MZ", "825", "8305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2128", "KRW", "TZ", "105", "1905");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2129", "KRW", "AO", "1830", "4775");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2130", "KRW", "JO", "1350", "6410");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2131", "KRW", "ZW", "830", "4550");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2132", "KRW", "TR", "2150", "5885");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2133", "KRW", "MU", "1100", "3765");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2134", "KRW", "SV", "825", "4560");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2135", "KRW", "TH", "3225", "10150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2136", "KRW", "CO", "1635", "6335");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2137", "KRW", "LK", "795", "1095");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2138", "KRW", "CR", "995", "6625");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2139", "KRW", "AR", "2230", "6035");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2140", "KRW", "MA", "995", "3905");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2141", "KRW", "MY", "2825", "10385");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2142", "KRW", "KZ", "1210", "4420");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2143", "KRW", "DZ", "990", "2095");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2144", "KRW", "ID", "2520", "9345");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2145", "KRW", "NG", "1415", "8960");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2146", "KRW", "GT", "990", "7015");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2147", "KRW", "VN", "2060", "7810");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2148", "KRW", "BY", "970", "3770");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2149", "KRW", "EG", "1305", "7975");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2150", "KRW", "UY", "1030", "4745");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2151", "KRW", "BD", "845", "1875");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2152", "KRW", "PK", "930", "5345");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2153", "KRW", "PH", "1610", "5935");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2154", "KRW", "ET", "260", "1965");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2155", "KRW", "TN", "990", "1795");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2156", "KRW", "LB", "1000", "2990");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2157", "KRW", "IN", "925", "4165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2158", "KRW", "PY", "990", "3190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2159", "KRW", "UZ", "990", "1935");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2160", "KRW", "EC", "965", "3305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2161", "KRW", "MM", "990", "1085");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2162", "KRW", "GE", "995", "1270");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2163", "MAD", "US", "195", "545");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2164", "MAD", "CH", "180", "475");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2165", "MAD", "AU", "165", "420");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2166", "MAD", "GB", "145", "365");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2167", "MAD", "DE", "140", "360");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2168", "MAD", "DK", "130", "325");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2169", "MAD", "AT", "95", "295");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2170", "MAD", "NO", "110", "300");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2171", "MAD", "CA", "120", "365");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2172", "MAD", "NL", "125", "325");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2173", "MAD", "SE", "100", "275");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2174", "MAD", "IE", "100", "265");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2175", "MAD", "BE", "95", "270");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2176", "MAD", "FI", "70", "210");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2177", "MAD", "FR", "85", "230");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2178", "MAD", "NZ", "85", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2179", "MAD", "HK", "80", "225");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2180", "MAD", "CZ", "75", "180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2181", "MAD", "SK", "70", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2182", "MAD", "AE", "65", "210");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2183", "MAD", "SG", "90", "260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2184", "MAD", "IL", "75", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2185", "MAD", "KW", "35", "170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2186", "MAD", "IT", "50", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2187", "MAD", "JP", "65", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2188", "MAD", "ES", "55", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2189", "MAD", "VE", "5", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2190", "MAD", "HU", "45", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2191", "MAD", "PT", "45", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2192", "MAD", "GR", "55", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2193", "MAD", "KR", "70", "180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2194", "MAD", "TW", "55", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2195", "MAD", "PL", "50", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2196", "MAD", "ZM", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2197", "MAD", "PR", "15", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2198", "MAD", "CI", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2199", "MAD", "RO", "45", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2200", "MAD", "BH", "20", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2201", "MAD", "PA", "15", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2202", "MAD", "GH", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2203", "MAD", "KH", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2204", "MAD", "SN", "5", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2205", "MAD", "SA", "30", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2206", "MAD", "RU", "30", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2207", "MAD", "UG", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2208", "MAD", "BR", "30", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2209", "MAD", "NI", "5", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2210", "MAD", "MG", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2211", "MAD", "DO", "10", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2212", "MAD", "MX", "25", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2213", "MAD", "OM", "15", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2214", "MAD", "CM", "5", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2215", "MAD", "ZA", "25", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2216", "MAD", "CL", "30", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2217", "MAD", "KE", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2218", "MAD", "NP", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2219", "MAD", "PE", "15", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2220", "MAD", "UA", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2221", "MAD", "MZ", "5", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2222", "MAD", "TZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2223", "MAD", "AO", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2224", "MAD", "JO", "10", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2225", "MAD", "ZW", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2226", "MAD", "TR", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2227", "MAD", "MU", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2228", "MAD", "SV", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2229", "MAD", "TH", "25", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2230", "MAD", "CO", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2231", "MAD", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2232", "MAD", "CR", "10", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2233", "MAD", "AR", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2234", "MAD", "MA", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2235", "MAD", "MY", "25", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2236", "MAD", "KZ", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2237", "MAD", "DZ", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2238", "MAD", "ID", "20", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2239", "MAD", "NG", "10", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2240", "MAD", "GT", "10", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2241", "MAD", "VN", "15", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2242", "MAD", "BY", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2243", "MAD", "EG", "10", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2244", "MAD", "UY", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2245", "MAD", "BD", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2246", "MAD", "PK", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2247", "MAD", "PH", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2248", "MAD", "ET", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2249", "MAD", "TN", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2250", "MAD", "LB", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2251", "MAD", "IN", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2252", "MAD", "PY", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2253", "MAD", "UZ", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2254", "MAD", "EC", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2255", "MAD", "MM", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2256", "MAD", "GE", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2257", "MXN", "US", "430", "1215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2258", "MXN", "CH", "400", "1060");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2259", "MXN", "AU", "365", "940");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2260", "MXN", "GB", "320", "815");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2261", "MXN", "DE", "315", "810");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2262", "MXN", "DK", "290", "725");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2263", "MXN", "AT", "215", "660");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2264", "MXN", "NO", "240", "675");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2265", "MXN", "CA", "265", "815");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2266", "MXN", "NL", "285", "725");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2267", "MXN", "SE", "230", "615");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2268", "MXN", "IE", "225", "595");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2269", "MXN", "BE", "210", "610");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2270", "MXN", "FI", "155", "470");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2271", "MXN", "FR", "190", "515");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2272", "MXN", "NZ", "195", "575");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2273", "MXN", "HK", "180", "505");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2274", "MXN", "CZ", "170", "405");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2275", "MXN", "SK", "160", "345");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2276", "MXN", "AE", "150", "475");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2277", "MXN", "SG", "195", "580");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2278", "MXN", "IL", "170", "420");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2279", "MXN", "KW", "80", "380");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2280", "MXN", "IT", "115", "310");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2281", "MXN", "JP", "145", "415");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2282", "MXN", "ES", "120", "320");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2283", "MXN", "VE", "15", "245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2284", "MXN", "HU", "100", "235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2285", "MXN", "PT", "100", "265");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2286", "MXN", "GR", "125", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2287", "MXN", "KR", "155", "405");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2288", "MXN", "TW", "125", "335");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2289", "MXN", "PL", "105", "265");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2290", "MXN", "ZM", "15", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2291", "MXN", "PR", "40", "355");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2292", "MXN", "CI", "20", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2293", "MXN", "RO", "100", "240");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2294", "MXN", "BH", "45", "245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2295", "MXN", "PA", "30", "340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2296", "MXN", "GH", "35", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2297", "MXN", "KH", "20", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2298", "MXN", "SN", "15", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2299", "MXN", "SA", "65", "245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2300", "MXN", "RU", "65", "205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2301", "MXN", "UG", "15", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2302", "MXN", "BR", "70", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2303", "MXN", "NI", "15", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2304", "MXN", "MG", "15", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2305", "MXN", "DO", "20", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2306", "MXN", "MX", "50", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2307", "MXN", "OM", "30", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2308", "MXN", "CM", "15", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2309", "MXN", "ZA", "60", "195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2310", "MXN", "CL", "65", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2311", "MXN", "KE", "20", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2312", "MXN", "NP", "15", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2313", "MXN", "PE", "40", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2314", "MXN", "UA", "35", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2315", "MXN", "MZ", "15", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2316", "MXN", "TZ", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2317", "MXN", "AO", "35", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2318", "MXN", "JO", "25", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2319", "MXN", "ZW", "15", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2320", "MXN", "TR", "40", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2321", "MXN", "MU", "20", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2322", "MXN", "SV", "15", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2323", "MXN", "TH", "60", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2324", "MXN", "CO", "30", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2325", "MXN", "LK", "15", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2326", "MXN", "CR", "20", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2327", "MXN", "AR", "40", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2328", "MXN", "MA", "20", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2329", "MXN", "MY", "50", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2330", "MXN", "KZ", "20", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2331", "MXN", "DZ", "20", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2332", "MXN", "ID", "45", "170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2333", "MXN", "NG", "25", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2334", "MXN", "GT", "20", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2335", "MXN", "VN", "35", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2336", "MXN", "BY", "15", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2337", "MXN", "EG", "25", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2338", "MXN", "UY", "20", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2339", "MXN", "BD", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2340", "MXN", "PK", "15", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2341", "MXN", "PH", "30", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2342", "MXN", "ET", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2343", "MXN", "TN", "20", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2344", "MXN", "LB", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2345", "MXN", "IN", "15", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2346", "MXN", "PY", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2347", "MXN", "UZ", "20", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2348", "MXN", "EC", "15", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2349", "MXN", "MM", "20", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2350", "MXN", "GE", "20", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2351", "MYR", "US", "90", "250");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2352", "MYR", "CH", "80", "215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2353", "MYR", "AU", "75", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2354", "MYR", "GB", "65", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2355", "MYR", "DE", "65", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2356", "MYR", "DK", "60", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2357", "MYR", "AT", "45", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2358", "MYR", "NO", "50", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2359", "MYR", "CA", "55", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2360", "MYR", "NL", "60", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2361", "MYR", "SE", "45", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2362", "MYR", "IE", "45", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2363", "MYR", "BE", "40", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2364", "MYR", "FI", "30", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2365", "MYR", "FR", "40", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2366", "MYR", "NZ", "40", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2367", "MYR", "HK", "35", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2368", "MYR", "CZ", "35", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2369", "MYR", "SK", "35", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2370", "MYR", "AE", "30", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2371", "MYR", "SG", "40", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2372", "MYR", "IL", "35", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2373", "MYR", "KW", "15", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2374", "MYR", "IT", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2375", "MYR", "JP", "30", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2376", "MYR", "ES", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2377", "MYR", "VE", "5", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2378", "MYR", "HU", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2379", "MYR", "PT", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2380", "MYR", "GR", "25", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2381", "MYR", "KR", "30", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2382", "MYR", "TW", "25", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2383", "MYR", "PL", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2384", "MYR", "ZM", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2385", "MYR", "PR", "10", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2386", "MYR", "CI", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2387", "MYR", "RO", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2388", "MYR", "BH", "10", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2389", "MYR", "PA", "5", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2390", "MYR", "GH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2391", "MYR", "KH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2392", "MYR", "SN", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2393", "MYR", "SA", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2394", "MYR", "RU", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2395", "MYR", "UG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2396", "MYR", "BR", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2397", "MYR", "NI", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2398", "MYR", "MG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2399", "MYR", "DO", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2400", "MYR", "MX", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2401", "MYR", "OM", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2402", "MYR", "CM", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2403", "MYR", "ZA", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2404", "MYR", "CL", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2405", "MYR", "KE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2406", "MYR", "NP", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2407", "MYR", "PE", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2408", "MYR", "UA", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2409", "MYR", "MZ", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2410", "MYR", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2411", "MYR", "AO", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2412", "MYR", "JO", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2413", "MYR", "ZW", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2414", "MYR", "TR", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2415", "MYR", "MU", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2416", "MYR", "SV", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2417", "MYR", "TH", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2418", "MYR", "CO", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2419", "MYR", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2420", "MYR", "CR", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2421", "MYR", "AR", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2422", "MYR", "MA", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2423", "MYR", "MY", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2424", "MYR", "KZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2425", "MYR", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2426", "MYR", "ID", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2427", "MYR", "NG", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2428", "MYR", "GT", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2429", "MYR", "VN", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2430", "MYR", "BY", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2431", "MYR", "EG", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2432", "MYR", "UY", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2433", "MYR", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2434", "MYR", "PK", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2435", "MYR", "PH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2436", "MYR", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2437", "MYR", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2438", "MYR", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2439", "MYR", "IN", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2440", "MYR", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2441", "MYR", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2442", "MYR", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2443", "MYR", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2444", "MYR", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2445", "NGN", "US", "8270", "23330");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2446", "NGN", "CH", "7710", "20290");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2447", "NGN", "AU", "7015", "18010");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2448", "NGN", "GB", "6115", "15650");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2449", "NGN", "DE", "6070", "15525");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2450", "NGN", "DK", "5585", "13860");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2451", "NGN", "AT", "4075", "12665");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2452", "NGN", "NO", "4620", "12895");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2453", "NGN", "CA", "5105", "15655");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2454", "NGN", "NL", "5465", "13865");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2455", "NGN", "SE", "4375", "11825");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2456", "NGN", "IE", "4325", "11405");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2457", "NGN", "BE", "3980", "11660");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2458", "NGN", "FI", "2975", "9035");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2459", "NGN", "FR", "3685", "9860");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2460", "NGN", "NZ", "3750", "11035");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2461", "NGN", "HK", "3410", "9640");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2462", "NGN", "CZ", "3250", "7805");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2463", "NGN", "SK", "3065", "6645");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2464", "NGN", "AE", "2895", "9080");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2465", "NGN", "SG", "3775", "11160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2466", "NGN", "IL", "3295", "8060");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2467", "NGN", "KW", "1485", "7245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2468", "NGN", "IT", "2245", "5920");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2469", "NGN", "JP", "2810", "7995");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2470", "NGN", "ES", "2305", "6095");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2471", "NGN", "VE", "300", "4670");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2472", "NGN", "HU", "1945", "4520");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2473", "NGN", "PT", "1940", "5055");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2474", "NGN", "GR", "2390", "4900");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2475", "NGN", "KR", "2950", "7810");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2476", "NGN", "TW", "2395", "6415");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2477", "NGN", "PL", "2050", "5075");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2478", "NGN", "ZM", "295", "1690");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2479", "NGN", "PR", "725", "6810");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2480", "NGN", "CI", "395", "1635");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2481", "NGN", "RO", "1885", "4560");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2482", "NGN", "BH", "855", "4740");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2483", "NGN", "PA", "575", "6510");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2484", "NGN", "GH", "685", "1915");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2485", "NGN", "KH", "395", "1900");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2486", "NGN", "SN", "290", "2065");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2487", "NGN", "SA", "1230", "4705");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2488", "NGN", "RU", "1220", "3900");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2489", "NGN", "UG", "285", "1510");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2490", "NGN", "BR", "1305", "3210");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2491", "NGN", "NI", "285", "2055");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2492", "NGN", "MG", "290", "1460");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2493", "NGN", "DO", "350", "2415");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2494", "NGN", "MX", "980", "3555");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2495", "NGN", "OM", "620", "3555");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2496", "NGN", "CM", "285", "2650");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2497", "NGN", "ZA", "1170", "3770");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2498", "NGN", "CL", "1220", "3645");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2499", "NGN", "KE", "350", "1520");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2500", "NGN", "NP", "285", "1380");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2501", "NGN", "PE", "730", "3065");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2502", "NGN", "UA", "695", "2170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2503", "NGN", "MZ", "285", "2875");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2504", "NGN", "TZ", "35", "660");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2505", "NGN", "AO", "635", "1655");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2506", "NGN", "JO", "470", "2220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2507", "NGN", "ZW", "290", "1575");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2508", "NGN", "TR", "745", "2040");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2509", "NGN", "MU", "380", "1305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2510", "NGN", "SV", "285", "1580");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2511", "NGN", "TH", "1120", "3520");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2512", "NGN", "CO", "565", "2195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2513", "NGN", "LK", "275", "380");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2514", "NGN", "CR", "345", "2295");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2515", "NGN", "AR", "770", "2090");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2516", "NGN", "MA", "345", "1355");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2517", "NGN", "MY", "980", "3600");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2518", "NGN", "KZ", "420", "1530");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2519", "NGN", "DZ", "345", "725");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2520", "NGN", "ID", "875", "3240");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2521", "NGN", "NG", "490", "3105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2522", "NGN", "GT", "345", "2430");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2523", "NGN", "VN", "715", "2705");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2524", "NGN", "BY", "335", "1305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2525", "NGN", "EG", "450", "2765");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2526", "NGN", "UY", "355", "1645");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2527", "NGN", "BD", "295", "650");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2528", "NGN", "PK", "320", "1855");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2529", "NGN", "PH", "555", "2055");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2530", "NGN", "ET", "90", "680");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2531", "NGN", "TN", "345", "620");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2532", "NGN", "LB", "345", "1035");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2533", "NGN", "IN", "320", "1445");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2534", "NGN", "PY", "345", "1105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2535", "NGN", "UZ", "345", "670");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2536", "NGN", "EC", "335", "1145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2537", "NGN", "MM", "345", "375");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2538", "NGN", "GE", "345", "440");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2539", "NOK", "US", "185", "520");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2540", "NOK", "CH", "170", "450");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2541", "NOK", "AU", "155", "400");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2542", "NOK", "GB", "135", "350");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2543", "NOK", "DE", "135", "345");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2544", "NOK", "DK", "125", "310");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2545", "NOK", "AT", "90", "280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2546", "NOK", "NO", "105", "285");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2547", "NOK", "CA", "115", "350");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2548", "NOK", "NL", "120", "310");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2549", "NOK", "SE", "95", "265");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2550", "NOK", "IE", "95", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2551", "NOK", "BE", "90", "260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2552", "NOK", "FI", "65", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2553", "NOK", "FR", "80", "220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2554", "NOK", "NZ", "85", "245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2555", "NOK", "HK", "75", "215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2556", "NOK", "CZ", "70", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2557", "NOK", "SK", "70", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2558", "NOK", "AE", "65", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2559", "NOK", "SG", "85", "250");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2560", "NOK", "IL", "75", "180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2561", "NOK", "KW", "35", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2562", "NOK", "IT", "50", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2563", "NOK", "JP", "65", "180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2564", "NOK", "ES", "50", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2565", "NOK", "VE", "5", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2566", "NOK", "HU", "45", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2567", "NOK", "PT", "45", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2568", "NOK", "GR", "55", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2569", "NOK", "KR", "65", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2570", "NOK", "TW", "55", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2571", "NOK", "PL", "45", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2572", "NOK", "ZM", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2573", "NOK", "PR", "15", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2574", "NOK", "CI", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2575", "NOK", "RO", "40", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2576", "NOK", "BH", "20", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2577", "NOK", "PA", "15", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2578", "NOK", "GH", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2579", "NOK", "KH", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2580", "NOK", "SN", "5", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2581", "NOK", "SA", "25", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2582", "NOK", "RU", "25", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2583", "NOK", "UG", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2584", "NOK", "BR", "30", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2585", "NOK", "NI", "5", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2586", "NOK", "MG", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2587", "NOK", "DO", "10", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2588", "NOK", "MX", "20", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2589", "NOK", "OM", "15", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2590", "NOK", "CM", "5", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2591", "NOK", "ZA", "25", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2592", "NOK", "CL", "25", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2593", "NOK", "KE", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2594", "NOK", "NP", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2595", "NOK", "PE", "15", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2596", "NOK", "UA", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2597", "NOK", "MZ", "5", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2598", "NOK", "TZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2599", "NOK", "AO", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2600", "NOK", "JO", "10", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2601", "NOK", "ZW", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2602", "NOK", "TR", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2603", "NOK", "MU", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2604", "NOK", "SV", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2605", "NOK", "TH", "25", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2606", "NOK", "CO", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2607", "NOK", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2608", "NOK", "CR", "10", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2609", "NOK", "AR", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2610", "NOK", "MA", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2611", "NOK", "MY", "20", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2612", "NOK", "KZ", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2613", "NOK", "DZ", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2614", "NOK", "ID", "20", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2615", "NOK", "NG", "10", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2616", "NOK", "GT", "10", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2617", "NOK", "VN", "15", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2618", "NOK", "BY", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2619", "NOK", "EG", "10", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2620", "NOK", "UY", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2621", "NOK", "BD", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2622", "NOK", "PK", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2623", "NOK", "PH", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2624", "NOK", "ET", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2625", "NOK", "TN", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2626", "NOK", "LB", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2627", "NOK", "IN", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2628", "NOK", "PY", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2629", "NOK", "UZ", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2630", "NOK", "EC", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2631", "NOK", "MM", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2632", "NOK", "GE", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2633", "PEN", "US", "80", "220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2634", "PEN", "CH", "75", "195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2635", "PEN", "AU", "65", "170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2636", "PEN", "GB", "60", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2637", "PEN", "DE", "60", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2638", "PEN", "DK", "55", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2639", "PEN", "AT", "40", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2640", "PEN", "NO", "45", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2641", "PEN", "CA", "50", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2642", "PEN", "NL", "50", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2643", "PEN", "SE", "40", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2644", "PEN", "IE", "40", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2645", "PEN", "BE", "40", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2646", "PEN", "FI", "30", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2647", "PEN", "FR", "35", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2648", "PEN", "NZ", "35", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2649", "PEN", "HK", "30", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2650", "PEN", "CZ", "30", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2651", "PEN", "SK", "30", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2652", "PEN", "AE", "25", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2653", "PEN", "SG", "35", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2654", "PEN", "IL", "30", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2655", "PEN", "KW", "15", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2656", "PEN", "IT", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2657", "PEN", "JP", "25", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2658", "PEN", "ES", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2659", "PEN", "VE", "5", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2660", "PEN", "HU", "20", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2661", "PEN", "PT", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2662", "PEN", "GR", "25", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2663", "PEN", "KR", "30", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2664", "PEN", "TW", "25", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2665", "PEN", "PL", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2666", "PEN", "ZM", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2667", "PEN", "PR", "5", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2668", "PEN", "CI", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2669", "PEN", "RO", "20", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2670", "PEN", "BH", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2671", "PEN", "PA", "5", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2672", "PEN", "GH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2673", "PEN", "KH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2674", "PEN", "SN", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2675", "PEN", "SA", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2676", "PEN", "RU", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2677", "PEN", "UG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2678", "PEN", "BR", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2679", "PEN", "NI", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2680", "PEN", "MG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2681", "PEN", "DO", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2682", "PEN", "MX", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2683", "PEN", "OM", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2684", "PEN", "CM", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2685", "PEN", "ZA", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2686", "PEN", "CL", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2687", "PEN", "KE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2688", "PEN", "NP", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2689", "PEN", "PE", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2690", "PEN", "UA", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2691", "PEN", "MZ", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2692", "PEN", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2693", "PEN", "AO", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2694", "PEN", "JO", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2695", "PEN", "ZW", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2696", "PEN", "TR", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2697", "PEN", "MU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2698", "PEN", "SV", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2699", "PEN", "TH", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2700", "PEN", "CO", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2701", "PEN", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2702", "PEN", "CR", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2703", "PEN", "AR", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2704", "PEN", "MA", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2705", "PEN", "MY", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2706", "PEN", "KZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2707", "PEN", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2708", "PEN", "ID", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2709", "PEN", "NG", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2710", "PEN", "GT", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2711", "PEN", "VN", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2712", "PEN", "BY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2713", "PEN", "EG", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2714", "PEN", "UY", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2715", "PEN", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2716", "PEN", "PK", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2717", "PEN", "PH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2718", "PEN", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2719", "PEN", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2720", "PEN", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2721", "PEN", "IN", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2722", "PEN", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2723", "PEN", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2724", "PEN", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2725", "PEN", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2726", "PEN", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2727", "PHP", "US", "1045", "2945");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2728", "PHP", "CH", "975", "2560");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2729", "PHP", "AU", "885", "2270");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2730", "PHP", "GB", "770", "1975");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2731", "PHP", "DE", "765", "1960");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2732", "PHP", "DK", "705", "1750");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2733", "PHP", "AT", "515", "1600");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2734", "PHP", "NO", "585", "1625");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2735", "PHP", "CA", "645", "1975");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2736", "PHP", "NL", "690", "1750");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2737", "PHP", "SE", "550", "1490");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2738", "PHP", "IE", "545", "1440");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2739", "PHP", "BE", "500", "1470");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2740", "PHP", "FI", "375", "1140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2741", "PHP", "FR", "465", "1245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2742", "PHP", "NZ", "475", "1390");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2743", "PHP", "HK", "430", "1215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2744", "PHP", "CZ", "410", "985");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2745", "PHP", "SK", "385", "840");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2746", "PHP", "AE", "365", "1145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2747", "PHP", "SG", "475", "1410");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2748", "PHP", "IL", "415", "1015");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2749", "PHP", "KW", "185", "915");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2750", "PHP", "IT", "285", "745");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2751", "PHP", "JP", "355", "1010");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2752", "PHP", "ES", "290", "770");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2753", "PHP", "VE", "40", "590");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2754", "PHP", "HU", "245", "570");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2755", "PHP", "PT", "245", "640");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2756", "PHP", "GR", "300", "620");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2757", "PHP", "KR", "370", "985");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2758", "PHP", "TW", "300", "810");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2759", "PHP", "PL", "260", "640");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2760", "PHP", "ZM", "35", "215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2761", "PHP", "PR", "90", "860");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2762", "PHP", "CI", "50", "205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2763", "PHP", "RO", "240", "575");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2764", "PHP", "BH", "110", "600");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2765", "PHP", "PA", "70", "820");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2766", "PHP", "GH", "85", "240");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2767", "PHP", "KH", "50", "240");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2768", "PHP", "SN", "35", "260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2769", "PHP", "SA", "155", "595");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2770", "PHP", "RU", "155", "490");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2771", "PHP", "UG", "35", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2772", "PHP", "BR", "165", "405");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2773", "PHP", "NI", "35", "260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2774", "PHP", "MG", "35", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2775", "PHP", "DO", "45", "305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2776", "PHP", "MX", "125", "450");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2777", "PHP", "OM", "80", "450");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2778", "PHP", "CM", "35", "335");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2779", "PHP", "ZA", "150", "475");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2780", "PHP", "CL", "155", "460");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2781", "PHP", "KE", "45", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2782", "PHP", "NP", "35", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2783", "PHP", "PE", "90", "385");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2784", "PHP", "UA", "90", "275");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2785", "PHP", "MZ", "35", "365");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2786", "PHP", "TZ", "5", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2787", "PHP", "AO", "80", "210");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2788", "PHP", "JO", "60", "280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2789", "PHP", "ZW", "35", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2790", "PHP", "TR", "95", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2791", "PHP", "MU", "50", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2792", "PHP", "SV", "35", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2793", "PHP", "TH", "140", "445");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2794", "PHP", "CO", "70", "275");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2795", "PHP", "LK", "35", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2796", "PHP", "CR", "45", "290");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2797", "PHP", "AR", "95", "265");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2798", "PHP", "MA", "45", "170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2799", "PHP", "MY", "125", "455");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2800", "PHP", "KZ", "55", "195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2801", "PHP", "DZ", "45", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2802", "PHP", "ID", "110", "410");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2803", "PHP", "NG", "60", "390");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2804", "PHP", "GT", "45", "305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2805", "PHP", "VN", "90", "340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2806", "PHP", "BY", "40", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2807", "PHP", "EG", "55", "350");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2808", "PHP", "UY", "45", "205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2809", "PHP", "BD", "35", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2810", "PHP", "PK", "40", "235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2811", "PHP", "PH", "70", "260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2812", "PHP", "ET", "10", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2813", "PHP", "TN", "45", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2814", "PHP", "LB", "45", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2815", "PHP", "IN", "40", "180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2816", "PHP", "PY", "45", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2817", "PHP", "UZ", "45", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2818", "PHP", "EC", "40", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2819", "PHP", "MM", "45", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2820", "PHP", "GE", "45", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2821", "PKR", "US", "3485", "9840");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2822", "PKR", "CH", "3250", "8555");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2823", "PKR", "AU", "2960", "7595");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2824", "PKR", "GB", "2580", "6600");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2825", "PKR", "DE", "2560", "6550");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2826", "PKR", "DK", "2355", "5845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2827", "PKR", "AT", "1720", "5340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2828", "PKR", "NO", "1950", "5440");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2829", "PKR", "CA", "2155", "6605");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2830", "PKR", "NL", "2305", "5850");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2831", "PKR", "SE", "1845", "4985");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2832", "PKR", "IE", "1825", "4810");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2833", "PKR", "BE", "1680", "4920");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2834", "PKR", "FI", "1255", "3810");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2835", "PKR", "FR", "1555", "4160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2836", "PKR", "NZ", "1580", "4655");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2837", "PKR", "HK", "1440", "4065");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2838", "PKR", "CZ", "1370", "3290");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2839", "PKR", "SK", "1295", "2805");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2840", "PKR", "AE", "1220", "3830");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2841", "PKR", "SG", "1590", "4705");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2842", "PKR", "IL", "1390", "3400");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2843", "PKR", "KW", "625", "3055");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2844", "PKR", "IT", "945", "2495");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2845", "PKR", "JP", "1185", "3370");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2846", "PKR", "ES", "970", "2570");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2847", "PKR", "VE", "125", "1970");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2848", "PKR", "HU", "820", "1905");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2849", "PKR", "PT", "820", "2130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2850", "PKR", "GR", "1010", "2065");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2851", "PKR", "KR", "1245", "3295");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2852", "PKR", "TW", "1010", "2705");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2853", "PKR", "PL", "865", "2140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2854", "PKR", "ZM", "125", "715");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2855", "PKR", "PR", "305", "2870");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2856", "PKR", "CI", "165", "690");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2857", "PKR", "RO", "795", "1920");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2858", "PKR", "BH", "360", "2000");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2859", "PKR", "PA", "240", "2745");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2860", "PKR", "GH", "290", "810");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2861", "PKR", "KH", "165", "800");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2862", "PKR", "SN", "120", "870");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2863", "PKR", "SA", "520", "1985");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2864", "PKR", "RU", "515", "1645");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2865", "PKR", "UG", "120", "635");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2866", "PKR", "BR", "550", "1355");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2867", "PKR", "NI", "120", "865");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2868", "PKR", "MG", "120", "615");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2869", "PKR", "DO", "145", "1020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2870", "PKR", "MX", "415", "1500");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2871", "PKR", "OM", "260", "1500");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2872", "PKR", "CM", "120", "1115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2873", "PKR", "ZA", "495", "1590");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2874", "PKR", "CL", "515", "1535");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2875", "PKR", "KE", "150", "640");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2876", "PKR", "NP", "120", "585");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2877", "PKR", "PE", "305", "1295");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2878", "PKR", "UA", "295", "915");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2879", "PKR", "MZ", "120", "1215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2880", "PKR", "TZ", "15", "280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2881", "PKR", "AO", "270", "700");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2882", "PKR", "JO", "195", "935");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2883", "PKR", "ZW", "120", "665");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2884", "PKR", "TR", "315", "860");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2885", "PKR", "MU", "160", "550");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2886", "PKR", "SV", "120", "665");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2887", "PKR", "TH", "470", "1485");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2888", "PKR", "CO", "240", "925");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2889", "PKR", "LK", "115", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2890", "PKR", "CR", "145", "970");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2891", "PKR", "AR", "325", "880");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2892", "PKR", "MA", "145", "570");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2893", "PKR", "MY", "415", "1515");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2894", "PKR", "KZ", "175", "645");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2895", "PKR", "DZ", "145", "305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2896", "PKR", "ID", "370", "1365");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2897", "PKR", "NG", "205", "1310");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2898", "PKR", "GT", "145", "1025");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2899", "PKR", "VN", "300", "1140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2900", "PKR", "BY", "140", "550");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2901", "PKR", "EG", "190", "1165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2902", "PKR", "UY", "150", "695");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2903", "PKR", "BD", "125", "275");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2904", "PKR", "PK", "135", "780");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2905", "PKR", "PH", "235", "870");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2906", "PKR", "ET", "40", "285");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2907", "PKR", "TN", "145", "260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2908", "PKR", "LB", "145", "435");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2909", "PKR", "IN", "135", "610");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2910", "PKR", "PY", "145", "465");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2911", "PKR", "UZ", "145", "285");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2912", "PKR", "EC", "140", "485");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2913", "PKR", "MM", "145", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2914", "PKR", "GE", "145", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2915", "PLN", "US", "80", "230");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2916", "PLN", "CH", "75", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2917", "PLN", "AU", "70", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2918", "PLN", "GB", "60", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2919", "PLN", "DE", "60", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2920", "PLN", "DK", "55", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2921", "PLN", "AT", "40", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2922", "PLN", "NO", "45", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2923", "PLN", "CA", "50", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2924", "PLN", "NL", "55", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2925", "PLN", "SE", "45", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2926", "PLN", "IE", "40", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2927", "PLN", "BE", "40", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2928", "PLN", "FI", "30", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2929", "PLN", "FR", "35", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2930", "PLN", "NZ", "35", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2931", "PLN", "HK", "35", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2932", "PLN", "CZ", "30", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2933", "PLN", "SK", "30", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2934", "PLN", "AE", "30", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2935", "PLN", "SG", "35", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2936", "PLN", "IL", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2937", "PLN", "KW", "15", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2938", "PLN", "IT", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2939", "PLN", "JP", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2940", "PLN", "ES", "25", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2941", "PLN", "VE", "5", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2942", "PLN", "HU", "20", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2943", "PLN", "PT", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2944", "PLN", "GR", "25", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2945", "PLN", "KR", "30", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2946", "PLN", "TW", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2947", "PLN", "PL", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2948", "PLN", "ZM", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2949", "PLN", "PR", "5", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2950", "PLN", "CI", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2951", "PLN", "RO", "20", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2952", "PLN", "BH", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2953", "PLN", "PA", "5", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2954", "PLN", "GH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2955", "PLN", "KH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2956", "PLN", "SN", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2957", "PLN", "SA", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2958", "PLN", "RU", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2959", "PLN", "UG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2960", "PLN", "BR", "15", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2961", "PLN", "NI", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2962", "PLN", "MG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2963", "PLN", "DO", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2964", "PLN", "MX", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2965", "PLN", "OM", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2966", "PLN", "CM", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2967", "PLN", "ZA", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2968", "PLN", "CL", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2969", "PLN", "KE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2970", "PLN", "NP", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2971", "PLN", "PE", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2972", "PLN", "UA", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2973", "PLN", "MZ", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2974", "PLN", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2975", "PLN", "AO", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2976", "PLN", "JO", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2977", "PLN", "ZW", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2978", "PLN", "TR", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2979", "PLN", "MU", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2980", "PLN", "SV", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2981", "PLN", "TH", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2982", "PLN", "CO", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2983", "PLN", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2984", "PLN", "CR", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2985", "PLN", "AR", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2986", "PLN", "MA", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2987", "PLN", "MY", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2988", "PLN", "KZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2989", "PLN", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2990", "PLN", "ID", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2991", "PLN", "NG", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2992", "PLN", "GT", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2993", "PLN", "VN", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2994", "PLN", "BY", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2995", "PLN", "EG", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2996", "PLN", "UY", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2997", "PLN", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2998", "PLN", "PK", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2999", "PLN", "PH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3000", "PLN", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3001", "PLN", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3002", "PLN", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3003", "PLN", "IN", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3004", "PLN", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3005", "PLN", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3006", "PLN", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3007", "PLN", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3008", "PLN", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3009", "RON", "US", "85", "245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3010", "RON", "CH", "80", "215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3011", "RON", "AU", "75", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3012", "RON", "GB", "65", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3013", "RON", "DE", "65", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3014", "RON", "DK", "60", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3015", "RON", "AT", "45", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3016", "RON", "NO", "50", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3017", "RON", "CA", "55", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3018", "RON", "NL", "60", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3019", "RON", "SE", "45", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3020", "RON", "IE", "45", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3021", "RON", "BE", "40", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3022", "RON", "FI", "30", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3023", "RON", "FR", "40", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3024", "RON", "NZ", "40", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3025", "RON", "HK", "35", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3026", "RON", "CZ", "35", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3027", "RON", "SK", "30", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3028", "RON", "AE", "30", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3029", "RON", "SG", "40", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3030", "RON", "IL", "35", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3031", "RON", "KW", "15", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3032", "RON", "IT", "25", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3033", "RON", "JP", "30", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3034", "RON", "ES", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3035", "RON", "VE", "5", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3036", "RON", "HU", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3037", "RON", "PT", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3038", "RON", "GR", "25", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3039", "RON", "KR", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3040", "RON", "TW", "25", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3041", "RON", "PL", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3042", "RON", "ZM", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3043", "RON", "PR", "10", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3044", "RON", "CI", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3045", "RON", "RO", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3046", "RON", "BH", "10", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3047", "RON", "PA", "5", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3048", "RON", "GH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3049", "RON", "KH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3050", "RON", "SN", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3051", "RON", "SA", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3052", "RON", "RU", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3053", "RON", "UG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3054", "RON", "BR", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3055", "RON", "NI", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3056", "RON", "MG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3057", "RON", "DO", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3058", "RON", "MX", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3059", "RON", "OM", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3060", "RON", "CM", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3061", "RON", "ZA", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3062", "RON", "CL", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3063", "RON", "KE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3064", "RON", "NP", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3065", "RON", "PE", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3066", "RON", "UA", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3067", "RON", "MZ", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3068", "RON", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3069", "RON", "AO", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3070", "RON", "JO", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3071", "RON", "ZW", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3072", "RON", "TR", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3073", "RON", "MU", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3074", "RON", "SV", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3075", "RON", "TH", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3076", "RON", "CO", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3077", "RON", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3078", "RON", "CR", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3079", "RON", "AR", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3080", "RON", "MA", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3081", "RON", "MY", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3082", "RON", "KZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3083", "RON", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3084", "RON", "ID", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3085", "RON", "NG", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3086", "RON", "GT", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3087", "RON", "VN", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3088", "RON", "BY", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3089", "RON", "EG", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3090", "RON", "UY", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3091", "RON", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3092", "RON", "PK", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3093", "RON", "PH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3094", "RON", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3095", "RON", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3096", "RON", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3097", "RON", "IN", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3098", "RON", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3099", "RON", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3100", "RON", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3101", "RON", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3102", "RON", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3103", "RSD", "US", "2100", "5930");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3104", "RSD", "CH", "1960", "5155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3105", "RSD", "AU", "1785", "4580");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3106", "RSD", "GB", "1555", "3980");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3107", "RSD", "DE", "1545", "3945");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3108", "RSD", "DK", "1420", "3525");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3109", "RSD", "AT", "1035", "3220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3110", "RSD", "NO", "1175", "3280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3111", "RSD", "CA", "1300", "3980");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3112", "RSD", "NL", "1390", "3525");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3113", "RSD", "SE", "1110", "3005");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3114", "RSD", "IE", "1100", "2900");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3115", "RSD", "BE", "1010", "2965");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3116", "RSD", "FI", "755", "2295");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3117", "RSD", "FR", "935", "2505");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3118", "RSD", "NZ", "955", "2805");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3119", "RSD", "HK", "865", "2450");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3120", "RSD", "CZ", "825", "1985");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3121", "RSD", "SK", "780", "1690");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3122", "RSD", "AE", "735", "2310");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3123", "RSD", "SG", "960", "2835");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3124", "RSD", "IL", "840", "2050");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3125", "RSD", "KW", "380", "1840");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3126", "RSD", "IT", "570", "1505");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3127", "RSD", "JP", "715", "2030");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3128", "RSD", "ES", "585", "1550");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3129", "RSD", "VE", "75", "1185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3130", "RSD", "HU", "495", "1150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3131", "RSD", "PT", "495", "1285");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3132", "RSD", "GR", "610", "1245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3133", "RSD", "KR", "750", "1985");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3134", "RSD", "TW", "610", "1630");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3135", "RSD", "PL", "520", "1290");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3136", "RSD", "ZM", "75", "430");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3137", "RSD", "PR", "185", "1730");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3138", "RSD", "CI", "100", "415");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3139", "RSD", "RO", "480", "1160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3140", "RSD", "BH", "215", "1205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3141", "RSD", "PA", "145", "1655");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3142", "RSD", "GH", "175", "485");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3143", "RSD", "KH", "100", "485");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3144", "RSD", "SN", "75", "525");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3145", "RSD", "SA", "315", "1195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3146", "RSD", "RU", "310", "990");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3147", "RSD", "UG", "75", "385");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3148", "RSD", "BR", "330", "815");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3149", "RSD", "NI", "75", "525");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3150", "RSD", "MG", "75", "370");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3151", "RSD", "DO", "90", "615");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3152", "RSD", "MX", "250", "905");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3153", "RSD", "OM", "155", "905");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3154", "RSD", "CM", "75", "675");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3155", "RSD", "ZA", "300", "960");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3156", "RSD", "CL", "310", "925");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3157", "RSD", "KE", "90", "385");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3158", "RSD", "NP", "75", "350");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3159", "RSD", "PE", "185", "780");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3160", "RSD", "UA", "175", "550");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3161", "RSD", "MZ", "75", "730");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3162", "RSD", "TZ", "10", "170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3163", "RSD", "AO", "160", "420");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3164", "RSD", "JO", "120", "565");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3165", "RSD", "ZW", "75", "400");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3166", "RSD", "TR", "190", "520");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3167", "RSD", "MU", "95", "330");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3168", "RSD", "SV", "75", "400");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3169", "RSD", "TH", "285", "895");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3170", "RSD", "CO", "145", "560");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3171", "RSD", "LK", "70", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3172", "RSD", "CR", "90", "585");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3173", "RSD", "AR", "195", "530");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3174", "RSD", "MA", "90", "345");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3175", "RSD", "MY", "250", "915");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3176", "RSD", "KZ", "105", "390");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3177", "RSD", "DZ", "85", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3178", "RSD", "ID", "220", "825");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3179", "RSD", "NG", "125", "790");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3180", "RSD", "GT", "85", "620");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3181", "RSD", "VN", "180", "690");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3182", "RSD", "BY", "85", "330");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3183", "RSD", "EG", "115", "700");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3184", "RSD", "UY", "90", "420");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3185", "RSD", "BD", "75", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3186", "RSD", "PK", "80", "470");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3187", "RSD", "PH", "140", "525");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3188", "RSD", "ET", "25", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3189", "RSD", "TN", "85", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3190", "RSD", "LB", "90", "265");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3191", "RSD", "IN", "80", "365");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3192", "RSD", "PY", "85", "280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3193", "RSD", "UZ", "85", "170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3194", "RSD", "EC", "85", "290");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3195", "RSD", "MM", "85", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3196", "RSD", "GE", "90", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3197", "RUB", "US", "1605", "4525");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3198", "RUB", "CH", "1495", "3935");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3199", "RUB", "AU", "1360", "3495");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3200", "RUB", "GB", "1185", "3035");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3201", "RUB", "DE", "1180", "3010");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3202", "RUB", "DK", "1085", "2690");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3203", "RUB", "AT", "790", "2455");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3204", "RUB", "NO", "895", "2500");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3205", "RUB", "CA", "990", "3040");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3206", "RUB", "NL", "1060", "2690");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3207", "RUB", "SE", "850", "2295");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3208", "RUB", "IE", "840", "2215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3209", "RUB", "BE", "770", "2260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3210", "RUB", "FI", "575", "1755");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3211", "RUB", "FR", "715", "1915");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3212", "RUB", "NZ", "725", "2140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3213", "RUB", "HK", "660", "1870");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3214", "RUB", "CZ", "630", "1515");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3215", "RUB", "SK", "595", "1290");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3216", "RUB", "AE", "560", "1760");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3217", "RUB", "SG", "735", "2165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3218", "RUB", "IL", "640", "1565");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3219", "RUB", "KW", "290", "1405");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3220", "RUB", "IT", "435", "1150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3221", "RUB", "JP", "545", "1550");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3222", "RUB", "ES", "445", "1185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3223", "RUB", "VE", "60", "905");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3224", "RUB", "HU", "375", "875");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3225", "RUB", "PT", "375", "980");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3226", "RUB", "GR", "465", "950");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3227", "RUB", "KR", "570", "1515");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3228", "RUB", "TW", "465", "1245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3229", "RUB", "PL", "400", "985");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3230", "RUB", "ZM", "55", "330");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3231", "RUB", "PR", "140", "1320");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3232", "RUB", "CI", "75", "315");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3233", "RUB", "RO", "365", "885");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3234", "RUB", "BH", "165", "920");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3235", "RUB", "PA", "110", "1265");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3236", "RUB", "GH", "135", "370");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3237", "RUB", "KH", "75", "370");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3238", "RUB", "SN", "55", "400");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3239", "RUB", "SA", "240", "915");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3240", "RUB", "RU", "235", "755");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3241", "RUB", "UG", "55", "295");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3242", "RUB", "BR", "255", "625");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3243", "RUB", "NI", "55", "400");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3244", "RUB", "MG", "55", "285");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3245", "RUB", "DO", "65", "470");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3246", "RUB", "MX", "190", "690");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3247", "RUB", "OM", "120", "690");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3248", "RUB", "CM", "55", "515");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3249", "RUB", "ZA", "225", "730");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3250", "RUB", "CL", "235", "705");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3251", "RUB", "KE", "70", "295");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3252", "RUB", "NP", "55", "270");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3253", "RUB", "PE", "140", "595");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3254", "RUB", "UA", "135", "420");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3255", "RUB", "MZ", "55", "560");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3256", "RUB", "TZ", "5", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3257", "RUB", "AO", "125", "320");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3258", "RUB", "JO", "90", "430");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3259", "RUB", "ZW", "55", "305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3260", "RUB", "TR", "145", "395");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3261", "RUB", "MU", "75", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3262", "RUB", "SV", "55", "305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3263", "RUB", "TH", "215", "680");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3264", "RUB", "CO", "110", "425");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3265", "RUB", "LK", "55", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3266", "RUB", "CR", "65", "445");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3267", "RUB", "AR", "150", "405");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3268", "RUB", "MA", "65", "265");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3269", "RUB", "MY", "190", "700");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3270", "RUB", "KZ", "80", "295");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3271", "RUB", "DZ", "65", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3272", "RUB", "ID", "170", "630");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3273", "RUB", "NG", "95", "600");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3274", "RUB", "GT", "65", "470");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3275", "RUB", "VN", "140", "525");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3276", "RUB", "BY", "65", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3277", "RUB", "EG", "90", "535");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3278", "RUB", "UY", "70", "320");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3279", "RUB", "BD", "55", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3280", "RUB", "PK", "60", "360");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3281", "RUB", "PH", "110", "400");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3282", "RUB", "ET", "15", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3283", "RUB", "TN", "65", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3284", "RUB", "LB", "65", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3285", "RUB", "IN", "60", "280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3286", "RUB", "PY", "65", "215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3287", "RUB", "UZ", "65", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3288", "RUB", "EC", "65", "220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3289", "RUB", "MM", "65", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3290", "RUB", "GE", "65", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3291", "SAR", "US", "80", "230");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3292", "SAR", "CH", "75", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3293", "SAR", "AU", "70", "180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3294", "SAR", "GB", "60", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3295", "SAR", "DE", "60", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3296", "SAR", "DK", "55", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3297", "SAR", "AT", "40", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3298", "SAR", "NO", "45", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3299", "SAR", "CA", "50", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3300", "SAR", "NL", "55", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3301", "SAR", "SE", "45", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3302", "SAR", "IE", "45", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3303", "SAR", "BE", "40", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3304", "SAR", "FI", "30", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3305", "SAR", "FR", "35", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3306", "SAR", "NZ", "35", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3307", "SAR", "HK", "35", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3308", "SAR", "CZ", "30", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3309", "SAR", "SK", "30", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3310", "SAR", "AE", "30", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3311", "SAR", "SG", "35", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3312", "SAR", "IL", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3313", "SAR", "KW", "15", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3314", "SAR", "IT", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3315", "SAR", "JP", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3316", "SAR", "ES", "25", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3317", "SAR", "VE", "5", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3318", "SAR", "HU", "20", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3319", "SAR", "PT", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3320", "SAR", "GR", "25", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3321", "SAR", "KR", "30", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3322", "SAR", "TW", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3323", "SAR", "PL", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3324", "SAR", "ZM", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3325", "SAR", "PR", "5", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3326", "SAR", "CI", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3327", "SAR", "RO", "20", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3328", "SAR", "BH", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3329", "SAR", "PA", "5", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3330", "SAR", "GH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3331", "SAR", "KH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3332", "SAR", "SN", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3333", "SAR", "SA", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3334", "SAR", "RU", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3335", "SAR", "UG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3336", "SAR", "BR", "15", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3337", "SAR", "NI", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3338", "SAR", "MG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3339", "SAR", "DO", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3340", "SAR", "MX", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3341", "SAR", "OM", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3342", "SAR", "CM", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3343", "SAR", "ZA", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3344", "SAR", "CL", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3345", "SAR", "KE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3346", "SAR", "NP", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3347", "SAR", "PE", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3348", "SAR", "UA", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3349", "SAR", "MZ", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3350", "SAR", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3351", "SAR", "AO", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3352", "SAR", "JO", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3353", "SAR", "ZW", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3354", "SAR", "TR", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3355", "SAR", "MU", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3356", "SAR", "SV", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3357", "SAR", "TH", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3358", "SAR", "CO", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3359", "SAR", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3360", "SAR", "CR", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3361", "SAR", "AR", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3362", "SAR", "MA", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3363", "SAR", "MY", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3364", "SAR", "KZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3365", "SAR", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3366", "SAR", "ID", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3367", "SAR", "NG", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3368", "SAR", "GT", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3369", "SAR", "VN", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3370", "SAR", "BY", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3371", "SAR", "EG", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3372", "SAR", "UY", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3373", "SAR", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3374", "SAR", "PK", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3375", "SAR", "PH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3376", "SAR", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3377", "SAR", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3378", "SAR", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3379", "SAR", "IN", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3380", "SAR", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3381", "SAR", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3382", "SAR", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3383", "SAR", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3384", "SAR", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3385", "SEK", "US", "180", "510");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3386", "SEK", "CH", "170", "445");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3387", "SEK", "AU", "155", "395");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3388", "SEK", "GB", "135", "345");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3389", "SEK", "DE", "135", "340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3390", "SEK", "DK", "125", "305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3391", "SEK", "AT", "90", "280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3392", "SEK", "NO", "100", "285");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3393", "SEK", "CA", "110", "345");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3394", "SEK", "NL", "120", "305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3395", "SEK", "SE", "95", "260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3396", "SEK", "IE", "95", "250");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3397", "SEK", "BE", "85", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3398", "SEK", "FI", "65", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3399", "SEK", "FR", "80", "215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3400", "SEK", "NZ", "80", "240");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3401", "SEK", "HK", "75", "210");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3402", "SEK", "CZ", "70", "170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3403", "SEK", "SK", "65", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3404", "SEK", "AE", "65", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3405", "SEK", "SG", "85", "245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3406", "SEK", "IL", "70", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3407", "SEK", "KW", "35", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3408", "SEK", "IT", "50", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3409", "SEK", "JP", "60", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3410", "SEK", "ES", "50", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3411", "SEK", "VE", "5", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3412", "SEK", "HU", "45", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3413", "SEK", "PT", "45", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3414", "SEK", "GR", "50", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3415", "SEK", "KR", "65", "170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3416", "SEK", "TW", "55", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3417", "SEK", "PL", "45", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3418", "SEK", "ZM", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3419", "SEK", "PR", "15", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3420", "SEK", "CI", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3421", "SEK", "RO", "40", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3422", "SEK", "BH", "20", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3423", "SEK", "PA", "15", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3424", "SEK", "GH", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3425", "SEK", "KH", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3426", "SEK", "SN", "5", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3427", "SEK", "SA", "25", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3428", "SEK", "RU", "25", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3429", "SEK", "UG", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3430", "SEK", "BR", "30", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3431", "SEK", "NI", "5", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3432", "SEK", "MG", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3433", "SEK", "DO", "10", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3434", "SEK", "MX", "20", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3435", "SEK", "OM", "15", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3436", "SEK", "CM", "5", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3437", "SEK", "ZA", "25", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3438", "SEK", "CL", "25", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3439", "SEK", "KE", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3440", "SEK", "NP", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3441", "SEK", "PE", "15", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3442", "SEK", "UA", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3443", "SEK", "MZ", "5", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3444", "SEK", "TZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3445", "SEK", "AO", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3446", "SEK", "JO", "10", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3447", "SEK", "ZW", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3448", "SEK", "TR", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3449", "SEK", "MU", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3450", "SEK", "SV", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3451", "SEK", "TH", "25", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3452", "SEK", "CO", "10", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3453", "SEK", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3454", "SEK", "CR", "10", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3455", "SEK", "AR", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3456", "SEK", "MA", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3457", "SEK", "MY", "20", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3458", "SEK", "KZ", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3459", "SEK", "DZ", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3460", "SEK", "ID", "20", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3461", "SEK", "NG", "10", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3462", "SEK", "GT", "10", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3463", "SEK", "VN", "15", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3464", "SEK", "BY", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3465", "SEK", "EG", "10", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3466", "SEK", "UY", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3467", "SEK", "BD", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3468", "SEK", "PK", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3469", "SEK", "PH", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3470", "SEK", "ET", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3471", "SEK", "TN", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3472", "SEK", "LB", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3473", "SEK", "IN", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3474", "SEK", "PY", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3475", "SEK", "UZ", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3476", "SEK", "EC", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3477", "SEK", "MM", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3478", "SEK", "GE", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3479", "SGD", "US", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3480", "SGD", "CH", "25", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3481", "SGD", "AU", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3482", "SGD", "GB", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3483", "SGD", "DE", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3484", "SGD", "DK", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3485", "SGD", "AT", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3486", "SGD", "NO", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3487", "SGD", "CA", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3488", "SGD", "NL", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3489", "SGD", "SE", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3490", "SGD", "IE", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3491", "SGD", "BE", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3492", "SGD", "FI", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3493", "SGD", "FR", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3494", "SGD", "NZ", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3495", "SGD", "HK", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3496", "SGD", "CZ", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3497", "SGD", "SK", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3498", "SGD", "AE", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3499", "SGD", "SG", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3500", "SGD", "IL", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3501", "SGD", "KW", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3502", "SGD", "IT", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3503", "SGD", "JP", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3504", "SGD", "ES", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3505", "SGD", "VE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3506", "SGD", "HU", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3507", "SGD", "PT", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3508", "SGD", "GR", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3509", "SGD", "KR", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3510", "SGD", "TW", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3511", "SGD", "PL", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3512", "SGD", "ZM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3513", "SGD", "PR", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3514", "SGD", "CI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3515", "SGD", "RO", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3516", "SGD", "BH", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3517", "SGD", "PA", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3518", "SGD", "GH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3519", "SGD", "KH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3520", "SGD", "SN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3521", "SGD", "SA", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3522", "SGD", "RU", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3523", "SGD", "UG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3524", "SGD", "BR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3525", "SGD", "NI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3526", "SGD", "MG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3527", "SGD", "DO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3528", "SGD", "MX", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3529", "SGD", "OM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3530", "SGD", "CM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3531", "SGD", "ZA", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3532", "SGD", "CL", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3533", "SGD", "KE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3534", "SGD", "NP", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3535", "SGD", "PE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3536", "SGD", "UA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3537", "SGD", "MZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3538", "SGD", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3539", "SGD", "AO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3540", "SGD", "JO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3541", "SGD", "ZW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3542", "SGD", "TR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3543", "SGD", "MU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3544", "SGD", "SV", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3545", "SGD", "TH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3546", "SGD", "CO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3547", "SGD", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3548", "SGD", "CR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3549", "SGD", "AR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3550", "SGD", "MA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3551", "SGD", "MY", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3552", "SGD", "KZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3553", "SGD", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3554", "SGD", "ID", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3555", "SGD", "NG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3556", "SGD", "GT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3557", "SGD", "VN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3558", "SGD", "BY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3559", "SGD", "EG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3560", "SGD", "UY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3561", "SGD", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3562", "SGD", "PK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3563", "SGD", "PH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3564", "SGD", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3565", "SGD", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3566", "SGD", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3567", "SGD", "IN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3568", "SGD", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3569", "SGD", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3570", "SGD", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3571", "SGD", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3572", "SGD", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3573", "THB", "US", "650", "1840");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3574", "THB", "CH", "610", "1600");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3575", "THB", "AU", "555", "1420");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3576", "THB", "GB", "485", "1235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3577", "THB", "DE", "480", "1225");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3578", "THB", "DK", "440", "1095");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3579", "THB", "AT", "320", "1000");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3580", "THB", "NO", "365", "1020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3581", "THB", "CA", "405", "1235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3582", "THB", "NL", "430", "1095");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3583", "THB", "SE", "345", "935");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3584", "THB", "IE", "340", "900");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3585", "THB", "BE", "315", "920");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3586", "THB", "FI", "235", "715");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3587", "THB", "FR", "290", "780");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3588", "THB", "NZ", "295", "870");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3589", "THB", "HK", "270", "760");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3590", "THB", "CZ", "255", "615");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3591", "THB", "SK", "240", "525");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3592", "THB", "AE", "230", "715");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3593", "THB", "SG", "300", "880");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3594", "THB", "IL", "260", "635");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3595", "THB", "KW", "115", "570");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3596", "THB", "IT", "175", "465");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3597", "THB", "JP", "220", "630");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3598", "THB", "ES", "180", "480");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3599", "THB", "VE", "25", "370");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3600", "THB", "HU", "155", "355");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3601", "THB", "PT", "155", "400");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3602", "THB", "GR", "190", "385");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3603", "THB", "KR", "235", "615");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3604", "THB", "TW", "190", "505");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3605", "THB", "PL", "160", "400");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3606", "THB", "ZM", "25", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3607", "THB", "PR", "55", "535");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3608", "THB", "CI", "30", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3609", "THB", "RO", "150", "360");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3610", "THB", "BH", "70", "375");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3611", "THB", "PA", "45", "515");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3612", "THB", "GH", "55", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3613", "THB", "KH", "30", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3614", "THB", "SN", "25", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3615", "THB", "SA", "95", "370");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3616", "THB", "RU", "95", "310");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3617", "THB", "UG", "25", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3618", "THB", "BR", "105", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3619", "THB", "NI", "25", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3620", "THB", "MG", "25", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3621", "THB", "DO", "25", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3622", "THB", "MX", "80", "280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3623", "THB", "OM", "50", "280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3624", "THB", "CM", "25", "210");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3625", "THB", "ZA", "90", "295");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3626", "THB", "CL", "95", "290");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3627", "THB", "KE", "30", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3628", "THB", "NP", "25", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3629", "THB", "PE", "55", "240");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3630", "THB", "UA", "55", "170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3631", "THB", "MZ", "25", "225");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3632", "THB", "TZ", "5", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3633", "THB", "AO", "50", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3634", "THB", "JO", "35", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3635", "THB", "ZW", "25", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3636", "THB", "TR", "60", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3637", "THB", "MU", "30", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3638", "THB", "SV", "25", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3639", "THB", "TH", "90", "280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3640", "THB", "CO", "45", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3641", "THB", "LK", "20", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3642", "THB", "CR", "25", "180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3643", "THB", "AR", "60", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3644", "THB", "MA", "25", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3645", "THB", "MY", "75", "285");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3646", "THB", "KZ", "35", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3647", "THB", "DZ", "25", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3648", "THB", "ID", "70", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3649", "THB", "NG", "40", "245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3650", "THB", "GT", "25", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3651", "THB", "VN", "55", "215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3652", "THB", "BY", "25", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3653", "THB", "EG", "35", "220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3654", "THB", "UY", "30", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3655", "THB", "BD", "25", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3656", "THB", "PK", "25", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3657", "THB", "PH", "45", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3658", "THB", "ET", "5", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3659", "THB", "TN", "25", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3660", "THB", "LB", "25", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3661", "THB", "IN", "25", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3662", "THB", "PY", "25", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3663", "THB", "UZ", "25", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3664", "THB", "EC", "25", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3665", "THB", "MM", "25", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3666", "THB", "GE", "25", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3667", "TRY", "US", "160", "455");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3668", "TRY", "CH", "150", "395");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3669", "TRY", "AU", "135", "350");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3670", "TRY", "GB", "120", "305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3671", "TRY", "DE", "120", "300");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3672", "TRY", "DK", "110", "270");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3673", "TRY", "AT", "80", "245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3674", "TRY", "NO", "90", "250");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3675", "TRY", "CA", "100", "305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3676", "TRY", "NL", "105", "270");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3677", "TRY", "SE", "85", "230");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3678", "TRY", "IE", "85", "220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3679", "TRY", "BE", "75", "225");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3680", "TRY", "FI", "60", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3681", "TRY", "FR", "70", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3682", "TRY", "NZ", "75", "215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3683", "TRY", "HK", "65", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3684", "TRY", "CZ", "65", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3685", "TRY", "SK", "60", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3686", "TRY", "AE", "55", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3687", "TRY", "SG", "75", "215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3688", "TRY", "IL", "65", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3689", "TRY", "KW", "30", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3690", "TRY", "IT", "45", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3691", "TRY", "JP", "55", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3692", "TRY", "ES", "45", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3693", "TRY", "VE", "5", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3694", "TRY", "HU", "40", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3695", "TRY", "PT", "40", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3696", "TRY", "GR", "45", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3697", "TRY", "KR", "55", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3698", "TRY", "TW", "45", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3699", "TRY", "PL", "40", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3700", "TRY", "ZM", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3701", "TRY", "PR", "15", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3702", "TRY", "CI", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3703", "TRY", "RO", "35", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3704", "TRY", "BH", "15", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3705", "TRY", "PA", "10", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3706", "TRY", "GH", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3707", "TRY", "KH", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3708", "TRY", "SN", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3709", "TRY", "SA", "25", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3710", "TRY", "RU", "25", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3711", "TRY", "UG", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3712", "TRY", "BR", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3713", "TRY", "NI", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3714", "TRY", "MG", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3715", "TRY", "DO", "5", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3716", "TRY", "MX", "20", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3717", "TRY", "OM", "10", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3718", "TRY", "CM", "5", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3719", "TRY", "ZA", "25", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3720", "TRY", "CL", "25", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3721", "TRY", "KE", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3722", "TRY", "NP", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3723", "TRY", "PE", "15", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3724", "TRY", "UA", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3725", "TRY", "MZ", "5", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3726", "TRY", "TZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3727", "TRY", "AO", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3728", "TRY", "JO", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3729", "TRY", "ZW", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3730", "TRY", "TR", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3731", "TRY", "MU", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3732", "TRY", "SV", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3733", "TRY", "TH", "20", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3734", "TRY", "CO", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3735", "TRY", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3736", "TRY", "CR", "5", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3737", "TRY", "AR", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3738", "TRY", "MA", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3739", "TRY", "MY", "20", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3740", "TRY", "KZ", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3741", "TRY", "DZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3742", "TRY", "ID", "15", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3743", "TRY", "NG", "10", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3744", "TRY", "GT", "5", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3745", "TRY", "VN", "15", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3746", "TRY", "BY", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3747", "TRY", "EG", "10", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3748", "TRY", "UY", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3749", "TRY", "BD", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3750", "TRY", "PK", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3751", "TRY", "PH", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3752", "TRY", "ET", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3753", "TRY", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3754", "TRY", "LB", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3755", "TRY", "IN", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3756", "TRY", "PY", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3757", "TRY", "UZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3758", "TRY", "EC", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3759", "TRY", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3760", "TRY", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3761", "TWD", "US", "610", "1715");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3762", "TWD", "CH", "570", "1495");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3763", "TWD", "AU", "515", "1325");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3764", "TWD", "GB", "450", "1150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3765", "TWD", "DE", "445", "1145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3766", "TWD", "DK", "410", "1020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3767", "TWD", "AT", "300", "930");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3768", "TWD", "NO", "340", "950");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3769", "TWD", "CA", "375", "1155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3770", "TWD", "NL", "400", "1020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3771", "TWD", "SE", "320", "870");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3772", "TWD", "IE", "320", "840");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3773", "TWD", "BE", "295", "860");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3774", "TWD", "FI", "220", "665");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3775", "TWD", "FR", "270", "725");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3776", "TWD", "NZ", "275", "810");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3777", "TWD", "HK", "250", "710");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3778", "TWD", "CZ", "240", "575");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3779", "TWD", "SK", "225", "490");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3780", "TWD", "AE", "215", "670");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3781", "TWD", "SG", "280", "820");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3782", "TWD", "IL", "245", "595");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3783", "TWD", "KW", "110", "535");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3784", "TWD", "IT", "165", "435");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3785", "TWD", "JP", "205", "590");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3786", "TWD", "ES", "170", "450");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3787", "TWD", "VE", "20", "345");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3788", "TWD", "HU", "145", "335");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3789", "TWD", "PT", "145", "370");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3790", "TWD", "GR", "175", "360");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3791", "TWD", "KR", "215", "575");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3792", "TWD", "TW", "175", "470");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3793", "TWD", "PL", "150", "375");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3794", "TWD", "ZM", "20", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3795", "TWD", "PR", "55", "500");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3796", "TWD", "CI", "30", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3797", "TWD", "RO", "140", "335");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3798", "TWD", "BH", "65", "350");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3799", "TWD", "PA", "40", "480");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3800", "TWD", "GH", "50", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3801", "TWD", "KH", "30", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3802", "TWD", "SN", "20", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3803", "TWD", "SA", "90", "345");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3804", "TWD", "RU", "90", "285");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3805", "TWD", "UG", "20", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3806", "TWD", "BR", "95", "235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3807", "TWD", "NI", "20", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3808", "TWD", "MG", "20", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3809", "TWD", "DO", "25", "180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3810", "TWD", "MX", "70", "260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3811", "TWD", "OM", "45", "260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3812", "TWD", "CM", "20", "195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3813", "TWD", "ZA", "85", "275");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3814", "TWD", "CL", "90", "270");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3815", "TWD", "KE", "25", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3816", "TWD", "NP", "20", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3817", "TWD", "PE", "55", "225");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3818", "TWD", "UA", "50", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3819", "TWD", "MZ", "20", "210");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3820", "TWD", "TZ", "5", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3821", "TWD", "AO", "45", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3822", "TWD", "JO", "35", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3823", "TWD", "ZW", "20", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3824", "TWD", "TR", "55", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3825", "TWD", "MU", "30", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3826", "TWD", "SV", "20", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3827", "TWD", "TH", "80", "260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3828", "TWD", "CO", "40", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3829", "TWD", "LK", "20", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3830", "TWD", "CR", "25", "170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3831", "TWD", "AR", "55", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3832", "TWD", "MA", "25", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3833", "TWD", "MY", "70", "265");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3834", "TWD", "KZ", "30", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3835", "TWD", "DZ", "25", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3836", "TWD", "ID", "65", "240");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3837", "TWD", "NG", "35", "230");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3838", "TWD", "GT", "25", "180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3839", "TWD", "VN", "55", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3840", "TWD", "BY", "25", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3841", "TWD", "EG", "35", "205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3842", "TWD", "UY", "25", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3843", "TWD", "BD", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3844", "TWD", "PK", "25", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3845", "TWD", "PH", "40", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3846", "TWD", "ET", "5", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3847", "TWD", "TN", "25", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3848", "TWD", "LB", "25", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3849", "TWD", "IN", "25", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3850", "TWD", "PY", "25", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3851", "TWD", "UZ", "25", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3852", "TWD", "EC", "25", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3853", "TWD", "MM", "25", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3854", "TWD", "GE", "25", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3855", "UAH", "US", "610", "1720");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3856", "UAH", "CH", "570", "1495");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3857", "UAH", "AU", "515", "1330");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3858", "UAH", "GB", "450", "1155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3859", "UAH", "DE", "450", "1145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3860", "UAH", "DK", "410", "1020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3861", "UAH", "AT", "300", "935");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3862", "UAH", "NO", "340", "950");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3863", "UAH", "CA", "375", "1155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3864", "UAH", "NL", "405", "1020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3865", "UAH", "SE", "320", "870");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3866", "UAH", "IE", "320", "840");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3867", "UAH", "BE", "295", "860");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3868", "UAH", "FI", "220", "665");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3869", "UAH", "FR", "270", "725");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3870", "UAH", "NZ", "275", "815");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3871", "UAH", "HK", "250", "710");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3872", "UAH", "CZ", "240", "575");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3873", "UAH", "SK", "225", "490");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3874", "UAH", "AE", "215", "670");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3875", "UAH", "SG", "280", "825");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3876", "UAH", "IL", "245", "595");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3877", "UAH", "KW", "110", "535");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3878", "UAH", "IT", "165", "435");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3879", "UAH", "JP", "205", "590");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3880", "UAH", "ES", "170", "450");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3881", "UAH", "VE", "20", "345");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3882", "UAH", "HU", "145", "335");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3883", "UAH", "PT", "145", "375");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3884", "UAH", "GR", "175", "360");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3885", "UAH", "KR", "215", "575");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3886", "UAH", "TW", "175", "475");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3887", "UAH", "PL", "150", "375");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3888", "UAH", "ZM", "20", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3889", "UAH", "PR", "55", "500");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3890", "UAH", "CI", "30", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3891", "UAH", "RO", "140", "335");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3892", "UAH", "BH", "65", "350");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3893", "UAH", "PA", "40", "480");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3894", "UAH", "GH", "50", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3895", "UAH", "KH", "30", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3896", "UAH", "SN", "20", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3897", "UAH", "SA", "90", "345");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3898", "UAH", "RU", "90", "290");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3899", "UAH", "UG", "20", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3900", "UAH", "BR", "95", "235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3901", "UAH", "NI", "20", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3902", "UAH", "MG", "20", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3903", "UAH", "DO", "25", "180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3904", "UAH", "MX", "70", "260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3905", "UAH", "OM", "45", "260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3906", "UAH", "CM", "20", "195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3907", "UAH", "ZA", "85", "280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3908", "UAH", "CL", "90", "270");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3909", "UAH", "KE", "25", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3910", "UAH", "NP", "20", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3911", "UAH", "PE", "55", "225");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3912", "UAH", "UA", "50", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3913", "UAH", "MZ", "20", "210");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3914", "UAH", "TZ", "5", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3915", "UAH", "AO", "45", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3916", "UAH", "JO", "35", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3917", "UAH", "ZW", "20", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3918", "UAH", "TR", "55", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3919", "UAH", "MU", "30", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3920", "UAH", "SV", "20", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3921", "UAH", "TH", "80", "260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3922", "UAH", "CO", "40", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3923", "UAH", "LK", "20", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3924", "UAH", "CR", "25", "170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3925", "UAH", "AR", "55", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3926", "UAH", "MA", "25", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3927", "UAH", "MY", "70", "265");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3928", "UAH", "KZ", "30", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3929", "UAH", "DZ", "25", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3930", "UAH", "ID", "65", "240");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3931", "UAH", "NG", "35", "230");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3932", "UAH", "GT", "25", "180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3933", "UAH", "VN", "55", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3934", "UAH", "BY", "25", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3935", "UAH", "EG", "35", "205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3936", "UAH", "UY", "25", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3937", "UAH", "BD", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3938", "UAH", "PK", "25", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3939", "UAH", "PH", "40", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3940", "UAH", "ET", "5", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3941", "UAH", "TN", "25", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3942", "UAH", "LB", "25", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3943", "UAH", "IN", "25", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3944", "UAH", "PY", "25", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3945", "UAH", "UZ", "25", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3946", "UAH", "EC", "25", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3947", "UAH", "MM", "25", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3948", "UAH", "GE", "25", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3949", "USD", "US", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3950", "USD", "CH", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3951", "USD", "AU", "20", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3952", "USD", "GB", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3953", "USD", "DE", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3954", "USD", "DK", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3955", "USD", "AT", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3956", "USD", "NO", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3957", "USD", "CA", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3958", "USD", "NL", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3959", "USD", "SE", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3960", "USD", "IE", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3961", "USD", "BE", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3962", "USD", "FI", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3963", "USD", "FR", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3964", "USD", "NZ", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3965", "USD", "HK", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3966", "USD", "CZ", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3967", "USD", "SK", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3968", "USD", "AE", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3969", "USD", "SG", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3970", "USD", "IL", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3971", "USD", "KW", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3972", "USD", "IT", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3973", "USD", "JP", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3974", "USD", "ES", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3975", "USD", "VE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3976", "USD", "HU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3977", "USD", "PT", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3978", "USD", "GR", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3979", "USD", "KR", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3980", "USD", "TW", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3981", "USD", "PL", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3982", "USD", "ZM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3983", "USD", "PR", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3984", "USD", "CI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3985", "USD", "RO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3986", "USD", "BH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3987", "USD", "PA", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3988", "USD", "GH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3989", "USD", "KH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3990", "USD", "SN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3991", "USD", "SA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3992", "USD", "RU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3993", "USD", "UG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3994", "USD", "BR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3995", "USD", "NI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3996", "USD", "MG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3997", "USD", "DO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3998", "USD", "MX", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3999", "USD", "OM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4000", "USD", "CM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4001", "USD", "ZA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4002", "USD", "CL", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4003", "USD", "KE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4004", "USD", "NP", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4005", "USD", "PE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4006", "USD", "UA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4007", "USD", "MZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4008", "USD", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4009", "USD", "AO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4010", "USD", "JO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4011", "USD", "ZW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4012", "USD", "TR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4013", "USD", "MU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4014", "USD", "SV", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4015", "USD", "TH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4016", "USD", "CO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4017", "USD", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4018", "USD", "CR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4019", "USD", "AR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4020", "USD", "MA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4021", "USD", "MY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4022", "USD", "KZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4023", "USD", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4024", "USD", "ID", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4025", "USD", "NG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4026", "USD", "GT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4027", "USD", "VN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4028", "USD", "BY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4029", "USD", "EG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4030", "USD", "UY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4031", "USD", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4032", "USD", "PK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4033", "USD", "PH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4034", "USD", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4035", "USD", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4036", "USD", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4037", "USD", "IN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4038", "USD", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4039", "USD", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4040", "USD", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4041", "USD", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4042", "USD", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4043", "VND", "US", "501260", "1414340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4044", "VND", "CH", "467440", "1230050");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4045", "VND", "AU", "425330", "1092035");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4046", "VND", "GB", "370825", "948980");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4047", "VND", "DE", "368005", "941305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4048", "VND", "DK", "338590", "840285");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4049", "VND", "AT", "247060", "767770");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4050", "VND", "NO", "280035", "781870");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4051", "VND", "CA", "309560", "949275");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4052", "VND", "NL", "331205", "840625");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4053", "VND", "SE", "265110", "716900");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4054", "VND", "IE", "262340", "691545");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4055", "VND", "BE", "241250", "707035");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4056", "VND", "FI", "180355", "547725");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4057", "VND", "FR", "223325", "597765");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4058", "VND", "NZ", "227285", "669110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4059", "VND", "HK", "206690", "584525");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4060", "VND", "CZ", "197060", "473095");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4061", "VND", "SK", "185915", "402915");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4062", "VND", "AE", "175445", "550600");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4063", "VND", "SG", "228920", "676560");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4064", "VND", "IL", "199775", "488665");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4065", "VND", "KW", "90110", "439220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4066", "VND", "IT", "135985", "358995");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4067", "VND", "JP", "170500", "484575");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4068", "VND", "ES", "139790", "369670");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4069", "VND", "VE", "18325", "283150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4070", "VND", "HU", "117795", "274075");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4071", "VND", "PT", "117590", "306530");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4072", "VND", "GR", "144990", "296945");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4073", "VND", "KR", "178765", "473390");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4074", "VND", "TW", "145295", "388965");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4075", "VND", "PL", "124320", "307750");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4076", "VND", "ZM", "17955", "102445");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4077", "VND", "PR", "43915", "412820");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4078", "VND", "CI", "23965", "99035");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4079", "VND", "RO", "114205", "276330");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4080", "VND", "BH", "51860", "287490");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4081", "VND", "PA", "34735", "394605");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4082", "VND", "GH", "41630", "116170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4083", "VND", "KH", "24000", "115255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4084", "VND", "SN", "17475", "125220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4085", "VND", "SA", "74540", "285405");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4086", "VND", "RU", "74075", "236380");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4087", "VND", "UG", "17405", "91510");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4088", "VND", "BR", "78980", "194735");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4089", "VND", "NI", "17370", "124690");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4090", "VND", "MG", "17575", "88390");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4091", "VND", "DO", "21075", "146550");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4092", "VND", "MX", "59560", "215530");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4093", "VND", "OM", "37440", "215540");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4094", "VND", "CM", "17345", "160620");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4095", "VND", "ZA", "70970", "228425");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4096", "VND", "CL", "73940", "220970");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4097", "VND", "KE", "21345", "92235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4098", "VND", "NP", "17345", "83780");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4099", "VND", "PE", "44165", "185900");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4100", "VND", "UA", "42105", "131500");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4101", "VND", "MZ", "17345", "174435");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4102", "VND", "TZ", "2190", "40030");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4103", "VND", "AO", "38465", "100290");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4104", "VND", "JO", "28365", "134700");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4105", "VND", "ZW", "17435", "95590");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4106", "VND", "TR", "45180", "123620");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4107", "VND", "MU", "23140", "79070");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4108", "VND", "SV", "17345", "95775");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4109", "VND", "TH", "67775", "213265");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4110", "VND", "CO", "34375", "133035");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4111", "VND", "LK", "16690", "23055");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4112", "VND", "CR", "20955", "139205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4113", "VND", "AR", "46810", "126790");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4114", "VND", "MA", "20905", "82055");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4115", "VND", "MY", "59320", "218145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4116", "VND", "KZ", "25370", "92865");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4117", "VND", "DZ", "20800", "44030");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4118", "VND", "ID", "52930", "196355");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4119", "VND", "NG", "29750", "188200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4120", "VND", "GT", "20845", "147390");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4121", "VND", "VN", "43305", "164120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4122", "VND", "BY", "20335", "79160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4123", "VND", "EG", "27425", "167505");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4124", "VND", "UY", "21620", "99635");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4125", "VND", "BD", "17800", "39405");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4126", "VND", "PK", "19515", "112330");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4127", "VND", "PH", "33795", "124710");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4128", "VND", "ET", "5420", "41305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4129", "VND", "TN", "20820", "37725");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4130", "VND", "LB", "21020", "62835");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4131", "VND", "IN", "19380", "87540");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4132", "VND", "PY", "20830", "66985");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4133", "VND", "UZ", "20845", "40665");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4134", "VND", "EC", "20250", "69470");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4135", "VND", "MM", "20850", "22770");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4136", "VND", "GE", "20915", "26650");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4137", "ZAR", "US", "330", "935");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4138", "ZAR", "CH", "310", "815");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4139", "ZAR", "AU", "280", "720");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4140", "ZAR", "GB", "245", "630");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4141", "ZAR", "DE", "245", "620");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4142", "ZAR", "DK", "225", "555");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4143", "ZAR", "AT", "165", "510");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4144", "ZAR", "NO", "185", "515");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4145", "ZAR", "CA", "205", "630");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4146", "ZAR", "NL", "220", "555");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4147", "ZAR", "SE", "175", "475");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4148", "ZAR", "IE", "175", "455");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4149", "ZAR", "BE", "160", "470");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4150", "ZAR", "FI", "120", "360");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4151", "ZAR", "FR", "150", "395");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4152", "ZAR", "NZ", "150", "440");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4153", "ZAR", "HK", "135", "385");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4154", "ZAR", "CZ", "130", "315");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4155", "ZAR", "SK", "125", "265");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4156", "ZAR", "AE", "115", "365");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4157", "ZAR", "SG", "150", "445");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4158", "ZAR", "IL", "130", "325");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4159", "ZAR", "KW", "60", "290");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4160", "ZAR", "IT", "90", "235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4161", "ZAR", "JP", "115", "320");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4162", "ZAR", "ES", "90", "245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4163", "ZAR", "VE", "10", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4164", "ZAR", "HU", "80", "180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4165", "ZAR", "PT", "80", "205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4166", "ZAR", "GR", "95", "195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4167", "ZAR", "KR", "120", "315");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4168", "ZAR", "TW", "95", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4169", "ZAR", "PL", "80", "205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4170", "ZAR", "ZM", "10", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4171", "ZAR", "PR", "30", "275");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4172", "ZAR", "CI", "15", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4173", "ZAR", "RO", "75", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4174", "ZAR", "BH", "35", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4175", "ZAR", "PA", "25", "260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4176", "ZAR", "GH", "30", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4177", "ZAR", "KH", "15", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4178", "ZAR", "SN", "10", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4179", "ZAR", "SA", "50", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4180", "ZAR", "RU", "50", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4181", "ZAR", "UG", "10", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4182", "ZAR", "BR", "50", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4183", "ZAR", "NI", "10", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4184", "ZAR", "MG", "10", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4185", "ZAR", "DO", "15", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4186", "ZAR", "MX", "40", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4187", "ZAR", "OM", "25", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4188", "ZAR", "CM", "10", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4189", "ZAR", "ZA", "45", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4190", "ZAR", "CL", "50", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4191", "ZAR", "KE", "15", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4192", "ZAR", "NP", "10", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4193", "ZAR", "PE", "30", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4194", "ZAR", "UA", "30", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4195", "ZAR", "MZ", "10", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4196", "ZAR", "TZ", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4197", "ZAR", "AO", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4198", "ZAR", "JO", "20", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4199", "ZAR", "ZW", "10", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4200", "ZAR", "TR", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4201", "ZAR", "MU", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4202", "ZAR", "SV", "10", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4203", "ZAR", "TH", "45", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4204", "ZAR", "CO", "25", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4205", "ZAR", "LK", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4206", "ZAR", "CR", "15", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4207", "ZAR", "AR", "30", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4208", "ZAR", "MA", "15", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4209", "ZAR", "MY", "40", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4210", "ZAR", "KZ", "15", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4211", "ZAR", "DZ", "15", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4212", "ZAR", "ID", "35", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4213", "ZAR", "NG", "20", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4214", "ZAR", "GT", "15", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4215", "ZAR", "VN", "30", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4216", "ZAR", "BY", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4217", "ZAR", "EG", "20", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4218", "ZAR", "UY", "15", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4219", "ZAR", "BD", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4220", "ZAR", "PK", "15", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4221", "ZAR", "PH", "20", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4222", "ZAR", "ET", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4223", "ZAR", "TN", "15", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4224", "ZAR", "LB", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4225", "ZAR", "IN", "15", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4226", "ZAR", "PY", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4227", "ZAR", "UZ", "15", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4228", "ZAR", "EC", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4229", "ZAR", "MM", "15", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4230", "ZAR", "GE", "15", "20");

/* INSERT TABLE DATA: wp_layerslider */
INSERT INTO `wp_layerslider` VALUES("1", NULL, "1", "Notre USine", "", "{\"properties\":{\"sliderVersion\":\"7.6.7\",\"title\":\"Notre USine\",\"slug\":\"\",\"status\":true,\"schedule_start\":\"\",\"schedule_end\":\"\",\"type\":\"responsive\",\"popupFitWidth\":\"\",\"popupFitHeight\":\"\",\"popupPositionHorizontal\":\"center\",\"popupPositionVertical\":\"middle\",\"popupWidth\":\"640\",\"popupHeight\":\"360\",\"popupDistanceTop\":\"10\",\"popupDistanceRight\":\"10\",\"popupDistanceBottom\":\"10\",\"popupDistanceLeft\":\"10\",\"popupShowOnTimeout\":\"\",\"popupShowOnIdle\":\"\",\"popupShowOnScroll\":\"\",\"popupShowOnClick\":\"\",\"popupCloseOnTimeout\":\"\",\"popupCloseOnScroll\":\"\",\"popup_repeat\":true,\"popup_repeat_days\":\"\",\"popupShowOnce\":true,\"popup_pages_custom\":\"\",\"popup_pages_exclude\":\"\",\"popup_roles_administrator\":true,\"popup_roles_editor\":true,\"popup_roles_author\":true,\"popup_roles_contributor\":true,\"popup_roles_subscriber\":true,\"popup_roles_customer\":true,\"popup_roles_visitor\":true,\"popupTransitionIn\":\"fade\",\"popupDurationIn\":\"1000\",\"popupDelayIn\":\"200\",\"popupTransitionOut\":\"fade\",\"popupDurationOut\":\"500\",\"popupResetOnClose\":\"slide\",\"popupShowCloseButton\":true,\"popupCloseButtonStyle\":\"\",\"popupOverlayClickToClose\":true,\"popupOverlayBackground\":\"rgba(0,0,0,.85)\",\"popupOverlayTransitionIn\":\"fade\",\"popupOverlayDurationIn\":\"400\",\"popupOverlayTransitionOut\":\"fade\",\"popupOverlayDurationOut\":\"400\",\"sceneHeight\":\"\",\"sceneSpeed\":\"100\",\"stickTo\":\"center\",\"width\":1280,\"height\":400,\"maxwidth\":\"\",\"responsiveunder\":\"\",\"fullSizeMode\":\"normal\",\"marginTop\":\"\",\"marginBottom\":\"\",\"fitScreenWidth\":true,\"maxRatio\":\"\",\"calculateOffsetFrom\":\"\",\"insertMethod\":\"prependTo\",\"insertSelector\":\"\",\"clipSlideTransition\":\"disabled\",\"preventSliderClip\":true,\"hideunder\":\"\",\"hideover\":\"\",\"slideOnSwipe\":true,\"optimizeForMobile\":true,\"firstlayer\":\"1\",\"autostart\":true,\"startinviewport\":true,\"pauseonhover\":\"disabled\",\"keybnav\":true,\"touchnav\":true,\"loops\":\"0\",\"forceloopnum\":true,\"skin\":\"v6\",\"sliderfadeinduration\":\"0\",\"sliderclass\":\"\",\"sliderstyle\":\"\",\"backgroundcolor\":\"\",\"globalBGRepeat\":\"no-repeat\",\"globalBGAttachment\":\"scroll\",\"globalBGPosition\":\"50% 50%\",\"globalBGSize\":\"auto\",\"navprevnext\":true,\"navstartstop\":true,\"navbuttons\":true,\"hoverprevnext\":true,\"circletimer\":true,\"thumb_nav\":\"hover\",\"thumb_container_width\":\"60%\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"autoplayvideos\":true,\"rememberUnmuteState\":true,\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"performanceMode\":\"inherit\",\"performanceModeThreshold\":\"20sh\",\"enhancedLazyLoad\":\"inherit\",\"slideBGSize\":\"cover\",\"slideBGPosition\":\"50% 50%\",\"slideDuration\":\"\",\"slideTransitionDuration\":\"\",\"slideTimeShift\":\"0\",\"parallaxSensitivity\":\"10\",\"parallaxCenterLayers\":\"center\",\"parallaxCenterDegree\":\"40\",\"scrollCenterLayers\":\"center\",\"forceLayersOutDuration\":\"750\",\"useSrcset\":\"inherit\",\"preferBlendMode\":\"disabled\",\"createdWith\":\"7.6.7\"},\"layers\":[{\"properties\":{\"post_offset\":-1,\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"bgcolor\":\"\",\"bgposition\":\"inherit\",\"bgsize\":\"inherit\",\"slidedelay\":\"\",\"timeshift\":0,\"transitionduration\":\"\",\"kenburnszoom\":\"disabled\",\"kenburnsscale\":1.2,\"kenburnsrotate\":\"\",\"globalhover\":false,\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxdistance\":10,\"parallaxrotate\":10,\"parallaxdurationmove\":1500,\"parallaxdurationleave\":1200,\"parallaxtransformorigin\":\"slidercenter slidermiddle 0\",\"parallaxtransformperspective\":500,\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"overflow\":false,\"customProperties\":[],\"background\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/12\\/stock-cables.jpg\",\"backgroundId\":188,\"backgroundThumb\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/12\\/stock-cables.jpg\",\"post_content\":false,\"schedule_start\":\"\",\"schedule_end\":\"\"},\"sublayers\":[{\"transition\":\"{\\\\\\\"backgroundvideo\\\\\\\":false,\\\\\\\"autoplay\\\\\\\":\\\\\\\"inherit\\\\\\\",\\\\\\\"muted\\\\\\\":\\\\\\\"auto\\\\\\\",\\\\\\\"volume\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"fillmode\\\\\\\":\\\\\\\"cover\\\\\\\",\\\\\\\"controls\\\\\\\":\\\\\\\"auto\\\\\\\",\\\\\\\"showinfo\\\\\\\":\\\\\\\"auto\\\\\\\",\\\\\\\"loopmedia\\\\\\\":\\\\\\\"auto\\\\\\\",\\\\\\\"overlay\\\\\\\":\\\\\\\"disabled\\\\\\\",\\\\\\\"position\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"pinned\\\\\\\":false,\\\\\\\"minfontsize\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"minmobilefontsize\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"scaleX\\\\\\\":1,\\\\\\\"scaleY\\\\\\\":1,\\\\\\\"rotation\\\\\\\":0,\\\\\\\"rotationX\\\\\\\":0,\\\\\\\"rotationY\\\\\\\":0,\\\\\\\"skewX\\\\\\\":0,\\\\\\\"skewY\\\\\\\":0,\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"pointerEvents\\\\\\\":false,\\\\\\\"minresponsiveratio\\\\\\\":0,\\\\\\\"maxresponsiveratio\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"transitionin\\\\\\\":true,\\\\\\\"offsetxin\\\\\\\":0,\\\\\\\"offsetyin\\\\\\\":0,\\\\\\\"scalexin\\\\\\\":1,\\\\\\\"scaleyin\\\\\\\":1,\\\\\\\"rotatein\\\\\\\":0,\\\\\\\"rotatexin\\\\\\\":0,\\\\\\\"rotateyin\\\\\\\":0,\\\\\\\"skewxin\\\\\\\":0,\\\\\\\"skewyin\\\\\\\":0,\\\\\\\"widthin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"heightin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"clipin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"transformperspectivein\\\\\\\":500,\\\\\\\"transformmirrorin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"delayin\\\\\\\":0,\\\\\\\"durationin\\\\\\\":1000,\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"colorin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"bgcolorin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"filterin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"radiusin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"static\\\\\\\":\\\\\\\"none\\\\\\\",\\\\\\\"skipViewport\\\\\\\":\\\\\\\"disabled\\\\\\\",\\\\\\\"transitionout\\\\\\\":true,\\\\\\\"offsetxout\\\\\\\":0,\\\\\\\"offsetyout\\\\\\\":0,\\\\\\\"scalexout\\\\\\\":1,\\\\\\\"scaleyout\\\\\\\":1,\\\\\\\"rotateout\\\\\\\":0,\\\\\\\"rotatexout\\\\\\\":0,\\\\\\\"rotateyout\\\\\\\":0,\\\\\\\"skewxout\\\\\\\":0,\\\\\\\"skewyout\\\\\\\":0,\\\\\\\"widthout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"heightout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"clipout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"transformperspectiveout\\\\\\\":500,\\\\\\\"transformmirrorout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"startatout\\\\\\\":\\\\\\\"slidechangeonly\\\\\\\",\\\\\\\"startatouttiming\\\\\\\":\\\\\\\"slidechangeonly\\\\\\\",\\\\\\\"startatoutoperator\\\\\\\":\\\\\\\"+\\\\\\\",\\\\\\\"startatoutvalue\\\\\\\":0,\\\\\\\"durationout\\\\\\\":1000,\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"colorout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"bgcolorout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"filterout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"radiusout\\\\\\\":\\\\\\\"\\\\\\\"}\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":36,\\\\\\\"wordwrap\\\\\\\":false,\\\\\\\"text-align\\\\\\\":\\\\\\\"center\\\\\\\",\\\\\\\"font-style\\\\\\\":\\\\\\\"normal\\\\\\\",\\\\\\\"text-decoration\\\\\\\":\\\\\\\"none\\\\\\\",\\\\\\\"text-transform\\\\\\\":\\\\\\\"none\\\\\\\",\\\\\\\"font-weight\\\\\\\":400,\\\\\\\"letter-spacing\\\\\\\":0,\\\\\\\"background-position\\\\\\\":\\\\\\\"0% 0%\\\\\\\",\\\\\\\"background-repeat\\\\\\\":\\\\\\\"no-repeat\\\\\\\",\\\\\\\"background-clip\\\\\\\":\\\\\\\"border-box\\\\\\\",\\\\\\\"opacity\\\\\\\":1,\\\\\\\"mix-blend-mode\\\\\\\":\\\\\\\"unset\\\\\\\",\\\\\\\"overflow\\\\\\\":\\\\\\\"visible\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"153px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"546px\\\\\\\"}\",\"media\":\"text\",\"htmlLineBreak\":\"auto\",\"htmlTag\":\"ls-layer\",\"post_text_length\":\"\",\"iconColor\":\"\",\"iconPlacement\":\"right\",\"iconSize\":1,\"iconGap\":0,\"iconVerticalAdjustment\":0,\"style\":\"\",\"url\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"target\":\"_self\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"tabindex\":\"\",\"autoSubtitle\":true,\"subtitle\":\"Notre Usine \",\"hasTransforms\":false,\"meta\":[],\"innerAttributes\":[],\"outerAttributes\":[],\"actions\":[],\"html\":\"Notre Usine \",\"uuid\":\"8963eef2-3fea-4211-8fb1-76815e3f0001\"}],\"meta\":{\"undoStackIndex\":14,\"activeLayers\":[0]},\"history\":[{\"cmd\":\"slide.general\",\"name\":\"SLIDE_IMAGE\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"background\":null,\"backgroundId\":null,\"backgroundThumb\":null},\"redo\":{\"background\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/10\\/Capture-decran-2023-07-18-a-15.28.35.png\",\"backgroundId\":14,\"backgroundThumb\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/10\\/Capture-decran-2023-07-18-a-15.28.35.png\"}}},{\"cmd\":\"slide.layers\",\"name\":\"LAYER_NEW\",\"updateInfo\":[{\"itemIndex\":0,\"selectIndex\":0,\"undo\":{\"data\":[]},\"redo\":{\"data\":{\"transition\":{\"backgroundvideo\":false,\"autoplay\":\"inherit\",\"muted\":\"auto\",\"volume\":\"\",\"fillmode\":\"cover\",\"controls\":\"auto\",\"showinfo\":\"auto\",\"loopmedia\":\"auto\",\"overlay\":\"disabled\",\"position\":\"\",\"pinned\":false,\"minfontsize\":\"\",\"minmobilefontsize\":\"\",\"scaleX\":1,\"scaleY\":1,\"rotation\":0,\"rotationX\":0,\"rotationY\":0,\"skewX\":0,\"skewY\":0,\"transformoriginin\":\"50% 50% 0\",\"pointerEvents\":false,\"minresponsiveratio\":0,\"maxresponsiveratio\":\"\",\"transitionin\":true,\"offsetxin\":0,\"offsetyin\":0,\"scalexin\":1,\"scaleyin\":1,\"rotatein\":0,\"rotatexin\":0,\"rotateyin\":0,\"skewxin\":0,\"skewyin\":0,\"widthin\":\"\",\"heightin\":\"\",\"clipin\":\"\",\"transformperspectivein\":500,\"transformmirrorin\":\"\",\"delayin\":0,\"durationin\":1000,\"easingin\":\"easeInOutQuint\",\"fadein\":true,\"colorin\":\"\",\"bgcolorin\":\"\",\"filterin\":\"\",\"radiusin\":\"\",\"static\":\"none\",\"skipViewport\":\"disabled\",\"transitionout\":true,\"offsetxout\":0,\"offsetyout\":0,\"scalexout\":1,\"scaleyout\":1,\"rotateout\":0,\"rotatexout\":0,\"rotateyout\":0,\"skewxout\":0,\"skewyout\":0,\"widthout\":\"\",\"heightout\":\"\",\"clipout\":\"\",\"transformoriginout\":\"50% 50% 0\",\"transformperspectiveout\":500,\"transformmirrorout\":\"\",\"startatout\":\"slidechangeonly\",\"startatouttiming\":\"slidechangeonly\",\"startatoutoperator\":\"+\",\"startatoutvalue\":0,\"durationout\":1000,\"easingout\":\"easeInOutQuint\",\"fadeout\":true,\"colorout\":\"\",\"bgcolorout\":\"\",\"filterout\":\"\",\"radiusout\":\"\"},\"styles\":{\"font-size\":36,\"color\":\"#000\",\"wordwrap\":false,\"text-align\":\"left\",\"font-style\":\"normal\",\"text-decoration\":\"none\",\"text-transform\":\"none\",\"font-weight\":400,\"letter-spacing\":0,\"border-style\":\"solid\",\"border-color\":\"#000\",\"background-position\":\"0% 0%\",\"background-repeat\":\"no-repeat\",\"background-clip\":\"border-box\",\"opacity\":1,\"mix-blend-mode\":\"unset\",\"overflow\":\"visible\"},\"media\":\"text\",\"html\":\"Text Layer\",\"htmlLineBreak\":\"auto\",\"htmlTag\":\"ls-layer\",\"post_text_length\":\"\",\"iconColor\":\"\",\"iconPlacement\":\"right\",\"iconSize\":1,\"iconGap\":0,\"iconVerticalAdjustment\":0,\"style\":\"\",\"url\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"target\":\"_self\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"tabindex\":\"\",\"autoSubtitle\":true,\"subtitle\":\"\"}}}]},{\"cmd\":\"layer.general\",\"name\":\"LAYER_CONTENT\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"html\":\"Text Layer\"},\"redo\":{\"html\":\"Notre Usine \"}}]},{\"cmd\":\"layer.style\",\"name\":\"LAYER_STYLES\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"font-family\":null},\"redo\":{\"font-family\":\"\"}}]},{\"cmd\":\"layer.style\",\"name\":\"LAYER_STYLES\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"font-family\":null},\"redo\":{\"font-family\":\"\"}}]},{\"cmd\":\"layer.style\",\"name\":\"LAYER_STYLES\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"font-family\":null},\"redo\":{\"font-family\":\"\"}}]},{\"cmd\":\"layer.style\",\"name\":\"LAYER_STYLES\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"font-family\":null},\"redo\":{\"font-family\":\"\"}}]},{\"cmd\":\"layer.style\",\"name\":\"LAYER_STYLES\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"font-family\":null},\"redo\":{\"font-family\":\"\"}}]},{\"cmd\":\"layer.style\",\"name\":\"LAYER_STYLES\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"font-family\":null},\"redo\":{\"font-family\":\"Roboto\"}}]},{\"cmd\":\"layer.style\",\"name\":\"LAYER_STYLES\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"color\":\"#000000\"},\"redo\":{\"color\":\"#ffffff\"}}]},{\"cmd\":\"layer.style\",\"name\":\"LAYER_STYLES\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"text-align\":\"left\"},\"redo\":{\"text-align\":\"center\"}}]},{\"cmd\":\"layer.style\",\"name\":\"LAYER_POSITION\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"0px\",\"top\":\"0px\"},\"redo\":{\"left\":\"546px\",\"top\":\"179px\"}}]},{\"cmd\":\"layer.style\",\"name\":\"LAYER_POSITION\",\"updateInfo\":[{\"itemIndex\":0,\"undo\":{\"left\":\"546.309px\",\"top\":\"178.5px\"},\"redo\":{\"left\":\"546px\",\"top\":\"153px\"}}]},{\"cmd\":\"slide.general\",\"name\":\"SLIDE_IMAGE\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"background\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/10\\/Capture-decran-2023-07-18-a-15.28.35.png\",\"backgroundId\":14,\"backgroundThumb\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/10\\/Capture-decran-2023-07-18-a-15.28.35-300x161.png\"},\"redo\":{\"background\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/12\\/potence-banc-de-traction.jpg\",\"backgroundId\":186,\"backgroundThumb\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/12\\/potence-banc-de-traction.jpg\"}}},{\"cmd\":\"slide.general\",\"name\":\"SLIDE_IMAGE\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"background\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/12\\/potence-banc-de-traction.jpg\",\"backgroundId\":186,\"backgroundThumb\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/12\\/potence-banc-de-traction.jpg\"},\"redo\":{\"background\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/12\\/stock-cables.jpg\",\"backgroundId\":188,\"backgroundThumb\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/12\\/stock-cables.jpg\"}}}]},{\"properties\":{\"post_offset\":-1,\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"bgcolor\":\"\",\"bgposition\":\"inherit\",\"bgsize\":\"inherit\",\"slidedelay\":\"\",\"timeshift\":0,\"transitionduration\":\"\",\"kenburnszoom\":\"disabled\",\"kenburnsscale\":1.2,\"kenburnsrotate\":\"\",\"globalhover\":false,\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxdistance\":10,\"parallaxrotate\":10,\"parallaxdurationmove\":1500,\"parallaxdurationleave\":1200,\"parallaxtransformorigin\":\"slidercenter slidermiddle 0\",\"parallaxtransformperspective\":500,\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"overflow\":false,\"background\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/12\\/stock-accessoires-chaines-et-cables.jpg\",\"backgroundId\":187,\"backgroundThumb\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/12\\/stock-accessoires-chaines-et-cables.jpg\",\"customProperties\":[],\"post_content\":false},\"sublayers\":[{\"transition\":\"{\\\\\\\"backgroundvideo\\\\\\\":false,\\\\\\\"autoplay\\\\\\\":\\\\\\\"inherit\\\\\\\",\\\\\\\"muted\\\\\\\":\\\\\\\"auto\\\\\\\",\\\\\\\"volume\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"fillmode\\\\\\\":\\\\\\\"cover\\\\\\\",\\\\\\\"controls\\\\\\\":\\\\\\\"auto\\\\\\\",\\\\\\\"showinfo\\\\\\\":\\\\\\\"auto\\\\\\\",\\\\\\\"loopmedia\\\\\\\":\\\\\\\"auto\\\\\\\",\\\\\\\"overlay\\\\\\\":\\\\\\\"disabled\\\\\\\",\\\\\\\"position\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"pinned\\\\\\\":false,\\\\\\\"minfontsize\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"minmobilefontsize\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"scaleX\\\\\\\":1,\\\\\\\"scaleY\\\\\\\":1,\\\\\\\"rotation\\\\\\\":0,\\\\\\\"rotationX\\\\\\\":0,\\\\\\\"rotationY\\\\\\\":0,\\\\\\\"skewX\\\\\\\":0,\\\\\\\"skewY\\\\\\\":0,\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"pointerEvents\\\\\\\":false,\\\\\\\"minresponsiveratio\\\\\\\":0,\\\\\\\"maxresponsiveratio\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"transitionin\\\\\\\":true,\\\\\\\"offsetxin\\\\\\\":0,\\\\\\\"offsetyin\\\\\\\":0,\\\\\\\"scalexin\\\\\\\":1,\\\\\\\"scaleyin\\\\\\\":1,\\\\\\\"rotatein\\\\\\\":0,\\\\\\\"rotatexin\\\\\\\":0,\\\\\\\"rotateyin\\\\\\\":0,\\\\\\\"skewxin\\\\\\\":0,\\\\\\\"skewyin\\\\\\\":0,\\\\\\\"widthin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"heightin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"clipin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"transformperspectivein\\\\\\\":500,\\\\\\\"transformmirrorin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"delayin\\\\\\\":0,\\\\\\\"durationin\\\\\\\":1000,\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"colorin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"bgcolorin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"filterin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"radiusin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"static\\\\\\\":\\\\\\\"none\\\\\\\",\\\\\\\"skipViewport\\\\\\\":\\\\\\\"disabled\\\\\\\",\\\\\\\"transitionout\\\\\\\":true,\\\\\\\"offsetxout\\\\\\\":0,\\\\\\\"offsetyout\\\\\\\":0,\\\\\\\"scalexout\\\\\\\":1,\\\\\\\"scaleyout\\\\\\\":1,\\\\\\\"rotateout\\\\\\\":0,\\\\\\\"rotatexout\\\\\\\":0,\\\\\\\"rotateyout\\\\\\\":0,\\\\\\\"skewxout\\\\\\\":0,\\\\\\\"skewyout\\\\\\\":0,\\\\\\\"widthout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"heightout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"clipout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"transformperspectiveout\\\\\\\":500,\\\\\\\"transformmirrorout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"startatout\\\\\\\":\\\\\\\"slidechangeonly\\\\\\\",\\\\\\\"startatouttiming\\\\\\\":\\\\\\\"slidechangeonly\\\\\\\",\\\\\\\"startatoutoperator\\\\\\\":\\\\\\\"+\\\\\\\",\\\\\\\"startatoutvalue\\\\\\\":0,\\\\\\\"durationout\\\\\\\":1000,\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"colorout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"bgcolorout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"filterout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"radiusout\\\\\\\":\\\\\\\"\\\\\\\"}\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":36,\\\\\\\"wordwrap\\\\\\\":false,\\\\\\\"text-align\\\\\\\":\\\\\\\"center\\\\\\\",\\\\\\\"font-style\\\\\\\":\\\\\\\"normal\\\\\\\",\\\\\\\"text-decoration\\\\\\\":\\\\\\\"none\\\\\\\",\\\\\\\"text-transform\\\\\\\":\\\\\\\"none\\\\\\\",\\\\\\\"font-weight\\\\\\\":400,\\\\\\\"letter-spacing\\\\\\\":0,\\\\\\\"background-position\\\\\\\":\\\\\\\"0% 0%\\\\\\\",\\\\\\\"background-repeat\\\\\\\":\\\\\\\"no-repeat\\\\\\\",\\\\\\\"background-clip\\\\\\\":\\\\\\\"border-box\\\\\\\",\\\\\\\"opacity\\\\\\\":1,\\\\\\\"mix-blend-mode\\\\\\\":\\\\\\\"unset\\\\\\\",\\\\\\\"overflow\\\\\\\":\\\\\\\"visible\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"153px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"546px\\\\\\\"}\",\"media\":\"text\",\"htmlLineBreak\":\"auto\",\"htmlTag\":\"ls-layer\",\"post_text_length\":\"\",\"iconColor\":\"\",\"iconPlacement\":\"right\",\"iconSize\":1,\"iconGap\":0,\"iconVerticalAdjustment\":0,\"style\":\"\",\"url\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"target\":\"_self\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"tabindex\":\"\",\"autoSubtitle\":true,\"subtitle\":\"Notre Usine \",\"hasTransforms\":false,\"meta\":[],\"innerAttributes\":[],\"outerAttributes\":[],\"actions\":[],\"html\":\"Notre Usine \",\"uuid\":\"a3955733-0827-4b80-a18f-525b8e20d95c\"}],\"meta\":{\"undoStackIndex\":0,\"activeLayers\":[0]},\"history\":[{\"cmd\":\"slide.layers\",\"name\":\"LAYER_NEW\",\"updateInfo\":[{\"itemIndex\":0,\"selectIndex\":0,\"undo\":{\"data\":[]},\"redo\":{\"data\":[{\"transition\":{\"backgroundvideo\":false,\"autoplay\":\"inherit\",\"muted\":\"auto\",\"volume\":\"\",\"fillmode\":\"cover\",\"controls\":\"auto\",\"showinfo\":\"auto\",\"loopmedia\":\"auto\",\"overlay\":\"disabled\",\"position\":\"\",\"pinned\":false,\"minfontsize\":\"\",\"minmobilefontsize\":\"\",\"scaleX\":1,\"scaleY\":1,\"rotation\":0,\"rotationX\":0,\"rotationY\":0,\"skewX\":0,\"skewY\":0,\"transformoriginin\":\"50% 50% 0\",\"pointerEvents\":false,\"minresponsiveratio\":0,\"maxresponsiveratio\":\"\",\"transitionin\":true,\"offsetxin\":0,\"offsetyin\":0,\"scalexin\":1,\"scaleyin\":1,\"rotatein\":0,\"rotatexin\":0,\"rotateyin\":0,\"skewxin\":0,\"skewyin\":0,\"widthin\":\"\",\"heightin\":\"\",\"clipin\":\"\",\"transformperspectivein\":500,\"transformmirrorin\":\"\",\"delayin\":0,\"durationin\":1000,\"easingin\":\"easeInOutQuint\",\"fadein\":true,\"colorin\":\"\",\"bgcolorin\":\"\",\"filterin\":\"\",\"radiusin\":\"\",\"static\":\"none\",\"skipViewport\":\"disabled\",\"transitionout\":true,\"offsetxout\":0,\"offsetyout\":0,\"scalexout\":1,\"scaleyout\":1,\"rotateout\":0,\"rotatexout\":0,\"rotateyout\":0,\"skewxout\":0,\"skewyout\":0,\"widthout\":\"\",\"heightout\":\"\",\"clipout\":\"\",\"transformoriginout\":\"50% 50% 0\",\"transformperspectiveout\":500,\"transformmirrorout\":\"\",\"startatout\":\"slidechangeonly\",\"startatouttiming\":\"slidechangeonly\",\"startatoutoperator\":\"+\",\"startatoutvalue\":0,\"durationout\":1000,\"easingout\":\"easeInOutQuint\",\"fadeout\":true,\"colorout\":\"\",\"bgcolorout\":\"\",\"filterout\":\"\",\"radiusout\":\"\"},\"styles\":{\"font-size\":36,\"wordwrap\":false,\"text-align\":\"center\",\"font-style\":\"normal\",\"text-decoration\":\"none\",\"text-transform\":\"none\",\"font-weight\":400,\"letter-spacing\":0,\"border-style\":\"\",\"border-color\":\"\",\"background-position\":\"0% 0%\",\"background-repeat\":\"no-repeat\",\"background-clip\":\"border-box\",\"opacity\":1,\"mix-blend-mode\":\"unset\",\"overflow\":\"visible\",\"font-family\":\"Roboto\",\"color\":\"#ffffff\",\"top\":\"153px\",\"left\":\"546px\",\"border-width\":\"\"},\"media\":\"text\",\"htmlLineBreak\":\"auto\",\"htmlTag\":\"ls-layer\",\"post_text_length\":\"\",\"iconColor\":\"\",\"iconPlacement\":\"right\",\"iconSize\":1,\"iconGap\":0,\"iconVerticalAdjustment\":0,\"style\":\"\",\"url\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"target\":\"_self\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"tabindex\":\"\",\"autoSubtitle\":true,\"subtitle\":\"Notre Usine  copy\",\"hasTransforms\":false,\"meta\":[],\"innerAttributes\":[],\"outerAttributes\":[],\"actions\":[],\"html\":\"Notre Usine \",\"uuid\":\"a3955733-0827-4b80-a18f-525b8e20d95c\"}]}}]}]},{\"properties\":{\"post_offset\":-1,\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"bgcolor\":\"\",\"bgposition\":\"50% 0%\",\"bgsize\":\"cover\",\"slidedelay\":\"\",\"timeshift\":0,\"transitionduration\":\"\",\"kenburnszoom\":\"disabled\",\"kenburnsscale\":1.2,\"kenburnsrotate\":\"\",\"globalhover\":false,\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxdistance\":10,\"parallaxrotate\":10,\"parallaxdurationmove\":1500,\"parallaxdurationleave\":1200,\"parallaxtransformorigin\":\"slidercenter slidermiddle 0\",\"parallaxtransformperspective\":500,\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"overflow\":false,\"background\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/12\\/potence-banc-de-traction.jpg\",\"backgroundId\":186,\"backgroundThumb\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/12\\/potence-banc-de-traction.jpg\",\"customProperties\":[],\"post_content\":false},\"sublayers\":[{\"transition\":\"{\\\\\\\"backgroundvideo\\\\\\\":false,\\\\\\\"autoplay\\\\\\\":\\\\\\\"inherit\\\\\\\",\\\\\\\"muted\\\\\\\":\\\\\\\"auto\\\\\\\",\\\\\\\"volume\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"fillmode\\\\\\\":\\\\\\\"cover\\\\\\\",\\\\\\\"controls\\\\\\\":\\\\\\\"auto\\\\\\\",\\\\\\\"showinfo\\\\\\\":\\\\\\\"auto\\\\\\\",\\\\\\\"loopmedia\\\\\\\":\\\\\\\"auto\\\\\\\",\\\\\\\"overlay\\\\\\\":\\\\\\\"disabled\\\\\\\",\\\\\\\"position\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"pinned\\\\\\\":false,\\\\\\\"minfontsize\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"minmobilefontsize\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"scaleX\\\\\\\":1,\\\\\\\"scaleY\\\\\\\":1,\\\\\\\"rotation\\\\\\\":0,\\\\\\\"rotationX\\\\\\\":0,\\\\\\\"rotationY\\\\\\\":0,\\\\\\\"skewX\\\\\\\":0,\\\\\\\"skewY\\\\\\\":0,\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"pointerEvents\\\\\\\":false,\\\\\\\"minresponsiveratio\\\\\\\":0,\\\\\\\"maxresponsiveratio\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"transitionin\\\\\\\":true,\\\\\\\"offsetxin\\\\\\\":0,\\\\\\\"offsetyin\\\\\\\":0,\\\\\\\"scalexin\\\\\\\":1,\\\\\\\"scaleyin\\\\\\\":1,\\\\\\\"rotatein\\\\\\\":0,\\\\\\\"rotatexin\\\\\\\":0,\\\\\\\"rotateyin\\\\\\\":0,\\\\\\\"skewxin\\\\\\\":0,\\\\\\\"skewyin\\\\\\\":0,\\\\\\\"widthin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"heightin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"clipin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"transformperspectivein\\\\\\\":500,\\\\\\\"transformmirrorin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"delayin\\\\\\\":0,\\\\\\\"durationin\\\\\\\":1000,\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"colorin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"bgcolorin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"filterin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"radiusin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"static\\\\\\\":\\\\\\\"none\\\\\\\",\\\\\\\"skipViewport\\\\\\\":\\\\\\\"disabled\\\\\\\",\\\\\\\"transitionout\\\\\\\":true,\\\\\\\"offsetxout\\\\\\\":0,\\\\\\\"offsetyout\\\\\\\":0,\\\\\\\"scalexout\\\\\\\":1,\\\\\\\"scaleyout\\\\\\\":1,\\\\\\\"rotateout\\\\\\\":0,\\\\\\\"rotatexout\\\\\\\":0,\\\\\\\"rotateyout\\\\\\\":0,\\\\\\\"skewxout\\\\\\\":0,\\\\\\\"skewyout\\\\\\\":0,\\\\\\\"widthout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"heightout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"clipout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"transformperspectiveout\\\\\\\":500,\\\\\\\"transformmirrorout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"startatout\\\\\\\":\\\\\\\"slidechangeonly\\\\\\\",\\\\\\\"startatouttiming\\\\\\\":\\\\\\\"slidechangeonly\\\\\\\",\\\\\\\"startatoutoperator\\\\\\\":\\\\\\\"+\\\\\\\",\\\\\\\"startatoutvalue\\\\\\\":0,\\\\\\\"durationout\\\\\\\":1000,\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"colorout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"bgcolorout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"filterout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"radiusout\\\\\\\":\\\\\\\"\\\\\\\"}\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":36,\\\\\\\"wordwrap\\\\\\\":false,\\\\\\\"text-align\\\\\\\":\\\\\\\"center\\\\\\\",\\\\\\\"font-style\\\\\\\":\\\\\\\"normal\\\\\\\",\\\\\\\"text-decoration\\\\\\\":\\\\\\\"none\\\\\\\",\\\\\\\"text-transform\\\\\\\":\\\\\\\"none\\\\\\\",\\\\\\\"font-weight\\\\\\\":400,\\\\\\\"letter-spacing\\\\\\\":0,\\\\\\\"background-position\\\\\\\":\\\\\\\"0% 0%\\\\\\\",\\\\\\\"background-repeat\\\\\\\":\\\\\\\"no-repeat\\\\\\\",\\\\\\\"background-clip\\\\\\\":\\\\\\\"border-box\\\\\\\",\\\\\\\"opacity\\\\\\\":1,\\\\\\\"mix-blend-mode\\\\\\\":\\\\\\\"unset\\\\\\\",\\\\\\\"overflow\\\\\\\":\\\\\\\"visible\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"153px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"546px\\\\\\\"}\",\"media\":\"text\",\"htmlLineBreak\":\"auto\",\"htmlTag\":\"ls-layer\",\"post_text_length\":\"\",\"iconColor\":\"\",\"iconPlacement\":\"right\",\"iconSize\":1,\"iconGap\":0,\"iconVerticalAdjustment\":0,\"style\":\"\",\"url\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"target\":\"_self\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"tabindex\":\"\",\"autoSubtitle\":true,\"subtitle\":\"Notre Usine \",\"hasTransforms\":false,\"meta\":[],\"innerAttributes\":[],\"outerAttributes\":[],\"actions\":[],\"html\":\"Notre Usine \",\"uuid\":\"0e724573-b667-4429-bbe6-caf4b5716034\"}],\"meta\":{\"undoStackIndex\":9,\"activeLayers\":[0]},\"history\":[{\"cmd\":\"slide.general\",\"name\":\"SLIDE_IMAGE\",\"updateInfo\":{\"itemIndex\":2,\"undo\":{\"background\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/12\\/stock-cables.jpg\",\"backgroundId\":188,\"backgroundThumb\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/12\\/stock-cables.jpg\"},\"redo\":{\"background\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/12\\/stock-accessoires-chaines-et-cables.jpg\",\"backgroundId\":187,\"backgroundThumb\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/12\\/stock-accessoires-chaines-et-cables.jpg\"}}},{\"cmd\":\"slide.general\",\"name\":\"SLIDE_IMAGE\",\"updateInfo\":{\"itemIndex\":2,\"undo\":{\"background\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/12\\/stock-accessoires-chaines-et-cables.jpg\",\"backgroundId\":187,\"backgroundThumb\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/12\\/stock-accessoires-chaines-et-cables.jpg\"},\"redo\":{\"background\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/12\\/potence-banc-de-traction.jpg\",\"backgroundId\":186,\"backgroundThumb\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/12\\/potence-banc-de-traction.jpg\"}}},{\"cmd\":\"slide.general\",\"name\":\"SLIDE_SETTINGS\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"bgsize\":\"inherit\"},\"redo\":{\"bgsize\":\"auto\"}}]},{\"cmd\":\"slide.general\",\"name\":\"SLIDE_SETTINGS\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"bgsize\":\"inherit\"},\"redo\":{\"bgsize\":\"cover\"}}]},{\"cmd\":\"slide.general\",\"name\":\"SLIDE_SETTINGS\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"bgsize\":\"inherit\"},\"redo\":{\"bgsize\":\"contain\"}}]},{\"cmd\":\"slide.general\",\"name\":\"SLIDE_SETTINGS\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"bgsize\":\"inherit\"},\"redo\":{\"bgsize\":\"100% 100%\"}}]},{\"cmd\":\"slide.general\",\"name\":\"SLIDE_SETTINGS\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"bgsize\":\"inherit\"},\"redo\":{\"bgsize\":\"auto\"}}]},{\"cmd\":\"slide.general\",\"name\":\"SLIDE_SETTINGS\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"bgsize\":\"inherit\"},\"redo\":{\"bgsize\":\"cover\"}}]},{\"cmd\":\"slide.general\",\"name\":\"SLIDE_SETTINGS\",\"updateInfo\":[{\"itemIndex\":2,\"undo\":{\"bgposition\":\"inherit\"},\"redo\":{\"bgposition\":\"50% 0%\"}}]},{\"cmd\":\"slide.layers\",\"name\":\"LAYER_NEW\",\"updateInfo\":[{\"itemIndex\":0,\"selectIndex\":0,\"undo\":{\"data\":[]},\"redo\":{\"data\":[{\"transition\":{\"backgroundvideo\":false,\"autoplay\":\"inherit\",\"muted\":\"auto\",\"volume\":\"\",\"fillmode\":\"cover\",\"controls\":\"auto\",\"showinfo\":\"auto\",\"loopmedia\":\"auto\",\"overlay\":\"disabled\",\"position\":\"\",\"pinned\":false,\"minfontsize\":\"\",\"minmobilefontsize\":\"\",\"scaleX\":1,\"scaleY\":1,\"rotation\":0,\"rotationX\":0,\"rotationY\":0,\"skewX\":0,\"skewY\":0,\"transformoriginin\":\"50% 50% 0\",\"pointerEvents\":false,\"minresponsiveratio\":0,\"maxresponsiveratio\":\"\",\"transitionin\":true,\"offsetxin\":0,\"offsetyin\":0,\"scalexin\":1,\"scaleyin\":1,\"rotatein\":0,\"rotatexin\":0,\"rotateyin\":0,\"skewxin\":0,\"skewyin\":0,\"widthin\":\"\",\"heightin\":\"\",\"clipin\":\"\",\"transformperspectivein\":500,\"transformmirrorin\":\"\",\"delayin\":0,\"durationin\":1000,\"easingin\":\"easeInOutQuint\",\"fadein\":true,\"colorin\":\"\",\"bgcolorin\":\"\",\"filterin\":\"\",\"radiusin\":\"\",\"static\":\"none\",\"skipViewport\":\"disabled\",\"transitionout\":true,\"offsetxout\":0,\"offsetyout\":0,\"scalexout\":1,\"scaleyout\":1,\"rotateout\":0,\"rotatexout\":0,\"rotateyout\":0,\"skewxout\":0,\"skewyout\":0,\"widthout\":\"\",\"heightout\":\"\",\"clipout\":\"\",\"transformoriginout\":\"50% 50% 0\",\"transformperspectiveout\":500,\"transformmirrorout\":\"\",\"startatout\":\"slidechangeonly\",\"startatouttiming\":\"slidechangeonly\",\"startatoutoperator\":\"+\",\"startatoutvalue\":0,\"durationout\":1000,\"easingout\":\"easeInOutQuint\",\"fadeout\":true,\"colorout\":\"\",\"bgcolorout\":\"\",\"filterout\":\"\",\"radiusout\":\"\"},\"styles\":{\"font-size\":36,\"wordwrap\":false,\"text-align\":\"center\",\"font-style\":\"normal\",\"text-decoration\":\"none\",\"text-transform\":\"none\",\"font-weight\":400,\"letter-spacing\":0,\"border-style\":\"\",\"border-color\":\"\",\"background-position\":\"0% 0%\",\"background-repeat\":\"no-repeat\",\"background-clip\":\"border-box\",\"opacity\":1,\"mix-blend-mode\":\"unset\",\"overflow\":\"visible\",\"font-family\":\"Roboto\",\"color\":\"#ffffff\",\"top\":\"153px\",\"left\":\"546px\",\"border-width\":\"\"},\"media\":\"text\",\"htmlLineBreak\":\"auto\",\"htmlTag\":\"ls-layer\",\"post_text_length\":\"\",\"iconColor\":\"\",\"iconPlacement\":\"right\",\"iconSize\":1,\"iconGap\":0,\"iconVerticalAdjustment\":0,\"style\":\"\",\"url\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"target\":\"_self\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"tabindex\":\"\",\"autoSubtitle\":true,\"subtitle\":\"Notre Usine  copy\",\"hasTransforms\":false,\"meta\":[],\"innerAttributes\":[],\"outerAttributes\":[],\"actions\":[],\"html\":\"Notre Usine \",\"uuid\":\"0e724573-b667-4429-bbe6-caf4b5716034\"}]}}]}]},{\"properties\":{\"post_offset\":-1,\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"bgcolor\":\"\",\"bgposition\":\"inherit\",\"bgsize\":\"inherit\",\"slidedelay\":\"\",\"timeshift\":0,\"transitionduration\":\"\",\"kenburnszoom\":\"disabled\",\"kenburnsscale\":1.2,\"kenburnsrotate\":\"\",\"globalhover\":false,\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxdistance\":10,\"parallaxrotate\":10,\"parallaxdurationmove\":1500,\"parallaxdurationleave\":1200,\"parallaxtransformorigin\":\"slidercenter slidermiddle 0\",\"parallaxtransformperspective\":500,\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"overflow\":false,\"background\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/12\\/stock-elingues-textile.jpg\",\"backgroundId\":189,\"backgroundThumb\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/12\\/stock-elingues-textile.jpg\",\"customProperties\":[],\"post_content\":false},\"sublayers\":[{\"transition\":\"{\\\\\\\"backgroundvideo\\\\\\\":false,\\\\\\\"autoplay\\\\\\\":\\\\\\\"inherit\\\\\\\",\\\\\\\"muted\\\\\\\":\\\\\\\"auto\\\\\\\",\\\\\\\"volume\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"fillmode\\\\\\\":\\\\\\\"cover\\\\\\\",\\\\\\\"controls\\\\\\\":\\\\\\\"auto\\\\\\\",\\\\\\\"showinfo\\\\\\\":\\\\\\\"auto\\\\\\\",\\\\\\\"loopmedia\\\\\\\":\\\\\\\"auto\\\\\\\",\\\\\\\"overlay\\\\\\\":\\\\\\\"disabled\\\\\\\",\\\\\\\"position\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"pinned\\\\\\\":false,\\\\\\\"minfontsize\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"minmobilefontsize\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"scaleX\\\\\\\":1,\\\\\\\"scaleY\\\\\\\":1,\\\\\\\"rotation\\\\\\\":0,\\\\\\\"rotationX\\\\\\\":0,\\\\\\\"rotationY\\\\\\\":0,\\\\\\\"skewX\\\\\\\":0,\\\\\\\"skewY\\\\\\\":0,\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"pointerEvents\\\\\\\":false,\\\\\\\"minresponsiveratio\\\\\\\":0,\\\\\\\"maxresponsiveratio\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"transitionin\\\\\\\":true,\\\\\\\"offsetxin\\\\\\\":0,\\\\\\\"offsetyin\\\\\\\":0,\\\\\\\"scalexin\\\\\\\":1,\\\\\\\"scaleyin\\\\\\\":1,\\\\\\\"rotatein\\\\\\\":0,\\\\\\\"rotatexin\\\\\\\":0,\\\\\\\"rotateyin\\\\\\\":0,\\\\\\\"skewxin\\\\\\\":0,\\\\\\\"skewyin\\\\\\\":0,\\\\\\\"widthin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"heightin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"clipin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"transformperspectivein\\\\\\\":500,\\\\\\\"transformmirrorin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"delayin\\\\\\\":0,\\\\\\\"durationin\\\\\\\":1000,\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"colorin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"bgcolorin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"filterin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"radiusin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"static\\\\\\\":\\\\\\\"none\\\\\\\",\\\\\\\"skipViewport\\\\\\\":\\\\\\\"disabled\\\\\\\",\\\\\\\"transitionout\\\\\\\":true,\\\\\\\"offsetxout\\\\\\\":0,\\\\\\\"offsetyout\\\\\\\":0,\\\\\\\"scalexout\\\\\\\":1,\\\\\\\"scaleyout\\\\\\\":1,\\\\\\\"rotateout\\\\\\\":0,\\\\\\\"rotatexout\\\\\\\":0,\\\\\\\"rotateyout\\\\\\\":0,\\\\\\\"skewxout\\\\\\\":0,\\\\\\\"skewyout\\\\\\\":0,\\\\\\\"widthout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"heightout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"clipout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"transformperspectiveout\\\\\\\":500,\\\\\\\"transformmirrorout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"startatout\\\\\\\":\\\\\\\"slidechangeonly\\\\\\\",\\\\\\\"startatouttiming\\\\\\\":\\\\\\\"slidechangeonly\\\\\\\",\\\\\\\"startatoutoperator\\\\\\\":\\\\\\\"+\\\\\\\",\\\\\\\"startatoutvalue\\\\\\\":0,\\\\\\\"durationout\\\\\\\":1000,\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"colorout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"bgcolorout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"filterout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"radiusout\\\\\\\":\\\\\\\"\\\\\\\"}\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":36,\\\\\\\"wordwrap\\\\\\\":false,\\\\\\\"text-align\\\\\\\":\\\\\\\"center\\\\\\\",\\\\\\\"font-style\\\\\\\":\\\\\\\"normal\\\\\\\",\\\\\\\"text-decoration\\\\\\\":\\\\\\\"none\\\\\\\",\\\\\\\"text-transform\\\\\\\":\\\\\\\"none\\\\\\\",\\\\\\\"font-weight\\\\\\\":400,\\\\\\\"letter-spacing\\\\\\\":0,\\\\\\\"background-position\\\\\\\":\\\\\\\"0% 0%\\\\\\\",\\\\\\\"background-repeat\\\\\\\":\\\\\\\"no-repeat\\\\\\\",\\\\\\\"background-clip\\\\\\\":\\\\\\\"border-box\\\\\\\",\\\\\\\"opacity\\\\\\\":1,\\\\\\\"mix-blend-mode\\\\\\\":\\\\\\\"unset\\\\\\\",\\\\\\\"overflow\\\\\\\":\\\\\\\"visible\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"153px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"546px\\\\\\\"}\",\"media\":\"text\",\"htmlLineBreak\":\"auto\",\"htmlTag\":\"ls-layer\",\"post_text_length\":\"\",\"iconColor\":\"\",\"iconPlacement\":\"right\",\"iconSize\":1,\"iconGap\":0,\"iconVerticalAdjustment\":0,\"style\":\"\",\"url\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"target\":\"_self\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"tabindex\":\"\",\"autoSubtitle\":true,\"subtitle\":\"Notre Usine \",\"hasTransforms\":false,\"meta\":[],\"innerAttributes\":[],\"outerAttributes\":[],\"actions\":[],\"html\":\"Notre Usine \",\"uuid\":\"1f924fff-7def-4159-a253-a578fec6d72c\"}],\"meta\":{\"undoStackIndex\":0,\"activeLayers\":[0]},\"history\":[{\"cmd\":\"slide.layers\",\"name\":\"LAYER_NEW\",\"updateInfo\":[{\"itemIndex\":0,\"selectIndex\":0,\"undo\":{\"data\":[]},\"redo\":{\"data\":[{\"transition\":{\"backgroundvideo\":false,\"autoplay\":\"inherit\",\"muted\":\"auto\",\"volume\":\"\",\"fillmode\":\"cover\",\"controls\":\"auto\",\"showinfo\":\"auto\",\"loopmedia\":\"auto\",\"overlay\":\"disabled\",\"position\":\"\",\"pinned\":false,\"minfontsize\":\"\",\"minmobilefontsize\":\"\",\"scaleX\":1,\"scaleY\":1,\"rotation\":0,\"rotationX\":0,\"rotationY\":0,\"skewX\":0,\"skewY\":0,\"transformoriginin\":\"50% 50% 0\",\"pointerEvents\":false,\"minresponsiveratio\":0,\"maxresponsiveratio\":\"\",\"transitionin\":true,\"offsetxin\":0,\"offsetyin\":0,\"scalexin\":1,\"scaleyin\":1,\"rotatein\":0,\"rotatexin\":0,\"rotateyin\":0,\"skewxin\":0,\"skewyin\":0,\"widthin\":\"\",\"heightin\":\"\",\"clipin\":\"\",\"transformperspectivein\":500,\"transformmirrorin\":\"\",\"delayin\":0,\"durationin\":1000,\"easingin\":\"easeInOutQuint\",\"fadein\":true,\"colorin\":\"\",\"bgcolorin\":\"\",\"filterin\":\"\",\"radiusin\":\"\",\"static\":\"none\",\"skipViewport\":\"disabled\",\"transitionout\":true,\"offsetxout\":0,\"offsetyout\":0,\"scalexout\":1,\"scaleyout\":1,\"rotateout\":0,\"rotatexout\":0,\"rotateyout\":0,\"skewxout\":0,\"skewyout\":0,\"widthout\":\"\",\"heightout\":\"\",\"clipout\":\"\",\"transformoriginout\":\"50% 50% 0\",\"transformperspectiveout\":500,\"transformmirrorout\":\"\",\"startatout\":\"slidechangeonly\",\"startatouttiming\":\"slidechangeonly\",\"startatoutoperator\":\"+\",\"startatoutvalue\":0,\"durationout\":1000,\"easingout\":\"easeInOutQuint\",\"fadeout\":true,\"colorout\":\"\",\"bgcolorout\":\"\",\"filterout\":\"\",\"radiusout\":\"\"},\"styles\":{\"font-size\":36,\"wordwrap\":false,\"text-align\":\"center\",\"font-style\":\"normal\",\"text-decoration\":\"none\",\"text-transform\":\"none\",\"font-weight\":400,\"letter-spacing\":0,\"border-style\":\"\",\"border-color\":\"\",\"background-position\":\"0% 0%\",\"background-repeat\":\"no-repeat\",\"background-clip\":\"border-box\",\"opacity\":1,\"mix-blend-mode\":\"unset\",\"overflow\":\"visible\",\"font-family\":\"Roboto\",\"color\":\"#ffffff\",\"top\":\"153px\",\"left\":\"546px\",\"border-width\":\"\"},\"media\":\"text\",\"htmlLineBreak\":\"auto\",\"htmlTag\":\"ls-layer\",\"post_text_length\":\"\",\"iconColor\":\"\",\"iconPlacement\":\"right\",\"iconSize\":1,\"iconGap\":0,\"iconVerticalAdjustment\":0,\"style\":\"\",\"url\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"target\":\"_self\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"tabindex\":\"\",\"autoSubtitle\":true,\"subtitle\":\"Notre Usine  copy\",\"hasTransforms\":false,\"meta\":[],\"innerAttributes\":[],\"outerAttributes\":[],\"actions\":[],\"html\":\"Notre Usine \",\"uuid\":\"1f924fff-7def-4159-a253-a578fec6d72c\"}]}}]}]}],\"googlefonts\":[{\"param\":\"Roboto\"}]}", "1698231189", "1701870136", "0", "0", "0", "0", "0", "0", "0");
INSERT INTO `wp_layerslider` VALUES("2", NULL, "1", "Nos Produits", "", "{\"properties\":{\"sliderVersion\":\"7.6.7\",\"title\":\"Nos Produits\",\"slug\":\"\",\"status\":true,\"schedule_start\":\"\",\"schedule_end\":\"\",\"type\":\"responsive\",\"popupFitWidth\":\"\",\"popupFitHeight\":\"\",\"popupPositionHorizontal\":\"center\",\"popupPositionVertical\":\"middle\",\"popupWidth\":\"640\",\"popupHeight\":\"360\",\"popupDistanceTop\":\"10\",\"popupDistanceRight\":\"10\",\"popupDistanceBottom\":\"10\",\"popupDistanceLeft\":\"10\",\"popupShowOnTimeout\":\"\",\"popupShowOnIdle\":\"\",\"popupShowOnScroll\":\"\",\"popupShowOnClick\":\"\",\"popupCloseOnTimeout\":\"\",\"popupCloseOnScroll\":\"\",\"popup_repeat\":true,\"popup_repeat_days\":\"\",\"popupShowOnce\":true,\"popup_pages_custom\":\"\",\"popup_pages_exclude\":\"\",\"popup_roles_administrator\":true,\"popup_roles_editor\":true,\"popup_roles_author\":true,\"popup_roles_contributor\":true,\"popup_roles_subscriber\":true,\"popup_roles_customer\":true,\"popup_roles_visitor\":true,\"popupTransitionIn\":\"fade\",\"popupDurationIn\":\"1000\",\"popupDelayIn\":\"200\",\"popupTransitionOut\":\"fade\",\"popupDurationOut\":\"500\",\"popupResetOnClose\":\"slide\",\"popupShowCloseButton\":true,\"popupCloseButtonStyle\":\"\",\"popupOverlayClickToClose\":true,\"popupOverlayBackground\":\"rgba(0,0,0,.85)\",\"popupOverlayTransitionIn\":\"fade\",\"popupOverlayDurationIn\":\"400\",\"popupOverlayTransitionOut\":\"fade\",\"popupOverlayDurationOut\":\"400\",\"sceneHeight\":\"\",\"sceneSpeed\":\"100\",\"stickTo\":\"center\",\"width\":1280,\"height\":400,\"maxwidth\":\"\",\"responsiveunder\":\"\",\"fullSizeMode\":\"normal\",\"marginTop\":\"\",\"marginBottom\":\"\",\"fitScreenWidth\":true,\"maxRatio\":\"\",\"calculateOffsetFrom\":\"\",\"insertMethod\":\"prependTo\",\"insertSelector\":\"\",\"clipSlideTransition\":\"disabled\",\"preventSliderClip\":true,\"hideunder\":\"\",\"hideover\":\"\",\"slideOnSwipe\":true,\"optimizeForMobile\":true,\"firstlayer\":\"1\",\"autostart\":true,\"startinviewport\":true,\"pauseonhover\":\"disabled\",\"keybnav\":true,\"touchnav\":true,\"loops\":\"0\",\"forceloopnum\":true,\"skin\":\"v6\",\"sliderfadeinduration\":\"0\",\"sliderclass\":\"\",\"sliderstyle\":\"\",\"backgroundcolor\":\"\",\"globalBGRepeat\":\"no-repeat\",\"globalBGAttachment\":\"scroll\",\"globalBGPosition\":\"50% 50%\",\"globalBGSize\":\"auto\",\"navprevnext\":true,\"navstartstop\":true,\"navbuttons\":true,\"hoverprevnext\":true,\"circletimer\":true,\"thumb_nav\":\"hover\",\"thumb_container_width\":\"60%\",\"thumb_width\":\"100\",\"thumb_height\":\"60\",\"thumb_active_opacity\":\"35\",\"thumb_inactive_opacity\":\"100\",\"autoplayvideos\":true,\"rememberUnmuteState\":true,\"autopauseslideshow\":\"auto\",\"youtubepreview\":\"maxresdefault.jpg\",\"performanceMode\":\"inherit\",\"performanceModeThreshold\":\"20sh\",\"enhancedLazyLoad\":\"inherit\",\"slideBGSize\":\"cover\",\"slideBGPosition\":\"50% 50%\",\"slideDuration\":\"\",\"slideTransitionDuration\":\"\",\"slideTimeShift\":\"0\",\"parallaxSensitivity\":\"10\",\"parallaxCenterLayers\":\"center\",\"parallaxCenterDegree\":\"40\",\"scrollCenterLayers\":\"center\",\"forceLayersOutDuration\":\"750\",\"useSrcset\":\"inherit\",\"preferBlendMode\":\"disabled\",\"createdWith\":\"7.6.7\"},\"layers\":[{\"properties\":{\"post_offset\":-1,\"3d_transitions\":\"\",\"2d_transitions\":\"\",\"custom_3d_transitions\":\"\",\"custom_2d_transitions\":\"\",\"bgcolor\":\"\",\"bgposition\":\"inherit\",\"bgsize\":\"inherit\",\"slidedelay\":\"\",\"timeshift\":0,\"transitionduration\":\"\",\"kenburnszoom\":\"disabled\",\"kenburnsscale\":1.2,\"kenburnsrotate\":\"\",\"globalhover\":false,\"parallaxtype\":\"2d\",\"parallaxevent\":\"cursor\",\"parallaxaxis\":\"both\",\"parallaxdistance\":10,\"parallaxrotate\":10,\"parallaxdurationmove\":1500,\"parallaxdurationleave\":1200,\"parallaxtransformorigin\":\"slidercenter slidermiddle 0\",\"parallaxtransformperspective\":500,\"layer_link\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"layer_link_target\":\"_self\",\"layer_link_type\":\"over\",\"deeplink\":\"\",\"overflow\":false,\"customProperties\":[],\"background\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/10\\/d462bb217038d792a15efd91ca58fb7291e1c4c2_chaine-home-deblock.jpg\",\"backgroundId\":54,\"backgroundThumb\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/10\\/d462bb217038d792a15efd91ca58fb7291e1c4c2_chaine-home-deblock.jpg\",\"post_content\":false,\"schedule_start\":\"\",\"schedule_end\":\"\"},\"sublayers\":[{\"transition\":\"{\\\\\\\"backgroundvideo\\\\\\\":false,\\\\\\\"autoplay\\\\\\\":\\\\\\\"inherit\\\\\\\",\\\\\\\"muted\\\\\\\":\\\\\\\"auto\\\\\\\",\\\\\\\"volume\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"fillmode\\\\\\\":\\\\\\\"cover\\\\\\\",\\\\\\\"controls\\\\\\\":\\\\\\\"auto\\\\\\\",\\\\\\\"showinfo\\\\\\\":\\\\\\\"auto\\\\\\\",\\\\\\\"loopmedia\\\\\\\":\\\\\\\"auto\\\\\\\",\\\\\\\"overlay\\\\\\\":\\\\\\\"disabled\\\\\\\",\\\\\\\"position\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"pinned\\\\\\\":false,\\\\\\\"minfontsize\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"minmobilefontsize\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"scaleX\\\\\\\":1,\\\\\\\"scaleY\\\\\\\":1,\\\\\\\"rotation\\\\\\\":0,\\\\\\\"rotationX\\\\\\\":0,\\\\\\\"rotationY\\\\\\\":0,\\\\\\\"skewX\\\\\\\":0,\\\\\\\"skewY\\\\\\\":0,\\\\\\\"transformoriginin\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"pointerEvents\\\\\\\":false,\\\\\\\"minresponsiveratio\\\\\\\":0,\\\\\\\"maxresponsiveratio\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"transitionin\\\\\\\":true,\\\\\\\"offsetxin\\\\\\\":0,\\\\\\\"offsetyin\\\\\\\":0,\\\\\\\"scalexin\\\\\\\":1,\\\\\\\"scaleyin\\\\\\\":1,\\\\\\\"rotatein\\\\\\\":0,\\\\\\\"rotatexin\\\\\\\":0,\\\\\\\"rotateyin\\\\\\\":0,\\\\\\\"skewxin\\\\\\\":0,\\\\\\\"skewyin\\\\\\\":0,\\\\\\\"widthin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"heightin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"clipin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"transformperspectivein\\\\\\\":500,\\\\\\\"transformmirrorin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"delayin\\\\\\\":0,\\\\\\\"durationin\\\\\\\":1000,\\\\\\\"easingin\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadein\\\\\\\":true,\\\\\\\"colorin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"bgcolorin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"filterin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"radiusin\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"static\\\\\\\":\\\\\\\"none\\\\\\\",\\\\\\\"skipViewport\\\\\\\":\\\\\\\"disabled\\\\\\\",\\\\\\\"transitionout\\\\\\\":true,\\\\\\\"offsetxout\\\\\\\":0,\\\\\\\"offsetyout\\\\\\\":0,\\\\\\\"scalexout\\\\\\\":1,\\\\\\\"scaleyout\\\\\\\":1,\\\\\\\"rotateout\\\\\\\":0,\\\\\\\"rotatexout\\\\\\\":0,\\\\\\\"rotateyout\\\\\\\":0,\\\\\\\"skewxout\\\\\\\":0,\\\\\\\"skewyout\\\\\\\":0,\\\\\\\"widthout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"heightout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"clipout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"transformoriginout\\\\\\\":\\\\\\\"50% 50% 0\\\\\\\",\\\\\\\"transformperspectiveout\\\\\\\":500,\\\\\\\"transformmirrorout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"startatout\\\\\\\":\\\\\\\"slidechangeonly\\\\\\\",\\\\\\\"startatouttiming\\\\\\\":\\\\\\\"slidechangeonly\\\\\\\",\\\\\\\"startatoutoperator\\\\\\\":\\\\\\\"+\\\\\\\",\\\\\\\"startatoutvalue\\\\\\\":0,\\\\\\\"durationout\\\\\\\":1000,\\\\\\\"easingout\\\\\\\":\\\\\\\"easeInOutQuint\\\\\\\",\\\\\\\"fadeout\\\\\\\":true,\\\\\\\"colorout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"bgcolorout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"filterout\\\\\\\":\\\\\\\"\\\\\\\",\\\\\\\"radiusout\\\\\\\":\\\\\\\"\\\\\\\"}\",\"styles\":\"{\\\\\\\"font-size\\\\\\\":36,\\\\\\\"wordwrap\\\\\\\":false,\\\\\\\"text-align\\\\\\\":\\\\\\\"center\\\\\\\",\\\\\\\"font-style\\\\\\\":\\\\\\\"normal\\\\\\\",\\\\\\\"text-decoration\\\\\\\":\\\\\\\"none\\\\\\\",\\\\\\\"text-transform\\\\\\\":\\\\\\\"none\\\\\\\",\\\\\\\"font-weight\\\\\\\":400,\\\\\\\"letter-spacing\\\\\\\":0,\\\\\\\"background-position\\\\\\\":\\\\\\\"0% 0%\\\\\\\",\\\\\\\"background-repeat\\\\\\\":\\\\\\\"no-repeat\\\\\\\",\\\\\\\"background-clip\\\\\\\":\\\\\\\"border-box\\\\\\\",\\\\\\\"opacity\\\\\\\":1,\\\\\\\"mix-blend-mode\\\\\\\":\\\\\\\"unset\\\\\\\",\\\\\\\"overflow\\\\\\\":\\\\\\\"visible\\\\\\\",\\\\\\\"font-family\\\\\\\":\\\\\\\"Roboto\\\\\\\",\\\\\\\"color\\\\\\\":\\\\\\\"#ffffff\\\\\\\",\\\\\\\"top\\\\\\\":\\\\\\\"153px\\\\\\\",\\\\\\\"left\\\\\\\":\\\\\\\"546px\\\\\\\"}\",\"media\":\"text\",\"htmlLineBreak\":\"auto\",\"htmlTag\":\"ls-layer\",\"post_text_length\":\"\",\"iconColor\":\"\",\"iconPlacement\":\"right\",\"iconSize\":1,\"iconGap\":0,\"iconVerticalAdjustment\":0,\"style\":\"\",\"url\":\"\",\"linkId\":\"\",\"linkName\":\"\",\"linkType\":\"\",\"target\":\"_self\",\"id\":\"\",\"class\":\"\",\"title\":\"\",\"alt\":\"\",\"rel\":\"\",\"tabindex\":\"\",\"autoSubtitle\":true,\"subtitle\":\"Nos Produits\",\"hasTransforms\":false,\"meta\":[],\"innerAttributes\":[],\"outerAttributes\":[],\"actions\":[],\"html\":\"Nos Produits\",\"uuid\":\"eb752751-e9da-42b0-8eb7-bf6483698f51\"}],\"meta\":{\"undoStackIndex\":14,\"activeLayers\":[0]},\"history\":[{\"cmd\":\"slide.general\",\"name\":\"SLIDE_IMAGE\",\"updateInfo\":{\"itemIndex\":0,\"undo\":{\"background\":null,\"backgroundId\":null,\"backgroundThumb\":null},\"redo\":{\"background\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/10\\/Capture-decran-2023-07-18-a-15.28.35.png\",\"backgroundId\":14,\"backgroundThumb\":\"http:\\/\\/deblock.local\\/wp-content\\/uploads\\/2023\\/10\\/Capture-decran-2023-07-18-a-15.28.35.png\"}}},{\"cmd\":\"slide.layers\",\"name\":\"LAYER_NEW\",\"updateInfo\":[{\"itemIndex\":0,\"selectIndex\":0,\"undo\":{\"data\":[]},\"redo\":{\"data\":{\"transition\":{\"backgroundvideo\":false,\"autoplay\":\"inherit\",\"muted\":\"auto\",\"volume\":\"\",\"fillmode\":\"cover\",\"controls\":\"auto\",\"showinfo\":\"auto\",\"loopmedia\":\"auto\",\"overlay\":\"disabled\",\"position\":\"\",\"pinned\":false,\"minfontsize\":\"\",\"minmobilefontsize\":\"\",\"scaleX\":1,\"scaleY\":1,\"rotation\":0,\"r